/* "chmod" utility, part of cnixutil.pre */
#include "bdos.h"

#define ON	1
#define OFF	0
#define NO_CHANGE	-1

do_chmod(argc, argv)
register char **argv;
{
	/* chmod [+w|-w|+s|-s] file1 file2 ... */
	int filex, wflag, sflag, on_off;
	char *fl;
	auto struct fcb fcb;

	/* Complain if no flags, or no files */
	if (argc < 3 || !strany(argv[1][0], "-+") ||
	    strany(argv[argc-1][0], "-+")) {
		return(err("Usage: chmod [+w|-w|+s|-s] file1 file2 ...",0));
	}
	wflag = NO_CHANGE;
	sflag = NO_CHANGE;
	for (filex = 1; strany(*(fl=argv[filex]), "-+"); ++filex) {
		/* Process flags */
		on_off = (*fl++ == '+')? ON: OFF;
		do {
			switch(*fl) {
			case 'w':
				wflag = on_off;
				continue;
			case 's':
				sflag = on_off;
				continue;
			}
			return(err("%c: Unrecognized flag", *fl));
		} while (*++fl);
	}
	/* Process file arguments */
	for ( ; filex < argc; ++filex) {
		makefcb(argv[filex], &fcb);
		if (!fileok(bdos(OPNFILE, &fcb))) {
			err("%s: Not found", argv[filex]);
			continue;
		}
		/* Set/reset R/O, SYS flags */
		if (wflag != NO_CHANGE) {
			if (wflag == OFF) {
				fcb.f_type[0] |= 0200;
			} else {
				fcb.f_type[0] &= ~0200;
			}
		}
		if (sflag != NO_CHANGE) {
			if (sflag == ON) {
				fcb.f_type[1] |= 0200;
			} else {
				fcb.f_type[1] &= ~0200;
			}
		}
		bdos(SETATTR, &fcb);
	}
	return(0);
}
dos(SETATTR, &fcb);
	