#include "bdos.h"
#include "stdio.h"

/* Buffered File Input/Output routines */


FILE *
fileopen(filep, fname, modestr)
FILE *filep;
char *fname, *modestr;
{
	/* Open, given initialized file structure (fcbp/max/datap must */
	/* be initialized by caller!). */
	/* modestr[0] is either 'r', 'w', or 'a' for read, write, or append */
	/* Second char of modestr should be 'b' for binary I/O */
	/* "fname" is name of file, and must exist already for read, */
	/* must NOT exist for write, and may or may not exist for append */
	/* Returns filep, or NULL if open/makefile fails */
	static FILE *fp;
	static int x;

	if ((fp=filep) <= stderr) return(fp);
	/* Fail if file structure not initialized */
	if (!fp->f_fcbp || !fp->f_max || !fp->f_datap) return(NULL);
	makefcb(fname, fp->f_fcbp);
	/* Check if file already exists */
	x = bdos(OPNFILE, fp->f_fcbp);
	/* Set binary I/O indicator */
	if (modestr[1] == 'b') fp->f_max |= BIN_IO;
	switch(modestr[0]) {
	case 'r':
		/* Open for read */
		if (!fileok(x)) return(NULL);
		fp->f_idx = 0;
		fp->f_cnt = 0;
		break;
	case 'a':
		/* Open for append */
		if (fileok(x)) {
			/* Already exists, seek to end of file */
			fp->f_idx = OUTIDX;	/* Indicate open for output */
			seekeof(fp);
			break;
		}
		/* Fall through to write */
	case 'w':
		/* Open for write */
		if (fileok(x)) return(NULL);
		if (!fileok(bdos(MAKFILE, fp->f_fcbp))) return(NULL);
		fp->f_idx = OUTIDX;	/* Indicate open for output */
		fp->f_cnt = 0;
		break;
	default:
		return(NULL);
	}
	/* Success! */
	return(fp);
}

putc(c, filep)
FILE *filep;
{
	static FILE *fp;
	/* Put out char to file, flush buffer if full */

	if ((fp=filep) <= stdout) {
		/* assume standard output */
		putchar(c);
		return;
	}
	if (fp == stderr) {
		/* standard error = Direct Output */
		if (c == '\n') putc('\r', fp);	     /* Preceed '\n' by '\r' */
		bdos(DIRCNSIO, c&0377);
		return;
	}
	if (fp->f_idx != OUTIDX) return;     /* Not open for output */
	if (fp->f_max < 0) {
		/* Binary output */
		fp->f_datap[fp->f_cnt] = c;
		if (++fp->f_cnt > (fp->f_max & ~BIN_IO))
			fflush(fp);
		return;
	}
	if (c == '\n') putc('\r', fp);	     /* Preceed '\n' by '\r' */
	fp->f_datap[fp->f_cnt] = c;
	if (++fp->f_cnt >= fp->f_max) {
		fflush(fp);
	}
}

fflush(filep)
FILE *filep;
{
	/* flush chars to file */
	static int cnt, i, lim;
	static FILE *fp;

	if ((fp=filep) <= stderr || fp->f_idx != OUTIDX) return;
	cnt = fp->f_cnt;
	/* write out only buffer-fulls */
	lim = cnt & ~(IOSIZ-1);
	for (i = 0; i < lim; i += IOSIZ) {
		stdma(&fp->f_datap[i]);
		bdos(WTSEQ, fp->f_fcbp);
	}
	stdma(IOBUF);
	/* move down partial buffer full */
	for ( ; i < cnt; i++) {
		fp->f_datap[i-lim] = fp->f_datap[i];
	}
	fp->f_cnt = cnt-lim;
	CtlCk();
}

fileclose(filep)
FILE *filep;
{
	static FILE *fp;
	/* close file, ignore if not open for output */

	if ((fp=filep) <= stderr) return;
	if (fp->f_idx != OUTIDX) return;
	if (fp->f_cnt&(IOSIZ-1)) {
		/* Terminate with TXTEOF if not on page boundary already */
		/*  and not binary */
		if (fp->f_max >= 0) putc(TXTEOF, fp);
		/* fill out buffer count */
		fp->f_cnt = (fp->f_cnt + (IOSIZ-1)) & ~(IOSIZ-1);
	}
	fflush(fp);
	bdos(CLSFILE, fp->f_fcbp);
}

seekeof(filep)
FILE *filep;
{
	/* Find end of file, to allow append with putc */
	static FILE *fp;
	static struct fcb *fcbp;
	static int cnt, rc;

	if ((fp=filep) <= stderr || fp->f_idx != OUTIDX) return;
	rc = 0;
	fcbp = fp->f_fcbp;
	fcbp->f_ranovflo = 0;
	stdma(fp->f_datap);
	do {
		/* Read in one page */
		fcbp->f_ranrec = rc;
		if (bdos(RDRANDOM, fcbp)) {
			/* "Physical" EOF, set count to zero */
			cnt = 0;
			break;
		}
		/* If binary, ignore all but "physical" EOF */
		if (fp->f_max < 0) continue;
		/* Scan for CP/M EOF indicator */
		for (cnt = 0; cnt < IOSIZ; cnt++) {
			if (fp->f_datap[cnt] == TXTEOF) {
				break;
			}
		}
		++rc;	/* Point to next record */
		CtlCk();
	} while (cnt == IOSIZ);
	stdma(IOBUF);
	/* Exit with filep->f_cnt set up for putc() */
	fp->f_cnt = cnt;
}

getc(filep)
FILE *filep;
{
	static FILE *fp;
	static int idx, c;
	/* Get char from file */

	if ((fp=filep) <= stdin) return(getchar());	/* Standard input */
	if (fp == stderr) {
		/* standard error = Direct Input */
		while (!(c=bdos(DIRCNSIO, 0xff)));
		return(c == TXTEOF? EOF: c);
	}
	/* loop to ignore '\r' */
	do {
		idx = fp->f_idx;
		if (idx == OUTIDX) {
			/* Open for output */
			c = EOF;
			break;
		}
		while (idx >= (fp->f_cnt&~BIN_EOF)) {
			/* Check for binary EOF indicator */
			if (fp->f_cnt < 0) return(EOF);
			_filbuf(fp);
			fp->f_idx = 0;
			idx = 0;
			/* Loop to check for binary EOF */
		}
		c = fp->f_datap[idx]&0377;
		/* Check for binary input flag */
		if (c != TXTEOF || fp->f_max < 0) ++fp->f_idx;
		else		 c = EOF;
	} while (c == '\r' && fp->f_max >= 0);
	return(c);
}

_filbuf(filep)
FILE *filep;
{
	/* Fill buffer, place TXTEOF on end of file */
	static int lim, i;
	static FILE *fp;

	if ((fp=filep) <= stderr || fp->f_idx == OUTIDX) return;
	/* Only interested in IOSIZ portions within buffer */
	lim = fp->f_max & ~((IOSIZ-1)|BIN_IO);
	for (i = 0; i < lim; i += IOSIZ) {
		stdma(&fp->f_datap[i]);
		if(bdos(RDSEQ, fp->f_fcbp)) {
			/* End of file */
			if (fp->f_max < 0) {
				/* Set binary end-of-file indicator */
				i |= BIN_EOF;
				break;
			}
			/* Text end-of-file indicator */
			fp->f_datap[i++] = TXTEOF;
			break;
		}
	}
	stdma(IOBUF);
	fp->f_cnt = i;
	fp->f_idx = 0;
	CtlCk();
}

/* File Control Block (FCB) utilities */

formnam(str, fcbp)
register char *str;
struct fcb *fcbp;
{
	/* gather together file name into str */

	str = lowerstr(str, fcbp->f_name, NAMSIZ);
	*str++ = '.';
	lowerstr(str, fcbp->f_type, TYPSIZ);
}

fileok(x)
{
	/* return non-zero if x == 0..3 */
	/* Which indicates successful file operation */
	return((x & ~3) == 0);
}

stdma(buf)
char *buf;
{
	/* Set up buffer address for read or write */
	bdos(SETDMA, buf);
}

makefcb(str, fp)
register char *str;
register struct fcb *fp;
{
	/* copy string into fcb, pad with blanks */
	/* CP/M format is 8 char name, and 3 char "type" */
	register int i;
	static struct fcb *f2;

	for (i = 0; i < (NAMSIZ+TYPSIZ); i++) {
		fp->f_name[i] = ' ';
	}
	if (str[1] == ':') {
		fp->f_usrdrv = chrdrv(str[0]);
		str += 2;
	} else {
		fp->f_usrdrv = 0;
	}
	i = 0;
	while (*str && *str != '.') {
		/* Stat expects filename in fcb2, remove backslashes */
		if (*str == '\\') ++str;
		if (i < NAMSIZ) fp->f_name[i++] = upper(*str);
		++str;
	}
	if (i && fp->f_name[--i] == '*') {
		do {
			fp->f_name[i] = '?';
		} while (++i < NAMSIZ);
	}
	if (*str == '.') {
		i = 0;
		str++;
		while (*str && i < TYPSIZ) {
			fp->f_type[i++] = upper(*str++);
		}
		if (i && fp->f_type[--i] == '*') {
			do {
				fp->f_type[i] = '?';
			} while (++i < TYPSIZ);
		}
	}
	for (i = 0; i < NAMSIZ+TYPSIZ; i++) {
		/* Clear high bits */
		fp->f_name[i] &= 0x7f;
	}
	fp->f_rsv1 = 0;
	fp->f_rsv2 = 0;
	fp->f_extent = 0;
	fp->f_reccnt = 0;
	f2 = FCB2;
	if (fp == f2) return; /* limit init. to 16 bytes if FCB2 */
	fp->f_currec = 0;
}

dflt_ext(str, fcbp)
char *str;
struct fcb *fcbp;
{
	/* add extension if now blank */
	register i;

	if (fcbp->f_type[0] != ' ') return;
	for (i = 0; i < TYPSIZ && *str; i++) {
		fcbp->f_type[i] = *str++;
	}
}

chrdrv(chr)
register int chr;
{
	/* Convert character to drive num (as used in fcb[0]) */
	/* 0, ? --> unchanged */

	if (chr == '?') return(chr);
	chr = upper(chr);
	if (chr < 'A' || chr > 'P') return(0);
	return(chr - 'A' + 1);
}

drvchr(drv)
register int drv;
{
	/* convert drive num (as used in fcb[0]) to drive char */
	/* 0, ? --> unchanged */

	if (drv == 0 || drv == '?') return(drv);
	if (drv <= 0 || drv > ('P' - 'A' + 1)) return('A');
	return(drv + 'A' - 1);
}
R! 9"	R!  "R
S*R#}o"R*