;	********************************************************************
;	****								****
;	****     SemiDisk Test Program, Copyright 1982, 1983, 1984  	****
;       ****		      SemiSoft Group				****
;	****	              SemiDisk Systems, Inc.			****
;	****	              P.O. Box G.G.				****
;	****	              Beaverton, Oregon 97075			****
;	****								****
;	********************************************************************

			;THIS PROGRAM PERFORMS THREE TESTS ON THE
			;SEMIDISK IN THE SYSTEM AT I/O BASE 80 HEX
			;SECTOR BASE 0
;
;Rev 1: Corrects double ZAP labels, changing first occurance to ZAPA.
;Rev 2: Allows accumulation of errors on map.  Allows operator to 
;       interrupt test.  TEST1 speeded up with macro-expansion clear.
;	TEST2 changed to an Incrementing Byte test.  Modified menu
;	display.  Expanded configurations to include 1.5 meg SemiDisk.
;	TEST3 Byte Access, Read-Write-Read test added. (24 APR 84)
;		
TRUE	EQU	255
FALSE	EQU	000

			;SET ONE OF THIS FLAGS TO INDICATE WHICH SIZE
			;OF SEMIDISK BOARD(S) THAT YOU WISH TO TEST

S256K	EQU	FALSE	;256K (one half of a SemiDisk)
S512K	EQU	true	;Half megabyte
S1MEG	EQU	false	;One  megabyte
S15MEG	EQU	false	;One and one-half meabyte
S2MEG	EQU	FALSE	;Two  megabyte	(two or more boards)

			;EXPAND MACROS FOR SPECIFIED SemiDisk

	IF	S256K
CHIPS	EQU	32	;HOW MANY CHIPS
CHIPR	EQU	4	;HOW MANY CHIPS PER ROW
SECTS	EQU	8	;HOW MANY SECTORS
	ENDIF

	IF	S512K
CHIPS	EQU	64	;HOW MANY CHIPS
CHIPR	EQU	8	;HOW MANY CHIPS PER ROW
SECTS	EQU	16	;HOW MANY SECTORS
	ENDIF

	IF	S1MEG
CHIPS	EQU	128	;HOW MANY CHIPS
CHIPR	EQU	16	;HOW MANY CHIPS PER ROW
SECTS	EQU	32	;HOW MANY SECTORS
	ENDIF

	IF	S15MEG
CHIPS	EQU	192	;Number of chips
CHIPR	EQU	24	;Number of chips per row
SECTS	EQU	48	;Number of Sectors
	ENDIF
	
	IF	S2MEG
CHIPS	EQU	255	;HOW MANY CHIPS
CHIPR	EQU	32	;HOW MANY CHIPS PER ROW
SECTS	EQU	64	;HOW MANY SECTORS
	ENDIF

			;GENERAL EQUATES

BYTES	EQU	128	;HOW MANY BYTES PER SECTOR
TRACS	EQU	0	;HOW MANY TRACKS, ACTUALLY THIS IS 256 MODULAS 256

			;SEMIDISK ADDRESS EQUATES

BASE 	EQU	80H	;SEMIDISK BASE FOR TESTING

SEMID	EQU	BASE	;SEMIDISK DATA   PORT
SEMIB	EQU	BASE+1	;SEMIDISK BYTE   PORT
SEMIT	EQU	BASE+2	;SEMIDISK TRACK  PORT
SEMIS	EQU	BASE+3	;SEMIDISK SECTOR PORT

			;CP/M EQUATES

BDOS	EQU	0005H	;CP/M ENTRY
RESET	EQU	0	;CP/M RESET
CONIN	EQU	1	;CP/M CHARACTER INPUT
CONOUT	EQU	2	;CP/M CHARACTER OUTPUT
CONST	EQU	11	;CP/M CONSOLE   STATUS

			;ASCII EQUATES

NULL	EQU	0	;ZERO, THE MOST IMPORTANT DIGIT OF OUR NUMBER SYSTEM
CR	EQU	13	;CARRAGE RETURN
LF	EQU	10	;LINE FEED
GOODC	EQU	'.'	;GOOD CHIP CHARACTER
BADC	EQU	'X'	;BAD  CHIP CHARACTER


PUSHALL MACRO		;Save all Registers and Flags
	PUSH	H
	PUSH	D
	PUSH	B	;Save BC on stack
	PUSH	PSW	;Save Acc and Flags on stack
	ENDM

POPALL  MACRO		;Restore Registers and Flags
	POP	PSW	;Restore Acc and Flags
	POP	B	;Restore BC
	POP	D	;Restore DE
	POP	H
	ENDM


			;PROGRAM STARTS HERE

	ORG	100H	;TRANSIENT PROGRAM AREA

START:	in	semis	;reading the sector port clears the parity and
			;write-protect flags on the SemiDisk II

			;CLEAR OUT BAD CHIP MARKERS BY WRITING ALL
			;GOOD CHIPS TO ARRAY
			;We do this first so that when a chip goes
			;bad, it stays bad.

	LXI	H,BAD	;CLEAR OUT ARRAY
	MVI	B,CHIPS	;HOW MANY CHIPS

ZAPA:   MVI	M,GOODC	;TELL COMPUTER CHIP IS GOOD
	INX	H	;ONTO NEXT CHIP
	DCR	B	;DECREMENT COUNTER
	JNZ	ZAPA	;STILL MORE CHIPS ?

	SUB	A	;CLEAR ACC.
	STA	MODE	;SET ONCE MODE

	LXI	H,0	;CLEAR H AND L
	SHLD	BADCO	;STORE BAD CHIP COUNT

	CALL	PRINT	
	DB	CR,LF,'SemiDisk Systems, Inc., P.O. Box GG, Beaverton, OR 97075',CR,LF

	DB	'SemiDisk Test Program Version 2.0',CR,LF

	DB	'This program will test a '

	IF	S256k
	DB	'Quarter'
 	ENDIF

	IF	S512K
	DB	'Half'
	ENDIF

	IF	S1MEG
	DB	'One'
	ENDIF

	IF	S15MEG
	DB	'One and one-half'
	ENDIF

	IF	S2MEG
	DB	'Two'
	ENDIF

	DB	' Megabyte SemiDisk at Base Address 80 Hex',CR,LF,'$'

RETRY:	CALL	PRINT	;ANOTHER COMMAND ?
	DB	'Commands are : E - Exit to CP/M',CR,LF
	DB	'               T - Test once',   CR,LF
	DB	'               F - Forever test',CR,LF

	DB	'Command -$'

	CALL	CHIN	;GET COMMAND

	CPI	96	;See if lower case
	JC	CASE
	SBI	32	;Make upper case

CASE:	CPI	'E'	;DOES HE WANT TO GO BACK TO CPM?
	JZ	CPM

	CPI	'F'	;DOES HE WANT FOREVER TEST?
	JNZ	NOTF

	STA	MODE	;SET MODE TO FOREVER AND EVER AND...
	JMP	ENTRY	;GO

NOTF:	CPI	'T'	;DOES HE WANT TO TEST THE SemiDisk?
	JNZ	START	;GUESS NOT

ENTRY:	CALL	PRINT
	DB	CR,LF,'$'

TEST0:	CALL	PRINT	;EXPLAIN WHAT IS HAPPENING
	DB	'Clearing SemiDisk, Writing all zeros',CR,LF,'$'

	CALL	CLEAR	;Clear entire SemiDisk to zeros


;SemiDisk IS NOW CLEARED TO ZERO SO TESTING MAY BEGIN.
;FOR TESTING PURPOSES, THESE REGISTERS ARE DEDICATED
;SO THAT WHEN A BAD BIT IS FOUND, USER CALLS BADB: 
;WITH THE BAD BIT ON (one) AND ALL OTHERS OFF (zero).

			;REGISTER D:	BYTE   COUNTER
			;REGISTER C:	TRACK  COUNTER
			;REGISTER B:	SECTOR COUNTER


TEST1:	CALL	PRINT
	DB	CR,LF,'TEST1 Byte March, Read-Modify-Write',CR,LF,'$'

	CAL	ADDSET	;SET UP INITIAL TRACK, SECTOR AND BYTE ADDRESSES
ALLZERO	CALL	ADDOUT	;OUTPUT ADDRESS TO SEMIDISK
	IN	SEMID	;GET CURRENT DATA BYTE
 	ORA	A	;IS IT A ZERO?
	CNZ	BADB	;IF SO, UPDATE ERROR MAP
	CALL	ADDOUT	;REASSERT PREVIOUS ADDRESS
	MVI	A,0FFH	;FILL ACC WITH ONES
	OUT	SEMID	;WRITE NEW DATA TO THE SEMIDISK
	CALL	ADDINC	;INCREMENT ADDRESS, RETURN WITH ZERO-FLAG SET IF DONE
	JNZ	ALLZERO	;IF NOT DONE, LOOP
	CALL	PMAP	;Print Array map
	CALL	CONSTAT	;Check for operator interrupt


;At this point, all bytes have been tested for 00 and all ones, FF, has been
;written in each address location.

	CALL	PRINT
	DB	CR,LF,'Reading all ones',CR,LF,'$'

	CALL	ADDSET	;Set up initial SemiDisk addresses
ALLONES	CALL	ADDOUT	;Write address to SemiDisk
	IN	SEMID	;Read current DATA Byte
	XRI	0FFH	;Is it all ones?
	CNZ	BADB	;If so, update Error-Map
	CALL	ADDINC	;Increment Address, return with Zero-Flag set if done.
	JNZ	ALLONES	;Loop if not done.
	CALL	PMAP	;Print Array map
	CALL	CONSTAT	;Check for operator interrupt

TEST2:	CALL	PRINT
	DB	CR,LF,'TEST2 Incrementing Byte Test, Writing',CR,LF,'$'

	LDA	DATA	;Fetch the first test data byte
	MOV	E,A	;Save it in E
	CALL	ADDSET	;Set up initial addresses
PETE	CALL	ADDWRT	;Write Track & Sector addresses to SemiDisk
	MOV	A,E	;Put Data in Acc

	REPT	BYTES	;Fast write to entire Sector
	OUT 	SEMID	;Write Data to SemiDisk
	INR	A	;Write something different in every location
	ENDM

	CALL	ADDINK	;Increment Track & Sector as needed, not Byte Count
	JNZ	PETE	;Loop until SemiDisk filled with test Data bytes

	CALL	CONSTAT	;Check for operator interrupt

;SemiDisk is now loaded with Binary Progession Data.  The first byte of each
;Sector is Pusdo-Random.

	CALL	PRINT
	DB	CR,LF,'Reading',CR,LF,'$' 

	CALL	ADDSET	;Set up SemiDisk addresses
REPETE	CALL	ADDWRT	;Write Track and Sector addresses to SemiDisk
	LDA	DATA	;Get initial data byte
	MOV	E,A	;Store it in E

	REPT	BYTES	;Fast Sector read
	IN	SEMID	;Read SemiDisk Data
	XRA	E	;Exclusive-OR SemiDisk data with test, errors are ones
	CNZ	BADB	;If Zero Flag not set, errors present, update map
	INR	E	;Set up E for next Read
	ENDM

	CALL	ADDINK	;Increment Track and Sector
	JNZ	REPETE	;Loop until all bytes read and checked

	LDA	DATA	;Get test byte
	CMA		;Compliment it
	RLC		;Shift left
	STA	DATA	;Store away new test byte for next test cycle
	CALL	PMAP	;Print Array map
	CALL	CONSTAT	;Check for operator interrupt

TEST3:	CALL	PRINT	;Notify operator
	DB	CR,LF,'TEST3 Byte Access Test, Read-Write-Read',CR,LF
	DB	'Clearing SemiDisk',CR,LF,'$'

	CALL	CLEAR	;Fill the SemiDisk with zeros

	CALL	PRINT
	DB	CR,LF,'Testing',CR,LF,'$'

	LXI	H,TABLE	;Put Data Table address in HL

RECUR:	MVI	A,'.'
	CALL	CHOUT	;Print activity dot

	INX	H	;Increment HL to address of next byte in TABLE
	MOV	E,M	;Store new test byte in E
	DCX	H	;Move HL back to old test byte address
	CALL	ADDSET	;Set up initial addresses

RECUR1:	CALL	ADDOUT	;Write Track, Sector, and Byte Count to SemiDisk

	REPT	BYTES
	IN	SEMID	;Read SemiDisk data
	XRA	M	;Is data the same as previously written?
	CNZ	BADB	;If not, update Error-Map
	MOV	A,D	;Put byte count in Acc
	OUT	SEMIB	;Reassert previous byte count on SemiDisk
	MOV	A,E	;Put new test byte in Acc
	OUT	SEMID	;Write it to the SemiDisk
	MOV	A,D	;Get current byte count again
	OUT	SEMIB	;Reassert it again
	IN	SEMID	;Read the new byte just written
	XRA	E	;Did it change?
	CNZ	BADB	;If it did, update the Error Map
	INR	D	;Go on to next byte in sector
	ENDM

	MVI	D,00	;Reset Byte counter to zero
	INR	B	;Advance to next Sector
	MOV	A,B	;Put Sector count in Acc
	CPI	SECTS	;Done?
	JNZ	RECUR1	;If not, go do next Sector

	MVI	B,00	;Reset Sector count to zero
	INR	C	;Advance to next Track
	MOV	A,C	;Put Track count in Acc
	CPI	TRACS	;More Tracks?
	JNZ	RECUR1	;If more to test, loop

	REPT	4
	CALL	PAUSE10	;Here is the pause that refreshes
	ENDM

	CALL	CONSTAT	;Check for operator interrupt
	INX	H	;Set HL for address of next new test byte
	XRA	A	;Clear Acc
	CMP	M	;Is it the final byte?
	JNZ	RECUR	

			;ROOM FOR MORE TESTS

			;ALL TESTS HAVE BEEN COMPLETED AND THE SemiDisk MAP
			;HAS BE UPDATED WITH THE BAD CHIPS MARKED AS SUCH

	CALL	PMAP	;Print Array map

DONE:	CALL	PRINT
	DB	CR,LF,LF,'Good chips are :',GOODC,', Bad chips are :',BADC,CR,LF
	DB	'Test Failures this Pass:$'

	LHLD	BADCO	;GET BAD CHIP COUNT
	CALL	DECO	;DECIMAL OUTPUT

	CALL	PRINT
	DB	', Pass number :$'

	LHLD	PC	;GET PASS COUNT
	INX	H	;INCREMENT
	SHLD	PC	;STORE BACK
	CALL	DECO	;DECIMAL OUTPUT

	CALL PRINT
	DB	CR,LF,'$'

	XRA	A	;Clear Acc
	STA	BADCO	;Zero Bad Count
	STA	BADCO+1	;For next pass

	CALL	CONSTAT	;Is Console char pending? Jump to RETRY if so.

	LDA	MODE	;SHOULD WE DO IT AGAIN ?
	ORA	A
	JNZ	TEST2	;Start another test sequence
	JMP	RETRY	;Else go to Menu


CPM:	CALL	PRINT
	DB	CR,LF,LF,'$'

	MVI	C,RESET	;BACK TO CP/M
	JMP	BDOS

			;THIS ROUTINE FINDS BITS IN THE ACCUMULATOR
			;AND CALLS BITF; WHICH UPDATES THE BAD CHIP MAP

BADB:	PUSHALL		;Save registers
	MVI	L,8

BADL:	RRC		;ROTATE BIT INTO CARRY
	CC	BITF	;WE FOUND A ONE

	DCR	L	;DECREMENT BIT COUNTER
	JNZ	BADL	;MORE BITS ?

	POPALL		;Restore registers
	RET		;BACK TO WHEREVER

			;PROCCESS SECTOR NUMBER AND BIT POSITION TO
			;FORMULATE INDEX INTO BAD CHIP ARRAY
			;
			;@BAD+(SECTOR[B]/2)+((BIT NUMBER[L]-1)*CHIPS PER ROW)

BITF:	PUSHALL
	MOV	A,L	;GET BIT NUMBER
	DCR	A	;ONE LESS SINCE WE STARTED AT 8
	RLC		;* 2
	RLC		;* 4
	RLC		;* 8

	IF	S1MEG
	RLC		;* 16
	ENDIF

	IF	S15MEG
	MOV	B,A
	ADD	B
	ADD	B	;*24
	ENDIF

	IF	S2MEG
	RLC		;* 16
	RLC		;* 32
	ENDIF

	LXI	H,BAD	;POINT TO BAD CHIP ARRAY
	MVI	D,0	;ADD DISTANCE
	MOV	E,A
	DAD	D	;TOTALIZE WORD

	MOV	A,B	;GET SECTOR NUMBER
	RRC		;/ 2
	MOV	E,A	;SAVE
	DAD	D	;ADD OFFSET

	MVI	M,BADC	;MARK THIS CHIP AS BAD

	POPALL		;Restore all registers and flags
	RET		;Return to caller

			;DECIMAL OUTPUT ROUTINE

DECO:	PUSHALL		;Save all registers and flags

	LXI	D,-10000;TEN THOUSANDS
	CALL	DECO2	;DIVIDE

	LXI	D,-1000	;THOUSANDS
	CALL	DECO2	;DIVIDE

	LXI	D,-100	;HUNDREDS
	CALL	DECO2	;DIVIDE

	LXI	D,-10	;TENS
	CALL	DECO2	;DIVIDE

	LXI	D,-1	;ONES
	CALL	DECO2	;DIVIDE

	POPALL		;Restore all registers
	RET

DECO2:	MVI	A,'0'-1	;SET UP COUNTER

DECO3:	MOV	B,H	;SAVE H AND L
	MOV	C,L
	INR	A	;INCREMENT COUNTER
	DAD	D	;SUBTRACT
	JC	DECO3	;STILL MORE ?
	MOV	H,B	;RETURN H AND L BEFORE WRAP
	MOV	L,C
	JMP	CHOUT	;OUTPUT		

			;OUTPUT A STRING TERMINATED BY A DOLLAR SIGN

PRINT:	POP	H	;GET POINTER
PRINL:	MOV	A,M	;GET CHARACTER
	INX	H	;POINT TO NEXT CHARACTER
	CPI	'$'	;END OF STRING ?
	JNZ	PRINM	;GUESS NOT, KEEP GOING
	PCHL		;CONTINUE WHERE WE LEFT OFF

PRINM:	CALL	CHOUT	;OUTPUT
	JMP	PRINL	;ANOTHER CHARACTER

			;OUTPUT CHARACTER IN ACCUMULATOR

CHOUT:	PUSHALL		;SAVE EVERYTHING

	MVI	C,CONOUT;CP/M OUTPUT COMMAND
	MOV	E,A	;CHARACTER IN E, WHY NOT ACC ?
	CALL	BDOS	;LINK TO CP/M
	POPALL		;RETURN EVERYTHING
	RET

CHIN:	MVI	C,CONIN	;CONSOLE INPUT
	JMP	BDOS	;GET INTO CP/M


ADDSET:	MVI	B,0	;Set Sector Address to Zero
	MVI	C,0	;Set Track Address to Zero
	MVI	D,0	;Set Byte Counter to Zero
	RET		;Return

ADDOUT:	MOV	A,C	;Load Acc with the Track
	OUT	SEMIT	;Write the Track to the SemiDisk
	MOV	A,B	;Load Acc with the Sector
	OUT	SEMIS	;Write the Sector to the SemiDisk
	MOV	A,D	;Load Acc with the Byte Count
	OUT	SEMIB	;Write the Byte Count ot the SemiDisk
	RET		;Exit to calling routine

ADDINC:	INR	D	;Increment Byte Count
	MOV	A,D	;Load Byte Count to Acc
	CPI	BYTES	;Last Byte?
	RNZ		;Return if more Bytes to test.

ADDINK:	MVI	D,0	;Reset Byte Count to Zero
	INR	C	;Increment Track Address
	MOV	A,C	;Load Track to Acc
	CPI	TRACS	;Last Track tested?
	RNZ		;Return is more Tracks to test

	MVI	A,'.'	;Put a dot in Acc
	CALL	CHOUT	;Output it as activity indicator

	MVI	C,00	;Reset Track count to zero
	INR	B	;Increment Sector Address
	MOV	A,B	;Load Acc with Sector
	CPI	SECTS	;Last Sector?
	RET		;Return with Zero-Flag not set if more Sectors to test

ADDWRT	MOV	A,C	;Load Acc with the Track
	OUT	SEMIT	;Write the Track to the SemiDisk
	MOV	A,B	;Load Acc with the Sector
	OUT	SEMIS	;Write the Sector to the SemiDisk
	RET		;Exit to calling routine

CONSTAT	PUSHALL		;Save Registers
	MVI	C,0BH	;Load C with console status code
	CALL	BDOS	;Go check console status
	ORA	A	;Is a character pending?
	JZ	RETURN	;No character pending, return
	CALL	PRINT
	DB	CR,LF,'Operator Interrupt Acknowledged',CR,LF,'$'
	XRA	A	;Clear Acc
	STA	MODE	;Store zero in MODE
	MVI	C,01	;Put Console Input code in C
	CALL	BDOS	;Go fetch pending character
	CPI	03	;Ctrl-C?
	JZ	CPM	;If so, exit to CP/M

RETURN	POPALL		;Restore Registers
	RET		;Return to caller

CLEAR:	CALL	ADDSET	;Set up initial SemiDisk addresses
CLEAR1:	CALL	ADDWRT	;Write address to SemiDisk
	XRA	A	;Clear Acc to zero

	REPT	BYTES
	OUT	SEMID	;Write Zeros to current DATA Byte
	ENDM

	CALL	ADDINK	;Increment Address, return with Zero-Flag set if done.
	JNZ	CLEAR1	;Loop if not done.
	CALL	CONSTAT	;Check for Operator interrupt
	RET		;Return to caller	

PMAP:	CALL	PRINT	;NO MORE TESTS, LETS TELL HUMAN WAT CHIPS ARE BAD
	DB	CR,LF,LF,'SemiDisk map',CR,LF,LF,'$'

	LXI	H,BAD	;SET THINGS TO TELL HUMAN ABOUT BAD BIT MAP
	MVI	B,CHIPS	;HOW MANY CHIPS ARE THERE IN THE MAP

CHIPB:	MVI	C,CHIPR	;HOW MANY CHIPS ARE THERE PER ROW

CHIPC:	MOV	A,M	;GET CHARACTER
	CPI	BADC	;IS THIS A BAD CHIP?
	JNZ	CHIPD	;GUESS NOT
	PUSH	H	;SAVE AWAY
	LHLD	BADCO	;GET BAD CHIP COUNT
	INX	H	;INCREMENT
	SHLD	BADCO	;PUT BACK
	POP	H	;BRING BACK

CHIPD:	CALL	CHOUT	;TELL HUMAN
	INX	H	;POINT TO NEXT CHIP
	DCR	B	;MORE CHIPS ?
	RZ		;Done if Zero-Flag set, return to caller
	DCR	C	;MORE ON THIS ROW ?
	JNZ	CHIPC	;GUESS SO
	MVI	A,CR	;NEW LINE
	CALL	CHOUT	;OUTPUT
	MVI	A,LF	;PAPER
	CALL	CHOUT	;OUTPUT
	JMP	CHIPB

PAUSE:	PUSHALL		;Save all registers
	LXI	H,00	;Load initial time value

PAUS1:	INR	L	;Increment L
	JNZ	PAUS1	;If it's not zero, do it again
	INR	H	;else, increment h
	JNZ	PAUS1	;overflow? no, go increment some more
	POPALL		;Restore all registers
	RET

PAUSE10:REPT	10	;10 pauses.
	CALL	PAUSE
	ENDM
	RET


			;RAM MEMORY

DATA	DB	01H	;Initial Test2 Data
MODE:	DS	1	;MODE FLAG
BADCO:	DS	2	;BAD CHIP COUNTER
PC:	DW	00	;PASS COUNTER
BAD:	DS	CHIPS	;BAD CHIP ARRAY
TABLE:	DB	0,0ffh,0aah,055h,033h,0cch,0f0h,0fh
ENDATA:	DB	00

END	END		;End of Assembly
