	PAGE	65
	TITLE	'RELOCATABLE SemiDisk DRIVER BY MIKE ENKELIS'
;						COMPUTEK SOFTWARE
;						PORTLAND, OREGON
;
TRUE	EQU	-1
FALSE	EQU	NOT TRUE
;
DRV	EQU	3		;DRIVER VER#
Z80	EQU	FALSE		;ZILOG Z80 MICRO
SD$I	EQU	TRUE		;SemiDisk I DRIVER
SD$II	EQU	NOT SD$I	;SemiDisk II DRIVER
SPOOLER	EQU	TRUE		;SemiSpool OPTION
FLUSH	EQU	'J'-40H		;FLUSH SPOOL BUFFER
;
X1	SET	0
X2	SET	0
X4	SET	0
X8	SET	0
;
	IF	SD$II
X1	SET	00010000B
	ENDIF
	IF	SPOOLER
X2	SET	00100000B
	ENDIF
	I	Z80
X4	SET	01000000B
	ENDIF
;
VER	SET	(X8 OR X4 OR X2 OR X1) + DRV
;
	IF	Z80
	$-MACRO
;	LDIR			LDIR			LDIR
;	DJNZ	ADDR		DJNZ	ADDR-$		DJNZ	ADDR
;	INIR			INIR			INIR
;	OUTIR			OTIR			OUTIR

LDIR	MACRO		
	DB	0EDH,0B0H
	ENDM
DJNZ	MACRO	?N
	DB	10H,?N-$-1
	ENDM
INIR	MACRO		
	DB	0EDH,0B2H
	ENDM
OUTIR	MACRO		
	DB	0EDH,0B3H
	ENDM
	ENDIF
;
	IF SD$I AND NOT SPOOLER
SIZE	SET	1024		;4 PAGES
	ENDIF
	IF SD$II AND NOT SPOOLER
SIZE	SET	1024		;4 PAGES
	ENDIF
	IF SD$I AND SPOOLER
SIZE	SET	1280		;5 PAGES
	ENDIF
	IF SD$II AND SPOOLER
SIZE	SET	1280		;5 PAGES
	ENDIF
;
	ORG	0000
;
BASE		EQU	128
SEMI$DATA	EQU	BASE+0		;DATA PORT IN/OUT
SEMI$BYTE	EQU	BASE+1		;SET BYTE   (0 - 7F)
SEMI$TRACK	EQU	BASE+2		;SET TRACK  (0 - FF)
SEMI$SECTOR	EQU	BASE+3		;SET SECTOR (0 - XX)
;
	IF	SD$II
SEMI$STATUS	EQU	BASE+1		;STATUS PORT
SEMI$RO		EQU	BASE+2		;SET R/O
SEMI$RESET	EQU	BASE+3		;RESET PARITY,R/O
	ENDIF
;
;	START OF SemiDisk DRIVER
;
SERIAL: DW	0,0,0	;CP/M SERIAL NUMBER.

@BDOS:	JMP	INSTALL	;ENTRY TO INSTALL.

@BS:	DW	0	;BDOS:BAD SECTOR
@SE:	DW	0	;BDOS:SELECT
@RO:	DW	0	;BDOS:R/O
@FRO:	DW	0	;BDOS:FILE R/O
;
;	OPTION BITS
;
;	PARITY NEEDS TWO (2) TRACKS FOR STORAGE.
;	BIT 7=1, IGNORE READ ERRORS.
;	BIT 6=1, ENABLE WARM BOOT (^C).
;	BIT 5=1, ENABLE READ AFTER WRITE.
;	BIT 4=1, DISK MAPPING ENABLE.
;
;	BIT 3=	SYSTEM TABLE SIZE
;	BIT 2=	SYSTEM TABLE SIZE
;	BIT 1=	SYSTEM TABLE SIZE
;	BIT 0=	SYSTEM TABLE SIZE
;
;		7654 3210	<-LSB
?OPT:	DB	0011$0000B	;SemiDisk OPTIONS, P+,B+,V+,M+
;
;
;	BITS 3-0 SEMIDISK SELECT
;	BITS 4-7 USER NUMBER
;
;		7654 3210	<- LSB
?ME:	DB	0000$0100B	;SemiDisk SELECT CODE, E:
;
;	DRIVER LOADED FLAGS
FLAG:	DB	51H,6DH		;RADIX 50 LOGGED FLAG
DRV$VER DB	VER		;DRIVER CODES & VERSION#
LOCATE:	DB	0		;LOCATE ABOVE BIOS FLAG
TRKMIN:	DB	0		;FIRST SPOOL TRACK <-PATCHED
;
;	DISK DEF TABLE 512k DEFAULT
;
DPB:	DW	16	;SPT
	DB	4	;BSH
	DB	15	;BLM
	DB	1	;EXM
DSM:	DW	252	;DSM(-1)
	DW	127	;DRM(-1)
	DB	192	;AL0
	DB	0	;AL1
	DW	0	;CKS
	DW	2	;OFF
;
	PAGE
;
;	SYSTEM BIOS SAVE TABLE
;
	IF NOT SPOOLER
@WBOOT: JMP	0	;WARM BOOT
@HOME:	JMP	0	;HOME DISK HEADS
@SELDK: JMP	0	;SELECT DISK
@SETTK: JMP	0	;SET TRACK
@SETSC: JMP	0	;SET SECTOR
@SETDM: JMP	0	;SET DMA ADDR
@READ:	JMP	0	;READ SECTOR
@WRITE: JMP	0	;WRITE SECTOR
@LISTS: JMP	0	;DUMMY
@SECTR: JMP	0	;SECTOR XLATE
@CONOUT	SET	0	;DUMMY
	ENDIF

	IF	SPOOLER
@WBOOT: JMP	0	;WARM BOOT
@CONST:	JMP	0	;CONSOLE STATUS
@CONIN:	JMP	0	;CONSOLE INPUT
@CONOUT:JMP	0	;CONSOLE OUTPUT
@LIST:	JMP	0	;SPOOLED LIST OUTPUT
@PUNCH:	JMP	0	;PUNCH
@READER:JMP	0	;READER
@HOME:	JMP	0	;HOME DISK HEADS
@SELDK: JMP	0	;SELECT DISK
@SETTK: JMP	0	;SET TRACK
@SETSC: JMP	0	;SET SECTOR
@SETDM: JMP	0	;SET DMA ADDR
@READ:	JMP	0	;READ SECTOR
@WRITE: JMP	0	;WRITE SECTOR
@LISTS: JMP	0	;LIST STATUS
@SECTR: JMP	0	;SECTOR XLATE
	ENDIF
;
;-----------------------;
;
;	SEMIDISK DRIVER BIOS TABLE
;	COPYED INTO CBIOS ON LOAD
;
	IF NOT SPOOLER
?WBOOT: JMP	WBOOT	;WARM BOOT
?HOME:	JMP	HOME	;HOME DISK HEADS
?SELDK: JMP	SELDK	;SELECT DISK
?SETTK: JMP	SETTK	;SET TRACK
?SETSC: JMP	SETSC	;SET SECTOR
?SETDM: JMP	SETDM	;SET DMA ADDR
?READ:	JMP	READ	;READ SECTOR
?WRITE: JMP	WRITE	;WRITE SECTOR
?LISTS: JMP	@LISTS	;DUMMY
?SECTR:	JMP	SECTR	;SECTOR XLATE
	ENDIF

	IF	SPOOLER
?WBOOT: JMP	WBOOT	;WARM BOOT
?CONST:	JMP	CONST	;CONSOLE STATUS
?CONIN:	JMP	CONIN	;CONSOLE INPUT
?CONOUT:JMP	CONOUT	;CONSOLE OUTPUT
?LIST:	JMP	LIST	;LIST OUTPUT
?PUNCH:	JMP	@PUNCH	;PUNCH
?READER:JMP	@READER	;READER
?HOME:	JMP	HOME	;HOME DISK HEADS
?SELDK: JMP	SELDK	;SELECT DISK
?SETTK: JMP	SETTK	;SET TRACK
?SETSC: JMP	SETSC	;SET SECTOR
?SETDM: JMP	SETDM	;SET DMA ADDR
?READ:	JMP	READ	;READ SECTOR
?WRITE: JMP	WRITE	;WRITE SECTOR
?LISTS: JMP	LISTS	;LIST STATUS
?SECTR:	JMP	SECTR	;SECTOR XLATE
	ENDIF
;
;	DISK PARM TABLE
;
DPE:	DW	0,0	;TRANSLATE TABLE
	DW	0,0	;SCRATCH AREA
	DW	DIR,DPB ;DIRECTORY,DISK TABLE
	DW	CSV,ALV ;CHECK,ALLOC VECTORS

	IF	SD$I
;
;	WARM BOOT RELOAD
;
WBOOT:	LXI	SP,80H	;RESET STACK
	LDA	LOCATE	;RELOCATE FLAG
	ORA	A	;SET?
	JNZ	@WBOOT	;YES, RELOAD CCP,BDOS
;
; RESTORE DRIVER TRAP TABLE
	LXI	H,SAVE	;HL=GET
	LXI	D,@BS	;DE=PUT
	IF	Z80
	LXI	B,8	;LENGTH
	LDIR
	ELSE
	MVI	B,8	;LENGTH
WBOOTL:	MOV	A,M	;GET BYTE
	STAX	D	;PUT BYTE
	INX	H	;NEXT GET
	INX	D	;NEXT PUT
	DCR	B	;COUNT
	JNZ	WBOOTL	;LOOP
	ENDIF
;
	LDA	4	;GET CURRENT DISK #
	MOV	C,A	;INTO REG C.
	LDA	?OPT	;GET OPTION FLAGS
	ANI	40H	;B-?
	JNZ	CBOOT	;DO SEMI-COLD BOOT
;
	LXI	H,@BDOS ;HL=BASE OF MODULE
	SHLD	6	;ELSE, RESTORE BASE
	LXI	D,SIZE	;DRIVER SIZE
	DAD	D	;HL=HL+DRIVER SIZE (BASE OF CCP)
	MVI	L,3	;HL=HL+3
	PCHL		;JUMP TO CCP BASE+3
;
;	MOVE TO TRACK 'ZERO'
;
HOME:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@HOME	;NOT SemiDisk
	JMP	SETT0	;SET TRACK #000
;
;	SELECT 'SemiDisk' FOR NEXT READ/WRITE
;
SELDK:	LXI	H,DPE	;HL=POINTER TO DPE
	LDA	?ME	;ACC.=MY SELECT CODE
	SUB	C	;AM I SELECTED?
	STA	SEMI	;SAVE SELECT FLAG
	RZ		;SemiDisk SELECTED?
	JP	@SELDK	;NOPE,SELECT UNMAPPED DISK?
	LDA	?OPT	;GET OPTION FLAGS
	ANI	10H	;DISK MAPPING ENABLED?
	JZ	@SELDK	;NO, OVERRIDE DISK
	DCR	C	;MAP DISK DRIVES
	JMP	@SELDK	;SELECT FLOPPY DISK
;
;	SELECT 'TRACK' FOR NEXT READ/WRITE
;
SETTK:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@SETTK	;NOT SemiDisk
	MOV	A,C	;A=TRACK#
SETT0:	STA	TRACK
	RET

	PAGE
;
;	SELECT 'SECTOR' FOR NEXT READ/WRITE
;
SETSC:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@SETSC	;NOT SemiDisk
	MOV	A,C	;A=SECTOR#
	STA	SECTOR	;
	RET
;
;	SET DMA POINTER FOR NEXT READ/WRITE
;
SETDM:	MOV	H,B	;H=DMA (HIGH)
	MOV	L,C	;L=DMA (LOW)
	SHLD	DMA	;SET SemiDisk DMA POINTER
	JMP	@SETDM	;SET CBIOS DMA POINTER
;
;	TRANSLATE 'LOGICAL' SECTOR TO 'PHYSICAL' SECTOR
;
SECTR:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@SECTR	;NOT SemiDisk
	MVI	H,0	;H=ZERO
	MOV	L,C	;L=SECTOR#
	RET		;RETURN XLATED SECTOR#
;
;	READ SemiDisk 'SECTOR' into MEMORY
;
READ:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@READ	;NOT SemiDisk
	MVI	E,5	;SET RETRY COUNTER
RREAD:	CALL	SETUP	;SET DISK TRACK,SECTOR,BYTE & DMA
PP$1	EQU	$+1	;READ DATA PORT
READL:	IN	SEMI$DATA
	MOV	M,A	;READ INTO MEMORY
	XRA	C	;FORM
	RLC		; CRC
	MOV	C,A	;SAVE CRC
	INX	H	;+DMA
	IF	Z80
	DJNZ	READL	;LOOP TILL DONE
	ELSE
	DCR	B	;-COUNT
	JNZ	READL	;LOOP TILL DONE
	ENDIF
	CALL	PARITY	;FIND PARITY BYTE
PP$2	EQU	$+1	;READ DATA PORT
	IN	SEMI$DATA
	XRA	C	;TEST FOR READ ERRORS
	JZ	DESLCT	;NORMAL EXIT
;
;	BAD SECTOR RE-TRY
;
	DCR	E	;COUNT DOWN READ-RETRY
	JNZ	RREAD	;RE-READ LAST SECTOR
;
;	DECODE PARITY ERROR REPORT SWITCH
;
ERROR:	CALL	DESLCT	;ERROR EXIT
	LDA	?OPT	;GET OPTION FLAGS
	CMA		;INVERT OPTION WORD
	ANI	80H	;P-?
	RZ		;ACC=0,INGNORE PARITY ERROR

	PAGE
;
;          ** BAD SECTOR **
;	TRACK & SECTOR DISPLAY
;
	CALL	PRINT
	DB	0DH,0AH
	DB	'Track=',0
	LDA	TRACK	;GET CURRENT TRACK#
	CALL	PDEC	;DISPLAY IN BASE 10
	CALL	PRINT
	DB	', Sector=',0
	LDA	SECTOR	;GET CURRENT SECTOR#
	CALL	PDEC	;DISPLAY IN BASE 10
	CALL	DESLCT	;ERROR EXIT
	MVI	A,1	;SET FLAG
	RET
;
;	BINARY TO DECIMAL
;
PDEC:	MVI	B,100	;/100
	CALL	PDEC1	;
	MVI	B,10	;/10
	CALL	PDEC1	;
	ADI	'0'	;/1
	MOV	C,A	;INTO REG C.
DISP:	JMP	@CONOUT	;DIRECT BIOS CALL: CONOUT

PDEC1:	MVI	C,'0'-1 ;PRE-LOAD DECIMAL VALUE
PDEC2:	INR	C	;+1
	SUB	B	;-DIV
	JNC	PDEC2	;LOOP
	ADD	B	;CORRECT
	PUSH	PSW	;SAVE VALUE
	CALL	DISP
	POP	PSW	;RESTORE VALUE
	RET
;
PRINT:	POP	H	;GET ADDRESS
	MOV	A,M	;GET DATA
	INX	H	;NEXT ADDR
	PUSH	H	;SAVE IT
	ORA	A	;END OF STRING?
	RZ		;YES
	MOV	C,A	;ELSE
	CALL	DISP	;DISPLAY IT
	JMP	PRINT	;NEXT BYTE
;
	PAGE
;
;	WRITE SemiDisk 'SECTOR' from MEMORY
;
WRITE:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@WRITE	;NOT SEMIDISK
	CALL	SETUP	;SET DISK TRACK,SECTOR,BYTE & DMA
WRITEL: MOV	A,M	;GET FROM MEMORY
PP$3	EQU	$+1	;WRITE DATA PORT
	OUT	SEMI$DATA
	XRA	C	;FORM
	RLC		; CRC
	MOV	C,A	;SAVE CRC
	INX	H	;+DMA
	IF	Z80
	DJNZ	WRITEL	;LOOP TILL DONE
	ELSE
	DCR	B	;-COUNT
	JNZ	WRITEL	;LOOP TILL DONE
	ENDIF
	CALL	PARITY	;FIND PARITY BYTE
	MOV	A,C	;ACC.=SECTOR PARITY
PP$4	EQU	$+1	;WRITE DATA PORT
	OUT	SEMI$DATA
;
;	READ AFTER WRITE CHECK
;
	LDA	?OPT	;GET OPTION FLAGS
	ANI	20H	;V-?
	JZ	DESLCT	;READ AFTER WRITE DISABLED
;
;	READ AFTER WRITE ENABLED
;
	CALL	SETUP	;SET DISK TRACK,SECTOR,BYTE & DMA
PP$5	EQU	$+1	;READ DATA PORT
RAW:	IN	SEMI$DATA
	CMP	M	;MATCH?
	JNZ	ERROR	;NO,REPORT WRITE ERROR
	INX	H	;+DMA	
	IF	Z80
	DJNZ	RAW	;TEST NEXT
	ELSE
	DCR	B	;-COUNT
	JNZ	RAW	;TEST NEXT
	ENDIF
;
;	DESELECT SEMIDISK AFTER READ/WRITE
;
DESLCT:	MVI	A,255	;DESELECT CODE
	JMP	UNSLCT	;RETURN STATUS=OK

	PAGE
;
;	SET UP FOR READ/WRITE TO SEMIDISK.
;	ON EXIT HL='DMA' POINTER
;	C(PARITY)=0 value
;	B(SECTOR)=128 length
;
SETUP:	LHLD	TRACK	;H=SECTOR#,L=TRACK#
	MOV	A,L	;XFER TRACK# TO ACC.
PP$6	EQU	$+1
	OUT	SEMI$TRACK
	MOV	A,H	;XFER SECTOR# TO ACC.
	LHLD	DMA	;GET DMA ADDR.
	LXI	B,8080H	;B=128,C=128
;
PP$7	EQU	$+1	;WRITE SECTOR PORT
UNSLCT:	OUT	SEMI$SECTOR
	XRA	A	;A=0
PP$8	EQU	$+1	;CLEAR BYTE COUNTER
	OUT	SEMI$BYTE
	RET
;
;	RETURN SEMIDISK BOARD SET TO PARITY TRACK,SECTOR,BYTE
;	ON ENTRY SECTOR SET CORRECTLY
;	ON EXIT	TRACK,BYTE SET TO PARITY BLOCK
;
PARITY: LDA	TRACK	;GET CURRENT TRACK
	PUSH	PSW	;SAVE TRACK
	RLC		;LEFT ROTATE
	ANI	1	;MASK TO TRACK 0,1
PP$9	EQU	$+1	;WRITE TRACK PORT
	OUT	SEMI$TRACK
	POP	PSW	;GET TRACK BACK
	JMP	PP$8-1	;USE AS BYTE POINTER

	PAGE
;
;	SEMI-COLD BOOT.
;	READ CP/M INTO SYSTEM, AND CREATE A BATCH FILE
;	TO RELOAD SemiDisk DRIVER
;
CBOOT:	LXI	H,SERIAL;HL=BASE OF DRIVER
	SHLD	39H	;SET BASE FLAG
	LDA	?ME	;A.=SELECTED DISK #
	ADI	'A'	;CONVERT TO ASCII DRIVE#
	STA	DRIVE	;SAVE IT
;	CLEAR FCB TABLES	;
	MVI	A,50H	;WBOOT FLAG
	STA	FLAG+1	;MARK WBOOT IN PROGRESS
	LXI	H,DIR	;HL=DIRECTORY BUFFER
	LXI	B,2000H	;B=TABLE LENGTH,C=0
LOOP:	MOV	M,C	;CLEAR BYTE
	INX	H	;HL=HL+1
	IF	Z80
	DJNZ	LOOP	;LOOP
	ELSE
	DCR	B	;B=B-1
	JNZ	LOOP	;LOOP
	ENDIF
;	RESET DISK SYSTEM R/W	;
	MVI	C,13	;COMMAND=RESET DISK SYSTEM
	CALL	@BDOS	;
;	MAKE $$$ FILE		;
	LXI	D,FCB	;POINT TO FCB
	PUSH	D	;SAVE FCB
	PUSH	D	;SAVE FCB
	MVI	C,22	;COMMAND=MAKE FILE
	CALL	@BDOS	;
	XRA	A	;A.=00
	STA	FCB+32	;CLEAR RC FIELD
;	SET DMA POINTER		;
	LXI	D,AUTO	;AUTO RE-LOAD
	MVI	C,26	;COMMAND=SET DMA
	CALL	@BDOS
;	WRITE 1 SECTOR		;
	POP	D	;RESTORE FCB POINTER
	MVI	C,21	;COMMAND=WRITE
	CALL	@BDOS
;	CLOSE BATCH FILE	;
	POP	D	;RESTORE FCB POINTER
	MVI	C,16	;COMMAND=CLOSE
	CALL	@BDOS
;	RELOAD CP/M & DRIVER	;
	JMP	@WBOOT
;
;	BDOS ERROR HANDLER
;
BS:	LHLD	@BS		;BAD SECTOR
	PCHL			;EXECUTE
SE:	LHLD	@SE		;SELECT
	PCHL			;EXECUTE
RO:	LHLD	@RO		;DISK R/O
	PCHL			;EXECUTE
FRO:	LHLD	@FRO		;FILE R/O
	PCHL			;EXECUTE
;
	ENDIF
;
;-----------------------;
;
	IF	SD$II
;
;	WARM BOOT RELOAD
;
WBOOT:	LXI	SP,80H	;RESET STACK
	LDA	LOCATE	;RELOCATE FLAG
	ORA	A	;SET?
	JNZ	@WBOOT	;YES, RELOAD CCP,BDOS
;
; RESTORE DRIVER TRAP TABLE
	LXI	H,SAVE	;HL=GET
	LXI	D,@BS	;DE=PUT
	IF	Z80
	LXI	B,8	;LENGTH
	LDIR
	ELSE
	MVI	B,8	;LENGTH
WBOOTL:	MOV	A,M	;GET BYTE
	STAX	D	;PUT BYTE
	INX	H	;NEXT GET
	INX	D	;NEXT PUT
	DCR	B	;COUNT
	JNZ	WBOOTL	;LOOP
	ENDIF
;
	LDA	4	;GET CURRENT DISK #
	MOV	C,A	;INTO REG C.
	LDA	?OPT	;GET OPTION FLAGS
	ANI	40H	;B-?
	JNZ	CBOOT	;DO SEMI-COLD BOOT
;
	LXI	H,@BDOS ;HL=BASE OF MODULE
	SHLD	6	;ELSE, RESTORE BASE
	LXI	D,SIZE	;DRIVER SIZE
	DAD	D	;HL=HL+DRIVER SIZE (BASE OF CCP)
	MVI	L,3	;HL=HL+3
	PCHL		;JUMP TO CCP BASE+3
;
;	MOVE TO TRACK 'ZERO'
;
HOME:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@HOME	;NOT SemiDisk
	JMP	SETT0	;SET TRACK #000
;
;	SELECT 'SemiDisk' FOR NEXT READ/WRITE
;
SELDK:	LXI	H,DPE	;HL=POINTER TO DPE
	LDA	?ME	;ACC.=MY SELECT CODE
	SUB	C	;AM I SELECTED?
	STA	SEMI	;SAVE SELECT FLAG
	RZ		;SemiDisk SELECTED?
	JP	@SELDK	;SELECT UNMAPPED DISK?
;
	LDA	?OPT	;GET OPTION FLAGS
	ANI	10H	;DISK MAPPING ENABLED?
	JZ	@SELDK	;NO, OVERRIDE DISK
	DCR	C	;MAP DISK DRIVES
	JMP	@SELDK	;SELECT FLOPPY DISK
;
;	SELECT 'TRACK' FOR NEXT READ/WRITE
;
SETTK:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@SETTK	;NOT SemiDisk
	MOV	A,C	;A=TRACK#
SETT0:	STA	TRACK
	RET

	PAGE
;
;	SELECT 'SECTOR' FOR NEXT READ/WRITE
;
SETSC:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@SETSC	;NOT SemiDisk
	MOV	A,C	;A=SECTOR#
	STA	SECTOR	;
	RET
;
;	SET DMA POINTER FOR NEXT READ/WRITE
;
SETDM:	MOV	H,B	;H=DMA (HIGH)
	MOV	L,C	;L=DMA (LOW)
	SHLD	DMA	;SET SemiDisk DMA POINTER
	JMP	@SETDM	;SET CBIOS DMA POINTER
;
;	TRANSLATE 'LOGICAL' SECTOR TO 'PHYSICAL' SECTOR
;
SECTR:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@SECTR	;NOT SemiDisk
	MVI	H,0	;H=ZERO
	MOV	L,C	;L=SECTOR#
	RET		;RETURN XLATED SECTOR#
;
;	READ SemiDisk 'SECTOR' into MEMORY
;
READ:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@READ	;NOT SemiDisk
	MVI	E,5	;SET RETRY COUNTER
RREAD:	CALL	SETUP	;SET DISK TRACK,SECTOR,BYTE & DMA
	IF	Z80
PP$1	EQU	$+1	;READ DATA PORT
	MVI	C,SEMI$DATA
READL:	INIR		;READ DATA
	ELSE
PP$1	EQU	$+1	;READ DATA PORT
READL:	IN	SEMI$DATA
	MOV	M,A	;READ INTO MEMORY
	INX	H	;+DMA
	DCR	B	;-COUNT
	JNZ	READL	;LOOP TILL DONE
	ENDIF
	CALL	STATUS	;GET STATUS
	MOV	A,D	;A=STATUS
	ANI	1	;PARITY ERROR?
	JZ	DESLCT	;NORMAL EXIT
;
;	BAD SECTOR RE-TRY
;
	DCR	E	;COUNT DOWN READ-RETRY
	JNZ	RREAD	;RE-READ LAST SECTOR
;
;	DECODE PARITY ERROR REPORT SWITCH
;
ERROR:	CALL	DESLCT	;ERROR EXIT
	LDA	?OPT	;GET OPTION FLAGS
	CMA		;INVERT OPTION WORD
	ANI	80H	;P-?
	RZ		;ACC=0,INGNORE PARITY ERROR

	PAGE
;
;		** BAD SECTOR **
;	TRACK & SECTOR DISPLAY
;
	CALL	PRINT
	DB	0DH,0AH,0
	CALL	STATUS	;GET STATUS
	MOV	A,D	;A=STATUS
	RAR		;PARITY?
	PUSH	PSW	;SAVE STATUS
	JNC	ERROR1	;NO
	CALL	PRINT
	DB	'Parity error,',0
ERROR1:	POP	PSW	;GET BACK STATUS
	RAR		;R/O?
	JNC	ERROR2	;NO
	CALL	PRINT
	DB	'R/O,',0
ERROR2:	CALL	PRINT
	DB	'Track=',0
	LDA	TRACK	;GET CURRENT TRACK#
	CALL	PDEC	;DISPLAY IN BASE 10
	CALL	PRINT
	DB	', Sector=',0
	LDA	SECTOR	;GET CURRENT SECTOR#
	CALL	PDEC	;DISPLAY IN BASE 10
	MVI	A,1	;SET FLAG
	RET
;
;	BINARY TO DECIMAL
;
PDEC:	MVI	B,100	;/100
	CALL	PDEC1	;
	MVI	B,10	;/10
	CALL	PDEC1	;
	ADI	'0'	;/1
	MOV	C,A	;INTO REG C.
DISP:	JMP	@CONOUT	;DIRECT BIOS CALL: CONOUT

PDEC1:	MVI	C,'0'-1 ;PRE-LOAD DECIMAL VALUE
PDEC2:	INR	C	;+1
	SUB	B	;-DIV
	JNC	PDEC2	;LOOP
	ADD	B	;CORRECT
	PUSH	PSW	;SAVE VALUE
	CALL	DISP
	POP	PSW	;RESTORE VALUE
	RET
;
PRINT:	POP	H	;GET ADDRESS
	MOV	A,M	;GET DATA
	INX	H	;NEXT ADDR
	PUSH	H	;SAVE IT
	ORA	A	;END OF STRING?
	RZ		;YES
	MOV	C,A	;ELSE
	CALL	DISP	;DISPLAY IT
	JMP	PRINT	;NEXT BYTE

	PAGE
;
;	WRITE SemiDisk 'SECTOR' from MEMORY
;
WRITE:	LDA	SEMI	;GET SemiDisk ACTIVE FLAG
	ORA	A	;SET PSW BYTE
	JNZ	@WRITE	;NOT SEMIDISK
	CALL	SETUP	;SET DISK TRACK,SECTOR,BYTE & DMA
	MOV	A,D	;GET STATUS
	RAR		;
	RAR		;R/O?
	JC	ERROR	;YES
	IF	Z80
PP$2	EQU	$+1	;WRITE DATA PORT
	MVI	C,SEMI$DATA
	OUTIR		;WRITE SECTOR
	ELSE
WRITEL: MOV	A,M	;GET FROM MEMORY
PP$2	EQU	$+1	;WRITE DATA PORT
	OUT	SEMI$DATA
	INX	H	;+DMA
	DCR	B	;-COUNT
	JNZ	WRITEL	;LOOP TILL DONE
	ENDIF
;
;	READ AFTER WRITE CHECK
;
	LDA	?OPT	;GET OPTION FLAGS
	ANI	20H	;V-?
	JZ	DESLCT	;READ AFTER WRITE DISABLED
;
;	READ AFTER WRITE ENABLED
;
	CALL	SETUP	;SET DISK TRACK,SECTOR,BYTE & DMA
PP$3	EQU	$+1	;READ DATA PORT
RAW:	IN	SEMI$DATA
	CMP	M	;MATCH?
	JNZ	ERROR	;NO,REPORT WRITE ERROR
	INX	H	;+DMA	
	IF	Z80
	DJNZ	RAW	;TEST NEXT
	ELSE
	DCR	B	;-COUNT
	JNZ	RAW	;TEST NEXT
	ENDIF
;
;	DESELECT SEMIDISK AFTER READ/WRITE
;
DESLCT:	MVI	A,255	;DESELECT CODE
	CALL	UNSLCT	;AND GET STATUS
	MOV	A,D	;INTO ACC
	ANI	1	;PARITY BIT
	RET

	PAGE
;
;	SET UP FOR READ/WRITE TO SEMIDISK.
;	ON EXIT HL='DMA' POINTER
;	B(SECTOR)=128 length
;
SETUP:	LHLD	TRACK	;H=SECTOR#,L=TRACK#
	MOV	A,L	;XFER TRACK# TO ACC.
PP$4	EQU	$+1	;WRITE TRACK PORT
	OUT	SEMI$TRACK
	MOV	A,H	;XFER SECTOR# TO ACC.
	LHLD	DMA	;GET DMA ADDR.
	MVI	B,128	;B=128
;
PP$5	EQU	$+1	;WRITE SECTOR PORT
UNSLCT:	OUT	SEMI$SECTOR
	XRA	A
PP$6	EQU	$+1	;CLEAR BYTE COUNTER
	OUT	SEMI$BYTE
;
; READ SEMIDISK II STATUS
;
;   RESETS PARITY ERROR
;
; D=00, NO PARITY ERROR, R/W
; D=01, PARITY ERROR, R/W
; D=10, NO PARITY ERROR, R/O
; D=11, PARITY ERROR, R/O
;
PP$7	EQU	$+1	;STATUS PORT
STATUS:	IN	SEMI$STATUS
	CMA		;INVERT BYTE
	ANI	07H	;LOWER 3 BITS
	MOV	D,A	;SAVE STATUS
	RAR		;PARITY ERROR?
	RNC		;NO ERROR TO RESET
	PUSH	PSW	;SAVE R/O BIT
PP$8	EQU	$+1	;PARITY RESET PORT
	IN	SEMI$RESET
	POP	PSW	;GET R/O BIT
	RAR		;SET?
	RNC		;NO
PP$9	EQU	$+1	;SET R/O BIT
	IN	SEMI$RO
	RET

	PAGE
;
;	SEMI-COLD BOOT.
;	READ CP/M INTO SYSTEM, AND CREATE A BATCH FILE
;	TO RELOAD SemiDisk DRIVER
;
CBOOT:	LXI	H,SERIAL;HL=BASE OF DRIVER
	SHLD	39H	;SET BASE FLAG
	LDA	?ME	;A.=SELECTED DISK #
	ADI	'A'	;CONVERT TO ASCII DRIVE#
	STA	DRIVE	;SAVE IT
;	CLEAR FCB TABLES	;
	MVI	A,50H	;WBOOT FLAG
	STA	FLAG+1	;MARK WBOOT IN PROGRESS
	LXI	H,DIR	;HL=DIRECTORY BUFFER
	LXI	B,2000H	;B=TABLE LENGTH,C=0
LOOP:	MOV	M,C	;CLEAR BYTE
	INX	H	;HL=HL+1
	IF	Z80
	DJNZ	LOOP	;LOOP
	ELSE
	DCR	B	;B=B-1
	JNZ	LOOP	;LOOP
	ENDIF
;	RESET DISK SYSTEM R/W	;
	MVI	C,13	;COMMAND=RESET DISK SYSTEM
	CALL	@BDOS	;
;	MAKE $$$ FILE		;
	LXI	D,FCB	;POINT TO FCB
	PUSH	D	;SAVE FCB
	PUSH	D	;SAVE FCB
	MVI	C,22	;COMMAND=MAKE FILE
	CALL	@BDOS	;
	XRA	A	;A.=00
	STA	FCB+32	;CLEAR RC FIELD
;	SET DMA POINTER		;
	LXI	D,AUTO	;AUTO RE-LOAD
	MVI	C,26	;COMMAND=SET DMA
	CALL	@BDOS
;	WRITE 1 SECTOR		;
	POP	D	;RESTORE FCB POINTER
	MVI	C,21	;COMMAND=WRITE
	CALL	@BDOS
;	CLOSE BATCH FILE	;
	POP	D	;RESTORE FCB POINTER
	MVI	C,16	;COMMAND=CLOSE
	CALL	@BDOS
;	RELOAD CP/M & DRIVER	;
	JMP	@WBOOT
;
;	BDOS ERROR HANDLER
;
BS:	LHLD	@BS		;BAD SECTOR
	PCHL			;EXECUTE
SE:	LHLD	@SE		;SELECT
	PCHL			;EXECUTE
RO:	LHLD	@RO		;DISK R/O
	PCHL			;EXECUTE
FRO:	LHLD	@FRO		;FILE R/O
	PCHL			;EXECUTE

	ENDIF
;
;-----------------------;
;
	PAGE
PP$20	SET	ZERO
PP$21	SET	ZERO
PP$22	SET	ZERO
PP$23	SET	ZERO
PP$24	SET	ZERO

	IF	SPOOLER
CONST:	CALL	DATACK	;CHECK SPOOL STATUS
	JMP	@CONST	;CHECK CONSOLE STATUS
;
CONIN:	CALL	CONST	;CHECK CONSOLE STATUS/PRINTER
	ORA	A	;TEST FLAG
	JZ	CONIN	;WAIT FOR CONSOLE READY
	CALL	@CONIN	;GET CONSOLE DATA
	LXI	H,ACT	;ADDR FLUSH FLAG
	CPI	FLUSH	;FLUSH BUFFER?
	JNZ	CONIN1	;NO
	CMP	M	;FLAG SET?
	JZ	FB	;YES
CONIN1:	MOV	M,A	;CLEAR FLAG
	RET		;RETURN CODE
;
CONOUT:	PUSH	B	;SAVE DATA
	CALL	DATACK	;CHECK SPOOL STATUS
	POP	B	;RESTORE DATA
	JMP	@CONOUT	;SEND TO CONSOLE
;
LIST:	PUSH	B	;SAVE DATA
	CALL	DATACK	;CHECK SPOOL STATUS
	POP	B	;RESTORE DATA
	CALL	LISTS	;CHECK PRINTER STATUS
	ORA	A	;TEST FLAG
	JZ	LIST	;WAIT FOR PRINTER READY
;
	LHLD	BEGSEC	;GET BUFFER START
	SHLD	TMPSEC	;SAVED
	LDA	BEGBYTE	;GET BYTE COUNTER
	LXI	H,TMPBYTE
	MOV	M,A	;SAVED
	CALL	NEXT	;ADV PNTR
	LXI	D,ENDBYTE
	CALL	EQUAL	;(BEG+1)=END?
	ANI	80H	;BUFFER FULL
	STA	DATA	;  *FLAG*
	LXI	H,BEGBYTE
	CALL	CONVERT	;SETUP SEMIDISK
	MOV	A,C	;A=DATA
PP$20	SET	$+1	;SEMIDISK DATA PORT
	OUT	SEMI$DATA
	JMP	NEXT	;NEXT BYTE

;
LISTS:	LDA	DATA	;GET DATA FLAG
	RAL		;CARRY=STATUS
	MVI	A,0	;FULL?
	RC		;YES
	CMA		;A=-1
	RET		;NOT FULL
;
; DATACK MUST
; USE BIOS LIST STATUS CHECK
;
DATACK:	LDA	DATA	;GET DATA FLAG
	RAR		;TEST FLAG
	RC		;EMPTY
	CALL	ULISTS	;CHECK PRINTER STATUS
NOCHK:	NOP		;CHANGE TO CMA IF NO STATUS
	ORA	A	;TEST FLAG
	RZ		;BUSY
;
	LXI	H,ENDBYTE
	CALL	CONVERT	;SETUP SEMDISK
PP$21	SET	$+1	;SEMIDISK DATA PORT
	IN	SEMI$DATA
	MOV	C,A	;DATA INTO REG C
	CALL	NEXT	;NEXT BYTE
;
	LXI	H,ENDBYTE
	LXI	D,BEGBYTE
	CALL	EQUAL	;BUFFER EMPTY?
	ANI	01H	;KEEP EMPTY FLAG
	STA	DATA	;  *FLAG*
	JMP	@LIST	;SEND TO PRINTER
;
EQUAL:	PUSH	H
	PUSH	D
	MOV	A,M	;A=BYTE
	INX	H
	XCHG
	CMP	M
	JNZ	NOTEQU
	INX	H
	MOV	A,M	;A=SECTOR
	XCHG
	CMP	M
	JNZ	NOTEQU
	INX	H
	INX	D
	MOV	A,M	;A=TRACK
	XCHG
	CMP	M
	JNZ	NOTEQU
	MVI	A,255	;A=TRUE
	DB	041Q	;2 BYTE SKIP
NOTEQU:	MVI	A,000	;A=FALSE
	ORA	A	;SET FLAG
	POP	D
	POP	H
	RET
;
NEXT:	PUSH	H
	INR	M
	MVI	A,128	;LAST BYTE OF SECTOR?
	CMP	M
	JNZ	NEND	;NO
	MVI	M,0
	INX	H
	INR	M
	LDA	DPB	;LAST BYTE OF TRACK?
	CMP	M
	JNZ	NEND	;NO
	MVI	M,0
	INX	H
	INR	M
	MVI	A,255	;LAST TRACK
	CMP	M
	JNZ	NEND	;NO
	LDA	TRKMIN	;RESET TRACK
	MOV	M,A
NEND:	POP	H
	RET
;
CONVERT:INX	H
	INX	H
	MOV	A,M
PP$22	SET	$+1
	OUT	SEMI$TRACK
	DCX	H
	MOV	A,M
PP$23	SET	$+1
	OUT	SEMI$SECTOR
	DCX	H
	MOV	A,M
PP$24	SET	$+1
	OUT	SEMI$BYTE
	RET
;
; FLUSH SPOOLER
;
FB:	PUSH	PSW	;SAVE PSW
	LXI	H,0100H	;H=01, L=00
	SHLD	ACT	;ACT=0, DATA=1

	DCR	H	;H=00, L=00
	SHLD	BEGBYTE	;CLEAR BYTE,SECTOR BEG
	SHLD	ENDBYTE	;  "    "     "    END

	LDA	TRKMIN	;FIRST TRACK
	STA	BEGTRK	;RESET
	STA	ENDTRK	;RESET
	MVI	C,7	;RING BELL
	CALL	DISP	;ON CONSOLE
	POP	PSW	;RESTORE PSW
	RET
;
; RETURN LIST STATUS
;
; A=00 IF BUSY, A=FF IF READY
;
ULISTS:	JMP	@LISTS	;USE CP/M LIST STATUS
	DS	12	;SPACE FOR USER LIST STATUS
;;;
;;;	SAMPLES USER LIST STATUS
;;;
;;;	NORTH STAR HORIZON
;;;	RIGHT SERIAL PORT
;;;	IN	5	;GET STATUS
;;;	XRI	00H	;INVERT STATUS?
;;;	ANI	80H	;DTR MASK
;;;	RZ		;DTR=HIGH= BUSY
;;;	MVI	A,0FFH	;DTR=LOW = READY
;;;	RET
;;;
;;;	NORTH STAR HORIZON
;;;	PARALLEL PORT
;;;	IN	6	;GET STATUS
;;;	XRI	00H	;INVERT STATUS?
;;;	ANI	01H	;ACK MASK
;;;	RZ		;ACK=HIGH= BUSY
;;;	MVI	A,0FFH	;ACK=LOW = READY
;;;	RET
;;;
;
ACT	DB	0	;FLUSH SPOOL FLAG
DATA	DB	0	;FULL=80,EMPTY=01
;
BEGBYTE	DB	0	;FIRST BYTE
BEGSEC	DB	0	;  "   SECTOR
BEGTRK	DB	0	;  "   TRACK
;
ENDBYTE	DB	0	;LAST BYTE
ENDSEC	DB	0	;  "  SECTOR
ENDTRK	DB	0	;  "  TRACK
;
TMPBYTE	DB	0	;TEMPORY BYTE
TMPSEC	DB	0	;   "    SECTOR
TMPTRK	DB	0	;   "    TRACK
	ENDIF
;
;-----------------------;
;
	PAGE
;
SEMI:	DB	0		;DRIVER SELECTED FLAG.
;
;	BATCH FILE FCB
;
AUTO:	DB	10		;LENGTH OF COMMAND
DRIVE:	DB	'A:'		;UNIT (2 BYTES)
	DB	'WARMBOOT'	;NAME (8 BYTES)
;
FCB:	DB	0		;MUST USE DRIVE 0
	DB	'$$$     '	;NAME (8 BYTES)
	DB	'SUB'		;TYPE (3 BYTES)
;
;	SCRATCH PAD RAM
;
RAM	EQU	$		;SCRATCH RAM
DIR:	EQU	RAM+0		;CP/M DIRECTORY BUFFER (128)
SAVE:	EQU	RAM+128		;SAVE TABLE (8)
DMA	EQU	RAM+136		;DM ADDR. (2)
TRACK:	EQU	RAM+138		;TRACK#	(0 - 255) (1)
SECTOR: EQU	RAM+139		;SECTOR# (0 - 255) (1)
ALV:	EQU	RAM+140		;ALLOCATION VECTOR (120)
CSV:	EQU	RAM+260		;CHECKED DIRECTORY ENTRYS
;
INSTALL:		;INSTALL DRIVER INTO CPM
			;ACC=BASE SEMIDISK PORT
	IF	SD$I
; FIX DATA PORTS
	STA	PP$1
	STA	PP$2
	STA	PP$3
	STA	PP$4
	STA	PP$5
	STA	PP$20
	STA	PP$21
; FIX BYTE PORTS
	INR	A
	STA	PP$8
	STA	PP$24
; FIX TRACK PORTS
	INR	A
	STA	PP$6
	STA	PP$9
	STA	PP$22
; FIX SECTOR PORTS
	INR	A
	STA	PP$7
	STA	PP$23
	ENDIF

	IF	SD$II
; FIX DATA PORTS
	STA	PP$1
	STA	PP$2
	STA	PP$3
	STA	PP$20
	STA	PP$21
; FIX BYTE PORTS
	INR	A
	STA	PP$6
	STA	PP$7	;STATUS PORT
	STA	PP$24
; FIX TRACK PORTS
	INR	A
	STA	PP$4
	STA	PP$9	;R/O PORT
	STA	PP$22
; FIX SECTOR PORTS
	INR	A
	STA	PP$5
	STA	PP$8	;RESET PORT
	STA	PP$23
	ENDIF

	IF NOT SPOOLER
;
; FILL IN DRIVER TABLES
;
	LHLD	1	;HL=GET (WBOOT)
	LXI	D,@WBOOT;DE=PUT
	IF	Z80
	LXI	B,3	;LENGTH
	LDIR
	ELSE
	MVI	B,3	;LENGTH
	CALL	COPY
	ENDIF
	MVI	L,18H	;HL=GET (HOME)
	IF	Z80
	LXI	B,27	;LENGTH
	LDIR
	ELSE
	MVI	B,27	;LENGTH
	CALL	COPY
	ENDIF
;
; FILL IN BIOS TABLES
;
	LHLD	1	;HL=BIOS BASE
	LXI	D,?WBOOT;DE=DRIVER TABLE
	XCHG		;DE=PUT (WBOOT)
	IF	Z80
	LXI	B,3	;LENGTH
	LDIR
	ELSE
	MVI	B,3	;LENGTH
	CALL	COPY
	ENDIF
	MVI	E,18H	;DE=PUT (HOME)
	IF	Z80
	LXI	B,27	;LENGTH
	LDIR
	ELSE
	MVI	B,27	;LENGTH
	CALL	COPY
	ENDIF
	ENDIF

	IF	SPOOLER
;
; FILL IN DRIVER TABLES
;
	LHLD	1	;HL=GET (WBOOT)
	LXI	D,@WBOOT;DE=PUT
	IF	Z80
	LXI	B,48	;LENGTH
	LDIR
	ELSE
	MVI	B,48	;LENGTH
	CALL	COPY
	ENDIF
;
; CHECK FOR SPOOL TRACKS = 0
;
	LDA	TRKMIN	;GET # TRACKS
	ORA	A	;ZERO?
	JNZ	ACTIVE	;NOPE
	LXI	H,@CONST
	LXI	D,?CONST
	IF	Z80
	LXI	B,12	;LENGTH
	LDIR
	ELSE
	MVI	B,12	;LENGTH
	CALL	COPY
	ENDIF
	LHLD	@LISTS+1
	SHLD	?LISTS+1
ACTIVE:
;
; FILL IN BIOS TABLES
;
	LHLD	1	;HL=BIOS BASE
	LXI	D,?WBOOT;DE=DRIVER TABLE
	XCHG		;DE=PUT (WBOOT)
	IF	Z80
	LXI	B,48	;LENGTH
	LDIR
	ELSE
	MVI	B,48	;LENGTH
	CALL	COPY
	ENDIF
	ENDIF

	IF NOT SPOOLER
;
; FILL IN DIRECT BIOS CALL
;
	LHLD	1	;GET BIOS BASE
	LXI	D,9	;OFFSET TO CONOUT
	DAD	D	;HL=GET
	LXI	D,DISP	;DE=PUT
	IF	Z80
	LXI	B,3	;LENGTH
	LDIR
	ELSE
	MVI	B,3	;LENGTH
	CALL	COPY
	ENDIF
	ENDIF

	IF	SPOOLER
;
; CHECK FOR LIST STATUS SUPPORTED
;
	LDA	TRKMIN	;GET # TRACKS
	ORA	A	;TRACKS=0?
	JZ	NOTRKS	;YES, SKIP CHECK
	PUSH	PSW	;SAVE # TRACKS
	CALL	ULISTS	;CHECK STATUS
	ORA	A	;TEST FLAGS
	JNZ	SKIP	;READY
	MVI	A,CMA	;NOT SUPPORTED
	STA	NOCHK	;IN BIOS
	CALL	PRINT
	DB	0DH,0AH
	DB	'LIST STATUS not supported/offline.  ',0
SKIP:	POP	PSW	;GET # TRACKS
	CMA		;INVERT
	MOV	E,A	;INTO E
	MVI	D,255	;FILL D
	INX	D	;2'S COMPLEMENT
	MVI	A,255	;A=LAST TRACK ON BOARD
	ADD	E	;SUBTRACT SPOOL TRACKS
	STA	TRKMIN	;SET BASE SPOOL TRACK
	LHLD	DSM	;HL=TOTAL DISK SIZE
	DAD	D	;SUBTRACT SPOOL TRACKS
	SHLD	DSM	;SET NEW DISK SIZE
NOTRKS:	CALL	FB	;FLUSH SPOOLER
	ENDIF
;
; FILL IN SERIAL NUMBER, BDOS JUMP
;
	LHLD	6	;GET BDOS BASE
	MVI	L,0	;HL=GET
	LXI	D,SERIAL;DE=PUT
	IF	Z80
	LXI	B,17	;LENGTH
	LDIR
	ELSE
	MVI	B,17	;LENGTH
	CALL	COPY
	ENDIF
;
; FILL IN BDOS ERROR TABLE
;
	LDA	LOCATE	;GET LOCATE FLAG
	ORA	A	;SET?
	RNZ		;YES, INSTALL DONE
;
	LHLD	6	;GET BDOS BASE
	MVI	L,9	;HL=BDOS TABLE
	LXI	D,BS	;DE=ADDR OF DRIVER TRAP
	MVI	B,4	;NUMBER OF ENTRYS
INS1:	MOV	M,E	;FILL IN LOW
	INX	H	;POINT TO HIGH
	MOV	M,D	;FILL IN HIGH
	INX	H	;POINT TO LOW
	INX	D	;SKIP 'LHLD'
	INX	D	;SKIP ADDR LOW
	INX	D	;SKIP ADDR HIGH
	INX	D	;SKIP 'PCHL'
	IF	Z80
	DJNZ	INS1	;NEXT ENTRY
	ELSE
	DCR	B	;COUNT ENTRY
	JNZ	INS1	;NEXT ENTRY
	ENDIF
;
; COPY BDOS TRAPS INTO SAVE TABLE
	LXI	H,@BS	;HL=GET
	LXI	D,SAVE	;DE=PUT
	IF	Z80
	LXI	B,8	;LENGTH
	LDIR
	ELSE
	MVI	B,8	;LENGTH
	CALL	COPY
	ENDIF
;
; PROTECT SemiDisk DRIVER
;
	LXI	H,@BDOS	;HL=DRIVER BASE
	SHLD	6	;SET TOP OF MEMORY
	RET		;INSTALL DONE
;
	IF NOT Z80
;
; BLOCK COPY
; HL=GET,DE=PUT,B=BYTES
;
COPY:	MOV	A,M	;GET BYTE
	STAX	D	;PUT BYTE
	INX	H	;NEXT GET
	INX	D	;NEXT PUT
	DCR	B	;COUNT
	JNZ	COPY	;TILL ZERO
	RET		;ALL DONE
	ENDIF
;
	DS SIZE-($-SERIAL)-1
ZERO:	DB	0	;NULL BYTE
	END		;END OF DRIVER
