;
	title	'CCS Set Step Rate Utility Program Version 1.0'
;
; This program is designed to make changing the step rates in
;	various CCS utility programs an easy task.  With it, the
;	user can tailor the utilities CCSINIT, CCSYSGEN, CCCOPY
;	and VCOPY to meet the correct step rates for his specific
;	disk drives.
;
;
; SETSTEP expects the 8" step rate to be located at the fourth byte
;	of the utility it is tailoring. (START + 3).  Likewise,
;	it expects the 5" step rate to be located at the fifth byte
;	of the utility.  (START + 4)
;
; SETSTEP is invoked by typing in its name and the name of the utility
;	on the command line.  It provides the File Type Extension of
;	COM, thus this need not be specified.  After it has read in the
;	first record of the file, it asks the operator for the appropriate
;	step rates, installs them, and then writes the updated record
;	to the disk.  It then closes the file and exits to CP/M.
;
cr:	equ	13
lf:	equ	10
ctrlc:	equ	3
tbuf:	equ	80h	;transient buffer address
fcb:	equ	5ch
bdosv:	equ	5
;
	org	100h
readfile:  lda	tbuf	;see if command line has anything in it
	ora	a
	jz	done1	;brif not
	lxi	h,'CO'	;set file type to .COM
	shld	fcb+9
	mvi	a,'M'
	sta	fcb+11
	mvi	c,15	;open the file
	lxi	d,fcb
	call	bdosv
	lxi	d,fnfmsg ;prepare for file not found
	inr	a
	jz	errexit	;brif no file
	lxi	d,tbuf
	mvi	c,26	;set the dma address
	call	bdosv
	call	readseq
	jnz	endit	;brif end of file
	lxi	d,msg8
	call	prtrd	;print the message and read the response
	inr	b	;see if default
	jnz	main1
	mvi	b,7	;set 6 ms default
main1:	mov	a,b	;mov the step rate over
	dcr	a
	lxi	h,tbuf+3  ;point to STEP8 hold location
	call	setit
	lxi	d,msg5	;now get the 5" step rates
	call	prtrd
	inr	b	;see if default wanted
	jnz	main2
	mvi	b,31	;set mini default to 31 ms
main2:	ora	a	;divide response by two
	mov	a,b
	rar
	lxi	h,tbuf+4
	call	setit
	xra	a
	sta	fcb+32	;reset the current record
	lxi	d,fcb
	mvi	c,21	;write the record
	call	bdosv
	mvi	a,8	;insure the deblocker is purged
	sta	fcb+32
	call	readseq
done:	jmp	0	;return to cpm
;
readseq:  lxi	d,fcb
	mvi	c,20	;read sequential function
	call	bdosv
	ora	a
	ret		;good read
;
prtrd:	mvi	c,9	;print the string
	call	bdosv
prtrd0:	mvi	b,0ffh	;set up to get the response
prtrd1:	push	b
	mvi	c,1
	call	bdosv	; read the next character
	pop	b
	cpi	cr	;see if carriage return
	rz		;done if so
	inr	b	;see if first digit
	jz	prtrd2	;brif so
	dcr	b
prtrd2:
	sui	'0'	;check the number for validity
	jc	badnum	;brif bad
	cpi	10
	jnc	badnum	;brif bad
	push	psw	; save the number for a moment
	mov	a,b	; multiply partial by ten
	add	a	; *2
	add	a	; * 4
	add	b	; * 5
	add	a	; * 10
	mov	b,a
	pop	psw
	add	b	; tack on new number
	mov	b,a	; save it
	jmp	prtrd1	; go get the next number
;
badnum:	lxi	d,badent
	mvi	c,9
	call	bdosv	;inform of bad entry
	jmp	prtrd0	;restart from scratch
badent:	db	cr,lf,'Bad entry - try again:  $'
;
setit:	mvi	b,0	;start off at fast rate
	cpi	4
	jc	setit1
	inr	b
	cpi	7
	jc	setit1
	inr	b
	cpi	11
	jc	setit1
	inr	b
setit1:	mov	a,m	;check old value
	ora	a
	jm	setit2
	cpi	4
	jnc	setit2
	mov	m,b	;set the new value
	ret
;
setit2:	lxi	d,badfile
	jmp	errexit
;
endit:	lxi	d,vacfile
	jmp	errexit
;
done1:	lxi	d,nofile
errexit:  mvi	c,9	;print string parameter
	call	bdosv
	jmp	0
;
fnfmsg:	db	cr,lf,'File not found$'
nofile:	db	cr,lf,'No file was specified$'
vacfile:	db	cr,lf,'Specified file is vacuous$'
badfile:	db	cr,lf,'Specified file is not set up to accept changeable step rates.$'
msg8:	db	cr,lf,'What is the step rate for your 8" drives '
	db	'(in milliseconds)?  $'
msg5:	db	cr,lf,'What is the step rate for your 5.25" drives '
	db	'(in milliseconds)?  $'
;
