;
; modified for 2 mhz operation  17 dec 82  rbm
;
;
; 28 MAY 80
;  UPDATED 17 JUL 1980
;
; Version 1.2  7 FEB 82   RBM
;	Error handling improvements
;	Changeable step rates installed
;	Message presentation improvements
;	Auto-load of command line file (if specified)
;
	TITLE	'CCS SYSTEM GENERATION ROUTINE VERSION 1.2'
	PAGE	56
;
;	THIS ROUTINE WILL TRANSFER THE SYSTEM TRACKS FROM ONE
; DISKETTE TO ANOTHER, REGARDLESS OF DISKETTE SIZE, DENSITY, OR
; SECTOR SIZE.  IF DOUBLE DENSITY DISKETTES ARE USED, A 4 MHZ
; CPU IS MANDATORY.  SHOULD THE SYSTEM TRACKS OF THE DESTINATION
; DISK HAVE LESS SPACE THAN THE SOURCE DISK, A WARNING IS ISSUED
; TO ADVISE THE OPERATOR THAT A POTENTIAL DATA LOSS MAY HAPPEN.
;
;	OPERATION OF THE ROUTINE IS IDENTICAL TO THE CP/M SYSGEN
; ROUTINE, AS DOCUMENTED IN THE CP/M USER'S GUIDE.  THIS INCLUDES
; USING THE RESIDUAL MEMORY IMAGE OF A MOVCPM RUN.  THE UNDOCUMENTED
; SYSGEN CAPABILITY OF READING IN A NEW SOURCE FILE FROM DISK IS NOT
; SUPPORTED.
;
false:	equ	0
true:	equ	not false
;
meg2:	equ	false	; 2 megahertz conditional flag
;
wbootv:	equ	0
BDOSV:	EQU	5	;BDOS VECTOR ADDRESS
tbuf:	equ	80h	;transient buffer address
fcb:	equ	5ch
cpmloc:	equ	900h
;
cr:	equ	13
lf:	equ	10
;
DSTAT	EQU	30H	;DISK STATUS PORT
DCMMD	EQU	30H	;DISK COMMAND PORT
DTRCK	EQU	31H	;DISK TRACK PORT
DSCTR	EQU	32H	;DISK SECTOR PORT
DDATA	EQU	33H	;DISK DATA PORT
DFLAG	EQU	34H	;DISK FLAG PORT
DCTRL1	EQU	34H	;DISK CONTROL PORT
DCTRL2:	EQU	4	;BOARD CONTROL PORT
SDE:	EQU	43H	;SAVE LOC OF SIDE SELECT
step8:	equ	1	;default step rate for 8"
step5:	equ	3	;default step rate for 5"
;
	ORG	100H	;ORIGIN OF THIS PROGRAM
;
entry:	jmp	ccsys	;jump around entry prolog
stp8:	db	step8
stp5:	db	step5
CCSYS:	LXI	SP,STACK  ;SET THE STACK
	IN	DCTRL2	;SAVE THE ENTRY STATUS OF THE 1793
	ANI	2
	MVI	A,20H	;ASSUME MINI FOR THE MOMENT
	JNZ	CCSYS1	;JUMP IF IT IS A MINI
	MVI	A,30H	;  ELSE, SET FOR 8"
CCSYS1:	MOV	B,A	;SAVE FOR A MOMENT
	IN	DCTRL2	;NOW FIND THE DENSITY
	ANI	20H
	RAL
	ORA	B	;ADD IT ON TO THE PARTIAL SELBITS
	MOV	B,A
	IN	DCTRL1	;NOW SEE WHICH DRIVE WAS UP
	RAR
	ANI	0FH
	ORA	B	;ADD THE DRIVE SELECT ONTO THE SELBITS
	STA	SELSV	;SAVE FOR LATER RESTORAL
	IN	DTRCK	;SAVE THE TRACK REGISTER ON ENTRY
	STA	TRKSV
	LXI	H,BUFFER+1A00H  ;SET DEFAULT BUFFER LIMIT
	SHLD	LIM
	LXI	H,LOGMSG  ;LOG ONTO THE SYSTEM
	CALL	PRMSG
readfile:  lda	tbuf	;see if command line has anything in it
	ora	a
	jz	sourc	;brif not
	mvi	c,15	;else, open the file
	lxi	d,fcb
	call	bdosv
	lxi	d,fnfmsg ;prepare for file not found
	inr	a
	jz	errexit	;brif no file
	mvi	a,800h*2 shr 8	;number of records to skip
	sta	fcb+32	;set the current record
	lxi	d,cpmloc	;do the for-real read
load2:	push	d	;save the buffer pointer
	mvi	c,26	;set the dma address
	call	bdosv
	call	readseq
	pop	d	;reget the buffer pointer
	lxi	h,80h	;advance the pointer
	dad	d
	jnz	endit	;brif end of file
	xchg
	jmp	load2
;
errexit:  mvi	c,9	;print string parameter
	call	bdosv
SOURC:	LXI	H,SRMSG	;ASK FOR SOURCE DRIVE
	CALL	PRTRD
	JZ	DEST0	;JUMP IF SOURCE IS IN MEMORY
	ANI	5FH	;CONVERT TO UPPER CASE
	STA	DRIVE	;PUT INTO ERROR MESSAGE
	STA	UNIT
	MOV	B,A	;SAVE RESPONSE
	SUI	'A'	;SEE IF VALID DRIVE
	JC	SOURC	;NO, ASK AGAIN
	CPI	4
	JNC	SOURC	;NO, ASK AGAIN
	CALL	SETDRV	;SEE WHAT IS OUT THERE
	lda	diskno	;check for single density
	ani	40h	; (always enough room if so)
	jz	sourc1
	LDA	2	;SEE IF ENOUGH MEMORY EXISTS
	SUI	16H	; LESS CP/M SPACE
	SBI	ENDMEM/256  ; LESS ROOM FOR THIS PROGRAM
	JC	NOROOM	;JUMP IF NOT ENOUGH ROOM
sourc1:  LXI	H,SMSG	;VERIFY SOURCE
	CALL	PRTRD
	JNZ	RTCPM	;QUIT IF NOT CARRIAGE RETURN
	CALL	CRLF
	lda	diskno	;insure drive is selected
	out	dctrl1
	LXI	H,100H	;SET TRACK 0, SECTOR 1
	SHLD	TRACK
	LXI	H,BUFFER ;SET THE DMA ADDRESS
	SHLD	DMAAD
SOURC2:	CALL	READ	;READ A SECTOR
	ORA	A	;CHECK FOR ERRORS
	JNZ	ERROR
	SHLD	DMAAD	;UPDATE THE DMA ADDRESS
	LDA	SECTOR	;GO TO NEXT SECTOR
	LXI	H,SPT	;POINT TO SECTOR PER TRACK HOLD
	CMP	M	;SEE IF LAST SECTOR ON THIS TRACK
	JC	SOURC5	;JUMP IF NOT
	LDA	TRACK	;ELSE, UPDATE TRACK POINTER
	INR	A
	CPI	2	;MUST ALWAYS READ TWO TRACKS
	JC	SOURC3
	CPI	3	;NEVER READ MORE THAN THREE TRACKS
	JNC	DEST	;JUMP IF DONE
	MOV	B,A	;SAVE TRACK COUNT
	LDA	DISKNO	;SEE IF MINI
	ANI	10H
	JNZ	DEST	;DONE IF 8" DISK
	MOV	A,B	;REGET TRACK COUNT
SOURC3:	STA	TRACK	;FINISH THE TRACK UPDATE
	LDA	IDSV+3	;GET SECTOR SIZE INDICATOR
	XCHG		;SAVE POINTER
	MOV	B,A	;SAVE SIZE INDICATOR
	LXI	H,SPTBL-1	;8" SECTOR COUNT TABLE ADDRESS
	LDA	DISKNO	;SEE IF MINI
	ANI	10H
	JNZ	SOURC4	;JUMP IF 8"
	LXI	H,MSPTBL-1  ;MINI SECTOR PER TRACK TABLE ADDRESS
SOURC4:	INX	H	;POINT TO RIGHT ENTRY
	DCR	B
	JP	SOURC4
	LDA	DISKNO	;SEE IF DDEN
	ANI	40H
	JZ	SOURC6	;JUMP IF NOT
	DCX	H	;  ELSE, ADJUST POINTER
SOURC6:	MOV	A,M
	STAX	D	;RESET THE SECTOR PER TRACK COUNT
	XRA	A	;GET A ZERO
SOURC5:	INR	A	;INCREMENT SECTOR COUNT
	STA	SECTOR
	JMP	SOURC2	;GO GET NEXT SECTOR
;
DEST:	LHLD	DMAAD	;SAVE UPPER LIMIT FOR CHECK
endit:	SHLD	LIM
DEST0:	LXI	H,DSTMSG	;ASK FOR DEST DRIVE
	CALL	PRTRD
	JZ	RTCPM	;DONE IF CARRIAGE RETURN
	ANI	5FH	;CONVERT TO UPPER CASE
 	STA	DRIVE	;PUT INTO ERROR MESSAGE
	STA	UNIT
	MOV	B,A	;SAVE RESPONSE
	SUI	'A'	;SEE IF VALID DRIVE
	JC	DEST0	;NO, ASK AGAIN
	CPI	4
	JNC	DEST0	;NO, ASK AGAIN
	CALL	SETDRV	;SEE WHAT IS OUT THERE
	LXI	H,DMSG	;VERIFY DESTINATION
	CALL	PRMSG
	LXI	H,COMSG
	CALL	PRTRD
	JNZ	RTCPM	;QUIT IF NOT CARRIAGE RETURN
	CALL	CRLF
	lda	diskno	;insure drive is selected
	out	dctrl1
	LXI	H,100H	;SET TRACK 0, SECTOR 1
	SHLD	TRACK
	LXI	H,BUFFER ;SET THE DMA ADDRESS
	SHLD	DMAAD
DEST2:	CALL	WRITE	;WRITE A SECTOR
	ORA	A	;CHECK FOR ERRORS
	JNZ	ERROR
	SHLD	DMAAD	;UPDATE THE DMA ADDRESS
	LDA	SECTOR	;GO TO NEXT SECTOR
	LXI	H,SPT	;POINT TO SECTOR PER TRACK HOLD
	CMP	M	;SEE IF LAST SECTOR ON THIS TRACK
	JC	DEST5	;JUMP IF NOT
	LDA	TRACK	;ELSE, UPDATE TRACK POINTER
	INR	A
	CPI	2	;MUST ALWAYS WRITE TWO TRACKS
 	JC	DEST3
	CPI	3	;NEVER WRITE MORE THAN THREE TRACKS
	JNC	CHECK	;JUMP IF DONE
	MOV	B,A	;SAVE TRACK COUNT
	LDA	DISKNO	;SEE IF MINI
	ANI	10H
	JNZ	CHECK	;DONE IF 8" DISK
	MOV	A,B	;REGET TRACK COUNT
DEST3:	STA	TRACK	;FINISH THE TRACK UPDATE
	LDA	IDSV+3	;GET SECTOR SIZE INDICATOR
	XCHG		;SAVE POINTER
	MOV	B,A	;SAVE SIZE INDICATOR
	LXI	H,SPTBL-1	;8" SECTOR COUNT TABLE ADDRESS
	LDA	DISKNO	;SEE IF MINI
	ANI	10H
	JNZ	DEST4	;JUMP IF 8"
	LXI	H,MSPTBL-1  ;MINI SECTOR PER TRACK TABLE ADDRESS
DEST4:	INX	H	;POINT TO RIGHT ENTRY
	DCR	B
	JP	DEST4
	LDA	DISKNO	;SEE IF DDEN
	ANI	40H
	JZ	DEST6	;JUMP IF NOT
	DCX	H	; ELSE, ADJUST POINTER
DEST6:	MOV	A,M
	STAX	D	;RESET THE SECTOR PER TRACK COUNT
	XRA	A	;GET A ZERO
DEST5:	INR	A	;INCREMENT SECTOR COUNT
	STA	SECTOR
	JMP	DEST2	;GO GET NEXT SECTOR
;
CHECK:	LHLD	LIM	;LWA OF WRITE BUFFER
	XCHG
	LHLD	DMAAD	;LWA OF SOURCE BUFFER
	MOV	A,L	;CHECK FOR LOST DATA
	SUB	E
	MOV	A,H
	SBB	D
	JP	DEST	;CHECK IS O.K.
	LXI	H,WRMSG	;WARNING MESSAGE ADDRESS
	CALL	PRMSG
	JMP	DEST
;
ERROR:	LXI	H,ERMSG
	CALL	PRMSG
	JMP	DEST
;
SETDRV:	MOV	B,A	;SAVE THE UNIT
	INR	B	;SET UP FOR LOOP CONTROL
	XRA	A
	STA	LUNIT	;RESET LAST UNIT
	STC
SET1:	RAL		;SHIFT THE SELECT BIT INTO POSITION
	DCR	B
	JNZ	SET1
	ORI	20H	;ADD ON THE MOTOR ON BIT
	STA	DISKNO	;SAVE IN CASE OF 5" DRIVE
	MOV	B,A
	OUT	DCTRL1	;SELECT THE DRIVE
SET3:	MVI	A,08H	;GET A RESTORE COMMAND
	CALL	EOJB	;do the restore
	ani	4	;see if track 0 is reporting
	jnz	set4	;yes, press on
	mvi	a,0bh	;no, so restore at a slow rate
	call	eojb
set4:	IN	DDATA	;CLEAR JUNK OUT OF REGISTER
	lda	stp5	;get the 5" step rate
	mov	h,a
	mvi	l,18	;set the track 00 spt
	SHLD	SPT	;SAVE THEM
	IN	DCTRL2	;SEE IF MINI IS OUT THERE
	RAR
	RNC		;RETURN IF SO
	lda	stp8	;set the 8" step rate
	mov	h,a
	mvi	l,26	;set track 0 SPT
	SHLD	SPT
	MVI	A,10H	;AND SET THE 8" SELECT BIT
	ORA	B
	STA	DISKNO	;SAVE THE SELECT BITS
	OUT	DCTRL1	;SET CORRECTED SELBITS
	MVI	A,0D0H	;SET SIDE 0
	OUT	DCTRL2
	MVI	A,14
SET2:	DCR	A
	JNZ	SET2
	IN	DSTAT	;SEE IF DRIVE IS READY
	ORA	A
	RP
NOTRDY:	LXI	H,RDYMSG
	CALL	PRTRD	;TELL IT IS NOT READY
	RZ		;CR RETURNED, TRY AGAIN
	JMP	RTCPM	;DONE IF ANYTHING ELSE
;
;
EOJA:	LDA	STPRAT	;GET THE STEP RATE BITS
	ORA	C	;ADD ON THE COMMAND
EOJB:	call	eojb1
	push	h
	lxi	h,320	;delay 8 ms
eojb2:	dcx	h
	xthl
	xthl
	xthl
	xthl
	mov	a,h
	ora	l
	jnz	eojb2
	pop	h
	IN	DSTAT	;GET THE DISK STATUS
	STA	CSTAT	;SAVE IT
	ret
;
eojb1:	OUT	DCMMD	;DO THE COMMAND
	STA	CMDSV	;SAVE FOR AUDIT TRAIL
EOJ:	IN	DFLAG	;DISK FLAG PORT
	RAR
 	JNC	EOJ
	ei
	RET
;
READ:	MVI	C,10	;NUMBER OF RETRIES
RDAGN:	PUSH	B
	CALL	SEEK
	JNZ	READ3
	OUT	DCMMD	;DISK COMMAND PORT
	di
READ1:	IN	DDATA	;DISK DATA PORT
	MOV	M,A
	INX	H
	IN	DDATA	;DISK DATA PORT
	MOV	M,A
	INX	H
	IN	DDATA	;DISK DATA PORT
	MOV	M,A
	INX	H
	IN	DDATA	;DISK DATA PORT
	MOV	M,A
	INX	H
	DCR	B
	JNZ	READ1
	CALL	EOJ
	IN	DSTAT	;GET THE DISK STATUS
	STA	CSTAT	;SAVE IT
	ANI	9CH
READ3:	POP	B
	RZ
	DCR	C
	JNZ	RDAGN
rderr:	ral		;see if the drive went not ready
	lxi	h,dnrmsg
	jc	prterr
	ral
	lxi	h,wpmsg
	jc	prterr
	ral
	lxi	h,wfmsg
	jc	prterr
	ral
	lxi	h,rnfmsg
	jc	prterr
	ral
	lxi	h,crcerr
	jc	prterr
	ral
	lxi	h,dlerr
prterr:	cc	prtwd
	MVI	A,1	;READ ERROR
	RET
;
WRITE:	MVI	C,10	;NUMBER OF RETRIES
WRAGN:	PUSH	B
	CALL	SEEK
 	JNZ	WRT3
	ADI	20H	;ADD WRITE COMMAND
	STA	CMDSV
	OUT	DCMMD	;DISK COMMAND PORT
	di
WRT1:	MOV	A,M
	OUT	DDATA	;DISK DATA PORT
	INX	H
	MOV	A,M
	OUT	DDATA	;DISK DATA PORT
	INX	H
	MOV	A,M
	OUT	DDATA	;DISK DATA PORT
	INX	H
	MOV	A,M
	OUT	DDATA	;DISK DATA PORT
	INX	H
	DCR	B
	JNZ	WRT1
	CALL	EOJ
	IN	DSTAT	;GET THE DISK STATUS
	STA	CSTAT	;SAVE IT
	ANI	0FCH
WRT3:	POP	B
	JZ	VERFY
	DCR	C
	JNZ	WRAGN
	jmp	rderr
 ;
VERFY:
  if	meg2
	ret
  endif
  if	not meg2
	MVI	C,10	;10 TRYS
VERFY0:	PUSH	B	;SAVE THE TRY COUNTER
	CALL	RDWRT
	MVI	E,0	;START THE CHECKSUM
	OUT	DCMMD	;DISK COMMAND PORT
	di
VERFY1:	IN	DDATA	;DISK DATA PORT
	XRA	M
	ORA	E
	MOV	E,A
	INX	H
	IN	DDATA	;DISK DATA PORT
	XRA	M
	ORA	E
	MOV	E,A
	INX	H
	IN	DDATA	;DISK DATA PORT
	XRA	M
	ORA	E
	MOV	E,A
	INX	H
	IN	DDATA	;DISK DATA PORT
	XRA	M
	ORA	E
	MOV	E,A
	INX	H
	DCR	B
	JNZ	VERFY1
	CALL	EOJ
	IN	DSTAT	;GET THE DISK STATUS
	STA	CSTAT	;SAVE IT
	ANI	9CH
	POP	B	;SET STACK STRAIGHT
	jz	veri1	;good read, go check the checksum
	DCR	C	;SEE IF MORE TRYS LEFT
	JNZ	VERFY0	;JUMP IF SO
	jmp	rderr
;
veri1:	ora	e	;add on the check-sum
	ret
  endif
;
SEEK:	LDA	DISKNO
	MOV	C,A	;SAVE FOR LATER USE
	LDA	LUNIT	;SEE IF SAME AS LAST USED DRIVE
	CMP	C
	JZ	SEEK1	;JUMP IF SO
IDRD1:	MOV	A,C	;REGET THE SELECT BYTE
	OUT	DCTRL1	;OUTPUT IT
 	IN	DSTAT	;INSURE A DRIVE IS THERE
	ANI	80H
	RNZ		;ERROR IF NOT
	LXI	H,IDSV	;SET UP TO READ ADDRESS
	MVI	B,3
	MOV	A,C	;GET THE SELECT BITS
	ORI	80H	;SET THE AUTOWAIT BIT
	OUT	DCTRL1	;SELECT THE DRIVE
	MVI	A,0C4H	;READ ADDRESS COMMAND
	STA	CMDSV
	OUT	DCMMD	;START IT GOING
	di
IDRD3:	IN	DDATA	;GET THE DATA
	MOV	M,A	;STORE IT
	INX	H
	IN	DDATA	;GET THE DATA
	MOV	M,A	;STORE IT
	INX	H
	DCR	B
	JNZ	IDRD3	;JUMP IF MORE TO GO
	CALL	EOJ
	IN	DSTAT	;GET THE DISK STATUS
	STA	CSTAT	;SAVE IT
	ANI	0FCH	;MASK THE ERROR BITS
	JZ	IDRD4	;JUMP IF NO ERROR
	MOV	A,C	;ELSE, SEE IF DDEN TRIED YET
	ANI	40H
	RNZ		;TAKE ERROR IF DDEN TRIED
	MVI	A,40H	;ELSE, TRY DDEN
	ORA	C
	MOV	C,A
	STA	DISKNO	;SAVE FOR LATER USE
	JMP	IDRD1
;
IDRD4:	LDA	IDSV	;GET THE TRACK NUMBER
	OUT	DTRCK	;SET THE TRACK REGISTER
	ORA	A	;INSURE NOT ON TRACK 0
 	MOV	A,C	;REGET THE SELECT BYTE
	STA	LUNIT	;UPDATE LAST USED UNIT
	JNZ	SEEK1	;JUMP IF OKAY
	PUSH	B	;SAVE THE SELECT BITS
	MVI	C,58H	;BUILD A STEP-IN COMMAND
	CALL	EOJA
	POP	B	;RESTORE THE SELECT BITS
	JMP	IDRD1	;GO REREAD THE ADDRESS
;
SEEK1:	OUT	DCTRL1	;DISK CONTROL PORT
	LDA	SECTOR
	OUT	DSCTR	;DISK SECTOR PORT
	IN	DTRCK	;DISK TRACK PORT
	MOV	C,A	;SAVE IT
	LDA	TRACK	;GET DESIRED TRACK
	CMP	C
	JZ	RDWRT	;JUMP IF NO SEEK NEEDED
	OUT	DDATA	;SET THE SEEK TRACK
	MVI	C,1CH	;BUILD THE SEEK COMMAND
	CALL	EOJA
	ANI	98H
	RNZ		;ERROR RETURN
;
RDWRT:	LXI	H,10H	;BUILD SECTOR BYTE COUNT
	IN	DTRCK	;CHECK FOR TRACK 00
	ORA	A
	JZ	RDWRT0	;JUMP IF SO
	LDA	IDSV+3	;GET SECTOR SIZE
RDWRT0:	DAD	H	;DOUBLE (H,L)
	DCR	A	;LOOP CONTROL
	JP	RDWRT0
	MOV	B,L	;SECTOR BYTE COUNT TO (B,C)
	LHLD	DMAAD
	IN	DFLAG	;DISK FLAG PORT
 	ANI	20H
	MVI	A,4
	JZ	RDWRT1
	XRA	A
RDWRT1:	ADI	88H
	MOV	E,A
	LDA	DISKNO
	ORI	80H
	MOV	D,A
	IN	DTRCK	;SEE IF TRACK 0
	ORA	A
	MOV	A,D
	JNZ	RDWRT2	;JUMP IF NOT
	ANI	0BFH	; ELSE, INSURE DDEN BIT NOT SET
RDWRT2:	OUT	DCTRL1	;DISK CONTROL PORT
	XRA	A	;CLEAR THE FLAGS
	MOV	A,E
	STA	CMDSV	;SAVE THE COMMAND
	RET
;
PRTRD:	CALL	PRMSG	;FIRST, PRINT THE MESSAGE
	MVI	C,1
	CALL	BDOSV	;GET A CHARACTER
	PUSH	PSW	;SAVE IT
	call	crlf
	pop	psw
	cpi	0dh	; check for CR
	ret
;
noroom:	lxi	h,szmsg
	call	prmsg	; output the no room message
rtcpm:	lda	selsv
	out	dctrl1
	lda	trksv	; restore the track number
	out	dtrck
	ei
	call	wbootv	; do a warm boot
	hlt		; error if return to here
;
crlf:	mvi	a,cr	; output a carriage return
	call	charout
	mvi	a,lf
charout:
	push	h
	push	d
	push	b
	mov	e,a
	mvi	d,0
	mvi	c,2
	call	bdosv	; output the character
	pop	b
	pop	d
	pop	h
	ret
;
prtwd:	call	crlf	; start a new line
	call	prmsg	; output the message
	lxi	h,303h	; get pad bytes
	shld	atrk
	shld	asect	; set up the messages
	lxi	h,atrk+1h
	lda	track
	call	cvasc	; convert the digit
	lda	sector
	lxi	h,asect+1
	call	cvasc
	lxi	h,edrvmsg
prmsg:	mov	a,m	; get the next character
	ora	a
	rz		; done if delimiter
	call	charout	; else, output the character
	inx	h	; advance the pointer
	jmp	prmsg
;
cvasc:
	mvi	b,0ffh
prt1	sbi	10
	inr	b
	jnc	prt1
	adi	10
	ori	'0'
	mov	m,a
	dcx	h
	mov	a,b
	ori	'0'
	mov	m,a
	ret
;
readseq:  lxi	d,fcb
	mvi	c,20	;read sequential function
	call	bdosv
	ora	a
	ret		;good read
;
;
fnfmsg:	db	13,10,'File not found$'
;
WRMSG:	DB	0DH,0AH,'*** WARNING: Possible lost data ***',0DH,0AH,0
ERMSG:	DB	0DH,0AH,'DISK I/O ERROR ON '
DRIVE:	DS	1
	DB	':',0DH,0AH,0
RDYMSG:	DB	0DH,0AH,'DRIVE NOT READY (Type CR when ready).',0A0H
	DB	0
dnrmsg:	db	'Drive not ready',0
wpmsg:	db	'Diskette is Write Protected',0
wfmsg:	db	'Write Fault on',0
rnfmsg:	db	'Record Not Found on',0
crcerr:	db	'Cyclic Redundancy Check error on',0
dlerr:	db	'Data Lost error on',0
edrvmsg:  db	' Track '
atrk:	ds	2
	db	' Side 0  Sector '
asect:	ds	2
	db	0
;
logmsg:	db	0dh,0ah,'CCS System Generation Program Version 1.2'
	db	13,10,'  Copyright 1980, 1982 California Computer Systems',13,10,0
SZMSG:	DB	0DH,0AH,'INSUFFICIENT MEMORY SPACE - need 24k',0DH,0AH,0
SRMSG:	DB	0DH,0AH,'Source Drive (or CR to skip): ',0
DSTMSG:	DB	0DH,0AH,'Destination Drive (or CR to abort): ',0
SMSG:	DB	'Source'
COMSG:	DB	' on '
UNIT:	DS	1
	DB	', then type CR',0
DMSG:	DB	'Destination',0
;
SPTBL:	DB	26,15,8,4  ;8" SECTORS PER TRACK
MSPTBL:	DB	18,10,5,2  ;5" SECTORS PER TRACK
;
TRACK:	DS	1
SECTOR:	DS	1
DMAAD:	DS	2	;DIRECT MEMORY ADDRESS
DISKNO:	DS	1	;DISK NUMBER 0-15
LUNIT:	DS	1	;LAST USED DRIVE
SPT:	DS	1	;SECTORS PER TRACK
STPRAT:	DS	1	;STEP RATE SAVE AREA
CMDSV:	DS	1	;COMMAND SAVE AREA
CSTAT:	DS	1	;CURRENT STATUS SAVE AREA
IDSV:	DS	6	;DISK ID SAVE AREA
SELSV:	DS	1	;SELBITS SAVE AREA
TRKSV:	DS	1	;SAVE AREA FOR TRACK REGISTER
LIM:	DS	2
;
	ORG	cpmloc	;BUFFER START POINT
STACK:	EQU	$	;TOP OF STACK LOCATION
BUFFER:	DS	12544	;MAX SIZE FOR DDEN
ENDMEM:	EQU	$
