;W.ASM	by Mark Gardner  9/12/83
;  from January/February 1984 Pro-Files Pg. 75
;
;Program to invoke WordStar from any user area, by changing the
;directory entry for the two required overlay files that WS.COM
;will access.  Once the directory entries are found and changed,
;WS.COM is loaded and control is given to it.  Any filename
;entered after the W on the command line is passed along
;directly to WordStar.
;
;*Begin WSGET
;
	ORG	100H
;
BDOS	EQU	5
BIOS	EQU	0EA00H
SETTRK	EQU	BIOS+1EH
SETSEC	EQU	BIOS+21H
SETDMA	EQU	BIOS+24H
READ	EQU	BIOS+27H
WRITE	EQU	BIOS+2AH
;
; Initialize Variables
;   Marked Flag to 0
	MVI	A,0
	STA	MARKED
;   Determine current user
	MVI	C,20H		;'GET USER' BDOS function
	MVI	E,0FFH
	CALL	5
	STA	USER		;Save user code for later use
;   Establish buffer area
	LXI	B,BUFFER
	CALL	SETDMA		;BIOS SETDMA function
	JMP	PROG		;Jump over stored variables
;
BUFFER	EQU	8000H		;Simple and safe location
USER:	DS	1		;Code for Current User Area
SECTOR:	DS	1		;Storage for Directory Sector
TRACK:	DS	1		;Storage for Directory Track
MARKED:	DS	1		;Set when .OVR file in sector
;
FRSTRK	EQU	4		;First Directory Track on disk
LASTRK	EQU	7		;Last Directory Track on disk
FRSSEC	EQU	0		;First Sector on each track
LASSEC	EQU	67		;Last Sector on each track
MSGSTR:	DB	'WSMSGS  OVR'	;Name of Message Overlay
OVLSTR:	DB	'WSOVLY1 OVR'	;Name of Program Overlay
;;Compare Subroutine
;;Compares two strings of length 11 -- one string pointer in DE,
;;the other in HL.  Must preserve C.  Returns Z if equal, NZ if not.
;
COMPAR:
	MVI	B,12		;Counter for 11 compares
COMLUP:
	DCR	B		;Decrease the counter
	RZ			;If zero, strings are equal
	LDAX	D		;Else, compare next entries
	CMP	M
	RNZ			;If not equal, return with NZ
	INX	H		;Else, continue to next entry
	INX	D
	JMP	COMLUP
;
PROG:
; For each sector in the directory space on the disk
;;TRACK LOOP
	MVI	A,FRSTRK-1	;Start with the first track
	STA	TRACK
TRKLUP:
	LDA	TRACK
	INR	A		;Increase it each time
	STA	TRACK
	CPI	LASTRK+1        ;and stop after the last
	JZ	MOVLOD
;;SECTOR LOOP
	MVI	A,FRSSEC        ;Start with the first sector
	STA	SECTOR
SECLUP:
	LDA	SECTOR
	INR	A		;Increase it each time
	STA	SECTOR
	CPI	LASSEC+1        ;and stop after the last
	JZ	TRKLUP
;   For each entry in the sector (0 - 3)
	LDA	TRACK		;Call the SET TRACK routine
	MOV	C,A
	MVI	B,0
	CALL	SETTRK
	LDA	SECTOR		;Call the SET SECTOR routine
	MOV	C,A
	MVI	B,0
	CALL	SETSEC
	CALL	READ		;Read the sector from directory
;;ENTRY LOOP
	MVI	A,7*32		;Kluge for -32
	MOV	C,A		;Store entry pointer
ENTLUP:
	MOV	A,C		;Start with first entry
	ADI	32		;Increase each time
	MOV	C,A
	CPI	80H		;and stop after the last
	JZ	ENDENT
;     If the entry is for WSMSGS.OVR or for WSOVLY1.OVR
	LXI	D,BUFFER
	MOV	E,A		;Set up pointer to buffer string
	LDAX	D		;Pick up first byte of entry
	CPI	0E5H		;If it is a deleted entry, don't bother
	JZ	ENTLUP
	INR	E		;Point to entry name
	LXI	H,MSGSTR        ;Point to compare string
	CALL	COMPAR		;and see if equal
	JNZ	TRYOVL		;If not, proceed to WSOVLY1
	MVI	A,0FFH		;If so, set marked flag
	STA	MARKED
	LXI	H,BUFFER
	MOV	L,C		;and set directory entry to
	LDA	USER		;Current User Code
	MOV	M,A
TRYOVL:
	MOV	A,C		;This section is identical to above,
	INR	A		;but is for WSOVLY1.OVR file
	LXI	D,BUFFER
	MOV	E,A		;Set up pointer to buffer string
	LXI	H,OVLSTR        ;Point to compare string
	CALL	COMPAR		;and see if equal
	JNZ	ENTLUP		
;	Set the marked flag
	MVI	A,0FFH		
	STA	MARKED
;	Mark the entry to the current user
	LXI	H,BUFFER
	MOV	L,C		
	LDA	USER		
	MOV	M,A
;     End if (entry)
	JMP	ENTLUP
;   End for (each entry)
ENDENT:
;   If the marked flag is set
	LDA	MARKED		;If the current buffer full
	ANA	A		;of directory entries had any
	JZ	SECLUP		;matches, then write new code
;	Write the changed buffer to the disk
	CALL	WRITE		;BIOS WRITE function
;	Clear the marked flag
	MVI	A,0		;Clear the marked flag in
	STA	MARKED		;preparation for next buffer
;   End if (marked flag)
; End for (each sector)
	JMP	SECLUP
MOVLOD:
; Move the WS loader into high memory
;
PATCBS	EQU	0C000H		;Location for patch assembly
TRANSI	EQU	100H		;Transient Program Area
OPEN	EQU	0FH		;BDOS OPEN FILE
BDREAD	EQU	20		;BDOS READ FILE
BDSDMA	EQU	26		;BDOS SET DMA
;
	MVI	E,0
	MVI	C,20H		;Set user to 0 temporarily
	CALL	BDOS
;
	LXI	H,MOVBAS        ;Move the loader and patch
	LXI	D,MOVLOC        ;to the upper memory area
	LXI	B,MOVSIZ
MOVLUP:
	MOV	A,M		;Get a byte of patch
	STAX	D		;and move to patch area
	DCX	B		;See if done
	MOV	A,B
	ORA	C
	JZ	LOAD+OFFSET	;If done, then go to WS loader
	INX	H
	INX	D
	JMP	MOVLUP		;Else, get next byte to move
;
; Load WS.COM and transfer control
;-End WSGET
;*WS Loader
;	ORG	PATCBS-(BDOSRE-MOVBAS)
BDOSRE:
MOVBAS:
WSTFCB:		;File Control Block for WordStar
	DB	0,'WS      COM'
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
;
LOAD:		;Load WordStar and transfer control
	LDA	USER		;Set up to restore user
	STA	RESUSR+1+OFFSET
	LXI	D,WSTFCB+OFFSET	;Open the file
	MVI	C,OPEN
	CALL	BDOS
	LXI	D,TRANSI        ;Load into the user TPA
LOADLP:		;Load Loop
	PUSH	D		;Save for incrementing
	MVI	C,BDSDMA
	CALL	BDOS
	LXI	D,WSTFCB+OFFSET
	MVI	C,BDREAD        ;BDOS READ
	CALL 	BDOS
	POP	D
	ANA	A		;See if end of file
	JNZ	RESUSR+OFFSET	;If so, go to WordStar, else
	LXI	H,128		;point to next sector area
	DAD	D
	XCHG
	JMP	LOADLP+OFFSET	;and go load next file sector
RESUSR:		;Restore the user
	MVI	E,0		;(Replaced before execution)
	MVI	C,20H		;'SET USER' BDOS function
	CALL	BDOS
	JMP	TRANSI		;All set, start WordStar
MOVLIM:
;
;;Equate statements to calculate move parameters for MOVLUP
;
MOVSIZ	EQU	MOVLIM-MOVBAS
MOVLOC	EQU	PATCBS-(BDOSRE-MOVBAS)
OFFSET	EQU	PATCBS-BDOSRE
	END

