; SD Version 8.8 - 05/09/84
;
;			SUPER DIRECTORY PROGRAM
;
; Displays the directory of a CP/M disk, sorted alphabetically, with the
; file size in k, rounded to the nearest CP/M block size.  Also displays
; library files with the file size in k if the '$L' option is used.
;
; Current versions of SD will automatically adjust for any block size
; and directory length under CP/M 1.4 or 2.x or MP/M (any version).  They
; also automatically adjust for any number of disk drives and work sat-
; isfactorily even if no disk is in that drive at the moment.  Provisions
; are made for:
;
;	(1) automatic pauses when the screen fills up
;	(2) searching individual or multiple drives and/or user areas
;	(3) unconditional or optional resetting the disk system before
;	    execution begins
;	(4) directing output to a disk file called SD.DIR and appending
;	    to that file on subsequent runs
;	(5) summary line output giving drive and user information, # of
;	    files matched and how much space they consume, and the a-
;	    mount of free space remaining on the disk
;	(6) displaying or suppressing "system" files
;	(7) accepting ambiguous filenames with or without a drive name
;	(8) printer output
;	(9) can make a ;disk file of the results called DISKMENU.DIR
;
;
; See SD.DOC for detailed instructions on configuring and running SD.ASM
;
;	    NOTE: If you add improvements or otherwise update
;	    this program, please modem a copy of the new file
;	    to "TECHNICAL CBBS" in Dearborn, Michigan - phone
;	    313-846-6127.
;
;=======================================================================
;
; 05/09/84  Fixed the three major bugs for RCP/M operators introduced 
;  SD-88    in SD-87.  First, WHEEL byte is 03E not 03B.  Second, 
;	    MXZUSR is 16, not 15.  Third, and most important, I put back
;	    the SBI 1 code to subtract MAXUSR value to be compatiable with
;	    the SD compare logic.  The person who changed this must not
;	    understand that CCP or ZCMD or ZCPR logic is MAXUSR-1...
;	    ie, if MAXUSR contains 8, then users 0 thru 7 are legal areas.
;	    The way SD-87 was coded, it would allow a user to get a 
;	    directory of an area that he could not log into under ZCMD.
;	    If BYE doesn't work like ZCMD (or ZCPR) then fix BYE.  XMODEM,
;	    FILE, and SD were all modified a year ago to work with ZCMD or
;	    ZCPR.  The logic was sound then and it still is.  Please leave
;	    the code alone if you don't know why it is there....
;	    The KTHREE option is a bummer for RCP/M operators if ANY user
;	    area has more than 999K of files TOTAL--which most large systems
;	    do, which makes PRDI and PRUS useless unless you limit 3 names
;	    per-line on your display.
;					-Wayne Masters 
;
; 05/06/84  Added equates: KTHREE, PRDI, PRUS, PRLIBD, & PRBRDR.
;  SD-87
;
;	KTHREE allows a choice using 3 or 4 digits in the display
;	of file sizes.  As the equate implies, setting KTHREE to
;	yes will limit proper display of file sizes to 999k.  On the
;	plus side, yes will allow the use of a fence character for
;	4 files per line displays, even with drive/user option.
;
;	PDRI & PRUS allow (yes) or disallow the printing of the
;	drive and/or user numbers at the front of each file display
;	line.  These equates affect the video display only and allow
;	maximum flexibility for use with RCPM systems where several
;	display formats must be supplied.
;
;	PRLIBD if yes (and PRUS & PDRI are yes) the drive/user numbers
;	will be displayed for library display lines.  This may not
;	be wanted when PRBRDR is yes.
;
;	PRBRDR if yes will print a quasi-border around the left side
;	of library files.  This makes for a much more appealing and
;	easier to read display.
;
;	Fixed a bug in the screen display format that showed up when
;	a drive was found to have no files.  SD-77 would fail to
;	print a blank line before displaying the 'No files...'
;	statement.  Added a call to CRLF just before the print.
;
;	Fixed a bug that caused SD77 to only allow a search to
;	MAXUSR-1. The routine that was removed claimed that MAXUR
;	was MAXUR +1.  This is true only with MAXDRV.  Use BYE3 to
;	verify the validity of this mod.
;       Search for '05/06/84' to find mod
;                                       - John Ray 
;
; 04/29/84  Fixed error in TIMEUP routine.  Thanks for help from Paul Wood.
;  SD-86    Also moved the TIMEON instructions from the .MSG file to .DQC.
;					- W. Masters
;
; 04/26/84  Consolidated the two SD-84 versions.
;  SD-85				- J.E. Byram
;
; 04/25/84  Reformatted informational line displays.  Added user
;  SD-84    number to "No file" error report.  Consolidated drive/
;	    user error reports to resolve problems introduced by
;	    DU: option.  Cleaned up several inconsistencies in code.
;	    Modified to allow for all 32 user numbers under CP/M 2.2.
;	    Rearranged tables to put all uninitialized data space at
;	    END of program.  Initialization code added to replace
;	    initialization using DBs so that SD can be rerun using the
;	    ZCPR/ZCPR2 GO command with new options.  Moved all terminal
;	    dependent values to front of program and repaired the code
;	    so that these values are fully utilized and may be patched
;	    with DDT.			- Jay P. Sage / J.E. Byram
;
; 04/23/84  Combined Sigi's version of SD-83 with my SD-82 version which
;  SD-84    added the TIMEON routine used in XMODEM.  Read the SD-84.MSG
;	    file.			- Wayne Masters
;
; 04/21/84  Fixed size display problem in LOPT.
;  SD-83				- Sigi Kluger
;
; 04/19/84  Fixed problem in DOPT conditional.
;  SD-82A   (only showed when DOPT EQU NO)
;					- Sigi Kluger
;
; 04/14/84  Fixed bug in vertical code routine (thanks to Dennis
;  SD-82    Vallianos).  Also, fixed bug in REVIDEO code.
;					- S. Kluger
;
; 04/04/84  Fixed bug introduced in SD-80, changed size calc routine,
;  SD-81    RMAC code. Now works will ALL CP/M 2.2 file sizes!
;	    (see SD-81.NOT for more info).
;					- S. Kluger
;
; 03/31/84  Fixed problem where certain files were displayed with
;  SD-80    incorrect size. See SD-80.NOT for exact info.
;	    Also fixed bug in FENCE routine introduced in 79A.
;					- S. Kluger
;
; 03/17/84  Changed the header line (free space remaining, etc.) easier
;  SD-79A   to read, was too cluttered.  Minor changes.  Distribution
;	    copy set to alphabetize vertically.  Very few (other than
;	    SYSOPs will need to reassemble now, or even bother getting
;	    the lengthy source code.	- N. Workman
;
;=======================================================================
;
;	 Set 'RMAC' YES to assemble with relocating assembler
;	 (requires link with PAGE 0 equates in separate file).
;
;=======================================================================
;
;
YES:	EQU	0FFH
NO:	EQU	0
;
CR:	EQU	0DH
LF:	EQU	0AH
ESC:	EQU	1BH
;
;***********************************************************************
;
;		      USER OPTION SPECIFICATIONS
;
;***********************************************************************
;
DIRCON:	EQU	NO	;yes for direct console output
LOWCCP:	EQU	YES	;yes only if you are running with BYELOW
BDOSPG:	EQU	0D4H	;set properly if LOWCCP is YES
;
TIMEON:	EQU	NO 	;If YES, add your clock reader code at the start
			;of label TIME: and store binary values in CHOUR
			; and CMIN
;
	 IF	TIMEON	;use these bytes in low memory
QUITE:	EQU	NO	;YES if "Time on System is xx minutes" suppressed
CHOUR:	EQU	043H	;some BIOS clocks keep time
CMIN:	EQU	044H	;here anyway.
LHOUR:	EQU	050H	;set by BBS (or BYE) in binary
LMIN:	EQU	051H	;when user logs on
STATUS:	EQU	053H	;and his status
MAXMIN:	EQU	60	;minutes for maximum file transfer time
			;this should be set to 60.  (99 max)
	 ENDIF		;TIMEON
;
;
; ZCPR options
;
ZCPR2:	EQU	NO  	;yes if NZCPR/ZCPR2 (wheel byte enabled)
MAXUR:	EQU	NO  	;yes If using MAXUSR in NZCPR/ZCPR2
MAXDR:	EQU	NO  	;yes If using MAXDRV in NZCPR/ZCPR2

	 IF	ZCPR2		
WHEEL:	EQU	3EH	;set to wheel location if ZCPR2 is YES
;
	 IF	MAXUR	;leave here so errors occur when ZCPR2=FALSE
MAXU:	EQU	3FH	;set to max user location if MAXU is YES
	 ENDIF		;MAXUR
;
	 IF	MAXDR
MAXD:	EQU	3DH	;set to max drive location for MAXD = YES
	 ENDIF		;MAXDR
	 ENDIF		;ZCPR2		
;
MXZUSR:	EQU	16	;maximum user # allowed WHLUSR=YES/WHEEL set
WHLUSR:	EQU	YES	;yes to allow search 0-MXZUSR if WHEEL set
;
WHLA:	EQU	NO	;yes to disallow A option if WHEEL zero
WHLC:	EQU	NO 	;yes to disallow C option if WHEEL zero
WHLD:	EQU	NO	;yes to disallow D option if WHEEL zero
WHLF:	EQU	NO 	;yes to disallow F option if WHEEL zero
WHLL:	EQU	NO	;yes to disallow L option if WHEEL zero
WHLP:	EQU	NO 	;yes to disallow P option if WHEEL zero
WHLR:	EQU	NO 	;yes to disallow R option if WHEEL zero
WHLS:	EQU	NO 	;yes to disallow S option if WHEEL zero
WHLU:	EQU	NO	;yes to disallow U option if WHEEL zero
;
;
; Command line options
;
OPTION:	EQU	YES	;yes if allowing ANY command line options
;
AOPT:	EQU	YES	;yes to allow searching all user areas
COPT:	EQU	NO	;yes to allow Clear Screen
DOPT:	EQU	YES	;yes to allow searching all drives on-line
FOPT:	EQU	YES	;yes to allow file output option
LOPREV:	EQU	NO	;no to reverse the 'L' option and not print
LOPT:	EQU	YES	;yes to allow Library file member printing
NOPT:	EQU	YES	;yes to allow disabling page pause option
PGPAWS:	EQU	YES	;yes for pause after each page
POPT:	EQU	YES	;yes to allow printer option
ROPT:	EQU	YES	;yes to allow reset option
SOPT:	EQU	YES	;yes to allow system file option
UOPT:	EQU	YES	;yes to allow user number option
VOPT:	EQU	YES	;yes to allow version number display
;
;
; Console video equates
;
REVIDEO:EQU	NO	;use reverse video sequences
			;if no, the rest of the equates are disabled
LEADIN:	EQU	ESC	;escape lead-in (TRY A NULL IF NOT REQUIRED)
INTOREV	EQU	'4'	;toggle background (ENTER YOUR VALUE HERE)
OUTAREV	EQU	'3'	;toggle foreground (ENTER YOUR VALUE HERE)
VECTOR:	EQU	NO	;yes to display attributes on Flashwriter II
VIDEO:	EQU	0E009H	;entry to Flashwriter video driver PROM
;
;
; Hardware equates
;
NPL:	EQU	4	;# of names per line   (max of 3 for 64x16)
			;		       (max of 4 for 80x24)
LPS:	EQU	24	;# of lines per screen (max of 16 for 64x16)
			;		       (max of 24 for 80x24)
FENCEC:	EQU	'|'	;Use 00H for none.
;
;
; Miscellaneous equates
;
AUTOR:	EQU	NO	;yes to reset disk reset every time
KTHREE	EQU	NO 	;yes limits file size columns to 3 digits to
			;gain an additional print colomn. Allows fence
			;to be used with four files per line.
PRDI	EQU	NO	;yes to print drive # on each line
PRUS	EQU	NO 	;yes to print user # on each line
PRLIBD	EQU	NO	;if yes and PRUS & PRDI are yes then drive & user
			;numbers will be displayed on library listing lines
PRBRDR	EQU	YES	;yes to print a quasi border around library files
DORST	EQU	YES 	;yes to always reset disks when D option active

DUOPT:	EQU	YES	;yes, allow drive/user spec ZCPR2 style
NODISK:	EQU	YES	;yes if you do not want to specify disk drive
			;when asking for options and using default drive
REPERR:	EQU	YES	;yes to report command line option errors
REPUSR:	EQU	YES	;yes to report user numbers
RMAC:	EQU	NO	;yes for RMAC assembly and external def link
VCODE:	EQU	YES	;yes if files are to be alphabetized vertically
;
	 IF	REPERR AND NOT OPTION
	++++ REPERR EQUATE USELESS WITHOUT OPTION ++++
	 ENDIF
;
	 IF	(MAXUR OR MAXDR) AND NOT ZCPR2
	++++ MAXUR / MAXDR CANNOT BE YES UNLESS ZCPR2 IS YES
	 ENDIF
;
;
; BDOS equates
;
RDCHR:	EQU	1	;read char from console
WRCHR:	EQU	2	;write char to console
PRINTS:	EQU	9	;print string
CONST:	EQU	11	;check cons stat
RESET:	EQU	13	;reset disk system
SELDSK:	EQU	14	;select disk
OPEN:	EQU	15	;0FFH=not found
CLOSE:	EQU	16	;   "	"
SEARCH:	EQU	17	;   "	"
NEXT:	EQU	18	;   "	"
READ:	EQU	20	;not 0 = EOF
WRITE:	EQU	21	;not 0 = disk full
MAKE:	EQU	22	;0FFH = directory full
CURDSK:	EQU	25	;get currently logged disk name
SETDMA:	EQU	26	;set current DMA
GALLOC:	EQU	27	;get address of allocation vector
CURDPB:	EQU	31	;get current disk parameters
CURUSR:	EQU	32	;get currently logged user number (2.x only)
;
;
	 IF	NOT RMAC
BASE:	EQU	0	;default to 0 (or 100H with MAC +R option)
TPA:	EQU	100H
FCB:	EQU	BASE+5CH
BDOS:	EQU	BASE+5
	 ENDIF		;NOT RMAC
;
	 IF	RMAC
	EXTRN	BASE,FCB,BDOS  ;make base external
TPA:	EQU	BASE+100H
	 ENDIF
;
;
	ORG	TPA
;
;
FILL	MACRO	BYTES,WITH
	REPT	BYTES
	DB	WITH
	 ENDM
	 ENDM
;
$-MACRO
;
;
;***********************************************************************
;
;		BEGIN EXECUTABLE PROGRAM CODE *
;
;***********************************************************************
;
;
	  JMP	START
;
MLEADIN:  DB	LEADIN	;leadin char for hilite sequences
MINTOREV: DB	INTOREV ;code to enter hilite mode
MOUTAREV: DB	OUTAREV ;code to return to normal mode
MNPL:	  DB	NPL	;names per line (# of columns)
MLPS:	  DB	LPS	;lines per screen (between pauses)
FC:	  DB	FENCEC	;fence character
;
	 IF	COPT
	DB	'CL SCR CODE->' ;for easy patching via DU/DDT
CLCHR:	DB	ESC,'v' 	;ENTER YOUR CLEAR SCREEN CODE(S) HERE
	DB	'$'		;end with a '$'
	DS	6		;allow further space for custom version
	 ENDIF			;put your clear screen ctl code(s) above
				;or put a call to a clear screen funct.

VERNAME:  DB	CR,LF,'SD v8.8 - 05/09/8','4' OR 80H
;
;
; Drive	code/user area lookup table
;
; Note that the LODRV-HIDRV table is included here fully configured.
; For your own use, you should change the maximum user areas as appro-
; priate for each drive on your system.  Note that there are only 32
; user areas available under CP/M 2, so the highest legal user area you
; can specify is 31 (range 0-31 = 32 areas).  The program will convert
; anything over 31 into mod 31.  The default table below is set for the
; usual	16 user areas rather than the full 32 available.
;
	DB	'MAXUSR TBL>'   ;label to make finding the table easier
;
LODRV:	EQU	$		;mark beginning of drive/user table
;
	DB	15		;maximum user area for Drive A
	DB	15		;   "	  "    "    "	 "   B
	DB	15		;   "	  "    "    "	 "   C
	DB	15		;   "	  "    "    "	 "   D
	DB	15		;   "	  "    "    "	 "   E
	DB	15		;   "	  "    "    "	 "   F
	DB	15		;   "	  "    "    "	 "   G
	DB	15		;   "	  "    "    "	 "   H
	DB	15		;   "	  "    "    "	 "   I
	DB	15		;   "	  "    "    "	 "   J
	DB	15		;   "	  "    "    "	 "   K
	DB	15		;   "	  "    "    "	 "   L
	DB	15		;   "	  "    "    "	 "   M
	DB	15		;   "	  "    "    "	 "   N
	DB	15		;   "	  "    "    "	 "   O
	DB	15		;   "	  "    "    "	 "   P
;
HIDRV:	EQU	$		;mark end of drive/user table
;
START:	LXI	H,0
	DAD	SP		;HL=old stack
	SHLD	STACK		;save it
	LXI	SP,STACK	;get new stack
;
;
; Initialize reverse video code in message area
;
	 IF	REVIDEO
	LHLD	MLEADIN
	SHLD	REVMS1
	SHLD	REVMS2
	SHLD	REVMS3
	LDA	MOUTAREV
	STA	REVMS3+1
	 ENDIF			;REVIDEO
;
;
; Zero out the entire initialization data area
;
	LXI	H,DATA0 	;point to beginning of init. data area
	PUSH	H		;save for non-zero filling later
	MVI	C,DATA1-DATA0	;get length of data area
	XRA	A		;zero accumulator
;
ZFILL:	MOV	M,A
	INX	H
	DCR	C
	JNZ	ZFILL
;
;
; Now copy non-zero initialization data from the template area
;
	POP	H		;reset HL to DATA0
	LXI	D,TMPLT0	;set DE to beginning of template
	MVI	C,TMPLT1-TMPLT0 ;get length of template area
;
NZFILL:	LDAX	D		;get template byte
	MOV	M,A		;move to data area
	INX	D
	INX	H
	DCR	C
	JNZ	NZFILL
	MVI	C,12		;get and save the CP/M version #
	CALL	BDOS
	MOV	A,L
	STA	VERFLG
	CPI	20H		;set carry if CP/M 1.4
	MVI	E,0FFH		;get current user number if using CP/M 2
	MVI	C,CURUSR	;fall through with A=0 if not
	CNC	CPM
	STA	OLDUSR		;initialize startup user number
	STA	NEWUSR		;..and make new user match it
;
	 IF	DOPT		;save extra copy for multi-disk
	STA	BASUSR		;..directories
	 ENDIF			;DOPT
;
	 IF	TIMEON
	CALL	TIME
	 ENDIF			;TIMEON
;
	 IF	DUOPT		;drive/user option?
	LXI	H,81H		;point to command line
	MOV	A,M
	INX	H
	ORA	A
	JNZ	CLOK
	MOV	M,A
;
CLOK:	LXI	D,FCB
	CALL	FNAME
	MOV	A,B
	CPI	0FFH
	JZ	CLUS
	STAX	D
;
CLUS:	MOV	A,C
	CPI	0FFH
	JZ	CLNON
	STA	NEWUSR
;
	 IF	DOPT
	STA	BASUSR
	 ENDIF
	 ENDIF		;DUOPT
;
CLNON:	MVI	C,CURDSK
	CALL	CPM		;get current disk nr
	STA	OLDDSK		;save for reset if needed
;
	 IF	FOPT
	INR	A
	STA	OUTFCB		;set directory output file drive
	 ENDIF			;FOPT
;
	LXI	H,FCB
	MOV	A,M		;get drive name for directory search
	ORA	A		;any specified?
	JNZ	STRT1A		;yes skip next routine
	LDA	OLDDSK		;otherwise, get default disk
	INR	A
	JMP	START2
;
STRT1A:	PUSH	PSW
	MVI	A,1
	STA	DFLAG
	POP	PSW
;
START2:	MOV	M,A		;put the absolute drive code in
				;..directory FCB
;
;
; If at	least one option is allowed, scan the command line for the
; option field delimiter.  The option field delimiter is considered
; valid	only if it is preceded by at least 1 space (otherwise, it
; may be part of the directory filename).  Any unrecognized options
; or illegal user numbers will be flagged or ignored (see REPERR).
; (We scan the command line buffer rather than the 2nd default FCB
; because all 8 options plus a 2 digit user number won't fit in
; the FCB name field).
;
	 IF	OPTION
	LXI	H,80H		;set command line buffer pointer
	MOV	B,M		;get length of command line buffer
;
;
; Search for valid command line delimiter.  If not found, assume no op-
; tions.
;
SCNDOL:	INX	H
	DCR	B
	JM	CKREST		;exit if command line buffer empty
	MOV	A,M
	CPI	'$'
	JNZ	SCNDOL
	DCX	H		;'$' found - make sure a space precedes
	MOV	A,M
	INX	H
	CPI	' '
	JNZ	SCNDOL		;no space - ignore "$" and search again
;
;
; Valid	delimiter found.  Scan the rest of the buffer for options.
; Errors past this point will cause an abort if the command line error
; option is enabled.  Otherwise, the dud option will be ignored and SD
; will attempt to continue stumbling through the rest of the field.
;
	XCHG			;get option field pointer to DE
;
SCNOPT:	INX	D		;bump to next option field character
	DCR	B		;dock characters left in option field
	JM	CKREST		;if option field exhausted, exit
;
SCNAGN:	LDAX	D		;get the next option character
	CPI	' '	       ;do we have a space?
	JZ	SCNOPT		;ignore it if so
;
	 IF	ZCPR2 AND WHLU	
	CPI	'U'		;disallowing "U" option, treat
	JZ	CLERR		;as error if there..
	 ENDIF			;ZCPR2 AND WHLU
;
	LXI	H,OTBL-1	;get base of option lookup table
	MVI	C,OEND-OTBL+1	;get length of option lookup table
;
NOMACH:	INX	H		;bump to next option table character
	DCR	C		;are we out of the table?
	JZ	CK4USR		;if so, check for user option
;
	 IF	ZCPR2		;NZCPR/ZCPR2? (Wheel byte?)
	PUSH	PSW		;save accum.
	LDA	WHEEL		;get wheel byte
	ORA	A		;check it
	JZ	NOMAC1		;it's zero, so forget it
	MOV	A,M		;get the table option
	ANI	0DFH		;make sure is upper case
	MOV	M,A		;stuff back in table
;
NOMAC1:	POP	PSW		;restore accum.
	 ENDIF			;ZCPR2
;
	CMP	M		;compare our character with option table
	JNZ	NOMACH		;exit if no match
	MVI	M,0		;otherwise, activate the flag
	CPI	'D'		;all disk search?
	CZ	NOMAC2		;yes, start at A always
	CPI	'A'		;all user search?
	CZ	NOMAC4		;yes, start at User No. 0 always
	JMP	SCNOPT		;..and go get the next option character
;
NOMAC2:	PUSH	PSW
	PUSH	H
	LDA	DFLAG
	ORA	A
	JNZ	NOMAC3
	LXI	H,FCB		;set FCB drive byte to drive A
	MVI	A,1
	MOV	M,A
	POP	H
	POP	PSW
	RET
;
NOMAC3:	POP	H
	POP	PSW
	RET
;
NOMAC4:	LDA	AFLAG		;asking for $U3A or $U4A, etc.?
	ORA	A
	RNZ
	MVI	A,0		;always start at User No. 0
	STA	NEWUSR
	STA	BASUSR
	RET

;.....
;
;
; If option character doesn't match the table, see if we have a User
; option.
;
CK4USR:	 IF	UOPT		;check for user number option
	CPI	'U'
	JNZ	CLERR		;last option, so bad deal if not it
;
UAGN:	INX	D		;bump to user number digit
	DCR	B
	JM	CLERR		;error if nothing left
	LDAX	D		;get decimal digit
	CPI	' '	       ;ignore leading spaces
	JZ	UAGN
	SUI	30H		;subtract ASCII BIAS
	JC	CLERR		;error if < 0
	CPI	10
	JNC	CLERR		;error if > 9
	STA	NEWUSR		;save user number, might be only 1 digit
;
	 IF	DOPT
	STA	BASUSR		;duplicate it if multi-disk mode
	 ENDIF			;DOPT
;
	MVI	A,1
	STA	AFLAG		;to allow $U3A, etc.
	INX	D		;bump to possible 2nd digit of user #
	DCR	B
	JM	CKREST		;no more buffer, exit with user #
	LDAX	D		;else, check for another digit
	SUI	30H
	JC	SCNAGN		;if next char not numeric, it is not
	CPI	10		;..part of user number so go check for
	JNC	SCNAGN		;..another option
	MOV	L,A		;save units digit
	LDA	NEWUSR		;get tens digit
	ADD	A		;multiply by 10
	MOV	H,A
	ADD	A
	ADD	A
	ADD	H
	ADD	L		;combine with units digit
	STA	NEWUSR		;save the total user number
;
	 IF	DOPT
	STA	BASUSR		;duplicate it if multi-disk mode
	 ENDIF			;DOPT
;
	JMP	SCNOPT		;continue scanning
	 ENDIF			;UOPT
;
;
; If command line error option enabled, playback the command line up
; to the character that we gagged on and exit.	If REPERR is not enabled
; then continue as if nothing were amiss to avoid acknowledging that
; some options are available.
;
CLERR:	 IF	REPERR
	XRA	A
	INX	D		;tag end of command line with terminator
	STAX	D
	CALL	CRLF
	LXI	D,ERRMS2
	CALL	PRINT
	LXI	D,ERRTAG
	CALL	PRINT
	LXI	H,81H		;playback bad cmd line to error point
;
CLELP:	MOV	A,M
	ORA	A
	JZ	CLEX
	CALL	TYPE
	INX	H
	JMP	CLELP
;
CLEX:	MVI	A,'?'		;tag line with a '?' field
	CALL	TYPE
	CALL	CRLF		;space down 1 more line
	JMP	EXIT		;..and return to CP/M
	 ENDIF			;REPERF
;
	 IF	NOT REPERR
	JMP	SCNOPT		;if not reporting errors, ignore the dud
	 ENDIF			;REPERR
	 ENDIF			;OPTION
;
;
; Options input or not specified.  If reset option specified, reset
; the disk system now.	Its important that the reset be done OUTSIDE
; the multiple drive loop if the file output option is enabled because
; CP/M 1.4 clobbers the DMA buffer on reset.
;
CKREST:	 IF	COPT
	LDA	COPFLG
	ORA	A
	JNZ	ROPTN
	LDA	CLCHR
	CPI	0C3H		;op-code for JMP
	JZ	CLCAL
	LXI	D,CLCHR 	;get it from down under
	MVI	C,PRINTS	;print just to console
	CALL	BDOS
	JMP	ROPTN
;
CLCAL:	LHLD	CLCHR+1
	SHLD	CLCALL+1
;
CLCALL:	CALL	0		;to be safe
	 ENDIF			;COPT
;
ROPTN:	 IF	ROPT
	LDA	ROPFLG		;if reset flag set, reset disk system
	ORA	A		;..before starting to update allocation
	MVI	C,RESET 	;..vetors
	CZ	CPM
	 ENDIF			;ROPT
;
	 IF	DOPT
	LDA	DOPFLG		;if multi-disk flag set,
	ORA	A		;..need to set error traps
	CZ	SWAPEM		;swap BDOS error vector tables
;
	 IF	DORST AND NOT AUTOR
	LDA	DOPFLG
	ORA	A
	CZ	DSET		;reset disk system if $D only
	 ENDIF			;DORST	AND NOT AUTOR
	 ENDIF			;DOPT
;
;
; Validate drive code and user area numbers from the drive table.
;
NOOPT:	LXI	D,DRUMSG	;get the drive/user error message
	PUSH	D
	LDA	FCB		;get directory drive code
	DCR	A		;normalize to range of 0-31
	CPI	HIDRV-LODRV	;compare with maximum drives on-line
	JNC	ERXIT		;take drive error exit if out of range
;
	 IF	MAXDR		;look for MAXD
	LXI	H,MAXD		;adddress to HL
	MOV	L,M		;MAXD to l
	INX	H		;add one
	CMP	L		;check it
	JNC	ERXIT		;oops if not bigger
	 ENDIF			;MAXDR
;
	MOV	E,A		;use drive code as index into table
	MVI	D,0
;
	 IF	ZCPR2 AND WHLUSR
	LDA	WHEEL		;get WHEEL byte
	ORA	A		;check it
	JZ	USRCK		;if reset, restrict user
	MVI	A,MXZUSR	;if set, max user = MXZUSR
	JMP	USRCK2
	 ENDIF			;ZCPR2 AND WHLUSR
;
USRCK:	LXI	H,LODRV 	;point to base of drive/user table
	DAD	D
	MOV	A,M		;get the maximum user # for this drive
;
	 IF	MAXUR		;use lomem values if smaller
	MOV	H,A		;current value of MAXUSR
	LDA	MAXU		;alternate value
	SBI	1		;MAXUSR was really max user + 1              
	CMP	H		;compare the two
	JNC	USRCK2		;jmp if table value smaller or equal
	STA	MAXUSR		;else replace it
	 ENDIF			;MAXUR
;
USRCK2:	ANI	1FH		;make sure its in range 0 - 31
	STA	MAXUSR		;save it for later
	LXI	H,NEWUSR	;point to the directory user area
	CMP	M		;compare it with the maximum
	JC	ERXIT		;take error exit if user number illegal
	POP	D		;destroy error message pointer
	LXI	H,FCB+1 	;point to name
	MOV	A,M		;any specified?
;
	 IF	NODISK
	CPI	'$'
	JZ	WCD
	 ENDIF			;NODISK
;
	CPI	' '
	JNZ	GOTFCB
;
;
; No FCB - make FCB all '?'
;
WCD:	MVI	B,11		;FN+FT count
;
QLOOP:	MVI	M,'?'		;store '?' IN FCB
	INX	H
	DCR	B
	JNZ	QLOOP
;
GOTFCB:	MVI	A,'?'		;force wild extent
	STA	FCB+12
	CALL	SETSRC		;set DMA for BDOS media change check
	LXI	H,FCB		;point to FCB drive code for directory
	MOV	E,M		;get the drive code out of the FCB
	DCR	E		;normalize drive code for SELECT
	MVI	C,SELDSK	;select the directory drive to retrieve
	CALL	CPM		;..the proper allocation vector
	CALL	CKVER		;check version
	JC	V14		;pre-2.X...get params the 1.4 way
	MVI	C,CURDPB	;it is 2.X or MP/M...request DPB
	CALL	BDOS
	INX	H
	INX	H
	MOV	A,M		;get block shift
	STA	BLKSHF
	INX	H		;bump to block mask
	MOV	A,M
	STA	BLKMSK		;get it
	INX	H
	INX	H
	MOV	E,M		;get max block #
	INX	H
	MOV	D,M
	XCHG
	SHLD	BLKMAX		;save it
	XCHG
	INX	H
	MOV	E,M		;get directory size
	INX	H
	MOV	D,M
	XCHG
	JMP	FREE		;let FREE save it and setup order table
;
V14:	LHLD	BDOS+1		;get params 1.4 style
	MVI	L,3BH		;point to directory size
	MOV	E,M		;get it
	MVI	D,0		;force high order to 0
	PUSH	D		;save for later
	INX	H		;point to block shift
	MOV	A,M		;fetch
	STA	BLKSHF		;save
	INX	H		;point to block mask
	MOV	A,M		;fetch it
	STA	BLKMSK		;and save it
	INX	H
	MOV	E,M		;get max. block no.
	MVI	D,0
	XCHG
	SHLD	BLKMAX		;save it
	POP	H		;restore directory size
	JMP	FREE20		;go figure free space from alloc vector
;
;
; Calculate # of K free on selected drive now so that the FREE figure
; will not reflect either the creation or additions to the SD.DIR file
; (which we would probably erase or move anyway).
;
FREE:	SHLD	DIRMAX		;save max # of entries in directory
	LDA	VERFLG		;check version #
	CPI	30H		;3.0?
	JC	FREE20		;use old method if not
	LDA	FCB		;get drive #
	DCR	A
	MOV	E,A		;use new Compute Free Space BDOS call
	MVI	C,46
	CALL	CPM
	MVI	C,3		;answer is a 24-bit integer
;
FRE3L1:	LXI	H,BASE+82H	;answer is in 1st 3 bytes of DMA adr
	MVI	B,3		;convert it from sectors to K
	ORA	A		;by dividing by 8
;
FRE3L2:	MOV	A,M
	RAR
	MOV	M,A
	DCX	H
	DCR	B
	JNZ	FRE3L2		;loop for 3 bytes
	DCR	C
	JNZ	FRE3L1		;shift 3 times
	LHLD	BASE+80H	;now get result in K
	JMP	SAVFRE		;go store it
;
FREE20:	MVI	C,GALLOC	;get address of allocation vector
	CALL	BDOS
	XCHG
	LHLD	BLKMAX		;get its length
	INX	H
	LXI	B,0		;init block count to 0
;
GSPBYT:	PUSH	D		;save alloc address
	LDAX	D
	MVI	E,8		;set to process 8 blocks
;
GSPLUP:	RAL			;test bit
	JC	NOTFRE
	INX	B
;
NOTFRE:	MOV	D,A		;save bits
	DCX	H		;count down blocks
	MOV	A,L
	ORA	H
	JZ	ENDALC		;quit if out of blocks
	MOV	A,D		;restore bits
	DCR	E		;count down 8 bits
	JNZ	GSPLUP		;do another bit
	POP	D		;bump to next byte..
	INX	D		;..of alloc. vector
	JMP	GSPBYT		;process it
;
ENDALC:	POP	D		;clear allocation vector pntr from stack
	MOV	L,C		;copy blocks to hl
	MOV	H,B
	LDA	BLKSHF		;get block shift factor
	SUI	3		;convert from sectors to K
	JZ	SAVFRE		;skip shifts if 1K blocks ret free in HL
;
FREKLP:	DAD	H		;multiply blocks by K/BLK
	DCR	A
	JNZ	FREKLP
;
SAVFRE:	SHLD	FREEBY		;save the free space for output later
;
;
; Reenter here on subsequent passes while in the all-users mode
;
SETTBL:	LHLD	DIRMAX		;get directory maximum again
	INX	H		;directory size is DIRMAX+1
	DAD	H		;double directory size
	LXI	D,ORDER 	;to get size of order table
	DAD	D		;allocate order table
	SHLD	TBLOC		;name tbl begins where order tbl ends
	SHLD	NEXTT
	XCHG
	LHLD	BDOS+1		;make sure we have room to continue
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	OUTMEM
;
	 IF	UOPT
	CALL	CKVER		;set carry if pre-CP/M 2
	LDA	NEWUSR		;get user area for directory
	MOV	E,A
	MVI	C,CURUSR	;get the user function
	CNC	CPM		;..and set new user number if CP/M 2
	 ENDIF			;UOPT
;
;
; Look up the FCB in the directory
;
	MVI	A,'?'
	LXI	H,FCB+12
	MOV	M,A		;match all extents
	INX	H
	MOV	M,A		;match all s1 bytes
	INX	H
	MOV	M,A		;match all s2 bytes
	LXI	H,0
	SHLD	COUNT		;initialize match counter
	SHLD	TOTFIL		;     "     total file counter
	SHLD	TOTSIZ		;     "     total size counter
	CALL	SETSRC		;set DMA for directory search
	MVI	C,SEARCH	;get 'search first' function
	JMP	LOOK		;..and go search for 1st match
;
;
; Read more directory entries
;
MORDIR:	MVI	C,NEXT		;search next
;
LOOK:	LXI	D,FCB
	CALL	CPM		;read directory entry
	INR	A		;check for end (0FFH)
	JZ	SPRINT		;if no more, sort & print what we have
;
;
; Point	to directory entry
;
SOME:	DCR	A		;undo prev 'INR A'
	ANI	3		;make modulus 4
	ADD	A		;multiply...
	ADD	A		;..by 32 because
	ADD	A		;..each directory
	ADD	A		;..entry is 32
	ADD	A		;..bytes long
	LXI	H,BASE+81H	;point to buffer (skip to FN/FT)
	ADD	L		;point to entry
	ADI	9		;point to SYS byte
	MOV	L,A		;save (can't carry to H)
;
	 IF	SOPT
	LDA	SOPFLG		;did user request SYS files?
	ORA	A
	JZ	SYSFOK
	 ENDIF			;SOPT
;
	MOV	A,M		;get SYS byte
	ORA	A		;check bit 7
	JM	MORDIR		;skip that file
;
SYSFOK:	MOV	A,L		;go back now
	SUI	10		;back to user number (alloc flag)
	MOV	L,A		;HL points to entry now
	LDA	NEWUSR		;get current user
	CMP	M
	JNZ	MORDIR		;ignore if different
	INX	H
;
;
; Move entry to table
;
	XCHG			;entry to DE
	LHLD	NEXTT		;next table entry to HL
	MVI	B,11		;entry length (name, type, extent)
;
TMOVE:	LDAX	D		;get entry char
;
	 IF	NOT (VECTOR OR REVIDEO)
	ANI	7FH		;remove attributes
	 ENDIF
;
	MOV	M,A		;store in table
	INX	D
	INX	H
	DCR	B		;more?
	JNZ	TMOVE
	INX	D		;de->> s1
	INX	D		;de->> s2
	LDAX	D		;get s2 byte, overflow=int(extents/32)
	PUSH	H		;save hl
	MOV	L,A		;set up 16-bit multiply
	MVI	H,0
	MVI	B,5
	CALL	SHLL		;HL is now # of overflow extents
	DCX	D		;DE->> S1
	DCX	D		;DE->> extent
	LDAX	D		;get extent
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A		;HL now has total extents
	MVI	B,7
	CALL	SHLL		;HL now has total sectors less last ext
	INX	D		;DE->> S1
	INX	D		;DE->> S2
	INX	D		;point to sector count
	LDAX	D		;get it
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A		;HL now has total sectors
	XTHL			;do some fancy shuffling
	XCHG
	XTHL
	XCHG
	MOV	M,D
	INX	H
	MOV	M,E
	POP	D		;all back to normal...
	INX	H
	SHLD	NEXTT		;save updated table address
	XCHG
	LHLD	COUNT		;bump the # of matches made
	INX	H
	SHLD	COUNT
	LXI	H,13		;size of next entry
	DAD	D
	XCHG			;future NEXTT is in DE
	LHLD	BDOS+1		;pick up TPA end
	MOV	A,E
	SUB	L		;compare NEXTT-TPA end
	MOV	A,D
	SBB	H
	JC	MORDIR		;if TPA END > NEXTT, loop back for more
;
OUTMEM:	CALL	ERXIT		;exit if directory too large
	DB	'Memor','y' OR 80H
;
; Shift	HL left by B bits
;
SHLL:	DAD	H
	DCR	B
	RZ
	JMP	SHLL
;
;
; Sort and print
;
SPRINT:	 IF	AOPT OR FOPT OR UOPT
	CALL	SETFOP		;return to file output DMA & user #
	 ENDIF
;
	LHLD	COUNT		;get file name count
	MOV	A,L
	ORA	H		;any found?
	JZ	PRTOTL		;exit if no files found
	PUSH	H		;save file count
	STA	SUPSPC		;enable leading zero suppression
;
;
; Initialize the order table
;
	LHLD	TBLOC		;get start of name table
	XCHG			;into DE
	LXI	H,ORDER 	;point to order table
	LXI	B,13		;entry length
;
BLDORD:	MOV	M,E		;save low order address
	INX	H
	MOV	M,D		;save high order address
	INX	H
	XCHG			;table addr to HL
	DAD	B		;point to next entry
	XCHG
	XTHL			;save tbl addr, fetch loop counter
	DCX	H		;count down loop
	MOV	A,L
	ORA	H		;more?
	XTHL			;(restore tbl addr, save counter)
	JNZ	BLDORD		;yes, go do another one
	POP	H		;clean loop counter off stack
	LHLD	COUNT		;get count
	SHLD	SCOUNT		;save as # to sort
	DCX	H		;only 1 entry?
	MOV	A,L
	ORA	H
	JZ	DONE		;yes, so skip sort
;
;
; This sort routine is adapted from SOFTWARE TOOLS by Kernigan and
; Plaugher.
;
SORT:	LHLD	SCOUNT		;number of entries
;
L0:	ORA	A		;clear carry
	MOV	A,H		;GAP=GAP/2
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	ORA	H		;is it zero?
	JZ	DONE		;then none left
	MOV	A,L		;make gap odd
	ORI	1
	MOV	L,A
	SHLD	GAP
	INX	H		;I=GAP+1
;
L2:	SHLD	I
	XCHG
	LHLD	GAP
	MOV	A,E		;J=I-GAP
	SUB	L
	MOV	L,A
	MOV	A,D
	SBB	H
	MOV	H,A
;
L3:	SHLD	J
	XCHG
	LHLD	GAP		;JG=J+GAP
	DAD	D
	SHLD	JG
	MVI	A,13		;compare 13 chars	{sfk}
	CALL	COMPARE 	;compare (J) and (JG)
	JP	L5		;if A(J)<=A(JG)
	LHLD	J
	XCHG
	LHLD	JG
	CALL	SWAP		;exchange A(J) and A(JG)
	LHLD	J		;J=J-GAP
	XCHG
	LHLD	GAP
	MOV	A,E
	SUB	L
	MOV	L,A
	MOV	A,D
	SBB	H
	MOV	H,A
	JM	L5		;if J>0 GOTO L3
	ORA	L		;check for zero
	JZ	L5
	JMP	L3
;
L5:	LHLD	SCOUNT		;for later
	XCHG
	LHLD	I		;I=I+1
	INX	H
	MOV	A,E		;if I<=N GOTO L2
	SUB	L
	MOV	A,D
	SBB	H
	JP	L2
	LHLD	GAP
	JMP	L0
;
;
; Sort is all done - print entries
;
DONE:	 IF	FOPT		;if output option wanted, prepare file
	LDA	FOPFLG
	ORA	A
	JNZ	NOOUT		;if file output, fall through, A=0
;
;
; If all user option enabled, and we're not on the first pass, then the
; output file is already open and positioned, so we can skip the open.
;
	LXI	H,OPNFLG	;get pointer to output file open flag
	CMP	M		;A=0,set z if opnflg=0 also
	JNZ	NOOUT		;if opnflg not zero, skip open
	DCR	M		;else, set opnflg for next user #
;
;
; First	pass on file append - prepare SD.DIR to receive new or appended
; output.
;
	LXI	D,OUTFCB	;does output file already exist?
	MVI	C,SEARCH
	CALL	CPM
	INR	A
	JNZ	OPENIT		;if it does, then open it for processing
	MVI	C,MAKE		;otherwise, create the output file
	CALL	CPM
	INR	A
	JNZ	NOOUT		;continue if open successful
;
;
; If make or open fails, declare error
;
OPNERR:	CALL	ERXIT
	DB	'Ope','n' OR 80H
;
WRTERR:	CALL	ERXIT
	DB	'Writ','e' OR 80H
;
;
; Output file already exists - open it and position to the last record
; of the last extent.
;
OPENIT:	MVI	C,OPEN		;open 1st extent of output file
	CALL	CPM
	INR	A
	JZ	OPNERR		;bad deal if 1st won't open
;
OPNMOR:	LDA	OUTFCB+15
	CPI	128
	JC	LSTEXT		;if RC<128, this is last extent
	LXI	H,OUTFCB+12
	INR	M		;else, bump to next extent
	MVI	C,OPEN		;..and try to open it
	CALL	CPM
	INR	A
	JNZ	OPNMOR		;continue opening extents til no more
	DCR	M		;then, reopen preceding extent
	MVI	C,OPEN
	CALL	CPM
	LDA	OUTFCB+15	;get RC for the last extent
;
;
; At this point, OUTFCB is opened to the last extent of the file, so
; read in the last record in the last extent.
;
LSTEXT:	ORA	A		;is this extent empty?
	JZ	NOOUT		;if so, then  starting a clean slate
	DCR	A		;normalize record count
	STA	OUTFCB+32	;set record number to read
	MVI	C,READ		;..and read last record of file
	CALL	CPM
	ORA	A		;was read successful?
	JZ	RDOK		;if so, proceed to scan for EOF mark
;
APERR:	CALL	ERXIT
	DB	'Appen','d' OR 80H
;
;
; We now have the last record in the file in our buffer.  Scan the last
; record for the EOF mark, indicating where we can start adding data.
;
RDOK:	LXI	H,OUTBUF	;point to start of output buffer
	MVI	B,128		;get length of output buffer
;
SCAN:	MOV	A,M
	CPI	'Z'-40H 	;have we found end of file?
	JZ	RESCR		;if so, save pointers and reset CR
	INX	H
	DCR	B
	JNZ	SCAN		;otherwise, look until end of buffer
;
;
; If we	find an explicit EOF mark in the last buffer (or an implied EOF
; if the last record is full), move the FCB record and extent pointers
; back to correct for the read operation so that our first write opera-
; tion will effectively replace the last record of the SD.DIR file.
;
RESCR:	PUSH	H		;save EOF buffer pointer
	PUSH	B		;save EOF buffer remaining
	LXI	H,OUTFCB+32	;get current record again
	DCR	M		;dock it
	JP	SAMEXT		;if CR >=0, we're still in same extent
	LXI	H,OUTFCB+12	;else, move to previous extent
	DCR	M
	MVI	C,OPEN		;then, reopen the previous extent
	CALL	CPM
	INR	A
	JZ	APERR		;append position error if can not reopen
	LDA	OUTFCB+15	;else, position to last record of extent
	DCR	A
	STA	OUTFCB+32
;
SAMEXT:	POP	PSW		;recall where EOF is in buffer
	STA	BUFCNT		;..and set buffer counter
	POP	H		;recall next buffer pointer
	SHLD	BUFPNT		;.. and set pointer for first addition
	 ENDIF			;FOPT
;
;		end of	IF  FOPT  routine
;-----------------------------------------------------------------------
;
NOOUT:	 IF	VOPT		;if version option, check if first
	LDA	FIRSTT		;time through
	ORA	A
	JNZ	NOVOPT		;no, we've been here before
	MVI	A,0FFH		;virgin, poke it
	STA	FIRSTT
	LDA	VOPFLG		;if version display flag set, print it
	ORA	A
	JNZ	NOVOPT
	LXI	D,VERNAME
	CALL	PRINT
	CALL	CRLF
;
NOVOPT:	 ENDIF			;VOPT
;
	 IF	LOPT
	LHLD	COUNT
	SHLD	LCOUNT
	LXI	H,0
	SHLD	LBTOTL
	SHLD	LMTOTL
	LXI	H,ORDER 	;initialize order table pointer
	SHLD	NEXTL
	 ENDIF			;LOPT
;
	 IF	NOT LOPT
	LXI	H,ORDER 	;initialize order table pointer
	 ENDIF			;LOPT
;
	SHLD	NEXTT
;
	 IF	VCODE
	LHLD	COUNT		;code computes end of name
	CALL	MULT13		;table (or start of second table
	XCHG			;..where files will be stored after
	LHLD	TBLOC		;..redundant extents removed.)
	DAD	D
	SHLD	NEWPTR		;save it twice
	SHLD	XPOINT		;..for later
	 ENDIF			;VCODE
;
	 IF	NOT VCODE;
	JMP	NEWLIN		;start new line and output the files
	 ENDIF			;NOT VCODE
;
;
; Output the directory files we've matched.
;
ENTRY:	LHLD	COUNT
	DCX	H		;dock file count
	SHLD	COUNT
	MOV	A,H		;is this the last file?
	ORA	L
	JZ	OKPRNT		;if COUNT=0, last file so skip compare
;
;
; Compare each entry to make sure that it isn't part of a multiple ex-
; tent file.	Go only when we have the last extent of the file.
;
	PUSH	B		;save NPL
;
	 IF	NOT VCODE
	CALL	CKABRT		;check for abort code from keyboard
	 ENDIF			;NOT VCODE
;
	LHLD	NEXTT
	MVI	A,11
	CALL	COMPR		;does this entry match next one?
	POP	B		;recall NPL
	JNZ	OKPRNT		;no, print it
	INX	H
	INX	H		;skip since highest extent last in list
	SHLD	NEXTT
	JMP	ENTRY		;loop back for next lowest extent
;
;
; Vcode	substitution .	If VCODE option chosen, OKPRINT moves unique
; filenames and sizes in 'k' to a second table above the first for use
; later.
;
OKPRNT:	LHLD	NEXTT		;get order table pointer
	MOV	E,M		;get low order address
	INX	H
	MOV	D,M		;get high order address
	INX	H
	SHLD	NEXTT		;save updated table pointer
	XCHG			;table entry to HL
;
	 IF	VCODE
	PUSH	H		;save address of byte to be moved
	LHLD	NEWPTR		;get address in new table to put it in
	PUSH	H		;save it
	LXI	D,13		;update it
	DAD	D
	SHLD	NEWPTR		;save for later - will be end of table
	POP	H		;get current move to address
	XCHG			;put in DE
	POP	H		;get current move from address back
	MVI	B,11		;size of file name, type
	CALL	MOVE		;move it
	PUSH	D
	 ENDIF			;VCODE
;
	 IF	NOT VCODE
	MVI	B,8		;file name length
	CALL	TYPEIT		;type filename
	MVI	A,'.'		;period after FN
	CALL	TYPE
	MVI	B,3		;display 3 characters of filetype
	CALL	TYPEIT
	 ENDIF			;NOT VCODE
;
	CALL	DOIT
	LHLD	TOTSIZ		;DE now has rounded size in K
	DAD	D		;add to total used
	SHLD	TOTSIZ
	LHLD	TOTFIL		;Increment file count
	INX	H
	SHLD	TOTFIL
	XCHG			;Get back file size
;
	 IF	VCODE
	POP	D		;get back where size is to go
	MOV	A,H		;move size to table two
	STAX	D
	INX	D
	MOV	A,L
	STAX	D
;
;
; One file MOVED - test to see if we have to move another one.
;
	LHLD	COUNT		;get current file counter and test it
	MOV	A,H
	ORA	L
	JZ	PRTOTL		;if no more files exit to summary output
	JMP	ENTRY		;if more, go get them
	 ENDIF			;VCODE
;
;
; Output the size of the individual file.
;
	 IF	NOT VCODE
	CALL	DECPRT		;..go print it
	MVI	A,'k'		;..and follow with K size
	CALL	TYPE
;
;
; One file output - test to see if we have to output another one.
;
	LHLD	COUNT		;get current file counter and test it
	MOV	A,H
	ORA	L
	JZ	PRTOTL		;if no more files exit to summary output
;
;
; At least one more file to output - can we put it on the current line?
;
	DCR	C
	PUSH	PSW
	CNZ	FENCE		;if room left output the fence character
	POP	PSW
	JNZ	ENTRY		;..and go output another file
;
;
; Current line full, start a new one.
;
NEWLIN:	LDA	MNPL
	MOV	C,A		;reset names per line counter
	CALL	CRLF		;space down to next line
;
	 IF	PRDI
	LDA	FCB		;..precede new line with drive name
	ADI	'A'-1
	CALL	TYPE
;
	 IF	REPUSR AND PRUS
				;if reporting user # and running under
	CALL	CKVER		;..CP/M 2, output the user number too
	CNC	TYPUSR
	 ENDIF			;REPUSR AND PRUS
;
	MVI	A,':'		;tag header with a colon and a space
	CALL	FPAD		;..and exit back to ENTRY
	 ENDIF			;PRDI  was NPL<4
;
	JMP	ENTRY		;go back and output another file
	 ENDIF			;NOT VCODE
;
;
; Compute the size of the file/library and update our summary datum.
; This has been changed into a subroutine so that both the file size
; computation and a library size (when printing out library members)
; can be computed in K.
;
DOIT:	MOV	D,M
	INX	H
	MOV	E,M		;size in DE (sectors)
	LDA	BLKMSK
	PUSH	PSW
	ADD	E
	MOV	E,A
	MOV	A,D
	ACI	0
	MOV	D,A
	POP	PSW
	CMA
	ANA	E
	MOV	E,A
	MVI	B,3
;
SHRR:	MOV	A,D
	ORA	A
	RAR
	MOV	D,A
	MOV	A,E
	RAR
	MOV	E,A
	DCR	B
	JNZ	SHRR
	RET
;.....
;
;
; Print	HL in decimal with leading zero suppression
;
DECPRT:	XRA	A		;clear leading zero flag
	STA	LZFLG
	 IF	NOT KTHREE
	LXI	D,-1000 	;print 1000's digit
	CALL	DIGIT
	 ENDIF
	LXI	D,-100		;etc.
	CALL	DIGIT
	LXI	D,-10
	CALL	DIGIT
	MVI	A,'0'		;get 1's digit
	ADD	L
	JMP	TYPE
;
DIGIT:	MVI	B,'0'		;start off with ASCII 0
;
DIGLP:	PUSH	H		;save current remainder
	DAD	D		;subtract
	JNC	DIGEX		;quit on overflow
	POP	PSW		;throw away remainder
	INR	B		;bump digit
	JMP	DIGLP		;loop back
;
DIGEX:	POP	H		;restore pointer
	MOV	A,B
	CPI	'0'		;zero digit?
	JNZ	DIGNZ		;no, type it
	LDA	LZFLG		;leading zero?
	ORA	A
	MVI	A,'0'
	JNZ	TYPE		;print digit
	LDA	SUPSPC		;get space suppression flag
	ORA	A		;see if printing file totals
	RZ			;yes, don't give leading spaces
	JMP	SPACE		;leading zero...print space
;
DIGNZ:	STA	LZFLG		;leading zero flag so next zero prints
	JMP	TYPE		;and print digit
;.....
;
;
;=======================================================================
;		 VCODE subroutines begin here
;
; Multiply contents of HL register by 13
;
	 IF	VCODE
MULT13:	MOV	D,H		
	MOV	E,L		
	DAD	H
	DAD	D
	DAD	H
	DAD	H
	DAD	D
	RET
;.....
;
;
; Main subroutine to print out a filename and column delimiter
;
SUBA:	CALL	PFILE1		;routine to print a filename
	RZ			;if at end of line return with zero set
	CPI	0FFH		;if true past the end of the table
	CNZ	FENCE		;print the column delimiter if more
	LHLD	JUMPER		;put the jumper back in DE
	XCHG
	RET
;.....
;
;
PFILE1:	MOV	A,M		;let's see what we have
	CPI	0FEH
	RNC
	ANI	7FH		;strip parity bit
	PUSH	B		;save the number of columns
	MVI	B,8		;print file name and type
	CALL	TYPEIT
	MVI	A,'.'
	CALL	TYPE
	MVI	B,3
	CALL	TYPEIT
	PUSH	H
	CALL	CKABRT		;Ctl-C from keyboard?
	POP	H
	MOV	D,M		;get it into
	INX	H
	MOV	E,M
	XCHG			;HL
	CALL	DECPRT		;and print it out
	MVI	A,'k'
	CALL	TYPE
	POP	B		;get back number of columns
	LHLD	TOTFIL		;get number of files left
	DCX	H		;reduce it by one
	SHLD	TOTFIL		;and resave it
	MOV	A,H
	ORA	L		;down to zero yet?
	RZ			;return if no more files
	DCR	C		;decrement it and
	RET
	 ENDIF			;VCODE
;.....
;
;			end of VCODE routines
;=======================================================================
;
;
; Show total space and files used
;
PRTOTL:
	 IF	NOT VCODE
	 IF	LOPT
	LDA	LOPFLG
	ORA	A
;
	 IF	LOPREV
	JZ	PRTOT1
	 ENDIF			;LOPREV
;
	 IF	NOT LOPREV
	JNZ	PRTOT1
	 ENDIF			;NOT LOPREV
;
	LHLD	TOTFIL		;how many files did we match?
	MOV	A,H
	ORA	L
	CNZ	PRTLMEM 	;skip the .LBR check if none found
;
PRTOT1:	EQU	$
	 ENDIF			;LOPT
	 ENDIF			;NOT VCODE	
;
	XRA	A		;get a zero to...
	STA	SUPSPC		;suppress leading spaces in totals
	LHLD	TOTFIL		;how many files did we match?
	MOV	A,H
	ORA	L
	JZ	NXTUSR		;skip the summary if we didn't find any
	PUSH	H		;save TOTFIL
	STA	FNDFLG		;set file found flag
;
	 IF	VCODE		;leading CRLF for vertical output mode
	LDA	FIRSTT		; if not first time through
	ORA	A
	CNZ	CRLF
	 ENDIF			;VCODE
;
	LXI	D,TOTMS1	;print [CR,LF]	" Drive "
	CALL	PRINT
	LDA	FCB
	ADI	'A'-1
	CALL	TYPE		;output the drive code
;
	 IF	REPUSR
	CALL	CKVER
	JC	NOUSER
	CALL	TYPUSR		;output the user number
	 ENDIF			;REPUSR
;
NOUSER:	LXI	D,TOTMS5	;print " FILES: "
	CALL	PRINT
	POP	H		;recall TOTFIL
	CALL	DECPRT		;print number of files matched
	LXI	D,TOTMS3	;print " SPACE USED: "
	CALL	PRINT
	LHLD	TOTSIZ		;print total K used by files matched
	CALL	DECPRT
	LXI	D,TOTMS4	;print "K "
	CALL	PRINT
	CALL	PRTFRE		;output free space remaining & " FREE."
;
	 IF	NOT VCODE
	CALL	CRLF
	 ENDIF			;NOT VCODE
;
;
; Summary line printed, now print the detail files, but first compute
; total	lines the printout will take.
;
	 IF	VCODE
NPRNT:	LXI	D,0-NPL 	;minus number of columns
	LXI	B,NPL-1 	;no. of columns minus 1
	LHLD	TOTFIL		;get total number of files
	DAD	B		;round up to a full line
	MVI	C,-1
;
NPRNT1:	INR	C		;'C' will end up holding number
	DAD	D		;..of lines to be displayed.
	JC	NPRNT1
	MOV	A,C
	STA	LINES		;done. Save it for later
	STA	SUPSPC		;allow spaces in front of file sizes
;
;
; Number of lines times size of an entry equals the number of bytes to
; jump in the second table when outputing files in vertical order.
;
	MOV	L,A		;put number of lines into HL
	MVI	H,0
	CALL	MULT13
	SHLD	JUMPER		;put it away
;
;
; Fill a sector with FF at the end of table 2
;
	LHLD	NEWPTR		;now points to end of table 2
	MVI	B,128
	MVI	A,0FFH
;
NPRNT2:	MOV	M,A
	INX	H
	DCR	B
	JNZ	NPRNT2
;
;
; Increment the number of files for use later in SUBA.	This insures
; that a column delimiter will be printed after the last filename, if
; the file appears in other than the last column of the display.
;
	LXI	H,TOTFIL
	INR	M
;
;
; Print	out a line of files
;
NPRNT3:	CALL	CRLF		;start a new line
	MVI	C,NPL		;reset num. of columns
;
	 IF	PRDI
	PUSH	B
	LDA	FCB		;show drive letter at beginning of
	ADI	'A'-1		;..each line
	CALL	TYPE
;
	 IF	REPUSR AND PRUS	;also user number, if allowed
	CALL	CKVER
	CNC	TYPUSR
	 ENDIF			;REPUSR AND PRUS
;
	MVI	A,':'
	CALL	FPAD
	POP	B
	 ENDIF			;PRDI  was NPL<4
;
;
; Print	first filename
;
	LHLD	XPOINT		;XPOINT points to start of second table
	CALL	SUBA		;..at entry.  Below it is incremented
				;..for additional lines of printout.
	JZ	NLINE		;either out of columns or out of files.
;
;
; Print	second filename
;
	LHLD	XPOINT		
	DAD	D		
	CALL	SUBA		
	JZ	NLINE
;
;
; NOTE:	The following conditionals are used only to save some bytes if
;	running with only two or three columns of files in display.
;
; Print	third filename, if still room on line
;
	 IF	NPL>2
	LHLD	XPOINT		
	DAD	D		
	DAD	D		
	CALL	SUBA		
	JZ	NLINE
	 ENDIF			;NPL>2
;
	 IF	NPL>3
;
;
; Print	fourth filename
;
	LHLD	XPOINT		
	DAD	D		
	DAD	D
	DAD	D
	CALL	SUBA
	 ENDIF			;NPL>3
;
NLINE:	LHLD	XPOINT		;increment XPOINT to next file
	LXI	D,13
	DAD	D
	SHLD	XPOINT
	LHLD	TOTFIL		;time to see if we're out of files
	MOV	A,H
	ORA	L
	JZ	DOLIB		;yes we are
	LXI	H,LINES 	;nope, just need a new line
	DCR	M
	JNZ	NPRNT3
;
DOLIB:	 IF	LOPT
	LDA	LOPFLG
	ORA	A
;
	 IF	LOPREV
	JZ	PRTOT1
	 ENDIF			;LOPREV
;
	 IF	NOT LOPREV
	JNZ	PRTOT1
	 ENDIF			;NOT LOPREV
;
	LHLD	TOTFIL		;how many files did we match?
	MOV	A,H
	ORA	L
	CNZ	PRTLMEM 	;Skip the Library check if none found
;
PRTOT1	EQU	$
	 ENDIF			;LOPT
	 ENDIF			;VCODE
;
;
; Directory for one user area completed.  If 'all users' option is se-
; lected, then go do another directory on the next user number until we
; exceed the maximum user # for the selected drive.
;
NXTUSR:	 IF	AOPT		;if all users option enabled
	LDA	AOPFLG		;if not all users mode - skip next
	ORA	A
	JNZ	GOCLZ
	CALL	CKVER		;are we running CP/M 2?
	JC	GOCLZ		;skip user increment if not
	CALL	CKABRT		;check for user abort first
	LDA	MAXUSR		;no abort - get maximum user number
	LXI	H,NEWUSR	;bump directory user number
	INR	M
	CMP	M		;does next user # exceed maximum?
	JNC	SETTBL		;continue if more user areas to go
	 ENDIF			;AOPT
;
	 IF	DOPT AND AOPT	;if multi-disk option enabled
	LDA	BASUSR		;reset base user number for the
	MOV	M,A		;..next directory search
	 ENDIF			;DOPT AND AOPT
;
;
; We've finished all of our outputting.  Flush the remainder of the out-
; put buffer and close the file before going to exit routine.
;
GOCLZ:	 IF	FOPT
	LXI	H,OPNFLG	;get file open status then reset flag to
	MOV	A,M		;..force reopen on next pass
	MVI	M,0
	ORA	A
	JZ	NXTDSK		;skip closing sd.dir if it wasn't opened
	LXI	H,BUFCNT
	MOV	A,M		;retrieve # OF unflushed characters in
	MVI	M,128		;..buffer, force BUFCNT to empty status
	ORA	A		;if BUFCNT=128, buffer empty set sign
	JM	CLOSE		;close SD.DIR if buffer is empty
	JZ	FLUSH		;write last record to SD.DIR if full buf
	LHLD	BUFPNT		;else pad unused buffer with CTL-Z
;
PUTAGN:	MVI	M,'Z'-40H
	INX	H
	DCR	A
	JNZ	PUTAGN		;keep padding until buffer filled out
;
FLUSH:	LXI	D,OUTFCB	;flush the last output buffer
	MVI	C,WRITE
	CALL	CPM
	ORA	A
	JNZ	WRTERR
;
CLOZE:	LXI	D,OUTFCB	;close the output file
	MVI	C,CLOSE
	CALL	CPM
	 ENDIF			;BALANCE FOPT
;
;
; Directory for all user areas completed.  If the multi-disk option is
; enabled and selected, reset to the base user area and repeat the di-
; rectory for next drive on-line until we either exceed the drives in
; our LODRV-HIDRV table, or the BDOS shuts us down with a select or bad
; sector error, which will be intercepted back to the EXIT module.
;
NXTDSK:	LXI	H,FNDFLG	;get file found flag
	MOV	A,M
	MVI	M,0		;clear file found flag for next drive
	ORA	A
	JNZ	NDSK		;continue if at least 1 file found
;
	 IF	FOPT		;if file output enabled, temp. diasable
	LXI	H,FOPFLG
	DCR	M
	PUSH	H
	 ENDIF			;FOPT
;
	LXI	D,NOFMS1	;print no file found report
	CALL	PRINT
	LDA	FCB
	ADI	'A'-1
	CALL	TYPE		;output the drive
;
	 IF	REPUSR
	CALL	CKVER
	JC	NOUSR1
	CALL	TYPUSR		;output the user number
	 ENDIF			;REPUSR
;
NOUSR1:	LXI	D,NOFMS2	;print divider
	CALL	PRINT
	CALL	PRTFRE		;tag with free message
;
	 IF	NOT VCODE
	CALL	CRLF		;need another crlf in horiz. output mode
	 ENDIF	;NOT VCODE

	 IF	FOPT		;restore original file output mode
	POP	H
	INR	M
	 ENDIF			;FOPT
;
NDSK:	 IF	DOPT		;if multi-disk option enabled
	LDA	DOPFLG		;If multi-disk not selected - skip next
	ORA	A
	JNZ	NPRT
	CALL	CKABRT		;check for user abort first
	MVI	A,HIDRV-LODRV	;get maximum drive code to search
	LXI	H,FCB		;bump directory FCB drive code
	INR	M
	CMP	M		;does next disk exceed maximum?
	JC	NPRT
;
	 IF	MAXDR
	LDA	MAXD		;look at another value limit
	INR	A
	CMP	M		;is it lower?
	JC	NPRT		;bail out if too low
	JMP	NOOPT		;search next disk
	 ENDIF			;MAXDR
;
	JNC	NOOPT		;search next disk if maxdr not true
	 ENDIF			;DOPT
;
;
; If no	printer, fall through to EXIT
;
NPRT:	 IF	POPT		;check if printer is in use
	LDA	POPFLG
	ORA	A		;printer active?
	JNZ	EXIT		;no, just exit...
	MVI	C,5
	MVI	E,CR		;print a CRLF
	CALL	CPM
	MVI	E,LF		;line feed
	CALL	CPM
	 ENDIF			;POPT
;
	JMP	EXIT		;All done - exit to CCP
;.....
;
;
; Print	the user number of the directory in decimal
;
TYPUSR:	 IF	REPUSR
	LDA	NEWUSR
	CPI	10		;if user no. < 10, skip tens digit
	JC	DUX
	PUSH	B
	MVI	C,'0'-1
;
DUY:	INR	C		;get tens digit
	SUI	10
	JNC	DUY		;loop until we've gone too far
	ADI	10
	MOV	B,A		;save units digit
	MOV	A,C		;print tens digit
	CALL	TYPE
	MOV	A,B		;get units back
	POP	B
;
DUX:	ADI	'0'
	JMP	TYPE
	 ENDIF			;REPUSR
;
;
; Force	new line on video and check for page pause
;
CRLF:	MVI	A,CR		;send CR
	CALL	TYPE
	MVI	A,LF		;send LF
	JMP	TYPE
;.....				;exit to caller from TYPE
;
;
; Separate the directory output on a line with a space, the delimiter,
; followed by another space.
;
FENCE:	CALL	SPACE
	LDA	FC		;fence character
;
FPAD:	CALL	TYPE		;print it, fall into space
;
SPACE:	MVI	A,' '	       ;fall through to TYPE
;
;
; Output character in A to console, and optionally to printer and/or the
; output file.
;
TYPE:	PUSH	B
	PUSH	D
	PUSH	H
	PUSH	PSW		;save the character to output
	CALL	TYPE1		;send it to console
	POP	PSW		;restore the output character
	ANI	7FH		;strip parity bit on character
;
;
; Check	if reverse video sequence. If so, do not store the
; leadin character or entry/exit characters in SD.DIR
;
	 IF	REVIDEO
	CPI	LEADIN		;if lead-in for hilite
	JZ	NOHLT		;skip file I/O and printer
	CPI	INTOREV 	;reverse start?
	JZ	CKREV
	CPI	OUTAREV 	;reverse end?
	JNZ	TYSKIP		;no, skip
;
CKREV:	MOV	B,A		;save character
	LDA	HITRAP		;get previous character
	CPI	LEADIN		;was it a leadin?
	MOV	A,B		;restore char
	JZ	NOHLT		;skip file and printer
;
TYSKIP:	STA	HITRAP		;save character for hilite trap
	 ENDIF			;REVIDEO
;
;
; Test file output mode and skip to page pause test if not active.
;
	 IF	FOPT
	MOV	B,A		;save stripped character to B
	LDA	FOPFLG		;is file output active?
	ORA	A
	JNZ	NOWRIT		;go check for page pause if not
;
;
; File output mode active - make sure we have room in buffer to add the
; next character.  If buffer full, write out current record first and
; then start a new record with current character.
;
	LHLD	BUFPNT		;get current buffer pointer
	LDA	BUFCNT		;get buffer capacity remaining
	ORA	A
	JNZ	PUTBUF		;continue if buffer not full
	CALL	SETFOP		;set the DMA address
	LXI	D,OUTFCB	;otherwise, write the current buffer out
	MVI	C,WRITE
	CALL	CPM		;(note call must save character in B)
	ORA	A
	JNZ	WRTERR		;write error exit if disk full or R/O
	LXI	H,OUTBUF	;reset buffer pointer
	MVI	A,128		;reset buffer capacity
;
PUTBUF:	MOV	M,B		;shove character to next buffer position
	INX	H		;bump buffer pointer
	SHLD	BUFPNT		;.. and save it
	DCR	A		;dock count of characters left in buffer
	STA	BUFCNT		;..and save it
;
NOWRIT:	MOV	A,B		;recall stripped character
	 ENDIF			;FOPT
;
	 IF	POPT		;if printer option
	ANI	7FH		;strip parity bit on character
	MOV	E,A		;setup list output call
	MVI	C,5
	LDA	POPFLG		;test printer flag
	ORA	A
	CZ	CPM		;print character if flag true
	MOV	A,E		;recall character
	 ENDIF			;POPT
;
	 IF	REVIDEO
NOHLT:	STA	HITRAP		;save character for hilite trap
	 ENDIF
;
	 IF	PGPAWS
	CPI	LF		;do we have a LF?
	JNZ	TYPRET		;exit if not
	 ENDIF			;PGPAWS
;
	 IF	NOPT AND PGPAWS
	LDA	NOPFLG		;is the page pause function disabled?
	ORA	A
	JZ	TYPRET		;exit if so
	 ENDIF			;NOPT AND PGPAWS
;
	 IF	PGPAWS
	LDA	LINCNT		;get line count
	INR	A		;bump it
	LXI	H,MLPS
	CMP	M		;are we at the end of the screen?
	JC	NOTEOS		;skip if not
	LXI	D,EOSMSG	;else, display pause message
	MVI	C,PRINTS	;..without checking for LFs
	CALL	BDOS
	CALL	CINPUT		;wait for character
	CPI	'C'-40H 	;want to abort?
	JZ	EXIT1		;abort on CTL-C
	LXI	D,MORERA	;wipe the silly '[more]' out
	MVI	C,PRINTS
	CALL	BDOS
	XRA	A		;reset line count
;
NOTEOS:	STA	LINCNT		;save new line count
	 ENDIF			;PBPAWZ
;
TYPRET:	POP	H		;exit from TYPE
	POP	D
	POP	B
	RET
;.....
;
;
; Output character
;
TYPE1:	 IF	VECTOR
	ORA	A		;set sign flag if MS bit is on
	JP	TYPE2		;if character is ASCII, continue
	MOV	B,A		;else, get character to B
	MVI	A,5		;video driver function for direct output
	JMP	VIDEO		;display in rev video, exit from VIDEO
	 ENDIF			;VECTOR
;
TYPE2:	 IF	REVIDEO
	ORA	A
	JP	TYPE99
	PUSH	PSW
	LDA	MLEADIN 	;send ESC char first
	CALL	TYPE99
	LDA	MINTOREV
	CALL	TYPE99
	POP	PSW		;retrieve character
	ANI	7FH
	CALL	TYPE99
	LDA	MLEADIN 	;send ESC first
	CALL	TYPE99
	LDA	MOUTAREV	;the out of reverse video character
;
TYPE99:	 ENDIF			;REVIDEO
;
	 IF	DIRCON
	MOV	C,A		;get character into BIOS entry register
	LHLD	BASE+1		;get page base of BIOS
	MVI	L,12		;get entry vector to CONOUT
	JMP	GOHL		;call CONOUT direct through the BIOS
	 ENDIF			;DIRCON
;
	 IF	NOT DIRCON
	MOV	E,A		;get character into BDOS entry register
	MVI	C,WRCHR
	JMP	BDOS		;call CONOUT via the BDOS
	 ENDIF			;NOT DIRCON
;.....
;
;
; Print	a string at HL of length B
;
TYPEIT:	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	TYPEIT
	RET
;.....
;
;
; Print	string terminated with last byte high on console
;
PRINT:	LDAX	D
	PUSH	PSW
	ANI	7FH
	CALL	TYPE
	POP	PSW
	ORA	A
	RM
	INX	D
	JMP	PRINT
;.....
;
;
; Fetch	character from console (without echo)
;
CINPUT:	LHLD	BASE+1
	MVI	L,9
	CALL	GOHL
	ANI	7FH
	RET
;.....
;
;
; Check	for a CTRL-C or CTRL-S entered from the keyboard.  Jump to EXIT
; if CTRL-C, pause on CTRL-S.
;
CKABRT:	LHLD	BASE+1
	MVI	L,6		;check status of keyboard
	CALL	GOHL		;any key pressed?
	ORA	A
	RZ			;no, return to caller
	CALL	CINPUT		;get character
	CPI	'C'-40H 	;CTL-C?
	JZ	EX0		;if CTL-C then quit
	CPI	'S'-40H 	;CTL-S?
	RNZ			;no, return to caller
	CALL	CINPUT		;yes, wait for another char.
	CPI	'C'-40H 	;might be CTL-C
	JZ	EX0		;if CTL-C, else fall thru and continue
	RET
;.....
;
;
; Routine to do disk reset if D option entered on command line
;
DSET:	MVI	C,RESET
	CALL	CPM
	RET
;.....
;
;
; Kludge to allow call to address in HL
;
GOHL:	PCHL
;
; Entry	to BDOS saving all extended registers
;
CPM:	PUSH	B
	PUSH	D
	PUSH	H
	CALL	BDOS
	MOV	B,A		;save return code
	LDA	VERFLG		;is this 3.0?
	CPI	30H
	MOV	A,B
	JC	CPM20		;no, exit normally
	CPI	0FFH		;it is 3.0 - was return code FF?
	JNZ	CPM20		;no, exit normally
	MOV	A,H		;3.0 and A=FF - check for error code
	ORA	A
	JNZ	DSKERR		;trap out if we got a physical error
	MOV	A,B		; Else continue normally
;
CPM20:	POP	H
	POP	D
	POP	B
	RET
;.....
;
;
; For file output mode, return to old user area and set DMA for the file
; output buffer.
;
SETFOP:	 IF	UOPT OR AOPT
	CALL	CKVER		;clear carry if CP/M 2 or later
	LDA	OLDUSR		;get user number at startup
	MOV	E,A
	MVI	C,CURUSR
	CNC	CPM		;reset the old user number if CP/M 2
	 ENDIF			;UOPT OR AOPT	
;
	 IF	FOPT
	LXI	D,OUTBUF	;move DMA from search buffer into the
	JMP	SET2		;..output buffer
	 ENDIF			;FOPT
;
	RET
;.....
;
;
; Move disk buffer DMA to default buffer for directory search operations
; and BDOS media change routines (necessary for pre-CP/M 2 systems while
; in file output mode with an active buffer).
;
SETSRC:	LXI	D,BASE+80H
;
SET2:	MVI	C,SETDMA
	JMP	CPM
;.....
;
;
; Print	the amount of free space remaining on the selected drive
;
PRTFRE:	LXI	D,TOTMS6	;print " ( "
	CALL	PRINT
	LHLD	FREEBY
	CALL	DECPRT		;print K free
	LXI	D,TOTMS7	;print " K FREE) "
	JMP	PRINT
;.....
;
;
; Compare routine for sort
;
COMPR:	PUSH	H		;save table addr
	MOV	E,M		;load low order
	INX	H
	MOV	D,M		;load high order
	INX	H
	MOV	C,M
	INX	H
	MOV	B,M
;
;
; BC, DE now point to entries to be compared
;
	XCHG
	MOV	E,A		;get count
;
CMPLP:	MOV	A,M
	ANI	7FH
	MOV	D,A
	LDAX	B
	ANI	7FH
	CMP	D
	INX	H
	INX	B
	JNZ	NOTEQL		;quit on mismatch
	DCR	E		;or end of count
	JNZ	CMPLP
;
NOTEQL:	POP	H
	RET			;Cond code tells all
;.....
;
;
; Swap entries in the order table
;
SWAP:	LXI	B,ORDER-2	;table base
	DAD	H		;*2
	DAD	B		;+ base
	XCHG
	DAD	H		;*2
	DAD	B		;+ base
	MOV	C,M
	LDAX	D
	XCHG
	MOV	M,C
	STAX	D
	INX	H
	INX	D
	MOV	C,M
	LDAX	D
	XCHG
	MOV	M,C
	STAX	D
	RET
;.....
;
;
; New compare routine
;
COMPARE:LXI	B,ORDER-2
	DAD	H
	DAD	B
	XCHG
	DAD	H
	DAD	B
	XCHG
	MOV	C,M
	INX	H
	MOV	B,M
	XCHG
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	MOV	E,A		;count
;
CMPLPE:	MOV	A,M
	ANI	7FH
	MOV	D,A
	LDAX	B
	ANI	7FH
	CMP	D
	INX	B
	INX	H
	RNZ
	DCR	E
	JNZ	CMPLPE
	RET
;.....
;
;
; Error	exit
;
ERXIT:	 IF	FOPT
	MVI	A,-1
	STA	FOPFLG		;Disable file output mode on error
	 ENDIF			;FOPT
;
	CALL	CRLF		;Space down
	POP	D		;Get pointer to message string
	CALL	PRINT		;Print it
	LXI	D,ERRMS1	;Print " Error"
	CALL	PRINT
	CALL	CRLF		;Space down
;
;
; Exit - all done, restore stack
;
EXIT:	 IF	DOPT		;if multi-disk option enabled
	LDA	DOPFLG		;if multi-disk not selected - skip next
	ORA	A
	JNZ	EX0
	CALL	CKABRT		;check for user abort first
	MVI	A,HIDRV-LODRV	;get maximum drive code to search
	LXI	H,FCB		;bump directory FCB drive code
	INR	M
	CMP	M		;does next disk exceed maximum?
	JC	EX0
;
	 IF	MAXDR
	LDA	MAXD		;look at another value limit
	INR	A
	CMP	M		;is it lower?
	JC	EX0		;bail out if too low
	JMP	NOOPT		;search next disk
	 ENDIF			;MAXDR
;
	JNC	NOOPT		;search next disk if maxdr not true
	 ENDIF			;DOPT
;
EX0:	 IF	VCODE
	CALL	CRLF		;turn up a blank line at end
	 ENDIF			;VCODE

	MVI	C,CONST 	;check console status
	CALL	CPM
	ORA	A		;char waiting?
	MVI	C,RDCHR
	CNZ	CPM		;gobble up char
;
	 IF	DOPT		;restore BDOS intercept vectors
	LDA	VERFLG		;or error mode, depending on version
	CPI	30H
	JC	EXIT0
	MVI	C,45
	MVI	E,0		;set error mode back to default
	CALL	CPM
	JMP	EXIT1
;
EXIT0:	LDA	DOPFLG		;..if they were swapped
	ORA	A
	CZ	SWAPEM
	 ENDIF			;DOPT
;
EXIT1:
;
	 IF	ROPT
	LDA	ROPFLG		;if disk system was reset
	ORA	A
	LDA	OLDDSK		;get default disk at startup
	MOV	E,A
	MVI	C,SELDSK	;reselect it
	CZ	CPM
	 ENDIF			;ROPT
;
	LHLD	STACK		;get old stack pointer
	SPHL			;move back to old stack
	RET			;..and return to CCP
;.....
;
;
; Trap BDOS select and sector error vectors to our own intercept routine
; so we	can catch a reference to an illegal drive.

	 IF	DOPT
SWAPEM:	LDA	VERFLG		;check version
	CPI	30H		;see if error mode call is available
	JC	SWAP20		;if not, use BDOS error vectors
	MVI	C,45
	MVI	E,0FFH		;use set error mode call
	CALL	CPM		;set "return code only" mode
	RET
;.....
;
;
SWAP20:	LHLD	BDOS+1		;Get pointer to base of BDOS
	 ENDIF			;DOPT
;
	 IF	DOPT AND LOWCCP
	LDA	BDOSPG		;get "proper" BDOS page
	MOV	E,A		;save it in "E"
	MOV	A,H		;get location of BDOS
	CMP	E		;is it where BDOS normally is?
	JZ	BDCHK2		;yes, but perform 2nd check to be sure
	INX	H		;swap in the new pointer if running a
	MOV	E,M		;..program below the CCP
	INX	H
	MOV	D,M
	XCHG			;now HL points to the proper vector
	JMP	SWAPOK		;bypass second check
	 ENDIF			;DOPT AND LOWCCP
;
	 IF	DOPT
BDCHK2:	MOV	A,L
	SUI	6		;check if pointing directly to BDOS
	JZ	SWAPOK		;continue if true
	MVI	A,'D'		;undo option request for multi-disk
	STA	DOPFLG
;
SWAPOK:	MVI	L,9		;point to sector error vector
	LXI	D,VECTBL	;exchanging with our own vector table
	MVI	A,4		;4 bytes to swap
;
SWAPLP:	MOV	B,M		;get byte from HL
	XCHG
	MOV	C,M		;get byte from DE
	MOV	M,B		;put byte from HL
	XCHG
	MOV	M,C		;put byte from DE
	INX	H		;bump exchange pointers
	INX	D
	DCR	A		;dock counter
	JNZ	SWAPLP		;continue swapping til done
	RET
	 ENDIF			;DOPT
;.....
;
;
; Check	CP/M version number.  Return carry flag set if pre-CP/M 2.  If
; CP/M 2 or later or MP/M (any version), return carry clear.
;
CKVER:	LDA	VERFLG
	CPI	20H
	RET
;.....
;
;
; Recovery point from intercepted BDOS select and bad sector errors.
;
DSKERR:	 IF	DOPT
	LXI	SP,STACK	;get out of BDOS' stack
	JMP	EXIT		;..and exit back to CCP
	 ENDIF			;DOPT
;
;-----------------------------------------------------------------------
;			start of FNAME routine
; FNAME	module
;
	 IF	DUOPT
MAXDISK	EQU	16		;maximum number of disks
MAXUSER	EQU	31		;maximum user number
;
;  MAIN	MODULE
;	ON ENTRY, DE PTS TO FCB TO BE FILLED AND HL PTS TO FIRST BYTE OF
;		TARGET STRING; FCB IS 36 BYTES LONG
;	ON EXIT, B=DISK NUMBER (1 FOR A, ETC) AND C=USER NUMBER
;		HL PTS TO TERMINATING CHAR
;		A=0 AND Z SET IF ERROR IN DISK OR USER NUMBERS,
;		A=0FFH AND NZ
;	IF OK
;
FNAME:	PUSH	D		;save 'DE'
	MVI	A,0FFH		;set default disk and user
	STA	DISK
	STA	USER
	MVI	B,36		;initialize 'FCB'
	PUSH	D		;save pointer
	XRA	A		;A=0
;
FNINI:	STAX	D		;store zero
	INX	D		;point to next
	DCR	B		;count down
	JNZ	FNINI
	POP	D		;get pointer back
;
;
; Scan for colon in string
;
	PUSH	H		;save pointer
;
COLON:	MOV	A,M		;scan fora colon or space
	INX	H		;point to next
	CPI	':'		;colon found?
	JZ	COLON1
	CPI	','		;comma found?
	JZ	GETF1
	CPI	' '+1	       ;delimiter?
	JC	GETF1
	JMP	COLON		;continue if not end of line
;
COLON1:	POP	H		;clear stack
	MOV	A,M		;save possible drive specification
	CALL	CAPS		;capitalize
	CPI	'A'		;digit if less than 'A'
	JC	USERCK		;process user number
	SUI	'A'		;convert to 0-31
	CPI	MAXDISK 	;within bounds?
	JC	SVDISK
;
ERREXIT:XRA	A		;error indicator
	POP	D		;restore 'DE'
	RET
;...
;
;
; Log in specified disk
;
SVDISK:	INR	A		;adjust to 1 for 'A'
	STA	DISK		;save flag
	INX	H		;point to next character
;
;
; Check	for user
;
USERCK:	MOV	A,M		;get possible user number
	CPI	':'		;no user number
	JZ	GETFILE
	CPI	'?'		;all user numbers?
	JNZ	USERC1
	STA	USER		;set value
	INX	H		;point to after
	MOV	A,M		;must be colon
	CPI	':'
	JZ	GETFILE
	JMP	ERREXIT 	;fatal error if not colon after ?
;
USERC1:	XRA	A		;zero user number
	MOV	B,A		;'B' = accumulator for user number
;
USRLOOP:MOV	A,M		;get digit
	INX	H		;point to next
	CPI	':'		;done?
	JZ	USRDN
	SUI	'0'		;convert to binary
	JC	ERREXIT 	;user number error?
	CPI	10
	JNC	ERREXIT
	MOV	C,A		;next digit in 'C'
	MOV	A,B		;old number in 'A'
	ADD	A		;*2
	ADD	A		;*4
	ADD	B		;*5
	ADD	A		;*10
	ADD	C		;*10+new digit
	MOV	B,A		;result in 'B'
	JMP	USRLOOP
;
USRDN:	MOV	A,B		;get nuer user number
	CPI	MAXUSER+1	;within range?
	JNC	ERREXIT
	STA	USER		;save in flag
	JMP	GETFILE
;
;
; Extract file name
;
GETF1:	POP	H		;get pointer to byte
;
GETFILE:MOV	A,M		;pointing to colon?
	CPI	':'
	JNZ	GFILE1
	INX	H		;skip over colon
;
GFILE1:	MOV	A,M		;get next character
	CPI	','		;delimiter?
	JZ	GFQUES
	CPI	' '+1	       ;not a delimiter?
	JNC	GFILE2
;
GFQUES:	INX	D		;fill with ???
	MVI	B,11		;11 bytes
	MVI	A,'?'
;
GFFILL:	STAX	D		;put?
	INX	D		;point to next
	DCR	B		;count down
	JNZ	GFFILL
;
FNDONE:	LDA	DISK		;get disk number
	MOV	B,A		;... in 'B'
	LDA	USER		;get user number
	MOV	C,A		;... in 'C'
	POP	D		;restore registers
	MVI	A,0FFH		;no error
	ORA	A		;set flags
	RET
;.....
;
;
; Get file name fields
;
GFILE2:	MVI	B,8		;at most, 8 bytes for filename
	CALL	SCANF		;scan and fill
	MVI	B,3		;at most, 3 bytes for filetype
	MOV	A,M		;get delimiter
	CPI	'.'		;filename ending in '.'?
	JNZ	GFILE3
	INX	H		;point to character after '.'
	CALL	SCANF		;scan and fill
	JMP	FNDONE		;done...return to 'ARGS'
;...
;
;
GFILE3:	CALL	SCANF4		;fill with spaces
	JMP	FNDONE
;.....
;
;
; Scanner routine
;
SCANF:	CALL	DELCK		;check for delimiter
	JZ	SCANF4		;fill with spaces if found
	INX	D		;point to next byte in filename
	CPI	'*'		;question mark fill ?
	JNZ	SCANF1
	MVI	A,'?'		;place '?'
	STAX	D
	JMP	SCANF2
;
SCANF1:	STAX	D		;place character
	INX	H		;point to next position
;
SCANF2:	DCR	B		;count down
	JNZ	SCANF		;continue loop
;
SCANF3:	CALL	DELCK		;"B" chars or more - skip to delimiter
	RZ
	INX	H		;point to next
	JMP	SCANF3
;
SCANF4:	INX	D		;point to next filename or filetype
	MVI	A,' '	       ;fill with spaces
	STAX	D
	DCR	B		;count down
	JNZ	SCANF4
	RET
;.....
;
;
; Buffers
;
DISK:	DS	1		;disk number
USER:	DS	1		;user number
;
;
; Check	character pointed to by 'HL' for a delimiter, return with Zero
; flage	set if the character is a delimiter	
;
DELCK:	MOV	A,M		;get the character
	CALL	CAPS		;capitalize
	ORA	A		;0=delimiter
	RZ
	CPI	' '+1	       ;space character+1
	JC	DELCK1		;space character or less
	CPI	'='
	RZ
	CPI	5FH		;underscore
	RZ
	CPI	'.'
	RZ
	CPI	':'
	RZ
	CPI	';'
	RZ
	CPI	','
	RZ
	CPI	'<'
	RZ
	CPI	'>'
	RET
;...
;
;
DELCK1:	CMP	M		;compare with self for OK
	RET
;...
;
;
CAPS:	CPI	'a'
	RC
	CPI	'z'+1
	RNC
	SUI	20H
	RET
	 ENDIF
;.....
;			end of FNAME routine
;
;=======================================================================
;
;	     SUBROUTINES to read library file directory
;
;=======================================================================
;			start of LOPT routine
;
	 IF	LOPT
PRTLMEM:LXI	H,ORDER 	;initialize order table pointer
	SHLD	NEXTL
	XRA	A
	STA	LNCNT
;
ENTRYL:	LHLD	LCOUNT		;get FCB count
	DCX	H		;decrement it
	SHLD	LCOUNT
	MOV	A,H		;is this the last file?
	ORA	L
	JZ	LBRTST		;if COUNT=0, last file skip compare
	PUSH	B
	CALL	CKABRT		;check for abort code from keyboard
	LHLD	NEXTL
	MVI	A,11
	CALL	COMPR		;does this entry match next one?
	POP	B
	JNZ	LBRTST		;no, print it
	INX	H
	INX	H		;skip, highest extent comes last in list
	SHLD	NEXTL
	JMP	ENTRYL		;loop back for next lowest extent
;
;
; Exit Library member printing
;
LBEXIT:	LHLD	LMTOTL
	MOV	A,H
	ORA	L
	RZ
	PUSH	H		;save Member count
	XRA	A		;get a zero to...
	STA	SUPSPC		;suppress leading spaces in totals
	LXI	H,MNPL		;if last line is full, don't turn
	LDA	LNCNT		;up extra line
	CMP	M
	CNZ	CRLF		;if partial line, extra line needed
;
	 IF	PRBRDR
	CALL	BDRCH2
	 ENDIF
;
	LXI	D,CONTM 	;print "There are "
	CALL	PRINT
	POP	H		;get total member count back
	CALL	DECPRT
	LXI	D,MFILES	;print "Members in "
	CALL	PRINT
	LHLD	LBTOTL
	CALL	DECPRT
	LXI	D,LIBR
	JMP	PRINT
;.....
;
;
; Valid	entry obtained - spit it out.
;
LBRTST:	LHLD	NEXTL		;get order table pointer
	MOV	E,M		;get low order address
	INX	H
	MOV	D,M		;get high order address
	INX	H
	SHLD	NEXTL		;save updated table pointer
	LXI	H,8
	DAD	D
	CALL	CKLBR
	JNZ	LBRNEX
	PUSH	D
	LXI	H,MNPL
	LDA	LNCNT		;old code here
	CMP	M
	CNZ	CRLF
	LXI	D,LFMSEP	;print "Library file members for "
	CALL	PRINT
	LDA	FCB		;get current drive
	ADI	'A'-1		;convert to ASCII
	CALL	TYPE		;print it
;
	 IF	REPUSR
	CALL	TYPUSR		;print User # after it
	 ENDIF			;REPUSR
;
	MVI	A,':'		;and colon
	CALL	TYPE
	POP	H
	PUSH	H
	MVI	B,8		;file name length
	CALL	TYPEIT
	MVI	A,'.'		;period after FN
	CALL	TYPE
	MVI	B,3		;display 3 characters of filetype
	CALL	TYPEIT
	CALL	DOIT		;compute size of library IN K
	XCHG
	CALL	DECPRT
	MVI	A,'k'
	CALL	TYPE
	CALL	CRLF
	POP	H
;
;
; Saves	the library file name into LBRFCB
;
	LDA	FCB
	LXI	D,LBRFCB	;to
	STAX	D
	INX	D
	MVI	B,11		;len
	CALL	MOVE		;do the move
	XCHG
	MVI	B,25
;
CLMFCB:	MVI	M,0
	INX	H
	DCR	B
	JNZ	CLMFCB
	CALL	SETLDMA
	LXI	D,LBRFCB	;point to file
	MVI	C,OPEN		;get function
	CALL	CPM		;open it
	MVI	C,READ
	LXI	D,LBRFCB
	CALL	CPM
	CALL	SETFOP
	LXI	H,LBBUF
	MOV	A,M
	ORA	A
	JZ	CKLDIR		;check directory present?
;
BADLBR:	LXI	H,NLBRF
	MVI	B,25
	CALL	TYPEIT
;
LMLEXI:	CALL	LBCLOSE
;
;
; Do next library file
;
LBRNEX:	LHLD	LCOUNT		;check count
	MOV	A,H
	ORA	L
	JZ	LBEXIT		;no more, all done
	JMP	ENTRYL		;else, get next .LBR file
;
NLBRF:	DB	'++ Not a LIBRARY file ++',CR,LF
;
;
; Close	the library file
;
LBCLOSE:LXI	D,LBRFCB
	MVI	C,CLOSE
	CALL	CPM
	RET
;.....
;
;
; Set the Library file DMA adderss
;
SETLDMA:CALL	CKVER		;set carry if pre-CP/M 2
	LDA	NEWUSR		;get user area for directory
	MOV	E,A
	MVI	C,CURUSR	;get the user function
	CNC	CPM		;..and set new user number if CP/M 2
	LXI	D,LBBUF
	MVI	C,SETDMA
	CALL	CPM
	RET
;.....
;
;
; Check	to see if there indeed is a LBR file directory and barf if not!
;
CKLDIR:	MVI	B,11		;length of file name
	MVI	A,' '	       ;space
	INX	H
;
CKDLP:	CMP	M
	JNZ	BADLBR
	DCR	B
	INX	H
	JNZ	CKDLP
;
;
; The first entry in the LBR directory is indeed blank.  Now see if the
; directory size is >0
;
	MOV	E,M		;file starting location low
	INX	H		;must be zero here
	MOV	A,M		;file starting location high
	ORA	E		;must be zero here also
	JNZ	BADLBR
	INX	H
	MOV	E,M		;get library size low
	INX	H		;point to library size high
	MOV	D,M		;get library size high
	MOV	A,D
	ORA	E		;library must have some size
	JZ	BADLBR
	DCX	D
	XCHG
	SHLD	SLFILE
	LHLD	LBTOTL
	INX	H
	SHLD	LBTOTL
	LDA	MNPL
	STA	LNCNT		;reset names per line counter
	MVI	B,3
	LXI	H,17
	DAD	D
	JMP	LMTEST
;
LFMLOP:	LHLD	SLFILE		;get
	MOV	A,L
	ORA	H
	JZ	LMLEXI
	DCX	H
	SHLD	SLFILE
	CALL	SETLDMA
	MVI	C,READ
	LXI	D,LBRFCB
	CALL	CPM
	CALL	SETFOP
	MVI	B,4		;get file count per sector
	LXI	H,LBBUF 	;get buffer starting address
;
LMTEST:	MOV	A,M		;get member open flag
	ORA	A		;test for open
	JZ	PRMNAM
;
LMTESA:	LXI	D,32		;member not open get offset
	DAD	D		;to next and add it in.
	DCR	B		;is buffer empty ?
	JNZ	LMTEST		;no so test next entry
	JMP	LFMLOP		;yes get next buffer...
;
PRMNAM:	PUSH	H		;print member NAME and SIZE
	PUSH	B
	CALL	CKABRT		;check for abort code from keyboard
	LXI	H,LNCNT
	LDA	MNPL
	CMP	M
	JNZ	PRMNA1
;*
;*	MVI	A,3		;if printing less than 4 wide
;*	CMP	M
;*	JC	PRMNA1		;Taken out when KTHREE was added
;*
	 IF	PRBRDR
	MVI	A,'*'		;Load A reg with border character
	CALL	TYPE		;Print it
	MVI	A,' '		;
	CALL	TYPE		;Print space between border & text
	 ENDIF
;
	 IF	PRDI AND PRLIBD
	LDA	LBRFCB		;..precede new line with drive name
	ADI	'A'-1
	CALL	TYPE
;
	 IF	REPUSR AND PRUS	;if reporting user numbers and running
	CALL	CKVER		;..under CP/M 2, output the user number
	CNC	TYPUSR		;..too
	 ENDIF			;REPUSR AND PRUS
;
	MVI	A,':'		;tag header with a colon and a space
	CALL	FPAD		;..and exit back to ENTRY
	 ENDIF			;PRDI AND PRLIBD
;
PRMNA1:	POP	B
	POP	H
	PUSH	H
	PUSH	B
	INX	H
	MVI	B,8		;file name length
	CALL	TYPEIT
	MVI	A,'.'		;period after FN
	CALL	TYPE
	MVI	B,3		;display 3 characters of filetype
	CALL	TYPEIT
	INX	H
	INX	H
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
;
;
; Output the size of the individual file.
;
	PUSH	D
	PUSH	H
	PUSH	H
	LHLD	LLENLOC
	PUSH	H
	POP	D
	POP	H
	DAD	D
	SHLD	LLENLOC
	POP	H
;
;
; New code added to convert lib members from sectors to 'k'
;
; Upon entry member's size in sectors is in HL
;
	XCHG			;put it in DE
	LXI	H,0		;zero out HL
	MOV	A,E		;put low byte of sector count in A
	ADI	7		;add seven to always round up 1K
	RRC			;convert it to K
	RRC
	RRC
	ANI	1FH
	MOV	E,A		;and put it back
	MOV	L,D		;get the high byte if any
	MVI	D,0		;clean out the old resting place
	DAD	H		;multiply it by 32 to convert to
	DAD	H		;number
	DAD	H		;of
	DAD	H		;K
	DAD	H		;bytes
	DAD	D		;and add in the low byte
	POP	D
	CALL	DECPRT		;..go print it
	MVI	A,'k'		;..and follow with size
	CALL	TYPE
;
;
; At least one more file to output - can we put it on the current line?
;
	LHLD	LMTOTL
	INX	H
	SHLD	LMTOTL
	LDA	LNCNT
	DCR	A
	STA	LNCNT
	PUSH	PSW
	CNZ	FENCE		;if room left, output the fence char.
	POP	PSW
	POP	B
	POP	H
	JNZ	LMTESA		;.. and go output another file
;
;
; Current line full, start a new one.
;
	LDA	MNPL
	STA	LNCNT		;reset names per line counter
	CALL	CRLF		;space down to next line
	JMP	LMTESA
;.....
;
;
; Move characters from 'HL' to 'DE' length in 'B'
;
MOVE:	MOV	A,M		;get a character
	STAX	D		;store it
	INX	H		;to next 'from'
	INX	D		;to next 'to'
	DCR	B		;more?
	JNZ	MOVE		;yes, loop
	RET			;no, return
;.....
;
;
; Test file extent for LBR
;
CKLBR:	PUSH	H
	PUSH	D
	PUSH	B
	XCHG
	LXI	H,LBRTYP
	MVI	C,3
;
CKLBL:	LDAX	D
	ANI	7FH
	CMP	M
	JNZ	CKLBX
	INX	H
	INX	D
	DCR	C
	JNZ	CKLBL
CKLBX:	POP	B
	POP	D
	POP	H
	RET
;
BDRCH2:	MVI	A,'*'
	CALL	TYPE
	POP	A
BDRCH1:	MVI	A,'*'
	CALL	TYPE
	POP	A
	RET
;
;.....
;
;
	 IF	PRBRDR
LFMSEP:	DB	CR,LF,'** Library Directory for',' ' OR 80H
	 ENDIF
	 IF	NOT PRBRDR
LFMSEP:	DB	CR,LF,'Library Directory for',' ' OR 80H
	 ENDIF
;
LBRTYP:	DB	'LBR'
	 ENDIF			;LOPT
;
;			end of LOPT routine
;
;***********************************************************************
;
;		TIME:  CALCULATE USER'S ELAPSED TIME
;
;***********************************************************************
;
; Calculate time on system and inform user.  Log him off if =>MAXMIN
; unless STATUS is non-zero.
;
	 IF TIMEON
TIME:	NOP			;the SYSOP must add the code here neces-
	NOP			;  sary to read his clock and store
	NOP			;  binary values of current hours (0-23)
	NOP			;  in CHOUR and minutes (0-59) in CMIN
	LXI	H,LHOUR 	;point to log-on hour
	LDA	CHOUR		;current hour
	CMP	M		;equal?
	JNZ	TIME1		;no
	LDA	LMIN		;log on minutes
	MOV	D,A
	LDA	CMIN		;current minutes
	SUB	D
	STA	TON		;store total time on
	JMP	TIME2
;
TIME1:	LDA	LMIN		;log on min
	MOV	D,A
	MVI	A,03CH		;60 min into A
	SUB	D
	LXI	H,CMIN		;point at current min
	ADD	M		;add current minutes
	STA	TON
;
TIME2:	LDA	STATUS		;look at user status
	ORA	A		;special user?
	JNZ	TIME3		;yes, skip log off check
	XRA	A		;clear status bits
	LDA	TON
	SUI	MAXMIN		;subtract max time allowed
	JC	TIME3		;still time left
	LDA	WHEEL
	CPI	0FFH		;skip timup if wheel byte is set
	RZ
	CALL	TIMEUP		;time is up, inform user
	MVI	A,0CDH		;alter jump vector
	STA	0		;at zero
	JMP	0		;and log him off
;
TIME3:	LXI	H,MSG1+015H	;point at message insert bytes
	LDA	TON		;convert to ASCII
	MVI	B,-1
;
TIME4:	INR	B
	SUI	0AH		;subtract 10
	JNC	TIME4		;until done
	ADI	0AH
	ORI	'0'		;make ASCII
	MOV	M,A
	DCX	H
	MVI	A,'0'
	ADD	B
	MOV	M,A
	IF	QUITE
	RET
	ENDIF
	LXI	D,MSG1
	CALL	PRINT
	RET
;.....
;
MSG1:	DB	CR,LF,'Time on system is 00 minutes',CR,LF,' ' OR 80H
;
TIMEUP:	LXI	D,MSG2
	CALL	PRINT
	RET
MSG2:	DB	CR,LF,CR,LF
	DB	'Your time is up - wait 24 hours '
	DB	'to call back',CR,LF,' 'OR 80H
;
TON:	DB	0			
	 ENDIF			;TIMEON
;
;
;-----------------------------------------------------------------------
;
;			End of program code
;
;-----------------------------------------------------------------------
;
; Initialized data area
;
DRUMSG:	DB	'Drive/Use','r' OR 80H
;
	 IF	PGPAWS
EOSMSG:	DB	'   [more]',CR,'$'
MORERA:	DB	'         ',CR,'$'
	 ENDIF
;
ERRMS1:	DB	' '
ERRMS2:	DB	'Erro','r' OR 80H
;
	 IF	REPERR
ERRTAG:	DB	' -','>' OR 80H
	 ENDIF
;
NOFMS1:	DB	CR,LF,CR,LF
;
	 IF	REVIDEO
REVMS1:	DB	LEADIN,INTOREV
	 ENDIF
;
	 IF	NPL>3
	DB	'     >'
	 ENDIF			;NPL>3
;
	DB	'>> No detectable file(s) on',' ' OR 80H
;
NOFMS2:	DB	': ',' ' OR 80H
;
TOTMS1:	DB	CR,LF
;
	 IF	REVIDEO
REVMS2:	DB	LEADIN,INTOREV
	 ENDIF
;
	DB	'         Drive',' ' OR 80H
;
TOTMS3:	 IF	NPL<3
	DB	'     ',CR,LF
	 ENDIF			;NPL<3
;
	DB	'  space used:',' ' OR 80H
TOTMS4:	DB	'k ',' ' OR 80H
TOTMS5:	DB	':  files:',' ' OR 80H
TOTMS6:	DB	'(' OR 80H
TOTMS7:	DB	'k free)'
;
	 IF	REVIDEO
REVMS3:	DB	LEADIN,OUTAREV
	 ENDIF			;REVIDEO
;
	DB	' ' OR 80H      ;eliminate double LF
;
	 IF	LOPT
;
	 IF	PRBRDR
CONTM:	DB	CR,LF,'*** There are',' '+80H
	 ENDIF
	 IF	NOT PRBRDR
CONTM:	DB	CR,LF,'There are',' '+80H
	 ENDIF
;
MFILES:	DB	' member files in',' '+80H
LIBR:	DB	' library(s',')'+80H
	 ENDIF			;LOPT
;
;
;=======================================================================
;
;		Permanently initialized data area
;
;=======================================================================

	 IF	DOPT
VECTBL:	DW	DSKERR		;BDOS sector error intercept vector
	DW	DSKERR		;BDOS select error intercept vector
	 ENDIF			;DOPT
;
;
;=======================================================================
;
;	template of initialization data for when SD is run or rerun
;
;	the values here are copied by initialization code into
;	the area in which they are actually used by the program
;
;=======================================================================
;
TMPLT0:	EQU	$		;mark start of initialization template
;
; Option field lookup table.  Note that you can force any of these op-
; tions	as a DEFAULT by changing the letter for the option into a zero
; (assuming that its enabling equate is true).	Each option that you
; hard-wire in this manner will no longer be recognized as a command
; line OPTION, and if you redundantly key it in, SD will flag it as un-
; recognized.
;
OTBL0:	EQU	$		;mark start of option table image
;
	 IF	AOPT
AOPFL0:	 IF	NOT WHLA
	DB	'A'		;axl users option flag
	 ENDIF			;NOT WHLA
;
	 IF	WHLA
	DB	'a'
	 ENDIF			;WHLA
	 ENDIF			;AOPT
;
	 IF	COPT
COPFL0:	 IF	NOT WHLC
	DB	'C'		;clear screen option flag
	 ENDIF			;NOT WHLC
;
	 IF	WHLC
	DB	'c'
	 ENDIF			;WHLC
	 ENDIF			;COPT
;
	 IF	DOPT
DOPFL0:	 IF	NOT WHLD
	DB	'D'		;multi-disk option flag
	 ENDIF			;NOT WHLD
;
	 IF	WHLD
	DB	'd'
	 ENDIF			;WHLD
	 ENDIF			;DOPT
;
	 IF	FOPT
FOPFL0:	 IF	NOT WHLF
	DB	'F'		;SD.DIR file output option
	 ENDIF			;NOT WHLF
;
	 IF	WHLF
	DB	'f'
	 ENDIF			;WHLF
	 ENDIF			;FOPT
;
	 IF	LOPT
LOPFL0:	 IF	NOT WHLL
	DB	'L'		;display library members flag
	 ENDIF			;NOT WHLL
;
	 IF	WHLL
	DB	'l'
	 ENDIF			;WHLL
	 ENDIF			;LOPT
;
	 IF	NOPT AND PGPAWS ;no page-pause option flag
NOPFL0:	DB	'N'
	 ENDIF			;NOPT AND PGPAWS
;
	 IF	POPT
POPFL0:	 IF	NOT WHLP
	DB	'P'		;printer output option
	 ENDIF			;NOT WHLP
;
	 IF	WHLP
	DB	'p'
	 ENDIF			;WHLP
	 ENDIF			;POPT
;
	 IF	AUTOR OR ROPT
ROPFL0:	 IF	AUTOR
	DB	0		;if auto-reset 0 is option flag
	 ENDIF			;AUTOR
;
	 IF	NOT AUTOR
	 IF	NOT WHLR
	DB	'R'		;if not auto reset and not wheel restr.
	 ENDIF			;NOT WHLF
;
	 IF	WHLR
	DB	'r'		;if not auto reset and is wheel restr.
	 ENDIF			;WHLF
	 ENDIF			;NOT AUTOR
	 ENDIF			;AUTOR OR ROPT
;
	 IF	SOPT
SOPFL0:	 IF	NOT WHLS
	DB	'S'
	 ENDIF			;NOT WHLS
;
	 IF	WHLS
	DB	's'
	 ENDIF			;WHLS
	 ENDIF			;SOPT
;
	 IF	VOPT		;display version number flag
VOPFL0:	DB	'V'
	 ENDIF			;VOPT
;
OEND0:	EQU	$		;mark end of option table image
;
;
; End of option lookup table

	 IF	FOPT
BUFPN0:	DW	OUTBUF		;ptr to next location in output buffer
BUFCN0:	DB	128		;number of bytes left in output buffer
OUTFC0:	DB	0,'SD      DIR'
	 ENDIF	;FOPT

TMPLT1:	EQU	$		;mark end of initialization data template

; THIS IS THE END OF THE CODE THAT MUST BE STORED ON DISK IN THE COM FILE
;
;=======================================================================
;
;	data area reinitialized by code when SD is run or rerun
;
;=======================================================================

DATA0:	EQU	$		;mark beginning of area to initialize


OTBL:	EQU	$		;mark start of option table
;
	 IF	AOPT
AOPFLG:	DS	1
	 ENDIF			;AOPT
;
	 IF	COPT
COPFLG:	DS	1
	 ENDIF			;COPT
;
	 IF	DOPT
DOPFLG:	DS	1
	 ENDIF			;DOPT
;
	 IF	FOPT
FOPFLG:	DS	1
	 ENDIF			;FOPT
;
	 IF	LOPT
LOPFLG:	DS	1
	 ENDIF			;LOPT
;
	 IF	NOPT AND PGPAWS ;no page-pause option flag
NOPFLG:	DS	1
	 ENDIF			;NOPT AND PGPAWS
;
	 IF	POPT
POPFLG:	DS	1
	 ENDIF			;POPT
;
	 IF	AUTOR OR ROPT
ROPFLG:	DS	1
	ENDIF			;AUTOR OR ROPT
;
	 IF	SOPT
SOPFLG:	DS	1
	 ENDIF			;SOPT
;
	 IF	VOPT		;display version number flag
VOPFLG:	DS	1
	 ENDIF			;VOPT
;
OEND:	EQU	$		;mark end of option table
;
; End of option lookup table

	 IF	FOPT
BUFPNT:	DS	2		;ptr to next location in output buffer
BUFCNT:	DS	1		;number of bytes left in output buffer
OUTFCB:	DS	1 + 8 + 3	;space for user #, filename, and filetype
	 ENDIF			;FOPT

; - - -	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; BEGINNING OF AREA REINITIALIZED TO ZERO EACH TIME SD IS RUN

	 IF	FOPT
	DS	21		;rest of SD.DIR FCB
OPNFLG:	DS	1		;file open flag for all user file output
	 ENDIF			;FOPT
;
AFLAG:	DS	1		;if A option check for prior U option
DFLAG:	DS	1		;if D option check for prior drive spec.
FNDFLG:	DS	1		;flag whether any files matched
;
	 IF	PGPAWS
LINCNT:	DS	1		;count of lines printed on screen
	 ENDIF			;PGPAWS
;
;
	 IF	LOPT
LLENLOC:DS	2		;running total of .LBR length
LMTOTL:	DS	2
LBTOTL:	DS	2
LNCNT:	DS	1
LCOUNT:	DS	2
NEXTL:	DS	2
SLFILE:	DS	2
	 ENDIF			;LOPT
;
	 IF	VCODE
LINES:	DS	1		;number of lines to be printed out.
	 ENDIF			;VCODE
;
	 IF	VOPT
FIRSTT:	DS	1		;first time flag for Version # display
	 ENDIF			;VOPT


DATA1:	EQU	$		;mark end of area to initialize

;
;=======================================================================
;
;		Uninitialized data area
;
;=======================================================================

	 IF	FOPT
OUTBUF:	DS	128		;output file buffer
	 ENDIF			;VOPT
;
BASUSR:	DS	1		;dupe of original dir. user # to search
BLKMAX:	DS	2		;highest block # on drive
BLKMSK:	DS	1		;SEC/BLK - 1
BLKSHF:	DS	1		;# shifts to mult by SEC/BLK
COUNT:	DS	2		;entry count
DIRMAX:	DS	2		;highest file # in directory
FREEBY:	DS	2		;contains number of K left on dir. drive
GAP:	DS	2		;sort routine storage
HITRAP:	DS	1		;highlit trap (previously typed char)
I:	DS	2		;sort routine storage
J:	DS	2		;sort routine storage
JG:	DS	2		;sort routine storage
LZFLG:	DS	1		;0 when printing leading zeros
MAXUSR:	DS	1		;max user # for drive from lookup table
NEWUSR:	DS	1		;contains user # selected by "$U" option
NEXTT:	DS	2		;next table entry
OLDDSK:	DS	1		;holder for currently logged-in drive
OLDUSR:	DS	1		;contains user number upon invocation
SCOUNT:	DS	2		;# to sort
SUPSPC:	DS	1		;leading space flag for decimal routine
TBLOC:	DS	2		;pointer to start of name table
TEMP:	DS	2		;save dir entry
TOTFIL:	DS	2		;total number of files
TOTSIZ:	DS	2		;total size of all files
VERFLG:	DS	1		;Cx/M version number (0=pre-CP/M 2)
;
	 IF	LOPT
LBRFCB:	DS	36
LBBUF:	DS	80H
	 ENDIF			;LOPT
;
	 IF	VCODE
NEWPTR:	DS	2		;pointer to start of second table
XPOINT:	DS	2		;ditto
JUMPER:	DS	2		;amount to increment by in second table
				;to keep vertical file alignment
	 ENDIF			;VCODE
;
	DS	60		;stack area
STACK:	DS	2		;save old stack pointer here
;
ORDER:	EQU	$		;order table starts here
;
;
	END
