
;*******************************************************************
;*                                                                 *
;*                THIS PROGRAM COPIES A FILE FROM                  *
;*             ONE DISC TO ANOTHER USING ONLY ONE DISC DRIVE       *
;*           PROGRAM BY JTS SOFTWARE;  ALL RIGHTS RESERVED         *
;*           DATE:  7/16/81                                        *
;*           EDITION: 1                                            *
;*                                                                 *
;*******************************************************************          
;
BOOT EQU 000H		;SYSTEM REBOOT
BDOS EQU 0005H		;BDOS ENTRY POINT
FCBL EQU 005CH		;FIRST FILE NAME
SFCB EQU FCBL		;SOURCE FCB
FCB2 EQU 006CH		;SECOND FILE NAME
TPA EQU 100H		;BEGINNING OF TPA
SAVE EQU 80H
;
CONSIN EQU 1		;CONSOLE INPUT FUNC#	
PRINTF EQU 9		;PRINT BUFFER FUNC#
OPENF EQU  15		;OPEN FILE FUNC#
CLOSEF EQU 16		;CLOSE FILE FUNC#
DELETEF EQU 19		;DELETE FILE FUNC#
READF EQU 20		;SEQUENTIAL READ
WRITEF EQU 21		;SEQUENTIAL WRITE
MAKEF EQU 22		;MAKE FILE FUNC#
RESETD EQU 13		;RESET DISK SYSTEM
DMA EQU 26		;SET DMA ADDRESS
;
	ORG TPA		;BEGINNING OF TPA
START:	LXI SP,STACK	;LOCAL STACK
;
;	MOVE SECOND FILE NAME TO DFCB
	MVI C,16	;HALF AN FCB
	LXI D,FCB2	;SOURCE OF MOVE
	LXI H,DFCB	;DESTINATION FCB
MFCB:	LDAX D		;SOURCE FCB
	INX D		;READY NEXT
	MOV M,A		;DESTINATION FCB
	INX H		;READY NEXT
	DCR C		;COUNT 16...0
	JNZ MFCB	;LOOP 16 TIMES
;
;	NAME HAS BEEN MOVED, ZERO CR
	XRA A		;A = 00
	STA DFCBCR	;CURRENT REC = 0
;
;	SOURCE AND DESTINATION FCB'S READY
;
	LXI D,SFCB	;SOURCE FILE
	CALL OPEN	;ERROR IF 255
	LXI D,NOFILE	;READY MESSAGE
	INR A		;255 BECOMES 0
	CZ FINIS	;DONE IF NO FILE
;
;	SOURCE FILE OPEN, COPY UNTIL
;	END OF FILE ON SOURCE
	MVI B,01H
COPY:	CALL UPDATE	;UP TO RIGHT DATA BUFFER
	PUSH B
	MVI C,DMA	;SET DMA ADDRESS
	CALL BDOS	;
	LXI D,SFCB	;SOURCE
	CALL READ	;READ NEXT RECORD
	ORA A		;END OF FILE?
	JNZ EOFILE	;JMP TO CLOSE SOURCE FILE
;
;	NOT END OF FILE, CONTINUE TO READ
	POP B
	INR B		;
	JMP COPY	;LOOP UNTIL EOF
;
;	END OF FILE, PREPARE TO COPY
EOFILE:	LXI D,READY	;READY MESSAGE
	MVI C,PRINTF	;
	CALL BDOS	;WRITE MESSAGE
	MVI C,CONSIN	;
	CALL BDOS	;GET OK FROM OPERATOR THAT DEST IS READY
	ANI 0DFH	;AND OFF 5TH BIT FOR SHIFT
	CPI 59H		;IF OP TYPED Y THEN DISC IS READY
	JNZ EOFILE	;JMP BACK IF NOT READY
	LXI D,CRLF	;CARRAGE RET LINE FEED
	MVI C,PRINTF	;PRINT CARRAGE RET LINE
	CALL BDOS	;DO IT
;
;	PREPARE DESTINATION FILE
	MVI C,RESETD	;RESET DISK SYSTEM
	CALL BDOS	;
	LXI D,DFCB	;DESTINATION
	MVI A,00H	;MAKE SURE DEST FCB HAS RIGHT DISC NUM
	STAX D		;STORE ZERO IN FIRST BYTE OF DFCB
	CALL DELETE	;REMOVE IF PRESENT
;
	LXI D,DFCB	;DESTINATION
	CALL MAKE	;CREATE THE FILE
	LXI D,NODIR	;READY MESSAGE
	INR A		;255 BECOMES 0
	CZ FINIS	;DONE IF NO DIR SPACE
;
;	DEST FILE OPEN, 
;	COPY UNTIL END OF FILE ON SOURCE
	POP B		;RETREIVE COUNTR
	MOV A,B
	STA STORE	;STORE COUNTR IN BUFFER
	MVI B,01H	;SET RECORD COUNTR
COPY2:	CALL UPDATE	;UPDATE DBUFF POINTR
	PUSH B
	MVI C,DMA	;UPDATE DMA NUMBER
	CALL BDOS	;
	LXI D,DFCB	;DESTINATION
	CALL WRITE	;WRITE RECORD	 
	LXI D,SPACE	;READY MESSAGE
	ORA A		;00 IF WRITE OK
	JNZ FINIS	;END IF DISC IS FULL
	LDA STORE	;GET COUNTR
	DCR A		;DECREMENT COUNTR
	JZ DONE		;DONE ?
	STA STORE	;STORE  COUNTR IF NOT DONE
	POP B
	INR B		;INCREMENT RECORD COUNTR
	JMP COPY2	;LOOP UNTIL EOF
;	END OF FILE, CLOSE DESTINATION
DONE:	LXI D,DFCB	;DESTINATION
	CALL CLOSE	;255 IF ERROR
	LXI D,WRPROT	;READY MESSAGE
	INR A		;255 BECOMES 00
	CZ FINIS	;SHOULDN'T HAPPEN
;
;COPY COMPLETE, END
	LXI D,NORMAL	;READY MESSAGE
;
FINIS:	;WRITE MESSAGE GIVEN BY DE, REBOOT
	MVI C,PRINTF
	CALL BDOS	;WRITE MASSAGE
	JMP BOOT
;
;	SYSTEM INTERFACE SUBROUTINES
;	(ALL RETURN DIRECTLY FROM BDOS)
;
OPEN:	MVI C,OPENF
	JMP BDOS
;
CLOSE:	MVI C,CLOSEF
	JMP BDOS
;
DELETE:	MVI C,DELETEF
	JMP BDOS
;
READ:	MVI C,READF
	JMP BDOS
;
WRITE:	MVI C,WRITEF
	JMP BDOS
;
MAKE:	MVI C,MAKEF
	JMP BDOS
UPDATE:	LXI D,300H	;BASE ADDRESS FOR DATA BUFFER
	MOV A,B		;MOV COUNTR TO A REG FOR MANIPULATION
LOOP:	PUSH H
	LXI H,80H	;
	DAD D		;ADD BASE FOR ADDRESS UPDATE
	MOV D,H		;RESTORE D REG
	MOV E,L		;RESTORE E REG
	POP H		;RETORE H AND L
	DCR A		;DECR COUNTR
	JNZ LOOP	;JMP BACK IF NOT DONE
	RET
;	CONSOLE MESSAGES
CRLF	DB 0DH,0AH,'$'
READY:	DB 'TYPE "Y" WHEN DESTINATION DISC IS IN DRIVE  $'
NOFILE:	DB 'NO SOURCE FILE$'
SPACE:	DB 'OUT OF DATA SPACE$'
WRPROT:	DB 'WRITE PROTECTED$'
NODIR:	DB 'NO DIRECTORY SPACE$'
NORMAL:	DB 'COPY COMPLETE$'
;
;	DATA AREAS
DFCB:	DS 33		;DESTINATION FCB
DFCBCR:	EQU DFCB+32	;CURRENT RECORD
;
	DS 32		;16 LEVEL STACK
STACK:
STORE: DS 1
	END
	PUSH B
 0180 0E1A      	MVI C,DMA	;UPDATE DMA NUMBER
 0182 CD0500    	CALL BDOS	;
 0185 116A02    	LXI D,DFCB	;DESTINATION
