


				SMALL C PLUS
		      ALPHA OMEGA COMPUTER SYSTEMS, INC.
		     P.O. Box U, Corvallis, Oregon 97330


	 INTRODUCTION

	      Small C Plus is an 8080/Z80 compiler which implements  a
	 usable  subset  of  the  "C" programming language.  The major
	 advantage of this compiler is the fact that the  compiler  is
	 itself  written  in  Small  C Plus, and since compiler source
	 code is provided, may be self-extended.  This compiler  is  a
	 descendent  of  the  Small C compiler written by Ron Cain and
	 published in Dr.  Dobb's in May 1980, (CP/M machine  readable
	 source  distributed  by  The  Code  Works  (tm)).  Although a
	 useful product, the current Small  C  Plus  compiler  is  not
	 suitable  for  production  work.   For  production  usage  an
	 excellent (and complete version 7 UNIX  compatible)  compiler
	 can  be  obtained  from  Whitesmiths,  Ltd.   for around $660
	 (March 1981).

	      The  Small  C  Plus compiler is designed to run on a 64K
	 CP/M (or CDOS) compatible system and produces  8080  assembly
	 language  suitable  for  use  with  Microsoft  M80 compatible
	 assemblers.  Note: for those not yet familiar  with  the  "C"
	 programming  language,  the  definitive  sourcebook is "The C
	 Programming Language", by Brian Kernighan and Dennis Ritchie,
	 available from Prentice-Hall.

	      Some  of  the improvements of Small C Plus over previous
	 versions include:

	 ***  argv/argc   command   line   parameter  parsing  (allows
	      compiles to be done from submit files!).

	 ***  the addition of "for" and "do-while" loops.

	 ***  the "switch-case-default" statement.

	 ***  numerous  bugs have been fixed and some code improvement
	      done.

	      Additionally, the compiler has been modified  to  output
	 assembler pseudo-ops which facilitate separate compilation of
	 function  modules.   To  complement this the "extern" storage
	 class  specifier  was  implemented  to  allow  external  data
	 definitions.

	 CP/M is a trademark of Digital Research, Inc.
	 UNIX is a trademark of Bell Laboratories.




	 INSTALLATION

	      1.  Backup the distribution media, make two copies even!

	      2.   Mail a self-addressed, stamped, legal size envelope
	 to us at the address listed at the beginning of this  manual.
	 This  will  enable  you  to  receive periodic updates and bug
	 fixes (as long as you maintain a current  envelope  with  us,
	 you will receive the latest changes).

	      3.   Create  a  "C system" disk for use with the Small C
	 Plus compiler, and  include  the  following  files  from  the
	 distribution diskette:

	 SCP.DOC	The Small C Plus documentation (text file).

	 CC1.COM	The compiler itself (binary).

	 C.SUB (C.CMD)	The  compile/assemble/link  script  for   CP/M
			(CDOS).

	 HEADER.C	A   "C"  "include" file  that  contains  macro
			definitions of general  use.   Nothing  sacred
			about   the   contents,   just   some   useful
			"#define"'s.

	 CDISK1.REL	The  relocatable  form  of  the  CP/M   (CDOS)
			interface   routines   (part  of  the  runtime
			routines).

	 CMATH1.REL	The relocatable form of  the  math  and  logic
			routines  used  by  the  Small C Plus compiler
			(the rest of the runtime stuff).

	 TIC.C		A sample C program that plays 3D tic-tac-toe.

	      If  you  have difficulty copying these files, verify the
	 operation of your disk drives, improper  head  alignment  can
	 make copying impossible.

	      4.   Add  a  copy  of  M80  and L80 to the "system" disk
	 created in step 2, also include any other utilities you  find
	 useful, like a debugger!

	      5.    Insert   the   "system"   disk   in  drive  A  and
	 compile/assemble/link  the  sample  program  by  typing   the
	 following command line:

				"SUBMIT C TIC"
			    (or "@ C TIC for CDOS)





	      This  should  go  through   a   series   of   operations
	 culminating  in  the  production of a "TIC.COM" binary output
	 file.  At this point, running the "TIC" file should start the
	 game.  If something doesn't work, first check to be sure that
	 you have the correct files on disk A (see  #2  and  #3),  and
	 that   all   the   files   were  copied  correctly  from  the
	 distribution diskette.  If the problem  persists,  check  the
	 operation   of  the  hardware  to  verify  correct  operation
	 (particularly the memory).  If you  have  access  to  another
	 working system you might try bringing Small C Plus up on that
	 to locate the problem.  If all else fails you can try sending
	 the distribution diskette back to us, and we will swap it for
	 another,  but  almost  all  "media"  problems  end  up  being
	 something else instead.

	      6.  If you  plan  on  doing  compiler  development,  the
	 following  files on the distribution disk will be of interest
	 to you:

	 CC1.C		The  compiler  itself  (source).   Note:   The
			compiler  is written in Small C Plus, but does
			not take advantage of the new features  ("for"
			loops,  "switch"'s,  etc.),  and  thus  can be
			compiled by an existing Small C compiler under
			a different operating system.  This allows you
			to gain the new features without going through
			the  bootstrap  process  (assuming  equivalent
			system interface functions).

	 CDISK1.MAC	The M80 source for the CP/M  (CDOS)  interface
			routines.

	 CMATH1.MAC	The  M80  source  for  the  runtime math/logic
			functions.

	      7.   If  you  discover  a  bug,  or   can   suggest   an
	 improvement,  or  even  want  to  contribute  a  program  for
	 distribution, let us know.  Good Luck.



	 COMPILER OPERATION

	      The general compiler invocation looks like:

	 CC1 (<output filename>|<switch>) [<input filename>|<switch>]+

	      The  input  and output filenames are CP/M filenames with
	 extensions.  The <switch> consists of a "-" followed by 1  or
	 more "switch" letters.  Currently supported "switch"'s are:

		"c"	causes  the C source code to be interleaved as
			comments in the assembly language output.

		"e"	causes the compiler  to  stop  every  time  it
			encounters an error.  When the compiler stops,
			it  asks the user to specify what it should do
			from now on by prompting: "Continue (Y,n,g)?".
			Answering Yes ("Y"),  tells  the  compiler  to
			resume  compiling  your  program.  A No ("N"),
			forces  the  compiler  to  abort  and   return
			control  to  the monitor.  Go ("G"), indicates
			that you want the compilation to continue, but
			you do not want the compiler to  stop  on  any
			future  errors (has the effect of removing the
			"e" switch).

		"o"	prevents  the  creation  of an output file and
			directs the compiler output  to  the  console.
			When   using   this   option,   the   compiler
			interprets all filenames on the  command  line
			as input files.

	 Some sample invocations:

		CC1 ZIP.MAC ZIP.C -E

			Compiles ZIP.C and puts the output on ZIP.MAC,
			stops if any errors are detected.

		CC1 FOO.MAC F1.C F2.C -ce

			Compiles  first  F1.C  and then F2.C, puts the
			output on FOO.MAC, interleaves the C  text  as
			comments in the output and stops if any errors
			are detected.

		CC1 -o -c FOOBAR.C

			Compile FOOBAR.C, put the output on the system
			console, and interleave the C text as comments
			in the output.

	      Compilations  may  be  aborted  while underway by typing
	 CNTL-Z,  which  closes  files  and  returns  control  to  the
	 monitor.   Typing  a CNTL-C causes an immediate return to the
	 monitor and does not close files,  etc.   When  an  error  is
	 reported,  the  compiler  lists  the  line number in which it
	 occurred, as well as the function the compiler was working on
	 and the relative offset within that function.





	 SEPARATE FUNCTION COMPILATION

	      Small C Plus allows the  user  to  compile  programs  in
	 several   pieces   and   let  L80  put  them  back  together.
	 Specifically, all  function  definitions  in  any  chunk  are
	 declared  as  "entry"  points to M80, all function references
	 that  are  not  defined  in  a  given  chunk   are   declared
	 "external".  All global data definitions within a given chunk
	 are declared "entry"s.   The "extern" storage class specifier
	 allows  the  user  to  access  global data defined in another
	 piece.  It is useful to use the separate compilation  feature
	 to  create "libraries" of often used functions which need not
	 be recompiled for every new program, (writing an improved I/O
	 function package would be a good use for this).

	 REENTRANCY/ROMABILITY

	      The code generated by Small  C  Plus  is  reentrant  and
	 supports  recursive  programming  techniques.  Since the data
	 areas used by a Small C Plus program are declared to be "data
	 segments"  to  M80,  The  program  and  data  areas  may   be
	 separately  located  at  linking time.  This allows a user to
	 locate  his  program  and  data  in  separate  ROM  and   RAM
	 locations.

	 CP/M I/O FUNCTIONS

	 exit();
	
			Returns to the monitor immediately.

	 cpm(bc,de);
		int bc,de;

			Performs a call to CP/M with the usual calling
			conventions  as  far  as  the  "bc"  and  "de"
			registers.   Returns  accumulator  "a",   sign
			extended.

	 fopen(filename,mode);
		char *filename,*mode;

			Opens a CP/M file pointed to by "filename" for
			reading  if "mode" points to a "r" string.  If
			"mode" points to a "w", the file is opened for
			reading and writing.  Returns a pointer to the
			appropriate file descriptor (used when closing
			and doing  I/O  to  the  file).   If  a  0  is
			returned, the open failed.

		Note:	No  more  than  four  files may be open at one
			time.  The current buffer length for files  is
			1024   bytes,  which  is  a  tradeoff  between
			storage use and speed.  The  number  of  files
			allowed   open  could  increase  depending  on
			available system  memory,  program  size,  and
			desired buffer length.





	 fclose(fd);
		int *fd;

			Closes a file previously  opened  with  fopen.
			The   "fd"  is  the  file  descriptor  pointer
			returned by the fopen.  A 0 is returned if the
			close fails.

	 getc(fd);
		int *fd;

			Gets  a  character from a file that was opened
			using fopen.   "fd"  is  the  file  descriptor
			pointer   from   the   fopen.   The  character
			following a <CR> is thrown  away,  (presumably
			being a <LF>).  Returns -1 on error and EOF.

		Note:	fopen,fclose,getc,  and  putc  should  only be
			used with ASCII files, (not smart  enough  yet
			to handle binary).

	 putc(a,fd);
		char a;
		int *fd;

			Write  the  character "a" to a file previously
			opened with fopen.  A <LF> is  appended  after
			every <CR> written out.  Returns the character
			passed to it or -1 on error.

	 gets(buf)
		char buf[81];

			Reads a "cooked"  input  line  from  the  CP/M
			system  console.   "buf"  is  a pointer to the
			input text buffer.  The input  will  be  taken
			from  the console until the user types a <CR>,
			at which time the string is returned with a  0
			byte  termination.   Returns  a pointer to the
			buffer.

	 puts(buf)
		char *buf;

			Outputs a 0 byte terminated string, pointed to
			by "buf", onto the system console.  Returns  a
			pointer to the start of the string.

	 getchar();

			Returns (and echos), a character read from the
			system  console. Returns a -1 on EOF.  Echos a
			<CR><LF> when a <CR> is typed.





	 putchar(a);
		char a;

			Outputs  the  character  "a"  on  the   system
			console.    Expands  <CR>'s  into  <CR><LF>'s.
			Returns "a".


	 SMALL C PLUS SYNTAX

	      The  syntax/semantics  are  basically a proper subset of
	 version 7 UNIX C, with  the  exception  of  the  #asm-#endasm
	 statement described below:

		1. Preprocessor commands:
			A. "#include <filename>" (cannot be nested)
			B. "#define <name> <string>" (no parameters)

		2. Global data types:
			A. 8 bit characters "char"
			B. 16 bit integers "int"
			C. pointers to A or B
			D. 1D arrays of A or B
			E. externally defined A, B, C, or D

		3. Functions
			A. functions return 16 bit integers only
			B. function   calls   consist   of  a  primary
			   expression followed by an open parentheses,
			   so non-standard  function  calls  could  be
			   used.

		4. Local data types:
			A. 8 bit characters
			B. 16 bit integers
			C. pointers to A or B
			D. 1D arrays of A or B

		5. Statements
			A. if-else
			B. while
			C. do-while
			D. for
			E. switch-case-default
			F. break
			G. continue
			H. return and return <expression>
			I. ; (null statement)
			J. { ... } (compound statement)
			K. #asm   <assembly   language  code>  #endasm
			   (Doesn't need a final semicolon  after  the
			   #endasm.   All  code  between  the #asm and
			   #endasm  is  passed  on  to  the  assembler
			   without   interference.    Note:  all  text
			   following the #asm or #endasm on  the  same
			   line is thrown away.)





		6. Expressions
			A. primaries
				a. arrays
				b. decimal constants
				c. function calls
				d. local variable references
				e. global variable references
				f. double-quoted strings
				g. single-quoted character/integer
				   constants
			B. binary operators
				a. add "+"
				b. subtract "-"
				c. multiply "*"
				d. divide "/"
				e. remainder "%"
				f. equality "=="
				g. not equal "!="
				h. less than "<"
				i. greater than ">"
				j. less than or equal "<="
				k. greater than or equal ">="
				l. arithmetic left shift "<<"
				m. arithmetic right shift ">>"
				n. bitwise and "&"
				o. bitwise or "|"
				p. bitwise xor "^"
				q. assignment "="
			C. unary operators
				a. indirection "*"
				b. location of "&"
				c. pre/post increment "++"
				d. pre/post decrement "--"
				e. unary minus "-"





	 MISCELLANEOUS NOTES

	      Since  "argv"  is a pointer to an array of pointers, and
	 Small C Plus only allows pointers to integers and characters,
	 you have to do the indirection in two steps (no  pointers  to
	 pointers).   Since  M80  uses  the  8080  register  names  as
	 reserved words, do not use an 8080 mnemonic for the name of a
	 piece of global data. Because  the  compiler  sometimes  gets
	 confused  when it detects an error, you may get several error
	 messages for the same error.

	 OTHER THOUGHTS

	      There  is  plenty  of  room for improvement with Small C
	 Plus, some suggestions are:

	      Redesign the symbol table format to allow structures and
	 unions to be implemented (also add structure access, "."   as
	 a binary operator).
	      Change access to the symbol table to some form of simple
	 hashed scheme.  This would speed the compiler up a bunch.
	      Implement the logical binary operators.
