       TITLE CLOCK W/YEAR,MONTH,DAY,HOUR,MIN,SEC
*********************************************************
*                                                       *
*    CLOCK FOR BIGBOARD WITH PFM-80 VERSION 3.3         *
*                                                       *
*    2/DEC/80            RUSSELL SMITH                  *
*                                                       *
*    MODIFIED BY DON RETZLAFF - JANUARY 23, 1980        *
*                                                       *
*    TO INCLUDE SUPPORT OF DAY, MONTH, AND YEAR         *
*                                                       *
*********************************************************
*
       PSECT ABS
       ORG  0F900H       ;**TEMP**
*
**  ROUTINE TO PUT CLOCK ROUTINE IN PROPER PLACE
**  AND TO INITALIZE VECTORS
*
MOVEUP LD   HL,CLOCK-$+100H
       LD   DE,CLOCK
       LD   BC,LENGTH
       LDIR
       DI
       LD   HL,(TIKVEC)
       LD   (VECSAV),HL
       LD   HL,CLOCK
       LD   (TIKVEC),HL
       EI
       RET
*
**  EQUATED SYMBOLS
*
YEAR   EQU  0FF5FH
MONTH  EQU  0FF60H
DAY    EQU  0FF61H
HRS    EQU  0FF62H
MINS   EQU  0FF63H
SECS   EQU  0FF64H
BASE   EQU  0FF77H
TIKVEC EQU  0FF57H
CRTMEM EQU  3000H
*
**  CLOCK DISPLAY ROUTINE FOR INTERRUPT DRIVEN 
**  TIME-OF-DAY CLOCK UTILITY
*
CLOCK  LD   HL,SECS
       CALL INCTIM       ;INCREMENT TIME IN BINARY
       LD   A,(BASE)     ;GET LINE # OF BOTTOM OF SCREEN
       INC  A            ;ADD 1 TO WRAP ARND TO TOP LINE
       CP   24
       JR   C,CLOCK2-$   ;WATCH FOR MODULO 24
       XOR  A
CLOCK2 SRL  A            ;TRNSFRM LINE # INTO 16 BIT ADRS
       LD   L,70*2       ; WITH COL # COMPONENT = 70
       RR   L
       LD   DE,CRTMEM    ;FIND PLACE IN SCREEN MEMORY
       OR   D
       LD   H,A
       IN   A,(1CH)
       SET  7,A
       OUT  (1CH),A
       LD   DE,HRS       ;POINT DE TO CLOCK HOURS
       LD   (HL),' '
       CALL PUTDEC       ;DISPLAY HOURS
       LD   (HL),':'
       INC  HL
       CALL PUTDEC       ;DISPLAY MINUTES
       LD   (HL),':'
       INC  HL
       CALL PUTDEC       ;DISPLAY SECONDS
       LD   (HL),' '
       IN   A,(1CH),A
       RES  7,A
       OUT  (1CH),A
       LD   HL,(VECSAV)
       JP   (HL)         ;RETURN
*
VECSAV DEFW 0
*
**  PUT HRS, MINS, OR SEC ON SCREEN
*
PUTHRS LD   A,(DE)
       CP   0            ;CHECK IF 0
       JP   NZ,PUTD0     ;NO - OUTPUT IT
       LD   A,24         ;YES - MAKE IT 24
       JR   PUTD0-$
PUTDEC LD   A,(DE)
PUTD0  INC  DE
       LD   C,0
PUTD1  SUB  10
       JR   C,PUTD2-$
       INC  C
       JR   PUTD1-$
PUTD2  ADD  A,10
       PUSH AF
       LD   A,C
       CALL PUTDIG       ;DISPLAY 10'S DIGIT OF TIME
       POP  AF
PUTDIG OR   '0'          ;MAKE MSB OF ACC INTO ASCII
       LD   (HL),A
       INC  HL           ;STORE CHAR AND BUMP POINTER
       RET
*
**  INCREMENT TIME ROUTINE
*
INCTIM INC  (HL)
       LD   A,(HL)       ;BUMP CLOCK SECS AND CHECK FOR
       CP   60           ; ROLL-OVER AT END OF MUNUTE
       RET  C            ;EXIT IF NO CARRY TO MINUTES
       LD   (HL),0       ;ELSE RESET SECONDS TO ZERO
       DEC  HL           ; AND POINT NEXT TO MINUTES
       INC  (HL)
       LD   A,(HL)       ;BUMP CLOCK MINS AND CHECK FOR
       CP   60           ; ROLL OVER AT END OF HOUR
       RET  C            ;EXIT IF NO CARRY INTO HOURS
       LD   (HL),0       ;ELSE RESET MINUTES TO ZERO
       DEC  HL           ; AND POINT NEXT TO HOURS
       INC  (HL)
       LD   A,(HL)       ;BUMP HOURS AND CHECK FOR
       CP   24           ; ROLL OVER AFTER 24 HOURS
       RET  C            ;EXIT IF NO ROLL OVER
       LD   (HL),0       ;ELSE RESET HOURS TO 0 AND
       DEC  HL           ; AND POINT NEXT TO DAYS
       INC  (HL)         ;BUMP DAYS
       LD   IX,DAYTAB    ;GET ADRS OF DAY TABLE
       LD   A,(MONTH)    ;GET MONTH
       DEC  A            ;DECREMENT DISPLACEMENT
       LD   (MNUM),A     ;PUT MONTH # IN INSTRUCTION
       LD   A,(DAY)      ;GET DAY #
       CP   (IX+0)       ;COMPARE DAY TO TABLE
MNUM   EQU  $-1
       RET  M            ;RETURN IF NO ROLL OVER REQUIRED
       LD   (HL),1       ;SET DAY TO 1
       DEC  HL           ; AND POINT NEXT TO MONTH
       INC  (HL)         ;BUMP MONTH
       LD   A,(HL)       ;GET MONTH
       CP   13           ;CHECK IF >12
       RET  C            ;RETURN IF NO CARRY
       LD   (HL),1       ;RESET MONTH TO 1
       DEC  HL           ;POINT TO YEAR
       INC  (HL)         ;INCREMENT YEAR
       RET               ;RETURN
*
**  TABLE OF #DAYS+1 PER MONTH
*
DAYTAB DEFB 32           ;JAN
       DEFB 29           ;FEB
       DEFB 32           ;MAR
       DEFB 31           ;APR
       DEFB 32           ;MAY
       DEFB 31           ;JUN
       DEFB 32           ;JUL
       DEFB 32           ;AUG
       DEFB 31           ;SEP
       DEFB 32           ;OCT
       DEFB 31           ;NOV
       DEFB 32           ;DEC
*
LENGTH EQU  $-CLOCK
*
       END
