	title	'FOXYCALC directory module, version 1.0'
;
	page	58
;
; 
;	bdos entry point and function codes
;
bdos		equ	0005h
;
wccfc		equ	02		;write console character
wcbfc		equ	09		;write console buffer
;
sfofc		equ	17		;search for first occurance
snofc		equ	18		;search for next occurance
;
sdafc		equ	26		;set dma address
;
gtaloc		equ	27		;get allocation vector
getdpb		equ	31		;get disc parameter block addr.
;
;	file control block definitions
;
tfcb		equ	005Ch		;default file control block
;
fcbdn		equ	00		;drive name
fcbfn		equ	01		;file name
fcbft		equ	09		;file type
fcbex		equ	12		;extent number
fcbrc		equ	15		;record count
fcbdm		equ	16		;disk map
fcbcr		equ	32		;current record
fcbrr		equ	33		;random record number
;
;	misc. definitions
;
dbuff		equ	0080h		;default dma buffer
fnsize		equ	11		;size of filename in table
fnpl		equ	5		;filenames per line
scrful		equ	20		;lines before pause, format 1
;
;	aseg
;
		org	100h
;
;
fox$dir:	lxi	d,dbuff
		mvi	c,26
		call	bdos
;
;	if no filename, default to *.*
;
		xra	a
		sta	tfcb
		lxi	h,tfcb+fcbfn	;default to all ?'s
		mvi	a,'?'
		mvi	b,11		; # of chars in fn + ft
;
dir0:		mov	m,a
		inx	h
		dcr	b
		jnz	dir0
;
;	create sorted table of all active directory entries
;	which satisy user's afn from command line
;	and print it
;
		mvi	a,'?'		;force ex field to ?
		sta	tfcb+fcbex
		mvi	c,getdpb
		call	bdos
		inx	h
		inx	h
		inx	h
		inx	h
		mov	a,m
		sta	exm
		call	cr$fn$tbl	;create file name table
;
		call	sfnt		;sort file name table
;
		call	prn$dir		;print file names
;
;		ret
;
;
;	cr$fn$tbl - create file name table from afn in tfcb
;
cr$fn$tbl:	lxi	h,fnt		;reset fnt pointer
		shld	fntp
		xra	a
		sta	fntc		;clear filename count
		lxi	d,tfcb		;search for first occurance
		call	srchf
		cpi	255		;jump if found
		rz			;exit
;
cr$fn$tbl1:	ani	3		;index into dma buffer
		mov	l,a
		mvi	h,0
		dad	h
		dad	h
		dad	h
		dad	h
		dad	h
		lxi	d,dbuff
		dad	d
		push	h
		lxi	d,12
		dad	d
		lda	exm
		cmp	m
		pop	h
		jc	cr$fn$tbl2
;
		xchg			;copy filename into fnt
		lhld	fntp
		inx	d
		xchg
		mvi	b,fnsize
;
mvx:		mov	a,m
		ani	7fh
		inx	h
		stax	d
		inx	d
		dcr	b
		jnz	mvx
;
		xchg
		shld	fntp		;update fnt pointer
		lxi	h,fntc		;increment count
		inr	m
		mov	a,m
		cpi	100
		rz
;
cr$fn$tbl2:	lxi	d,tfcb		;search for next occurance
		call	srchn
		cpi	255		;loop if found
		jnz	cr$fn$tbl1
;
		lxi	d,fnsize*100
		lxi	h,fnt
		dad	d
		xchg
		lhld	fntp
;
cr$fn$tbl3:	mov	a,d
		cmp	h
		jnz	cr$fn$tbl4
;
		mov	a,e
		cmp	l
		rz
;
cr$fn$tbl4:	mvi	m,00
		inx	h
		jmp	cr$fn$tbl3
;
; 
;	sfnt - sort file name table into ascending order
;
sfnt:		lxi	d,fnt		;de = fwa of fnt
		xra	a		;i = 0
		sta	iii
;
sfnt1:		lxi	h,fnsize	;hl = de + fnsize
		dad	d
		lda	iii		;j = i + 1
		inr	a
		sta	jjj
;
sfnt2:		push	h		;if entry(i) < entry(j), goto 6
		push	d
		mvi	b,fnsize
;
sfnt3:		ldax	d
		cmp	m
		jnz	sfnt4
;
		inx	d
		inx	h
		dcr	b
		jnz	sfnt3
;
		stc			;set carry flag
;
sfnt4:		pop	d
		pop	h
		jc	sfnt6
;
		push	h		;swap entry(i), entry(j)
		push	d
		mvi	b,fnsize
;
sfnt5:		ldax	d
		mov	c,a
		mov	a,m
		stax	d
		mov	m,c
		inx	d
		inx	h
		dcr	b
		jnz	sfnt5
;
		pop	d
		pop	h
;
sfnt6:		lxi	b,fnsize	;hl = hl + fnsize
		dad	b
		lda	jjj		;j = j + 1
		inr	a
		sta	jjj
		push	h
		lxi	h,fntc		;point to file count
		cmp	m		;if j < file count goto 2
		pop	h
		jc	sfnt2
;
		xchg			;de = de + fnsize
		lxi	b,fnsize
		dad	b
		xchg
		lda	iii		;i = i + 1
		inr	a
		sta	iii
		push	h
		lxi	h,fntc		;point to file count
		dcr	m
		cmp	m		;if i < file count-1 goto 1
		push	psw
		inr	m
		pop	psw
		pop	h
		jc	sfnt1
;
		ret			;done, exit
;
;
prn$dir:	lxi	h,fnt
		mvi	a,scrful
		sta	lines
;
prn$dir$1:	push	h
		call	disp$ln
		pop	h
		lxi	d,fnsize
		dad	d
		lda	lines
		dcr	a
		rz
;
		sta	lines
		jmp	prn$dir$1
;
;
disp$ln:	xra	a
		sta	lcount
;
disp$ln$2:	mov	a,m
		ora	a
		jz	wr$eol
;
		mvi	b,8
;
disp$ln$1:	mov	e,m
		call	char$out
		inx	h
		dcr	b
		jnz	disp$ln$1
;
		mvi	e,'.'
		call	char$out
		mvi	b,3
;
disp$ln$3:	mov	e,m
		call	char$out
		inx	h
		dcr	b
		jnz	disp$ln$3
;
		lxi	d,fnsize*(scrful-1)
		dad	d
		lda	lcount
		cpi	fnpl-1
		jz	wr$eol
;
		inr	a
		sta	lcount
		call	wr$blks
		jmp	disp$ln$2
;
;
wr$blks:	push	h
		lxi	d,blanks
;
wr$str:		mvi	c,wcbfc
		call	bdos
		pop	h
		ret
;
;
wr$eol:		push	h
		lxi	d,crlf
		jmp	wr$str
;
;
;	srchf - search for first occurance of afn
;
;	entry:	DE	fwa of FCB for file
;
;	exit:	A	FF if not found, else
;			fcb image number (0-3) in dma buffer
;
srchf:		push	h
		push	d
		push	b
		mvi	c,sfofc
;
srchf$1:	call	bdos
		pop	b
		pop	d
		pop	h
		ret
;
;
;	srchn - search for next occurance of afn
;
;	entry:	DE	fwa of FCB for file
;
;	exit:	A	FF if no further files, else
;			fcb image number (0-3) in dma buffer
;
srchn:		push	h
		push	d
		push	b
		mvi	c,snofc
		jmp	srchf$1
;
;
char$out:	push	b
		push	h
		mvi	c,6
		call	bdos
;
		pop	h
		pop	b
		ret
;
;
blanks		db	'    $'
crlf		db	0dh,0ah,'$'
;
;	dseg
;
iii		db	00h		;outer loop variable in sfnt
jjj		db	00h		;inner loop variable in sfnt
 
lcount		db	00h		;count of filenames on line
lines		db	00h		;count of lines per screen
;
fntp		dw	0000h		;file name table pointer
fntc		db	00h		;file name table count
exm		db	00h		;extent mask
;
pntr1		dw	0000h
pntr2		dw	0000h
;
cntr1		db	00h
;
fnt		ds	fnsize*100	;file name table
;
;
		end		;of directory overlay
