;BSTAM PATCH AREA FOR INTERTEC SUPERBRAIN
;
;USES MAIN SERIAL PORT AND TRANSMITS AT 9600BAUD
;
;NOTE THAT SUPERBRAIN BAUD RATE RATHER INNACURATE SO ERROR MESSAGES
;FOR OVERRUN AND FRAMING MAY BE REPORTED. IN ANY EVENT 9600 WITH
;REPORTED ERRORS HAS BETTER THROUGHPUT THAN 1200 BAUD WITH FEWER
;ERROR MESSAGES. NOTE REFERENCE TO ERRORS RELATES TO INFORMATION DISPLAYED
;ON SENDING OR RECEIVING CONSOLES. FILE TRANSFERS WILL BE CORRECT
;AND ERROR FREE DUE TO RE-TRY STRUCTURE OF BSTAM
;
;NOTE THAT NO HARDWARE INFO FROM INTERTEC AVAILABLE AT THIS DATE
;SE ROUTINES WERE INFERED FROM THE INTERTEC FIRMWARE
;WHERE A 68H DIVISOR WAS USED FOR 1200 BAUD.
;


	ORG	00103H
;
	JMP	INITIU
	JMP	INSPRU
	JMP	ERRSTU
	JMP	INPRTU
	JMP	OUTPRU
;
INITIU:	CALL	SIGNON
	MVI	A,080H		;DIVISOR LATCH ACCESS BIT TO LINE CONTROL
				;REGISTER
	OUT	043H
	MVI	A,00DH		;DIVISOR LS (LEAST SIGNIFICANT)
	OUT	040H
	MVI	A,000H		;DIVISOR MS (MOST SIGNIFICANT)
	OUT	041H
	MVI	A,001H		;SET DTR
	OUT	044H
	MVI	A,003H		;8 BIT WORD
	OUT	043H
	MVI	A,000H		;DISABLE INTERUPTS
	OUT	041H
	RET
;
INSPRU:	PUSH	B
	MVI	B,000H
	IN	045H
	MOV	C,A
	ANI	020H		;TBE
	JZ	NO$TBE
	MVI	B,001H
NO$TBE:	MOV	A,C
	ANI	001H		;RDA
	JZ	NO$RDA
	MOV	A,B
	ORI	002H
	MOV	B,A
NO$RDA:	MOV	A,B
	ORI	004H		;SET OTHER TX FLAG
	POP	B
	RET
;
ERRSTU:				;NO ERROR INITIALIZATION NEEDED
	RET
;
INPRTU:	IN	040H
	RET
;
OUTPRU:	OUT	040H
	RET
;
MESSAGE:
	DB	CR,LF,CR,LF,'VERSION FOR SUPERBRAIN 9/16/79'
	DB	CR,LF,'$'
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSAGE
	MVI	C,009H		;SEND MESSAGE TO CONSOLE
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
;
BDOS	EQU	00005H
CR	EQU	0DH
LF	EQU	0AH
;
;
;
	END	100H
