;VERSION 8250/4.2/4300 AUGUST 20, 1979
;
;If you have a Magnolia CP/M, change
;the origin in the next line to 103H.
;
BEGIN	ORG	4303H
INITIL  JMP     INITIU          ;UART/USART INITIALATION ENTRY POINT
INSPORT JMP     INSPRU          ;STATUS PORT READ ENTRY POINT
ERRSET  JMP     ERRSTU          ;UART/USART ERROR RESET ENTRY POINT
INPORT  JMP     INPRTU          ;READ DATA PORT ENTRY POINT
OUTPORT JMP     OUTPRU          ;WRITE DATA PORT ENTRY POINT
;
H84TTY  EQU     0D8H            ;This corresponds with the lowest
;                               ;UART/connector on the H89 serial
;                               ;port circuit card.
;
TPS     EQU     H84TTY+5        ;STATUS PORT
TP      EQU     H84TTY          ;DATA PORT
INITIU  EQU     $
;
	CALL	SIGNON
;
;BAUD RATE DIVISORS FOR 8250'S
B300    EQU     384
B600    EQU     192
B1200   EQU     96
B2400   EQU     48
B4800   EQU     24
B9600   EQU     12
;
;ROUTINE TO INITIALIZE ONE PORT OF AN 8250 ON H8-4 CARD
;REG HL HAS BAUD RATE WORD, REG B HAS BASE PORT
;
        PUSH H ! PUSH D ! PUSH B
        LXI     H,B9600 ;GET BAUD RATE
        MVI     B,H84TTY        ;PORT
IN8250: XCHG
        LXI     H,OUTH84+1      ;PT TO PORT IN OUT INSTR
        MVI     A,3     ;BAUD RATE ACCESS BIT
                        ;ON BASE+3 PORT
        ADD     B       ;GET ACTUAL PORT
        MOV     C,A     ;SAVE IN C FOR LATER
        MOV     M,A     ;AND MODIFY OUTPUT INSTR
        MVI     A,83H   ;SET DIVISOR LATCH ACCESS BIT
        CALL    OUTH84  ;TO A "1"
        INR     M       ;PT TO MODEM CONTROL REG
        MVI     A,3     ;AND SET DATA SET RDY
                        ;AND CLR TO SEND HIGH
        CALL    OUTH84  ;FOR DIABLO/OTHER TERMS
                        ;WHICH REQUIRE THEM
        MOV     M,B     ;SET PORT TO LEAST SIG BYTE
        MOV     A,E     ;
        CALL    OUTH84
        MOV     A,D     ;NOW DO MOST SIG BIT
        INR     M       ;ONE NEXT PORT
        CALL    OUTH84  ;
        MOV     M,C     ;RESET PORT TO DIVISOR LATCH
        MVI     A,03H   ;NO PARITY 8 BITS PLUS ONE STOP
                        ;WORD LEN (8 BITS), DIV LATCH
                        ;BIT 0,1=3      SETS 8 BIT WORD
                        ;BIT 2=0        SETS 1 STOP BIT
                        ;BIT 3=0        DISABLES PARITY
        CALL    OUTH84
        DCR     M       ;NOW SET PORT
        DCR     M       ;TO INT ENABLE REG
        XRA     A       ;TURN OFF INTS
        CALL    OUTH84  ;DISABLE INTS
;
;THE FOLLOWING CODE USES THE BAUD RATE DIVISOR TO
;DO A TWO CHARACTER TIMES DELAY BEFORE RETURNING
;
        XCHG            ;PUT BAUD RATE DIVISOR IN HL
        DAD     H       ;MULT BY 16 TO GET DELAY
        DAD     H
        DAD     H
        DAD     H
LOOP1:  DCX     H
        MOV     A,L
        ORA     H
        JNZ     LOOP1
        POP B ! POP D ! POP H
        RET
OUTH84: OUT     0       ;PORT NR MODIFIED BY ABOVE CODE
        RET
;       STATUS INPUT ROUTINE
INSPRU  EQU     $
        IN      TPS     ;RDA=BIT 0, TBE=BIT 5
        ANI     21H
        PUSH    B
        RLC             ;SHIFT RDA TO BIT 1
        MOV     B,A     ;AND SAVE IN B
        RLC
        RLC             ;TBE TO BIT 0
        ORA     B       ;OR IN RDA
        POP     B       ;RESTORE
        ANI     3       ;MASK UNWANTED BITS
        ORI     4       ;MUST BE SET
        RET
ERRSTU  EQU     $
        RET             ;ONLY
INPRTU  EQU     $
        IN      TP      ;GET DATA FROM PORT
        RET             ;RETURN TO BSTAM
OUTPRU  EQU     $
        OUT     TP      ;SEND DATA TO REMOTE CPU
        RET             ;RETURN TO BSTAM
;
;
MESSGE:	DB	0DH,0AH,0DH,0AH
	DB	'VERSION 8250/4.2/4300 SEPTEMBER 10,1980',0DH,0AH
	DB	'8250 ON PORTS D8/DD USING NO PARITY',0DH,0AH,'$'
;                           DATA/STATUS 
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	4205H		;ANOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
