1;*************************************************************************
;
;	BSTAM RECV PROGRAM
;	COPYRIGHT (C) 1979 BY BYROM SOFTWARE
;	ALL RIGHTS RESERVED
;
;************************************************************************
;
;	CP/M ORG 100 VERSION
;
;*********************************
;
BDOS	EQU	0005H
DEFFCB	EQU	005CH
DEFBFR	EQU	0080H

	ORG	0100H
;
;	JUMP VECTORS, PROGRAM COMMUNICATION TO THE OUTSIDE WORLD
;
	JMP	START
INITIL:	JMP	INITIU		;USART INITIALIZATION ENTRY POINT
INSPORT:
	JMP	INSPRU		;READ STATUS PORT ENTRY
ERRSET:	JMP	ERRSTU		;ERROR RESET ENTRY
INPORT:	JMP	INPRTU		;READ DATA PORT ENTRY
OUTPORT:
	JMP	OUTPRU		;WRITE DATA PORT ENTRY

;
;	INIT USART SUBR
;
INITIU:	CALL	PRTSGN		;OUTPUT SIGN-ON

	MVI	A,80H		;INIT USART, ISSUE ?
	OUT	0F5H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

	MVI	A,0		;ISSUE SEVERAL NULLS TO SYNC
	OUT	0F5H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

	OUT	0F5H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

	OUT	0F5H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

	MVI	A,40H		;NOW ISSUE RESET COMMAND
	OUT	0F5H

	MVI	A,36H		;SET UP 8253 BAUD RATE GENERATOR
	OUT	0F3H

	PUSH	H
	LXI	H,0008H		;OUTPUT DIVISOR
	MOV	A,L
	OUT	0F0H
	MOV	A,H
	OUT	0F0H
	POP	H

	MVI	A,6EH		;ISSUE MODE WORD (1 STOP, NO PAR, 8 BITS, 16X)
	OUT	0F5H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

	MVI	A,37H		;ISSUE COMMAND (RTS, ERR RES, RXE, DTR, TXEN)
	OUT	0F5H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RET

;**************************************
;
;	RETURN STATUS PORT DATA SUBR
;	EXIT -	A= STATUS
;
;***************************************
INSPRU:	IN	0F5H
	RET

;**************************************
;
;	RESET USART ERRORS SUBR
;	EXIT -	A= ?
;
;**************************************
ERRSTU:	MVI	A,37H
	OUT	0F5H
	RET

;********************************
;
;	RETURN USART DATA SUBR
;	EXIT -	A= DATA
;
;********************************
INPRTU:	IN	0F4H
	RET

;***********************************
;
;	OUTPUT CHAR TO USART SUBR
;	ENTRY-	A= CHAR
;
;***********************************
OUTPRU:	OUT	0F4H
	RET

;
;	SIGN-ON MESSAGE
;
SGNONM:	DB	CR,LF,CR,LF,'VERSION 8251/4.2 AUGUST 20, 1979'
	DB	CR,LF,'MODIFIED BY GIRVIN HERR, 3 MAR 82, LPARL'
	DB	CR,LF,'INTEL SERIES II TTY PORT USING NO PARITY'
	DB	CR,LF,'$'

;*****************************
;
;	SIGN-ON PRINTER
;
;*****************************
PRTSGN:	PUSH	B		;SAVE REGS
	PUSH	D
	PUSH	H
	LXI	D,SGNONM
	MVI	C,9		;USE BDOS PRINTER
	CALL	BDOS
	POP	H		;RESTORE REGS
	POP	D
	POP	B
	RET

;
;	POSITION PROGRAM
;
	DS	023EH - $

;
;	START OF MAIN PROGRAM
;
START:	LXI	H,0		;SAVE SYSTEM STACK
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	JMP	START2

;
;	POSTION NEW START
;
	DS	034BH - $	;STACK


STACK:	DW	0		;SYSTEM STACK SAVE

;
;	RESTART FROM SETTING STACK
;
START2:	JMP	S3

;
;	MESSAGES
;
SO1:	DB	CR,LF,'BYROM SOFTWARE TELECOMMUNICATIONS$'

S3:	MVI	C,9
	LXI	D,SO1
	CALL	BDOS
	JMP	S4

;
SO2:	DB	CR,LF,'SERIAL NO. LB-584 VERSION    4.4$'

S4:	MVI	C,9
	LXI	D,SO2
	CALL	BDOS
	JMP	S5

SO3:	DB	CR,LF,'COPYRIGHT (C) 1980  ALL RIGHTS RESERVED$'

S5:	MVI	C,9
	LXI	D,SO3
	CALL	BDOS

	LDA	DEFBFR		;IF INVOKED WITH ARGUMENTS THEN GO SERVICE THEM
	CPI	0
	JNZ	GETARG
	JMP	NOARGS

NODRM:	DB	CR,LF,'**** NO DRIVE NAME - PROGRAM ABORTING ****$'

NOARGS:	MVI	C,9
	LXI	D,NODRM
	CALL	BDOS
	JMP	PABORT


;
;	GET COMMAND LINE ARG
;
GETARG:	LDA	DEFFCB+1	;IF NO FILE THEN SKIP
	CPI	' '
	JZ	L0509

	LDA	DEFBFR+4
	CPI	'*'
	JNZ	L0466

	MVI	A,1		;SET EXTENDED MODE FLAG
	STA	XMODEF
	JMP	L045B

L043A:	DB	CR,LF,'---- EXTENDED MODE ACTIVE ----$'

;
;	WILDCARD FILE SPEC'D
;
L045B:	MVI	C,9
	LXI	D,L043A
	CALL	BDOS
	JMP	L0509

;
;	FILENAME SPECIFIED
;
L0466:	MVI	A,1		;SET TRANSMITTED FILENAME OVERRIDE
	STA	XFNOVF
	JMP	L049B

L046E:	DB	CR,LF,'---- OVERRIDING TRANSMITTED FILENAME ----$'

L049B:	MVI	C,9
	LXI	D,L046E
	CALL	BDOS
	JMP	L04CB

L04A6:	DB	CR,LF,'---- USING USER SUPPLIED NAME ----$'

L04CB:	MVI	C,09
	LXI	D,L04A6
	CALL	BDOS
	JMP	L0501

L04D6:	DB	CR,LF,'---- ONLY ONE FILE WILL BE RECEIVED ----$'

L0501:	MVI	C,09
	LXI	D,L04D6
	CALL	BDOS

;
;	NO FILENAME GIVEN, USE TRANSMITTED FILENAME
;
L0509:	MVI	A,0
	STA	L131E

	CALL	L0576

	LDA	L131E
	CPI	01
	JZ	L0527

L0519:	LDA	L131E
	SUI	0
	JNZ	L0527

	CALL	L0DAA
	JMP	L0519

L0527:	CALL	L1213

;
;	ABORT PROGRAM
;
PABORT:	LDA	XFNOVF
	SUI	0
	JNZ	L0571

	LDA	L131E
	SUI	02
	JZ	L0509

	LDA	XMODEF		;IF NOT EXTENDED MODE THEN SKIP
	SUI	01
	JNZ	L0571

	JMP	L0566		;ELSE OUTPUT EXTENDED ACTIVE MSG

L0545:	DB	CR,LF,'---- EXTENDED MODE ACTIVE ----$'

L0566:	MVI	C,09
	LXI	D,L0545
	CALL	BDOS
	JMP	L0509

L0571:	LHLD	STACK		;RESTORE CP/M STACK
	SPHL
	RET


;************************************
;
;	SUBR
;
;************************************
L0576:	LXI	H,DEFFCB+1
	SHLD	L133A

	MVI	A,0
	STA	L131D
	STA	L131E
	STA	L1320
	STA	L1321

	MVI	A,01
	STA	L1322
	CALL	INITIL
	JMP	L05BA

L0595:	DB	CR,LF,'**** CONNECTING TO REMOTE CPU ****$'

L05BA:	MVI	C,9
	LXI	D,L0595
	CALL	BDOS
	JMP	L0893


;*********************************
;
;	SUBR
;
;*********************************
L05C5:	SHLD	L088E

	XCHG
	SHLD	L0891

	STA	L0890

	LHLD	L088E
	SHLD	L088C

	MVI	A,1
	STA	L0887
	STA	L0888
	STA	L088A

	MVI	A,0
	STA	L0889

	LHLD	L0891
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H

	MVI	A,0FFH
	MOV	M,A
	INX	H

	MVI	A,0
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H

	MVI	A,0FFH
	MOV	M,A

L05F9:	LDA	L088A
	SUI	01H
	JNZ	L0886

	LHLD	L0891
	INX	H
	INX	H
	INX	H
	LDA	L0890
	CMP	M
	JNZ	L0643

	MVI	A,0
	STA	L088A

	LHLD	L088C
	DCX	H
	DCX	H
	MOV	A,M
	CPI	10H
	JNZ	L0639

	INX	H
	MOV	A,M
	CPI	06H
	JZ	L0883

	CPI	15H
	JZ	L0883

	CPI	05H
	JZ	L0883

	CPI	03H
	JZ	L0883

	CPI	17H
	JZ	L0883

L0639:	LHLD	L0891
	MVI	A,1
	ORA	M
	MOV	M,A
	JMP	L0883

L0643:	LHLD	L0891
	MVI	A,0
	MOV	M,A
	JMP	L070A


;***********************************
;
;	SUBR
;
;***********************************
L064C:	SHLD	L0702
	STA	L0708

	LHLD	L0706
	SHLD	L0704

L0658:	CALL	INSPORT		;GET USART STATUS
	STA	L0709

	LDA	L0709		;IF OVERRUN ERR THEN
	ANI	10H
	JZ	L0671

	CALL	ERRSET		;   CLEAR ERRORS

	LHLD	L0702		;   SET OVERRUN ERR FLAG (BIT 5)
	MVI	A,20H
	ORA	M
	MOV	M,A
	RET
;
;	NOT OVERRUN ERR
;
L0671:	LDA	L0709		;ELSE IF PARITY ERR THEN
	ANI	08H
	JZ	L0684

	CALL	ERRSET		;   CLEAR ERRS

	LHLD	L0702		;   SET PARITY ERR BIT (6)
	MVI	A,40H
	ORA	M
	MOV	M,A
	RET			;   RETURN ERR
;
;	NOT PARITY ERR
;
L0684:	LDA	L0709		;IF RXRDY IS TRUE THEN
	ANI	02H
	JZ	L06E0

	CALL	INPORT		;GET CHAR
	STA	L0709

	LDA	L0708		;IF L0708 IS TRUE THEN
	CPI	01H
	JZ	L069E

	LDA	L0709		;   RETURN CHAR
	RET


L069E:	LHLD	L0702		;ELSE
	INX	H
	INX	H
	MOV	D,M
	INX	H
	INX	H
	INX	H
	MOV	E,M

	LDA	L0709
	XCHG
	JMP	L06CE


;********************************
;
;	CALCULATE CRC SUBR
;
;********************************
CALCRC:	XRA	H
	MOV	B,A
	RLC
	RLC
	RLC
	RLC
	XRA	B
	MOV	C,A
	ANI	0F0H
	MOV	D,A
	ADD	C
	MOV	E,A
	MOV	A,D
	ACI	00H
	XRA	L
	MOV	H,A
	MOV	A,B
	ANI	0F0H
	MOV	B,A
	XRA	E
	MOV	L,A
	MOV	A,B
	RRC
	RRC
	RRC
	XRA	H
	MOV	H,A
	RET


;------------------------------------
;
;	CONTINUATION OF L064C SUBR
;
;------------------------------------
L06CE:	CALL	CALCRC
	XCHG

	LHLD	L0702
	INX	H
	INX	H
	MOV	M,D
	INX	H
	INX	H
	INX	H
	MOV	M,E

	LDA	L0709
	RET
;
;	NO CHAR RDY
;
L06E0:	LHLD	L0704
	DCX	H
	MVI	A,0
	CMP	H
	JZ	L06F0

	SHLD	L0704
	JMP	L0658

L06F0:	CMP	L
	JZ	L06FA

	SHLD	L0704
	JMP	L0658

L06FA:	LHLD	L0702
	MVI	A,4
	ORA	M
	MOV	M,A
	RET


L0702:	DW	0
L0704:	DW	0
L0706:	DW	0
L0708:	DB	0
L0709:	DB	0


L070A:	LHLD	L0891
	MVI	A,1
	CALL	L064C
	STA	L088B

	LHLD	L0891
	MVI	A,0
	CMP	M
	JZ	L0726

	MVI	A,0
	STA	L088A
	JMP	L0883

L0726:	LDA	L0887
	SUI	01H
	JNZ	L079E

	LDA	L0888
	SUI	01H
	JNZ	L0756

	LDA	L088B
	CPI	10H
	JNZ	L0746

	MVI	A,0
	STA	L0888
	JMP	L0785

L0746:	LHLD	L0891
	MVI	A,8
	ORA	M
	XCHG
	STAX	D
	MVI	A,0
	STA	L088A
	JMP	L0785

L0756:	LDA	L088B
	CPI	02H
	JNZ	L0766

	MVI	A,0
	STA	L0887
	JMP	L0785

L0766:	LDA	L088B
	CPI	06H
	JZ	L0780

	CPI	15H
	JZ	L0780

	CPI	05H
	JZ	L0780

	MVI	A,8
	LHLD	L0891
	ORA	M
	XCHG
	STAX	D

L0780:	MVI	A,0
	STA	L088A

L0785:	LDA	L088B
	LHLD	L088C
	XCHG
	STAX	D
	INX	D

	XCHG
	SHLD	L088C

	LHLD	L0891
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L0883

L079E:	LDA	L0889
	SUI	01H
	JNZ	L0862

	LDA	L088B
	CPI	10H
	JNZ	L07CA

	MVI	A,0
	STA	L0889

	LDA	L088B
	LHLD	L088C
	MOV	M,A
	INX	H
	SHLD	L088C

	LHLD	L0891
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L0883

L07CA:	LDA	L088B
	CPI	17H
	JZ	L07FA

	CPI	03H
	JZ	L07FA

	CPI	1BH
	JZ	L07FA

	LHLD	L0891
	MVI	A,8
	ORA	M
	MOV	M,A

	LDA	L088B
	LHLD	L088C
	MOV	M,A
	INX	H
	SHLD	L088C

	LHLD	L0891
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L085A

L07FA:	MVI	A,10H
	LHLD	L088C
	MOV	M,A
	INX	H

	LDA	L088B
	MOV	M,A

	LHLD	L0891
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	INR	A
	MOV	M,A

	LHLD	L0891
	MVI	A,0
	CALL	L064C
	STA	L088B

	LHLD	L0891
	MVI	A,0
	CMP	M
	JNZ	L085A

	INX	H
	LDA	L088B
	MOV	M,A

	LHLD	L0891
	MVI	A,0
	CALL	L064C
	STA	L088B

	LHLD	L0891
	MVI	A,0
	CMP	M
	JNZ	L085A

	INX	H
	INX	H
	INX	H
	INX	H
	LDA	L088B
	MOV	M,A
	INX	H
	CMP	M
	JNZ	L0853

	LHLD	L0891
	INX	H
	MOV	A,M
	INX	H
	CMP	M
	JZ	L085A

L0853:	MVI	A,10H
	LHLD	L0891
	ORA	M
	MOV	M,A

L085A:	MVI	A,0
	STA	L088A
	JMP	L0883

L0862:	LDA	L088B
	CPI	10H
	JNZ	L0872

	MVI	A,1
	STA	L0889
	JMP	L0883

L0872:	LHLD	L088C
	MOV	M,A
	INX	H
	SHLD	L088C

	LHLD	L0891
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
L0883:	JMP	L05F9

L0886:	RET


L0887:	DB	0
L0888:	DB	0
L0889:	DB	0
L088A:	DB	0
L088B:	DB	0
L088C:	DW	0
L088E:	DW	0
L0890:	DB	0
L0891:	DW	0


L0893:	LXI	H,1382H
	LXI	D,1323H
	MVI	A,2
	CALL	L05C5

L089E:	LDA	L1322
	SUI	01H
	JNZ	L0D76

	LDA	L1323
	CPI	00H
	JZ	L0A8D

	JMP	L0A21


L08B1:	SHLD	L0A1F
	MVI	A,80H
	ANA	M
	JZ	L08DF

	JMP	L08D7

L08BD:	DB	CR,LF,'**** FRAMING ERROR ****$'

L08D7:	MVI	C,9
	LXI	D,L08BD
	CALL	BDOS

L08DF:	LHLD	L0A1F
	MVI	A,40H
	ANA	M
	JZ	L090C

	JMP	L0904

L08EB:	DB	CR,LF,'**** PARITY ERROR ****$'

L0904:	MVI	C,9
	LXI	D,L08EB
	CALL	BDOS

L090C:	LHLD	L0A1F
	MVI	A,20H
	ANA	M
	JZ	L093A

	JMP	L0932

L0918:	DB	CR,LF,'**** OVERRUN ERROR ****$'

L0932:	MVI	C,9
	LXI	D,L0918
	CALL	BDOS

L093A:	LHLD	L0A1F
	MVI	A,10H
	ANA	M
	JZ	L0964

	JMP	L095C

L0946:	DB	CR,LF,'**** BCC ERROR ****$'

L095C:	MVI	C,9
	LXI	D,L0946
	CALL	BDOS

L0964:	LHLD	L0A1F
	MVI	A,8
	ANA	M
	JZ	L0994

	JMP	L098C

L0970:	DB	CR,LF,'**** LOST DATA ERROR ****$'

L098C:	MVI	C,9
	LXI	D,L0970
	CALL	BDOS

L0994:	LHLD	L0A1F
	MVI	A,4
	ANA	M
	JZ	L09C3

	JMP	L09BB

L09A0:	DB	CR,LF,'**** TIME OUT ERROR ****$'

L09BB:	MVI	C,9
	LXI	D,L09A0
	CALL	BDOS

L09C3:	LHLD	L0A1F
	MVI	A,2
	ANA	M
	JZ	L09F3

	JMP	L09EB

L09CF:	DB	CR,LF,'**** EXCEPTION ERROR ****$'

L09EB:	MVI	C,9
	LXI	D,L09CF
	CALL	BDOS

L09F3:	LHLD	L0A1F
	MVI	A,1
	ANA	M
	RZ

	JMP	L0A16

L09FD:	DB	CR,LF,'**** LENGTH ERROR ****$'

L0A16:	MVI	C,9
	LXI	D,L09FD
	CALL	BDOS
	RET


L0A1F:	DW	0


L0A21:	LXI	H,1323H
	CALL	L08B1
	JMP	L0A7C

;
;
;
L0A2A:	MVI	C,11		;IF NO KEY PRESSED THEN RETURN
	CALL	BDOS
	ORA	A
	RZ

	MVI	C,01		;GET CONSOLE INPUT
	CALL	BDOS

	CPI	03H		;IF NOT CTRL-C THEN RETURN
	RNZ
	JMP	L0A6D

L0A3C:	DB	CR,LF,'**** OPERATOR ABORT, PHONE LINE IS ACTIVE ****$'

L0A6D:	MVI	C,9
	LXI	D,L0A3C
	CALL	BDOS

	XRA	A
	STA	XMODEF
	JMP	L0527


L0A7C:	CALL	L0A2A

	LXI	H,1382H
	LXI	D,1323H
	MVI	A,2
	CALL	L05C5

	JMP	L0D73


L0A8D:	LDA	L1382
	CPI	10H
	JNZ	L0D20

	LDA	L1383
	CPI	05H
	JNZ	L0D20

	MVI	A,0
	STA	L1322
	JMP	L0D0F


L0AA5:	SHLD	L0CF6
	SHLD	L0CFA
	XCHG
	SHLD	L0CFE

	MOV	H,B
	MOV	L,C
	SHLD	L0CFC
	STA	L0D00

	MVI	A,0
	LHLD	L0CFE
	MOV	M,A
	INX	H
	INX	H
	INX	H
	MOV	M,A
	DCX	H
	MVI	A,0FFH
	MOV	M,A
	DCX	H
	MVI	A,0
	MOV	M,A
	INX	H
	INX	H
	INX	H
	MOV	M,A
	INX	H
	MVI	A,0FFH
	MOV	M,A

	MVI	A,1
	STA	L0CF9
	STA	L0CF8

	CALL	ERRSET

L0ADC:	LDA	L0CF9
	SUI	01H
	JNZ	L0CF5

	LHLD	L0CFC
	MOV	A,M

	LHLD	L0CFE
	INX	H
	INX	H
	INX	H
	CMP	M
	JNZ	L0C0C

	MVI	A,0
	STA	L0CF9
	JMP	L0B50


L0AFA:	STA	L0B4F
	SHLD	L0B4A
	XCHG
	SHLD	L0B4C

L0B04:	CALL	INSPORT
	STA	L0B4E
	ANI	01H
	JZ	L0B04

	LDA	L0B4E
	ANI	04H
	JZ	L0B04

	LHLD	L0B4C		;GET PTR
	MOV	A,M		;GET CHAR
	CALL	OUTPORT		;OUTPUT CHAR

L0B1E:	CALL	INSPORT		;IF TX NOT READY THEN WAIT
	ANI	04H
	JZ	L0B1E

	LDA	L0B4F
	CPI	01H
	RNZ

	LHLD	L0B4A
	INX	H
	INX	H
	MOV	D,M
	INX	H
	INX	H
	INX	H
	MOV	E,M

	LHLD	L0B4C
	MOV	A,M
	XCHG
	CALL	CALCRC

	XCHG

	LHLD	L0B4A
	INX	H
	INX	H
	MOV	M,D
	INX	H
	INX	H
	INX	H
	MOV	M,E
	RET


L0B4A:	DW	0
L0B4C:	DW	0
L0B4E:	DB	0
L0B4F:	DB	0


L0B50:	LHLD	L0CFE
	XCHG
	LHLD	L0D04
	XCHG
	MVI	A,1
	CALL	L0AFA

	CALL	INSPORT		;IF RX READY THEN 
	ANI	02H
	JZ	L0B6F

	LHLD	L0CFE		;
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L0CF2

L0B6F:	LDA	L0D00
	CPI	01H
	JZ	L0B87

	LHLD	L0CFE
	XCHG
	LHLD	L0D07
	XCHG
	MVI	A,1
	CALL	L0AFA

	JMP	L0BB3


L0B87:	LHLD	L1338
	INX	H
	MOV	A,M
	CPI	00H
	JZ	L0BA6

	MVI	A,2
	STA	L131E

	LHLD	L0CFE
	XCHG
	LHLD	L0D01
	XCHG
	MVI	A,1
	CALL	L0AFA

	JMP	L0BB3

L0BA6:	LHLD	L0CFE
	XCHG
	LHLD	L0D0A
	XCHG
	MVI	A,1
	CALL	L0AFA

L0BB3:	CALL	INSPORT
	ANI	02H
	JZ	L0BC5

	LHLD	L0CFE
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L0CF2


L0BC5:	LHLD	L0CFE
	INX	H
	INX	H
	SHLD	L0D0D

	LHLD	L0CFE
	XCHG
	LHLD	L0D0D
	XCHG
	MVI	A,0
	CALL	L0AFA

	CALL	INSPORT
	ANI	02H
	JNZ	L0C02

	LHLD	L0CFE
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	SHLD	L0D0D

	LHLD	L0CFE
	XCHG
	LHLD	L0D0D
	XCHG
	MVI	A,0
	CALL	L0AFA

	CALL	INSPORT
	ANI	02H
	JZ	L0CF2

L0C02:	LHLD	L0CFE
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L0CF2


L0C0C:	CALL	INSPORT
	ANI	02H
	JZ	L0C23

	LHLD	L0CFE
	MVI	A,2
	ORA	M
	MOV	M,A

	MVI	A,0
	STA	L0CF9
	JMP	L0CF2


L0C23:	LDA	L0CF8
	SUI	01H
	JNZ	L0C93

	LHLD	L0CFE
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A

	LHLD	L0CFE
	XCHG
	LHLD	L0CFA
	XCHG
	MVI	A,1
	CALL	L0AFA

	LHLD	L0CFA
	INX	H
	SHLD	L0CFA

	CALL	INSPORT
	ANI	02H
	JZ	L0C5F

	LHLD	L0CFE
	MVI	A,2
	ORA	M
	MOV	M,A

	MVI	A,0
	STA	L0CF9
	JMP	L0CF2


L0C5F:	LHLD	L0CFE
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A

	LHLD	L0CFE
	XCHG
	LHLD	L0CFA
	XCHG
	MVI	A,1
	CALL	L0AFA

	LHLD	L0CFA
	INX	H
	SHLD	L0CFA
	DCX	H
	MVI	A,2
	CMP	M
	JNZ	L0C8B

	MVI	A,0
	STA	L0CF8
	JMP	L0CF2


L0C8B:	MVI	A,0
	STA	L0CF9
	JMP	L0CF2


L0C93:	LHLD	L0CFE
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A

	LHLD	L0CFE
	XCHG
	LHLD	L0CFA
	XCHG
	MVI	A,1
	CALL	L0AFA

	LHLD	L0CFA
	INX	H
	SHLD	L0CFA

	CALL	INSPORT
	ANI	02H
	JZ	L0CC7

	LHLD	L0CFE
	MVI	A,2
	ORA	M
	MOV	M,A

	MVI	A,0
	STA	L0CF9
	JMP	L0CF2


L0CC7:	LHLD	L0CFA
	DCX	H
	MVI	A,10H
	CMP	M
	JNZ	L0CF2

	LHLD	L0CFE
	XCHG
	LHLD	L0D04
	XCHG
	MVI	A,1
	CALL	L0AFA

	CALL	INSPORT
	ANI	02H
	JZ	L0CF2

	LHLD	L0CFE
	MVI	A,2
	ORA	M
	MOV	M,A

	MVI	A,0
	STA	L0CF9

L0CF2:	JMP	L0ADC

L0CF5:	RET


L0CF6:	DW	0
L0CF8:	DB	0
L0CF9:	DB	0
L0CFA:	DW	0
L0CFC:	DW	0
L0CFE:	DW	0
L0D00:	DB	0


L0D01:	DB	3,0DH,1BH
L0D04:	DB	6,0DH,10H
L0D07:	DB	9,0DH,3
L0D0A:	DB	12,0DH,17H
L0D0D:	DW	0


L0D0F:	LXI	H,1380H
	LXI	D,132EH
	LXI	B,132DH
	MVI	A,0
	CALL	L0AA5
	JMP	L0D73

L0D20:	JMP	L0D4F

L0D23:	DB	CR,LF,'**** CONNECTION IS STILL IN PROGRESS ****$'

L0D4F:	MVI	C,9
	LXI	D,L0D23
	CALL	BDOS

	CALL	L0A2A

	LXI	H,137EH
	LXI	D,132EH
	LXI	B,132DH
	MVI	A,0
	CALL	L0AA5

	LXI	H,1382H
	LXI	D,1323H
	MVI	A,2
	CALL	L05C5

L0D73:	JMP	L089E

L0D76:	JMP	L0DA1

L0D79:	DB	CR,LF,'**** REMOTE CPU IS NOW CONNECTED ****$'

L0DA1:	MVI	C,9
	LXI	D,L0D79
	CALL	BDOS
	RET


L0DAA:	MVI	A,0
	STA	L1329

	MVI	A,1
	STA	L132A

	MVI	A,0
	STA	L1320

	LXI	H,1382H
	LXI	D,1323H
	MVI	A,0C8H
	CALL	L05C5

L0DC4:	LDA	L132A
	SUI	01H
	JNZ	L11DA

	LDA	L1323
	CPI	00H
	JZ	L0ED0

L0DD4:	LXI	H,1323H
	CALL	L08B1

	LDA	L1383
	CPI	05H
	JNZ	L0E49

	LDA	L131D
	SUI	00H
	JNZ	L0E19

	LDA	L1320
	INR	A
	STA	L1320

	LDA	L1320
	SUI	0C8H
	JC	L0DFD

	DCR	A
	JNC	L0E5B

L0DFD:	LXI	H,1380H
	LXI	D,132EH
	LXI	B,132DH
	MVI	A,0
	CALL	L0AA5

	LXI	H,1382H
	LXI	D,1323H
	MVI	A,0C8H
	CALL	L05C5

	JMP	L11D7

L0E19:	JMP	L0E3E

L0E1C:	DB	CR,LF,'**** SYNCHRONIZATION ERROR ****$'

L0E3E:	MVI	C,9
	LXI	D,L0E1C
	CALL	BDOS

	JMP	L0EA2



L0E49:	LDA	L1320
	INR	A
	STA	L1320

	LDA	L1320
	SUI	0C8H
	JC	L0EB4

	JZ	L0EB4

L0E5B:	JMP	L0E9A

L0E5E:	DB	CR,LF,'**** PERMANENT TRANSMISSION ERROR - '
	DB	'PROGRAM ABORTING ****$'

L0E9A:	MVI	C,9
	LXI	D,L0E5E
	CALL	BDOS

L0EA2:	MVI	A,1
	STA	L131E

	MVI	A,0
	STA	L132A

	MVI	A,1
	STA	L1329
	JMP	L11D7



L0EB4:	LXI	H,132BH
	LXI	D,132EH
	LXI	B,132DH
	MVI	A,0
	CALL	L0AA5

	LXI	H,1382H
	LXI	D,1323H
	MVI	A,0C8H
	CALL	L05C5
	JMP	L11D7

L0ED0:	LDA	L1382
	CPI	10H
	JNZ	L0DD4

	LDA	L1383
	CPI	02H
	JNZ	L0DD4

	LDA	L1321
	LXI	H,1384H
	SUB	M
	JNZ	L10ED

	LDA	L1321
	INR	A
	STA	L1321

	LXI	H,1382H
	LXI	B,0
	LDA	L1326
	MOV	C,A
	DAD	B
	DCX	H

	MVI	A,3
	CMP	M
	JZ	L0F16

	MVI	A,1BH
	CMP	M
	JNZ	L0F11

	MVI	A,2
	STA	L131E
	JMP	L0F16

L0F11:	MVI	A,1
	STA	L131E

L0F16:	DCX	H
	SHLD	L1334

	XCHG
	LXI	H,1385H
	SHLD	L1336

L0F21:	LHLD	L1334
	XCHG
	LHLD	L1336
	MOV	A,D
	CMP	H
	JNZ	L0F35

	MOV	A,E
	CMP	L
	JNZ	L0F35

	JMP	L0F6C

L0F35:	LDA	L131D
	SUI	00H
	JZ	L0F4E

	LHLD	L1336
	MOV	A,M
	CALL	L1006

	LHLD	L1336
	INX	H
	SHLD	L1336
	JMP	L0F21

L0F4E:	LHLD	L1336
	XCHG
	LHLD	L133A
	XCHG

	LDA	XFNOVF
	CPI	00H
	JNZ	L0F60

	MOV	A,M
	STAX	D

L0F60:	INX	H
	INX	D
	SHLD	L1336
	XCHG
	SHLD	L133A
	JMP	L0F21

L0F6C:	LDA	L131D
	SUI	00H
	JNZ	L10D7

	MVI	B,8
	LXI	H,1385H
	LXI	D,0FA8H

L0F7C:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	L0F7C

	INX	D
	MVI	B,3

L0F87:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	L0F87

	JMP	L0FBA

L0F92:	DB	CR,LF,'---- RECEIVING FILE --------.--- ----$'


L0FBA:	MVI	C,9
	LXI	D,L0F92
	CALL	BDOS

	JMP	L0FCE


;****************************************
;
;	MOVE SUBR
;	ENTRY-	HL= SOURCE PTR
;		DE= DEST PTR
;		C= COUNT
;	EXIT -	HL= HL + COUNT + 1
;		DE= DE + COUNT + 1
;		C= 0
;		A= LAST BYTE
;
;****************************************
L0FC5:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	L0FC5

	RET


L0FCE:	LXI	H,DEFFCB
	LXI	D,0FDCH
	MVI	C,9
	CALL	L0FC5
	JMP	L1003


;
;	GARBAGE
;
	DB	2,0C2H,0D4H,0DH,3AH,21H,13H,21H,84H,'***'

L0FE8:	DB	0
L0FE9:	DB	10H

L0FEA:	LDA	L1321
	INR	A
	STA	L1321

	LXI	H,1382H
	LXI	B,0
	LDA	L1326
	MOV	C,A
	DAD	B

L0FFC:	DCX	H
L0FFD:	MOV	C,D
	INR	D

L0FFF:	ADD	B
	INX	D

L1001:	MVI	D,0FH

L1003:	JMP	L1085

L1006:	PUSH	PSW

	LHLD	L0FFF
	XCHG
	LHLD	L1001
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	L1075

	LXI	H,0
	SHLD	L1001

L101B:	XCHG
	LHLD	L0FFF
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	L1067

	LHLD	L0FFD		;COMPUTE DMA ADDR
	DAD	D
	XCHG
	MVI	C,26		;SET XFER ADDR
	CALL	BDOS

	LXI	D,0FDCH		;WRITE SECTOR
	MVI	C,21
	CALL	BDOS

	ORA	A		;IF WRITE ERROR THEN DISK FULL
	JNZ	L1049

	LXI	D,0080H		;L1001 += SECTOR SIZE
	LHLD	L1001
	DAD	D

	SHLD	L1001
	JMP	L101B

L1049:	MVI	C,09		;OUTPUT DISK FULL MSG & GOTO CP/M
	LXI	D,1055H
	CALL	BDOS

	POP	PSW		;WARM BOOT
	JMP	L0000

L1055:	DB	CR,LF,'DISK FULL: DEST$'



L1067:	LXI	D,DEFBFR		;SET XFER ADDR TO DEFAULT BUFFER
	MVI	C,26
	CALL	BDOS

	LXI	H,0		;L1001 = 0
	SHLD	L1001

L1075:	XCHG
	LHLD	L0FFD
	DAD	D
	XCHG

	POP	PSW
	STAX	D

	LHLD	L1001
	INX	H
	SHLD	L1001
	RET


L1085:	XRA	A
	STA	L0FE8
	STA	L0FFC
	STA	L0FE9
	STA	L0FEA

	LXI	H,1380H
	SHLD	L0FFF

	LXI	H,0
	SHLD	L1001

	MVI	C,19		;DELETE FILE
	LXI	D,0FDCH
	CALL	BDOS

	MVI	C,22		;MAKE FILE
	LXI	D,0FDCH
	CALL	BDOS

	INR	A		;IF ERR THEN NO SPACE
	JNZ	L10D2

	MVI	C,09		;OUTPUT NO DIR SPACE MSG & GOTO CP/M
	LXI	D,10BDH
	CALL	BDOS
	JMP	L0000

L10BD:	DB	CR,LF,'NO DIR SPACE: DEST$'


L10D2:	MVI	A,1
	STA	L131D

L10D7:	LXI	H,1380H
	LXI	D,132EH
	LXI	B,132DH
	MVI	A,0
	CALL	L0AA5

	MVI	A,0
	STA	L132A

	JMP	L11D7


L10ED:	LDA	L1321
	SUI	00H
	JNZ	L11C6

	LDA	L1384
	CPI	0FCH
	JNC	L1141

L10FD:	JMP	L1129

L1100:	DB	CR,LF,'**** BCB ERROR - PROGRAM ABORTING ****$'

L1192:	MVI	C,9
	LXI	D,L1100
	CALL	BDOS

	MVI	A,1
	STA	L1329
	STA	L131E

	MVI	A,0
	STA	L132A
	JMP	L11D7


L1141:	LDA	L1320
	INR	A
	STA	L1320

	LDA	L1320
	SUI	0C8H
	JC	L11AA

	JZ	L11AA

	JMP	L1192

L1156:	DB	CR,LF,'**** PERMANENT TRANSMISSION ERROR - '
	DB	'PROGRAM ABORTING ****$'

L1192:	MVI	C,9
	LXI	D,L1156
	CALL	BDOS

	MVI	A,0
	STA	L132A

	MVI	A,1
	STA	L1329
	STA	L131E
	JMP	L11D7


L11AA:	LXI	H,1380H
	LXI	D,132EH
	LXI	B,132DH
	MVI	A,0
	CALL	L0AA5

	LXI	H,1382H
	LXI	D,1323H
	MVI	A,0C8H
	CALL	L05C5
	JMP	L11D7


L11C6:	LDA	L1321
	LXI	H,1384H
	SUB	M
	JC	L11D4

	DCR	A
	JNC	L1141

L11D4:	JMP	L10FD

L11D7:	JMP	L0DC4

L11DA:	LDA	L1329
	SUI	01H
	JZ	L1212

	JMP	L120A

L11E5:	DB	CR,LF,'**** BLOCK RECEIVED CORRECTLY ****$'

L120A:	MVI	C,9
	LXI	D,L11E5
	CALL	BDOS

L1212:	RET


L1213:	LDA	L131D
	SUI	00H
	JZ	L12E3

L121B:	LHLD	L1001
	MOV	A,L
	ANI	7FH
	JNZ	L1227

	SHLD	L0FFF

L1227:	MVI	A,1AH
	PUSH	PSW
	CALL	L1006

	POP	PSW
	JNZ	L121B

	MVI	C,16		;CLOSE FILE
	LXI	D,0FDCH
	CALL	BDOS

	INR	A		;IF CLOSE ERR THEN OUTPUT ERR MSG
	JNZ	L125C

	MVI	C,9
	LXI	D,L1248
	CALL	BDOS
	JMP	L125C

L1248:	DB	CR,LF,'CANNOT CLOSE DEST$'

L125C:	LDA	L1329
	SUI	01H
	JZ	L12E3

	LXI	D,L133C		;MOVE DEFAULT FCB NAME TO L133C
	LXI	H,DEFFCB
	MVI	B,0CH

L126C:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	L126C

	MVI	C,19		;DELETE FILE
	LXI	D,133CH
	CALL	BDOS

	LXI	H,DEFFCB		;MOVE 1ST 9 BYTES OF DEFFCB TO L135D
	LXI	D,135DH
	MVI	B,9

L1284:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	L1284

	LXI	H,1319H
	MVI	B,3

L1291:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	L1291

	LXI	D,136DH
	LXI	H,133CH
	MVI	B,0CH

L12A1:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	L12A1

	MVI	C,23		;RENAME FILE
	LXI	D,135DH
	CALL	BDOS
	JMP	L12DB

L12B4:	DB	CR,LF,'---- FILE IS NOW STORED ON DISK ----$'

L12DB:	MVI	C,9
	LXI	D,l12B4
	CALL	BDOS

L12E3:	JMP	L1310

L12E6:	DB	CR,LF,'**** DISCONNECTING FROM REMOTE CPU ****$'

	LXI	D,L12E6
	CALL	BDOS
	RET

;
;	DATA STORAGE AREAS
;

L1319:	DB	'$$$'
XFNOVF:	DB	0
L131D:	DB	0
L131E:	DB	0
XMODEF:	DB	0
L1320:	DB	0
L1321:	DB	0
L1322:	DB	0
L1323:	DB	0,0,0
L1326:	DB	0,0,0
L1329:	DB	0
L132A:	DB	0

	DB	10H,15H,2
	DB	0,0,0,0,0,0

L1334:	DW	0
L1336:	DW	0
L1338:	DW	0
L133A:	DS	43H

L137E:	DB	10H,5,10H,6
L1382:	DB	0
L1383:	DB	0

L1384:	DS	7CH

	END
