	TITLE	'All 6809 Addressing Modes.'
;	Example of all 6809 Addressing Modes.


n5:	EQU	14
n8:	EQU	127
mm16:	EQU	0FEDCh


;	Accumulator Offset.


	LDD	A,X
	LDD	A,Y
	LDD	A,S
	LDD	A,U
	LDD	B,X
	LDD	B,Y
	LDD	B,S
	LDD	B,U
	LDA	D,X
	LDA	D,Y
	LDA	D,S
	LDA	D,U

	LDD	[A,X]
	LDD	[A,Y]
	LDD	[A,S]
	LDD	[A,U]
	LDB	[b,x]
	LDB	[b,y]
	LDB	[b,s]
	LDB	[b,u]
	LDD	[D,X]
	LDD	[D,Y]
	LDD	[D,S]
	LDD	[D,U]


;	Automatic Increment & Decrement modes.

	LDD	X+
	LDD	,Y+
	LDD	0,S+
	LDD	U+
	LDD	-X
	LDD	0,-Y
	LDD	-S
	LDD	,-U
	LDD	X++
	LDD	,Y++
	LDD	0,S++
	LDD	U++
	LDD	--X
	LDD	0,--Y
	LDD	--S
	LDD	,--U
	LDD	[X++]
	LDD	[,Y++]
	LDD	[0,S++]
	LDD	[U++]
	LDD	[--X]
	LDD	[0,--Y]
	LDD	[--S]
	LDD	[,--U]


;	Expression offset mode.

	LDD	,X	;empty expression
	LDD	,Y
	LDD	,S
	LDD	,U
	LDD	,PC
	LDD	X
	LDD	Y
	LDD	S
	LDD	U
	LDD	PC
	LDD	0,X	;Zero same as omitted
	LDD	0,Y
	LDD	0,S
	LDD	0,U
	LDD	0,PC
	LDD	+15,X
	LDD	-16,Y
	LDD	n5,S
	LDD	n5,U
	LDD	n5,PC
	LDD	n8,X
	LDD	n8,Y
	LDD	n8,S
	LDD	n8,U
	LDD	n8,PC
	LDD	mm16,X
	LDD	mm16,Y
	LDD	mm16,S
	LDD	mm16,U
	LDD	mm16,PC

	LDD	[,X]	;empty expression
	LDD	[,Y]
	LDD	[,S]
	LDD	[,U]
	LDD	[,PC]
	LDD	[X]
	LDD	[Y]
	LDD	[S]
	LDD	[U]
	LDD	[PC]
	LDD	[0,X]	;Zero same as omitted
	LDD	[0,Y]
	LDD	[0,S]
	LDD	[0,U]
	LDD	[0,PC]
	LDD	[+15,X]
	LDD	[-16,Y]
	LDD	[n5,S]
	LDD	[n5,U]
	LDD	[n5,PC]
	LDD	[n8,X]
	LDD	[n8,Y]
	LDD	[n8,S]
	LDD	[n8,U]
	LDD	[n8,PC]
	LDD	[mm16,X]
	LDD	[mm16,Y]
	LDD	[mm16,S]
	LDD	[mm16,U]
	LDD	[mm16,PC]

	END
