;********************************************************
;*							*
;*	Vic's Box Board equate module			*
;*							*
;*	Latest Revision date:	10 may 84		*
;*							*
;********************************************************
;
;	System I/O port definitions
;
z8030		equ	00h		;Base of network serial controller
z8031		equ	40h		;Base of console and list serial controller
i8237		equ	80h		;Base of DMA controller chip
z8036		equ	100h		;Base of parallel I/O controller
;
;	z8030a internal register equates
;
sio_cha		equ	00100000b	;z8030 A/B, channel A select
sio_chb		equ	00000000b	;z8030 A/B, channel B select bit
;
sio_rr0		equ	00000b	;T/R & Ext. status reg.
sio_rr1		equ	00010b	;Special receive cond. status reg.
sio_rr2		equ	00100b	;Unmodified interrupt vector (ch.A only)
				;Modified interrupt vector (ch.B only)
sio_rr3		equ	00110b	;Interrupt pending bits (ch.A only)
sio_rr8		equ	10000b	;Receive data buffer
sio_rr10	equ	10100b	;Miscellaneous status reg.
sio_rr12	equ	11000b	;LSB of baud rate gen. TC reg.
sio_rr13	equ	11010b	;MSB of baud rate gen. TC reg.
sio_rr15	equ	11110b	;Ext./status interrupt information
;
sio_wr0		equ	00000b	;CRC, init., mode command reg.
sio_wr1		equ	00010b	;T/R interrupt & mode reg.
sio_wr2		equ	00100b	;Interrupt vector reg.
sio_wr3		equ	00110b	;Rec. param. and control reg.
sio_wr4		equ	01000b	;T/R misc. param. & modes reg.
sio_wr5		equ	01010b	;Xmit. param. & control reg.
sio_wr6		equ	01100b	;Sync or SDLC addr. reg.
sio_wr7		equ	01110b	;Sync or SDLC flag reg.
sio_wr8		equ	10000b	;Transmit data buffer
sio_wr9		equ	10010b	;Master int. control & reset reg.
sio_wr10	equ	10100b	;Misc. xmit./rec. control bits reg.
sio_wr11	equ	10110b	;Clock mode reg.
sio_wr12	equ	11000b	;LSB of baud rate gen. TC reg.
sio_wr13	equ	11010b	;MSB of baud rate gen. TC reg.
sio_wr14	equ	11100b	;Misc. control bits reg.
sio_wr15	equ	11110b	;Ext./status interrupt control reg.
;
tx_rdy		equ	00000100b	;Transmitter holding register empty bit
rx_rdy		equ	00000001b	;Receiver register full bit
sio_eoi		equ	00111000b	;End of interrupt command
;
;	Network, console and list data/status port addresses
;
net_data	equ	z8030 + sio_cha + sio_rr8
net_stat	equ	z8030 + sio_cha + sio_rr0
;
ci_data		equ	z8031 + sio_cha + sio_rr8
ci_stat		equ	z8031 + sio_cha + sio_rr0
co_data		equ	z8031 + sio_cha + sio_wr8
co_stat		equ	ci_stat
lo_data		equ	z8031 + sio_chb + sio_wr8
lo_stat		equ	z8031 + sio_chb + sio_rr0
;
;	z8036a CIO internal register equates
;
cio_portc	equ	z8036 + 0011010b	;Port C data reg.
cio_portb	equ	z8036 + 0011100b	;Port B data reg.
cio_porta	equ	z8036 + 0011110b	;Port A data reg.
;
cio_r0		equ	0000000b	;Master interrupt control reg.
cio_r1		equ	0000010b	;Master configuration control reg.
cio_r2		equ	0000100b	;Port A interrupt vector reg.
cio_r3		equ	0000110b	;Port B interrupt vector reg.
cio_r4		equ	0001000b	;Counter/timer interrupt vector reg.
cio_r5		equ	0001010b	;Port C data path polarity reg.
cio_r6		equ	0001100b	;Port C data direction reg.
cio_r7		equ	0001110b	;Port C special I/O control reg.
;
cio_r8		equ	0010000b	;Port A command & status reg.
cio_r9		equ	0010010b	;Port B command & status reg.
cio_r10		equ	0010100b	;C/T 1 command & status reg.
cio_r11		equ	0010110b	;C/T 2 command & status reg.
cio_r12		equ	0011000b	;C/T 3 command & status reg.
cio_r13		equ	0011010b	;Port A data reg.
cio_r14		equ	0011100b	;Port B data reg.
cio_r15		equ	0011110b	;Port C data reg.
;
cio_r16		equ	0100000b	;C/T 1 current count MSB reg.
cio_r17		equ	0100010b	;C/T 1 current count LSB reg.
cio_r18		equ	0100100b	;C/T 2 current count MSB reg.
cio_r19		equ	0100110b	;C/T 2 current count LSB reg.
cio_r20		equ	0101000b	;C/T 3 current count MSB reg.
cio_r21		equ	0101010b	;C/T 3 current count LSB reg.
;
cio_r22		equ	0101100b	;C/T 1 TC MSB reg.
cio_r23		equ	0101110b	;C/T 1 TC LSB reg.
cio_r24		equ	0110000b	;C/T 2 TC MSB reg.
cio_r25		equ	0110010b	;C/T 2 TC LSB reg.
cio_r26		equ	0110100b	;C/T 3 TC MSB reg.
cio_r27		equ	0110110b	;C/T 3 TC LSB reg.
;
cio_r28		equ	0111000b	;C/T 1 mode spec. reg
cio_r29		equ	0111010b	;C/T 2 mode spec. reg
cio_r30		equ	0111100b	;C/T 3 mode spec. reg
;
cio_r31		equ	0111110b	;Current vector reg.
;
cio_r32		equ	1000000b	;Port A mode specification reg.
cio_r33		equ	1000010b	;Port A handshake specification reg.
cio_r34		equ	1000100b	;Port A data path polarity reg.
cio_r35		equ	1000110b	;Port A data direction reg.
cio_r36		equ	1001000b	;Port A special I/O control reg.
cio_r37		equ	1001010b	;Port A pattern polarity reg.
cio_r38		equ	1001100b	;Port A pattern transition reg.
cio_r39		equ	1001110b	;Port A pattern mask reg.
;
cio_r40		equ	1010000b	;Port B mode specification reg.
cio_r41		equ	1010010b	;Port B handshake specification reg.
cio_r42		equ	1010100b	;Port B data path polarity reg.
cio_r43		equ	1010110b	;Port B data direction reg.
cio_r44		equ	1011000b	;Port B special I/O control reg.
cio_r45		equ	1011010b	;Port B pattern polarity reg.
cio_r46		equ	1011100b	;Port B pattern transition reg.
cio_r47		equ	1011110b	;Port B pattern mask reg.
;
;	i8237A-5 DMA controller internal register equates
;		NOTE:  AMD 9517a-5 may be used also.
;
dma_ch0		equ	i8237 + 00000b	;Base addr. of ch. 0
dma_ch1		equ	i8237 + 00100b	;Base addr. of ch. 1
dma_ch2		equ	i8237 + 01000b	;Base addr. of ch. 2
dma_ch3		equ	i8237 + 01100b	;Base addr. of ch. 3
dma_wcr		equ	00010b		;Offset of word count reg.
dma_cmd		equ	i8237 + 10000b	;Write command reg.
dma_stat	equ	dma_cmd		;Read status reg.
dma_wrr		equ	i8237 + 10010b	;Write request reg. (WR only)
dma_wsmr	equ	i8237 + 10100b	;Write single mask reg. bit (WR only)
dma_wmode	equ	i8237 + 10110b	;Write mode reg. (WR only)
dma_cbp		equ	i8237 + 11000b	;Clear byte pointer f/f reg. (WR only)
dma_rdtmp	equ	i8237 + 11010b	;Read temporary reg. (RD only)
dma_mclr	equ	i8237 + 11010b	;Master clear reg. (WR only)
dma_wmr		equ	i8237 + 11110b	;Write all mask reg. bits (WR only)
;
;	Base Page reserved interrupt vector locations
;
		dseg	0000h
		org	0000h
;
;	i8086 internal interrupt vectors
;
div0_int_off	rw	1		;divide by zero
div0_int_seg	rw	1
;
ss_int_off	rw	1		;single step
ss_int_seg	rw	1
;
nmi_off		rw	1		;non-maskable
nmi_seg		rw	1
;
brk_int_off	rw	1		;soft breakpoint inst.
brk_int_seg	rw	1
;
into_off	rw	1		;overflow
into_seg	rw	1
;
	org	16*4
;
;	z8030a SCC interrupt vectors
;
scc_vec		equ	((offset $) / 4)
;
scc_btbe_off	rw	1		;Ch-b transmit buffer empty
scc_btbe_seg	rw	1
;
		rw	2
;
scc_bes_off	rw	1		;Ch-b ext./status change
scc_bes_seg	rw	1
;
		rw	2
;
scc_brca_off	rw	1		;Ch-b receive character available
scc_brca_seg	rw	1
;
		rw	2
;
scc_bsrc_off	rw	1		;Ch-b special receive condition
scc_bsrc_seg	rw	1
;
		rw	2
;
scc_atbe_off	rw	1		;Ch-a transmit buffer empty
scc_atbe_seg	rw	1
;
		rw	2
;
scc_aes_off	rw	1		;Ch-a ext./status change
scc_aes_seg	rw	1
;
		rw	2
;
scc_arca_off	rw	1		;Ch-a receive character available
scc_arca_seg	rw	1
;
		rw	2
;
scc_asrc_off	rw	1		;Ch-a special receive condition
scc_asrc_seg	rw	1
		rw	2
;
;	z8031a ASCC interrupt vectors
;
ascc_vec	equ	((offset $) / 4)
;
ascc_btbe_off	rw	1		;Ch-b transmit buffer empty
ascc_btbe_seg	rw	1
;
		rw	2
;
ascc_bes_off	rw	1		;Ch-b ext./status change
ascc_bes_seg	rw	1
;
		rw	2
;
ascc_brca_off	rw	1		;Ch-b receive character available
ascc_brca_seg	rw	1
;
		rw	2
;
ascc_bsrc_off	rw	1		;Ch-b special receive condition
ascc_bsrc_seg	rw	1
;
		rw	2
;
ascc_atbe_off	rw	1		;Ch-a transmit buffer empty
ascc_atbe_seg	rw	1
;
		rw	2
;
ascc_aes_off	rw	1		;Ch-a ext./status change
ascc_aes_seg	rw	1
;
		rw	2
;
ascc_arca_off	rw	1		;Ch-a receive character available
ascc_arca_seg	rw	1
;
		rw	2
;
ascc_asrc_off	rw	1		;Ch-a special receive condition
ascc_asrc_seg	rw	1
		rw	2
;
;	z8036a CIO interrupt vectors (non-status)
;
cio_vec		equ	((offset $) / 4)
;
cio_pa_off	rw	1		;Port-A vector (non-status)
cio_pa_seg	rw	1
;
		rw	2
;
cio_pb_off	rw	1		;Port-B vector (non-status)
cio_pb_seg	rw	1
;
		rw	2
;
cio_ct_off	rw	1		;C/T 1-3 vector (non-status)
cio_ct_seg	rw	1
;
;
	org	0100h			;ram area base address
;
;	monitor ram area
;
ram_base	equ	$		;start of monitor ram block
brkcnt		rw	1		;number of breakpoints
tcount		rw	1		;number of steps to trace
load_cs		rw	1		;hex file download cs-reg.
load_ds		rw	1
load_es		rw	1
load_ss		rw	1
;
	org	((offset $) + 15) and 0fff0h
;
;	register save area
;
axsave		rw	1
bxsave		rw	1
cxsave		rw	1
dxsave		rw	1
;
spsave		rw	1
bpsave		rw	1
;
sisave		rw	1
disave		rw	1
;
dssave		rw	1
essave		rw	1
;
rstack		equ	offset $	;stack set here so registers
					; can be saved by pushing
sssave		rw	1
cssave		rw	1
;
ipsave		rw	1
fsave		rw	1
;
;	Monitor equates
;
buflen		equ	80		;maximum length of line input buffer
bpmax		equ	16		;maximum number of breakpoints
bplen		equ	bpmax+bpmax	;length of breakpoint table
;
bptab		rb	bplen		;breakpoint table
linebuf 	rb	buflen+1	;line input buffer
;
end_ram		equ	$		;end of ram variables
;
mon_stack	equ	200h		;local stack on even boundry
;
;	End of Vic's box board equate module
;
