;****************************************************************************
;
;	HALLOWEEN LIGHTING PROGRAM FOR IASIS IA7301 COMPUTER
;
;****************************************************************************
;
; REVISION HISTORY:
;
; 1.0 -	10-31-87   GRH
;	INITIAL RENDERING
;
; 1.1 - 10-31-87   GRH
;	CHANGE DELAY CONSTANT TO SPEED UP ACTION
;
;****************************************************************************

OPORT	EQU	5000H		;OUTPUT PORT LOCATION
RAMSIZ	EQU	1024		;SIZE OF RAM IN BYTES

;----------------------------------------------------------------------------
;
;	CODE START
;
;----------------------------------------------------------------------------
	ORG	0100H
;
;   INIT
;
	LXI	H,OPORT		;TURN ON ALL PORT BITS
	MVI	M,0FFH
;
;   COMPUTE RANDOM NUMBER SEED
;
	LXI	H,0		;COMPUTE RANDOM NUMBER SEED USING RAM SUM
	LXI	B,RAMSIZ
	XRA	A
CSEED:	ADD	M
	INX	H
	DCR	C
	JP	CSEED
;
	DCR	B
	JP	CSEED
;
	STA	RANSEED
;
;   MAIN LOOP
;
MAINLP:	MVI	E,4*2		;DELAY 4 SECONDS
	CALL	DELAYN
;
;   COMPUTE BLINK NUMBER FROM SEED
;
	LDA	RANSEED
	ANI	3
	JZ	DO0
;
	CPI	2
	JC	DO1
	JZ	DO2
;
DO3:	MVI	C,0F7H
	JMP	BLKIT
;
DO0:	MVI	C,0FEH
	JMP	BLKIT
;
DO1:	MVI	C,0FDH
	JMP	BLKIT
;
DO2:	MVI	C,0FBH
;
BLKIT:	LXI	H,OPORT
	MOV	M,C
;
;   DELAY OFF
;
	CALL	DELAY
;
;   TURN BACK ON
;
	MVI	M,0FFH		;HL STILL HAS PTR
;
;   COMPUTE NEW RANDOM NUMBER
;
	LDA	RANSEED
	MOV	C,A
	RLC
	XRA	C
	RRC
	ADD	C
	STA	RANSEED
;
;   REPEAT
;
	JMP	MAINLP


;****************************************************************************
;
;	DELAY N 1/2 SECONDS SUBROUTINE
;	ENTRY-	E= NUMBER OF 1/2 SECONDS
;	EXIT -	E= 0
;
;****************************************************************************
DELAYN:
;
;   SAVE REGS
;
	PUSH	D
;
;   DELAY
;
	CALL	DELAY
;
;   IF COUNT EXHAUSTED THEN REPEAT
;
	POP	D
	DCR	E
	JNZ	DELAYN
;
;   DONE
;
	RET


;****************************************************************************
;
;	DELAY 1/2 SECOND SUBROUTINE
;
;****************************************************************************
DELAY:
;
;   SAVE REGISTER
;
	PUSH	D
;
;   INITIALIZE
;
	LXI	D,4000H
;
;   DELAY LOOP
;
DELAY1:	DCR	E
	JNZ	DELAY1
;
	DCR	D
	JNZ	DELAY1
;
;   DONE
;
	POP	D	;RESTORE
	RET


;############################################################################
;
;				DATA
;
;############################################################################
RANSEED: DB	0
