#define THEEND	0x00
#define ABSDATA	0x10
#define EXPR	0x20
#define SMLINT	0x30
#define SMLNEG	0x40
#define MEDINT	0x50
#define LCLSYM	0x60
#define GBLSYM	0x70
#define SPACE	0x80
#define USECOMN	0x90
#define CODEREF	0xa0
#define DATAREF 0xb0
#define SPECIAL	0xf0
#define BEXPR	0xf1
#define BREL	0xf2
#define LRGINT	0xf3
#define USECODE	0xf4
#define USEDATA	0xf5
#define STARTAD	0xf6
#define LRGCODE 0xf7
#define LRGDATA 0xf8
#define INTJSR	0xf9		/* interpreter call instruction */
#define NLINE	0xff

#define ADD	1
#define SUB	2
#define MUL	3
#define DIV	4
#define MOD	5
#define AND	6
#define OR	7
#define XOR	8
#define RSH	9
#define LSH	10
#define NOT	11 /* this must be the first unary op, and only unarys may follow */
#define NEG	12

#define H_MAGIC	0x1a04
#define H_OVROOT 0xf0fe
#define H_LIBRARY 0xf3f0

struct header {
	int h_magic;		/* magic number for object files */
	char h_name[8];		/* module name */
	unsigned h_code;	/* size of code in this module */
	unsigned h_data;	/* size of data in this module */
	unsigned h_static;	/* size of static storage in this module */
	unsigned h_local;	/* offset of start of local symbols */
	unsigned h_global;	/* offset of start of global symbols */
	unsigned h_end;		/* end of local symbols */
	unsigned h_next;	/* offset of next module in this file */
};

#define LBSIZE 102

struct library {
	int lb_magic;		/* magic number for library files */
	unsigned lb_next;	/* location of next dictionary block (128 boundary) */
						/* but not scaled (i.e. a byte position) */
	struct l_item {
		char li_name[8];	/* name of symbol */
		unsigned li_pos;	/* location within file */
	} lb_items[LBSIZE];
};

#define S_ABS		1
#define S_CODE		2
#define S_DATA		3
#define S_COMN		4
#define S_CMNREF	5
#define S_EXPR		6
#define S_UND		7
#define S_WEAK		8
#define S_TOKEN		127

#define S_FIXED 	0x01
#define S_SHORT 	0x02
#define S_UNNAMED	0x04
#define S_GLOBL 	0x08
#define	S_FUNC		0x10
#define S_OVSYM		0x20		/* overlay symbol in root */

struct lcltab {
	char l_type,l_flags;
	unsigned l_value;
	int	l_common;
};

struct gbltab {
	char g_type,g_flags;
	unsigned g_value;
	int	g_common;
	char g_name[8];
};
