Package Assembly Jlib86

	;-------------------------------------------
	;----	  Library for Janus 8086	----
	;----	    CP/M-86 Version		----
	;---- Copyright 1982,1983		----
	;---- RR Software, Madison WI		----
	;---- This source code may not be	----
	;---- distributed without permission.	----
	;---- However, code generated from this	----
	;---- library file is not protected.	----
	;---- (608) 244-6436			----
	;---- Last Modified 5/10/83		----
	;-------------------------------------------

	;------------------------------------------------------
	;---- This library is always loaded first by the   ----
	;---- linker, whether or not it was explictly      ----
	;---- WITHed.  The compiler implictly uses this    ----
	;---- library.  The library may be trimmed to      ----
	;---- include only those routines which are used.  ----
	;---- Be careful, however.  The compiler           ----
	;---- occasionally uses these routines in ways     ----
	;---- that are not obvious.  For instance,         ----
	;---- Function Returns and File handling are both  ----
	;---- done on the heap.  Therefore, the heap       ----
	;---- routines should NEVER be removed.  The error ----
	;---- message routines in this library use the     ----
	;---- string and integer put routines.  If you get ----
	;---- a non-working program after modifying this   ----
	;---- library, use the Disassembler to see if any  ----
	;---- of the entry points which you removed are    ----
	;---- being called.				   ----
	;------------------------------------------------------

	;-----------------------------
	;---- Initialization Code ----
	;-----------------------------

	;**** I M P O R T A N T   N O T E ****
	;The Code from this point until the end of the initialization
	;code (marked by a comment) cannot be modified without modifying
	;the linker internally.

	;Notes:
	;    8086 requires all parameters which reside in the code segment
	;    to be passed by Value if seperated Code and Data segments are to
	;    be maintained w/o 32 bit addresses.
	;    (Or passed by address with copy into the data segment)

	Jmp	Start
	DB	"Copyright 1982 - RR Software"
	DB	" P.O. Box 1512, Madison WI  53701"
start:  ;Set up the interupt vectors
	Mov	CX,DS	;Save DS value
	Mov	AX,0	;Set DS to zero so I can set the interrupt vector
	Mov	DS,AX
	Mov	BX,CS	;Get CS to put into the interrupt vectors
	Mov	[12h],BX ;Set INT 4 - the Overflow vector
	Mov	[10h],Overflow
	Mov	[2],BX	;Set INT 0 - the Divide Error vector
	Mov	[0],DivZero
	Mov	DS,CX	;Restore DS

	Mov	AX,SS	;Save old SS and SP
	Mov	[OldSS],AX
	Mov	[OldSP],SP
	Mov	AX,[6]	;Top of Data segment
	Dec	AX	;Put on word boundary
	Mov	SS,CX	;Set SS to DS
	Mov	SP,AX	;Set new SP

	Mov	AX,0h		;0h = End of Static Data Section
				;(Patched by the linker)
	Mov	[Heap_Ptr],AX	;Initialize the Heap Pointer
	Mov	[Heap_Bot],AX	;and set the heap bottom
	Xor	AX,AX		;Clear the accumulator
	Mov	[File_Chain],AX	;Set the File Chain to Null
	Mov	[Free_Chain],AX	;Set the Free Chain to empty

	;Initialize the Standard Input and Output Files
	Call	New_Ptr
	DW	File_mask	;Size of the file object
				;Get a block off the heap for standard_output
	Mov	[Output_File],AX ;Set Standard_Output to the file
	Xchg	AX,BX
	Mov	Byte([BX+Ftype]),1	;Console Device
	Mov	Byte([BX+Fmode]),2	;W/O Mode
	Mov	Byte([BX+Eof_Flag]),0	;Not EOF
	Call	New_Ptr
	DW	File_Mask	;Size of the file object
				;Get a block off the heap for standard_input
	Mov	[Input_File],AX	;Set Standard_Input to the file
	Xchg	AX,BX
	Mov	Byte([BX+Ftype]),1	;Console Device
	Mov	Byte([BX+FMode]),1	;R/O Mode
	Mov	Byte([BX+Eof_Flag]),0	;Not EOF
	Mov	Word([BX+Buf_Ptr]),0	;Buffer Empty

Chain_Start:			;A chained program starts here
	Xor	AX,AX		;Clear the acc.
	Mov	[RetList],AX	;Set the Return List Pointer to Null
	Mov	[RetEnd],AX	; and the Return List End Pointer
	Mov	[Lineno],AX	;Set line number to none used
	Push	AX		;Nil = End of the dynamic Chain
	Mov	[PchainPtr],SP	;Start of Dynamic Chain {Used for walkbacks
				;and exception handling}
	Push	AX		;Line Number of call of main program = 0
	Push	AX		;End of return chain = Null
	Mov	AX,Main_Name
	Push	AX		;Name of Main Program

	;Initialize the Display Pointers
	Mov	[DispStart],0
	Mov	[DispStart+2],0
	Mov	[DispStart+4],0

	;Test for presence of 8087 (which also initializes it)
	Mov	[Have_8087],0	;Don't have 8087 until test succeeds
	Mov	[Stat_8087],0FFFFh
	Mov	[Stat_8087+2],0FFFFh
				;Set to some other value than the correct one
				;Must use a time delay, since wait hangs
				;some systems
	Esc	28,3		;FINIT
	Mov	CX,0
	Mov	CX,0		;Wait 8 clocks
	Esc	13,0		;Fld1	(Loads 1)
	Mov	CX,3
Me1:	Loop	Me1		;Wait at least 21 clocks
	Esc	1Bh,[Stat_8087]	;Fistp	(Stores 1 in memory long_integer,
				;which INTEL calls short_integer)
	Mov CX,20
Me2:	Loop	Me2		;Wait at least 100 clocks
	Cmp Word([Stat_8087]),1	;Test to see if Stat = 00000001
	Jne	Not8087
	Cmp	Word([Stat_8087+2]),0
	Jne	Not8087
	Mov	[Have_8087],1    ;Yes, have 8087
Not8087:
	;** Code Beyond this point may be modified **
	jmp	Pend	;Jump to the end of the package

	DSEG		;Data Area

	;Externally Defined Data
;DispStart:	RW	11	;Display 'registers' (0 and 1 not used)
;LineNo:	RW	 1	;Current Line Number (Set by LnoCode)
;File_Chain:	RW	 1	;The Chain of Files used to close all open
				;files at Termination
;Have_8087:	RB	 1	;1-If 8087 present; 0-otherwise

	;Internally Defined Data (Private)
RetList: RW	1	;Current Return List Pointer (Used for return values
			;larger than can fit in a register)
RetEnd: RW	1	;Current End of Return List Pointer (Used to insure
			;that the parameters, etc. are not freed before they
			;are no longer needed
Heap_Ptr: RW	1	;Current Heap Pointer
Heap_Bot: RW	1	;Bottom of the Heap (used to verify that pointers
			; actually point into the heap).
Free_Chain : RW	1	;Free chain of disposed blocks
PchainPtr: RW	1	;Current Dynamic Chain Pointer
OldSS: 	RW	1	;Stack Segment upon entry to this program
OldSP:	RW	1	;Stack Pointer upon entry to this program
			;used by program return.
Stat_8087: RW	2	;8087 Status value

	;-------------------------------------------------------------
	;---- Current Default I/O files for Get, Put and New_Line ----
	;-------------------------------------------------------------
	;These are Externally Defined in the Data Segment
	;Pointers to file blocks
	
;Input_File:  RW   1
;Output_File: RW   1

	CSEG	;In code space
	;---------------------------------------
	;---- Enumeration Table for Boolean ----
	;---------------------------------------
Proc Bool_Tab	;So it can be accessed externally - Ugh!
	dw F1,T1
F1:	db	5,'FALSE'
T1:	db	4,'TRUE'
	db	4,'RLB '
	dw	0,0,0
End Proc Bool_Tab

	;The Entry Points	
	;EHalt		- 1
	;PrgRet		- 2
	;PChain		- 3
	;NotUsed4	- 4
	;Exp2		- 5
	;Mod2		- 6
	;NotUsed7	- 7
	;NotUsed8	- 8
	;NotUsed9	- 9
	;NotUsed10	-10
	;NotUsed11	-11
	;NotUsed12	-12
	;NotUsed13	-13
	;NotUsed14	-14
	;NotUsed15	-15
	;NotUsed16	-16
	;NotUsed17	-17
	;NotUsed18	-18
	;Member1	-19
	;Member2	-20
	;SMember1	-21
	;SMember2	-22
	;ECWrite	-23 - Code Seg write
	;CSAssign	-24 - Code Seg String Assignment
	;Copy_Str	-25
	;NotUsed26	-26
	;NotUsed27	-27
	;NotUsed28	-28
	;NotUsed29	-29
	;NotUsed30	-30
	;Sour_Err	-31
	;Range1		-32
	;Range2		-33
	;SRange1	-34
	;SRange2	-35
	;EErr_Exit	-36
	;Null_Ptr	-37
	;Str_Bound	-38
	;CaseErr	-39
	;GetInt		-40
	;EPut_Str	-41
	;Put_CStr	-42
	;NotUsed43	-43
	;NotUsed44	-44
	;EPutInt	-45
	;PutHex		-46
	;EPutIntW	-47
	;EPutEnum	-48
	;EPutEnumW	-49
	;NotUsed50	-50
	;ProcInit	-51
	;ProcFin	-52
	;EClose		-53
	;RPlcByte	-54
	;SLt		-55
	;SLe		-56
	;SEq		-57
	;SNeq		-58
	;SGe		-59
	;SGt		-60
	;Sassign	-61
	;Concat		-62
	;EVWrite	-63
	;ERead		-64
	;EWrite		-65
	;ENew_Line	-66
	;ESkip_Line	-67
	;Func_Release	-68
	;Func_Ret	-69
	;EFile_Name	-70
	;New_Ptr	-71
	;EMemAvail	-72
	;EMaxAvail	-73
	;EDispose	-74
	;EDispose	-74
	;FError_chk	-75

	;-------------------------------------------
	;---- Error Handlers for Hardware Traps ----
	;-------------------------------------------

	;Arithmetic Overflow Handler
Overflow: Mov	AX,Str20
	Call	WCstr	;'Arithmetic Overflow Detected'
	Jmp	Err_Exit
Str20:	DB	31,'** Arithmetic Overflow Detected'

	;Divide Error Handler (Should only occur at a Divide by Zero)
DivZero:  Mov	AX,Str21
	Call	WCstr	;'Divide By Zero Detected'
	Jmp	Err_Exit
Str21:	DB	27,'** Divide By Zero Detected'

	;--------------------------------------
	;---- Integer, Boolean, and Relops ----
	;--------------------------------------

	;Integer Modulus
	;Dividend in AX, Divisor in BX (AX Mod BX)
	;Result in AX
	;Kills AX and DX
Proc Mod2	
	Cwd		;Convert Word in AX to DoubleWord
	IDiv	BX	;Divide
	Mov	AX,DX
	Xor	AX,BX	;Compare the sign of the divisor and remainder
	JNs	MDone	;Done if the signs are the same
	Cmp	DX,0	;Done if Remainder = 0
	Jz	MDone
	Add	DX,BX	;Add Divisor to Remainder
MDone:	Mov	AX,DX
	Ret
End Proc Mod2

	;Integer Exponentiation
	;AX ** BX - Result in AX
	;Kills All
Proc Exp2
	Cmp	BX,0	;Is the exponent < 0
	JL	ExpErr
	Mov	CX,BX
	Xchg	AX,BX
	Mov	AX,1	;Start with return value = 1
	Jcxz	ExpDone
ExpLoop:Imul	BX	;Multiply once
	Jo	ExpDone	;Quit If Overflow (Value incorrect, but who cares?)
	Loop	ExpLoop
	;Done when CX = 0 or Overflow flag set
ExpDone:Ret
ExpErr:	Push	BX
	Mov	AX,ExpMess
	Call	WCstr
	Pop	AX
	Call	Wint
	Jmp	Err_Exit
ExpMess:Db	42,'** Cannot Exponentiate by Negative Value = '
End Proc Exp2

	;---------------------------------------
	;---- Comparision tests for strings ----
	;---------------------------------------

IsFalse: Xor AL,AL	;Clear AL
	Ret
IsTrue: Mov AL,1	;Set result to True
	Ret

	;Compare the strings pointed at by AX and BX for equality
Proc Seq
	Mov	SI,AX	;Put AX where we can use it
	Mov	AL,[BX]	;get BX's length byte
	Cmp	[SI],AL	;compare AX's to it
	Jnz	Isfalse	;Not equal if length's are different
	Mov	DI,BX
	Mov	CL,AL
	Xor	CH,CH	;Clear upper byte
	Inc	CX
	Cld		;Count Up
	Repe
	Cmpsb		;Compare String
	Jnz	IsFalse
	Jmp	IsTrue
End Proc Seq

	;Compare the strings pointed at by AX and BX for inequality
Proc SNeq
	Call	Seq	;Equality Test
	Sub	AL,2
	Not	AL	;And negate
	Ret
End Proc SNeq
	
	;Compare the strings pointed at by AX and BX
	;Return 0 if equal, 1 if AX > BX, -1 (255) otherwise
StrCmp: Mov	SI,AX	;Put it where we can use it
	Mov	AL,[BX]
	Cmp	AL,[SI]
	Jb	Strcmp2
	Je	Strcmp3
	;If strings equal, return value stored in DL (which is longer)
	Mov	DL,255	;AX is shorter
	Mov	CL,[SI]	;Get the length of the shorter string
	Jmp	strcmp4
strcmp2:Mov	DL,1	;AX is longer
	Mov	CL,AL	;Get the length of the shorter string
	Jmp	strcmp4
strcmp3:Mov	DL,0	;Same length
	Mov	CL,AL	;Get the length of the strings
strcmp4:Xor	CH,CH	;Clear upper byte of count
	Jcxz	Strdone ;Don't Loop If count is 0 (Strings Equal this far)
	Mov	DI,BX
	Inc	DI
	Inc	SI	;Bump Pointers
	Cld		;Count Up
	Repe
	Cmpsb		;Compare strings
	Ja	Strdone2;AX > BX
	Je	Strdone	;AX = BX
	Mov	AL,255	;AX < BX
	Ret
strdone2: Mov	AL,1	;AX > BX
	Ret
strdone: Mov	AL,DL	;Get the value in DL (which is longer)
	Ret		;and return it
	
	;Compare the strings pointed at by AX and BX for AX < BX
Proc SLt
	Call	StrCmp
	Cmp	AL,255	;LT if A=255
	Jz	IsTrue
	Jmp	IsFalse
End Proc SLt

	;Compare the strings pointed at by AX and BX for AX <= BX
Proc SLe
	Call	StrCmp
	Cmp	AL,1	;GT if A=1
	Jz	IsFalse
	Jmp	IsTrue
End Proc SLe

	;Compare the strings pointed at by AX and BX for AX > BX
Proc SGt
	Call	StrCmp
	Cmp	AL,1	;GT if A=1
	Jz	IsTrue
	Jmp	IsFalse
End Proc SGt

	;Compare the strings pointed at by AX and BX for AX >= BX
Proc SGe
	Call	StrCmp
	Cmp	AL,255	;LT if A=255
	Jz	IsFalse
	Jmp	IsTrue
End Proc SGe

	;String Assignment
	;Source - SI, Dest - DI, Max Destination Length - Parameter
	;Data Segment Source
	;Kills All
Proc Sassign
	Pop	BX	;Get Return Address
	Seg	CS
	Mov	AH,[BX]	;Get Length of Destination variable
	Inc	BX
	Push	BX	;Store Return Address
	Mov	AL,[SI]	;Get length of source string
	Cmp	AH,AL
	Jae	StrOK	;String will fit
	Push	AX	;Save string length
	Mov	AX,Str12 ;String is too long
	Call	WCStr
	Pop	AX
	Xor	AH,AH	;Make an Integer out of the length
	Call	Wint
	Jmp	Err_Exit
Str12:  db	42,'** String Too Long for Variable, Length = '
StrOK:	Xor	CH,CH	;Clear CH
	Mov	CL,AL
	Inc	CX	;Move string length + 1 characters from HL to DE
			;Just in case the length is 255 (FF hex) (not Inr C)
	Cld		;Count UP
	Rep
	Movsb		;Blkmove
	Ret
End Proc Sassign

	;String Assignment
	;Source - SI, Dest - DI, Max Destination Length - Parameter
	;Code Segment Source
	;Kills All
Proc CSassign
	Pop	BX	;Get Return Address
	Seg	CS
	Mov	AH,[BX]	;Get Length of Destination variable
	Inc	BX
	Push	BX	;Store Return Address
	Seg	CS
	Mov	AL,[SI]	;Get length of source string
	Cmp	AH,AL
	Jae	CStrOK	;String will fit
	Push	AX	;Save string length
	Mov	AX,Str12 ;String is too long
	Call	WCStr
	Pop	AX
	Xor	AH,AH	;Make an Integer out of the length
	Call	Wint
	Jmp	Err_Exit
CStrOK:	Xor	CH,CH	;Clear CH
	Mov	CL,AL
	Inc	CX	;Move string length + 1 characters from HL to DE
			;Just in case the length is 255 (FF hex) (not Inr C)
	Cld		;Count UP
	;Cannot use 2 prefixes on Movsb if Interupts can happen (See Intel
	;Manual)
CStrLoop: Seg	CS
	Movsb		;Blkmove
	Loop	CStrLoop
	Ret
End Proc CSassign

	;Copy the constant string at CS:SI into a ret_list
	;block in the data segment
	;Used for string parameters and expressions, which are assumed
	;to be in DS
	;Kills SI and DI
	;Returns the new pointer in AX
Proc Copy_str
	Push	SI	;Following Entry Kills SI
	Seg	CS
	Mov	AL,[SI]
	Xor	AH,AH	;Get a block the size of the string
	Inc	AX
	Call	Cat_Entry ;Get the block - Address of block in AX upon return
	Pop	SI
	Mov	DI,AX
	Push	CX
	Seg	CS
	Mov	CL,[SI]	;Move size of string + 1 characters
	Xor	CH,CH
	Inc	CX	;Move CX characters
	Cld		;Count Up
	;Cannot have 2 prefixes (see above)
CopyLoop: Seg	CS
	Movsb
	Loop	CopyLoop
	Pop	CX
	Ret
End Proc Copy_Str

	;Test string bounds to see if indexed character exists
	;Kills SI and DI
	;AX - index value; BX - String address; String Var Length - Param
Proc Str_Bound
	Pop	SI
	Seg	CS
	Mov	CL,[SI]	;Get the Param
	Inc	SI
	Push	SI
	Cmp	AH,0	;Is the index between 0 and 255?
	Ja	Rng_Err	;Range error handler
	Cmp	AL,CL
	Ja	Rng_Err	;Range error handler
	Mov	CH,[BX]	;Is the index in the variable?
	Cmp	AL,CH
	Ja	SSkip
	Ret		;No error - string is long enough
Rng_err:Push	AX	;Range Error
	jmp	r2err	;In the range checks
SSkip:	Push	AX	;Save the index
	Push	CX	;Save the string length
	Mov	AX,str13
	Call	WCstr
	Call	Wcrlf
	Mov	AX,str14
	Call	WCstr
	Pop	AX	;Get string length
	Mov	AL,AH
	Xor	AH,AH
	Call	wint	;And print it
	Mov	AX,str15
	Call	WCstr
	Pop	AX	;Get index in error
	Call	wint	;And print it
	Jmp	Err_Exit
Str13:	db	57,'** Attempt to Access a Character outside of String Bounds'
Str14:	db	24,'Current String Length = '
Str15:	db	20,'  Character Index = '
End Proc Str_Bound

	;String Concat
	;The address of the left hand string is in AX, and the address
	;of the right hand string is in BX.  The address of the returned
	;string (which is allocated on the heap by Func_Ret) is in AX
	;upon return
	;Kills all
Proc Concat
	Mov	SI,AX	;Put the left hand string where it can be used
	Mov	AL,[SI]	;Get the string length (of string two)
	Add	AL,[BX]	;Add the length of the first string
	Jb	Conerr	;String is longer than 256 characters
			;Actually testing carry flag
	;Following Call Kills AX and SI
	Push	SI
	Push	AX
	Xor	AH,AH
	;Get the return slot - AX bytes long
	Inc	AX	;Add room for length byte
	call	Cat_Entry ;Concat entry into Func_Ret to allocate the block
	Mov	DI,AX	;Put block addr in Dest
	Pop	AX
	Pop	SI
	Push	DI	;Save the result address
	;Store the length byte
	Mov	[DI],AL
	Mov	CL,[SI]	;Get the length of the first string
	Xor	CH,CH
	Inc	SI
	Inc	DI
	Cld		;Count Up
	Rep
	Movsb		;Get the first string
	Mov	SI,BX
	Mov	CL,[SI]	;Get the length of the second string
	Inc	SI
	Rep
	Movsb		;Move the second string
	Pop	AX	;Return the starting address
	Ret
Conerr: Mov	AX,Str16
	Call	WCstr
	Jmp	Err_Exit
Str16:	db	29,'** Strings too long to Concat'
End Proc Concat

	;------------------------------
	;---- Membership Operators ----
	;------------------------------

RngFalse:	;Return False for a membership op.
	Xor	AL,AL
	Ret

	;Membership Ops Range Test for Bytes
	;Value to test in AL
	;Kills All - Returns Boolean in AL
	;Args Follow Call dw - Offset; db - level
Proc Member1
	Pop	SI	;Get return address
	Seg	CS
	Mov	DI,[SI] ;Get Offset
	Inc	SI
	Inc	SI
	Seg	CS
	Mov	BL,[SI] ;Get Level
	Inc	SI
	Push	SI
	Xor	BH,BH
	Add	BX,BX
	Add	DI,[BX+DispStart]
			;Add display pointer to Offset to get address
	;Range Test
	Cmp	AL,[DI]
	JB	RngFalse ;Not in range if Below than low bound
	Cmp	AL,[DI+1]
	JA	RngFalse ;Not in range if Above than high bound
	Mov	AL,1
	Ret
End Proc Member1
		
	;Membership Ops Range Test for Integers
	;Kills All - Returns Boolean in A
	;Args Follow Call dw - Offset; db - level
Proc Member2
	Pop	SI	;Get return address
	Seg	CS
	Mov	DI,[SI] ;Get Offset
	Inc	SI
	Inc	SI
	Seg	CS
	Mov	BL,[SI] ;Get Level
	Inc	SI
	Push	SI
	Xor	BH,BH
	Add	BX,BX
	Add	DI,[BX+DispStart]
			;Add display pointer to Offset to get address
	;Range Test
	Cmp	AX,[DI]
	JL	RngFalse ;Not in range if Less than low bound
	Cmp	AX,[DI+2]
	JG	RngFalse ;Not in Range if Greater than high bound
	Mov	AL,1
	Ret
End Proc Member2

	;Membership Ops Constant Range Test for Bytes
	;Value to test in AL
	;Kills All - Returns Boolean in AL
	;Args Follow Call dw - Address (in Code Segment)
Proc SMember1
	Pop	SI	;Get return address
	Seg	CS
	Mov	DI,[SI] ;Get Address
	Inc	SI
	Inc	SI
	Push	SI
	;Range Test
	Seg	CS
	Cmp	AL,[DI]
	JB	RngFalse ;Not in range if Below than low bound
	Seg	CS
	Cmp	AL,[DI+2] ;Range is formatted as integers.
	JA	RngFalse ;Not in range if Above than high bound
	Mov	AL,1
	Ret
End Proc SMember1
		
	;Membership Ops Constant Range Test for Integers
	;Value to test in AX
	;Kills All - Returns Boolean in AL
	;Args Follow Call dw - Address (in Code Segment)
Proc SMember2
	Pop	SI	;Get return address
	Seg	CS
	Mov	DI,[SI] ;Get Address
	Inc	SI
	Inc	SI
	Push	SI
	;Range Test
	Seg	CS
	Cmp	AX,[DI]
	JL	RngFalse ;Not in range if Less than low bound
	Seg	CS
	Cmp	AX,[DI+2]
	JG	RngFalse ;Not in Range if Greater than high bound
	Mov	AL,1
	Ret
End Proc SMember2


	;Check 8087 for floating point errors.  Print error message if error.
	;Kills no registers
Proc FError_chk
	Cmp	Byte([Have_8087]),0
	Je	FErr_Done	;No 8087
	Wait
	Esc	2Fh,[Stat_8087]	;Fstsw
	Wait			;Get whole status before continuing
	Test	Word([Stat_8087]),01101B
	Jz	FErr_Done	;No error flags set
	Test	Word([Stat_8087]),01000B
	Jnz	FOverflow
	Test	Word([Stat_8087]),00100B
	Jnz	FZeroDiv
	Jmps	FInv_Op		;Must be invalid operation
FErr_Done: Ret			;Must have this here, as it gets too far
				; away otherwise
	;Invalid operation handler
FInv_Op:Mov	AX,Str25
	Call	WCstr	;'8087 Bad Operand or Expression too Complex'
	Jmp	Err_Exit
Str25:	DB	45,'** 8087 Bad Operand or Expression too Complex'
	;Floating Overflow Handler
FOverflow: Mov	AX,Str26
	Call	WCstr	;'8087 Arithmetic Overflow Detected'
	Jmp	Err_Exit
Str26:	DB	36,'** 8087 Arithmetic Overflow Detected'
	;Floating Zero Handler
FZeroDiv: Mov	AX,Str27
	Call	WCstr	;'8087 Divide by Zero Detected'
	Jmp	Err_Exit
Str27:	DB	31,'** 8087 Divide by Zero Detected'
End Proc FError_chk

	;----------------------------
	;---- JANUS Program Exit ----
	;----------------------------

	;Terminate Routine
	;This Routine contains all of the operations to be performed on
	;program termination.  This is only the closing of open files in
	;JANUS, however, in a customized, ROM based environment, it might
	;be necessary to turn certain devices off on a Halt, or simply
	;start the program over (as in a dedicated controller).  The MS-DOS
	;<Ctrl>-C interrupt also comes here.
Terminate: ;Close all open files
	;While File_Chain /= Null Loop
	;   Close(File_Chain); -- Close deletes the file from the chain
	;End Loop;
	;-- Note that Standard_Input and Standard_Output are not on the chain
TLoop:	Mov	AX,[File_Chain]
	Cmp	AX,0		;Have all of the files been closed?
	Jnz	TSkip
	Ret
TSkip:	Call	EClose		;Close the file
	Jmp	TLoop

	;Halt program
	;Halts the currently running program, including all programs which
	;called this one
Proc EHalt
	Call	Terminate	;Take the terminate actions
	Mov	AX,[OldSS]	;Restore the SS and SP
	Mov	SS,AX
	Mov	SP,[OldSP]
	Mov	AX,4424h	;Abort Return (non-zero value to Prog_Call)
				;Doesn't matter if it is some other program
	Retf			;Return to the program
End Proc EHalt

	;Return Program
	;Terminates this program, and returns control to the program which
	;called this one.
Proc PrgRet
	Call	Terminate
	Mov	AX,[OldSS]	;Restore the SS and SP
	Mov	SS,AX
	Mov	SP,[OldSP]
	Mov	AX,0		;Normal Return (to Prog_Call)
	Retf			;Return to the program
End Proc PrgRet

	;Chain Program
	;Chains a program in place of the currently running one.
	;This code is assumed to be in the same place in both the chaining
	;and chained program.  The heap is also saved.
	;CX is assumed to contain the number of sectors to read
Proc PChain
	Push	ES
	Push	CX
	Mov	DX,CS		;Set buffer segment to CS
	Mov	CL,51
	Int	224
	Pop	CX
	Mov	DX,0h		;Starting address of read
PCLoop:	Push	CX
	Push	DX		;Save important registers
	Mov	CL,26
	Int	224		;Set the read address
	Mov	DX,5Ch		;File FCB address
	Mov	CL,20		;Read Sector
	Int	224
	Pop	DX
	Pop	CX
	Add	DX,80h		;Next sector
	Loop	PCloop		;Go around again if reading not done
	Mov	DX,DS		;Set buffer segment back to DS
	Mov	CL,51
	Int	224
	Pop	ES		;Restore the register
	Mov	AX,[6]		;Reset the stack pointer
	Dec	AX		;Put on a word boundary
	Mov	SP,AX
	Jmp	Chain_Start	;Set up the registers
End Proc PChain

	;-------------------------------------------
	;---- Procedure Entry and Exit Routines ----
	;---- (Set up of Stack)			----
	;-------------------------------------------

	;	|    Activation Record i-1		|
	;	|					| <-- Disp_Val[i-1]
	;	|---------------------------------------|
	;	|					|
	;	|  In Progress Expressions (optional)	|
	;	|					|
	;	|---------------------------------------|
	;	|					|
	;	|  Parameters (optional)		|
	;	|					|
	;	|---------------------------------------|
	;	|  Return Address (Word)		|
	;	|---------------------------------------|
	;	|  Old Display Pointer (Word)		|
	;	|---------------------------------------|
	;	|					|
	;	|					|
	;	|  Activation Record for i		|
	;	|					|
	;	|					|
	;	|---------------------------------------| <--  Disp_Val[i]
	;	| Dynamic Chain Pointer = Disp_Val[i-1]	|
	;	|---------------------------------------|
	;	| Line Number of Proc/Func Call		|
	;	|---------------------------------------|
	;	| Old Return Chain End			|
	;	|---------------------------------------|
	;	| Proc/Func Name Pointer (Word)		|
	;	| Also Exception Handler Pointer	|
	;	|---------------------------------------| <-- SP

	;Initialize of Procedure (Proc Entry)
	;Kills AX and DX (No regs should be in used at this entry
Proc ProcInit
	Mov	DX,[PChainPtr]	;Get the chain address of the last proc
	Pop	BX		;Get the return address off the stack,
	Push	DX		;and put the chain address on the stack
	Mov	[PChainPtr],SP	;Save Old Sp as current chain Pointer
	Push	[LineNo]	;Save line number of call
	Push	[RetEnd]	;Save Old Return End
	Mov	AX,[RetList]	;Set the RetEnd to the Current RetList
	Mov	[RetEnd],AX
	Push	BX		;Save return address
	Jmp	StkOver		;Check for stack overflow (StkOver will
				;return for ProcInit)
End Proc ProcInit

	;Finalize Proc
	;Kills BX and DX
Proc ProcFin
	Pop	BX	;Get return address
	Pop	DX	;Junk proc name ptr
	Pop	[RetEnd];Restore Old Return End
	Pop	[LineNo] ;Restore Line Number of Call
	Pop	[PChainPtr] ;Restore PChainPtr
	Jmp	BX	;Return (Addr is in BX)
End Proc ProcFin

	;-----------------------------------
	;----	Access Type Allocators	----
	;-----------------------------------

	;-- Heap Structure --

	;-- Data Segment --
	;---------------------------------
	;--  Static Data Area		--
	;---------------------------------
	;--  Allocated Heap Area	--
	;--  (Including Free Chain)	--
	;--------------------------------- <== Heap_Ptr
	;-- Free Heap/Stack Area	--
	;--------------------------------- <== SP
	;-- Stack (Local Data)		--
	;---------------------------------

	;Format of Free chain block
	;(0 = Null for pointers)
	;-----------------------------------------
	;--  Pointer at next block		--
	;-----------------------------------------
	;--  Size of Block			--
	;-----------------------------------------
	;--  Rest of Block (Size-4 Bytes)	--
	;-----------------------------------------

	;Allocate space for a access object, and check for heap overflow
	;Returns the new pointer in AX
	;Kills AX and BX
	;Number of bytes to allocate follows call
Proc New_Ptr
	Pop	BX
	Seg	CS
	Mov	AX,[BX]	;Get the number of bytes to allocate
	Inc	BX
	Inc	BX
	Push	BX	;Put return address back
Fun_All: ;An Entry for Func_Ret the blocks
	;Number of Bytes to Allocate is in AX

	;Return a block of size bytes
	;If Free_Chain = Null Then
	;    GoTo Get_from_top;
	;Else
	;    -- Search free chain for exact match
	;    Back := Free_chain'Address;
	;    Front := Free_chain;
	;    Loop
	;	If front.size = size Then -- Have a match
	;	    Back.next := front.next;  -- Remove block from chain
	;	    Return Front;
	;	Else
	;	    Exit When Front.next = Null;
	;	    Back := Front; -- Next Block
	;	    Front := Back.next;
	;	End If;
	;    End Loop;
	;    -- Search Chain for bigger block
	;    Front := Free_chain;
	;    Loop
	;	If front.size >= size + 4 Then -- Have a match
	;	    Front.size := Front.size - size; -- Remove block's space
	;	    Return Front + Front.size;
	;	Else
	;	    Exit When Front.next = Null;
	;	    Front := Front.next; -- Next Block
	;	End If;
	;    End Loop;
	;    <<Get_from_top>> -- Allocate from the top of the heap
	;    Front := Heap_Ptr;
	;    Heap_ptr := Heap_ptr + size;
	;    Check_for_overflow;
	;    Return Front;
	;End If;
	
	;Size =  AX
	;Back =  SI
	;Front = DI

	Cmp	Word([Free_Chain]),0	;If Free_Chain = Null Then
	Jz	Get_From_Top	;Goto Get_from_top
	Mov	SI,Free_Chain	;Back := Free_Chain'Address
	Mov	DI,[Free_Chain]	;Front := Free_Chain
	;Search chain for exact match
MLoop:	Cmp	AX,[DI+2]	;If front.size = size
	Jnz	MSkip		;Then -- Have a match
	Mov	BX,[DI]		;front.next
	Mov	[SI],BX		; =: back.next
	Mov	AX,DI		;Return Front
	Ret
Mskip:	Cmp	Word([DI]),0	;Exit When front.next = Null
	Jz	AStart
	Mov	SI,DI		;back := front
	Mov	DI,[SI]		;front := back.next
	Jmp	MLoop

	;Search chain for bigger block
AStart:	Mov	CX,AX
	Add	CX,4		;figure size + 4
	Mov	DI,[Free_Chain]	;Front := Free_Chain
ALoop:	Cmp	CX,[DI+2]	;If size+4 <= Front.size
	Ja	ASkip		;Then
	Sub	[DI+2],AX	;Front.size := Front.size - size
	Mov	AX,DI
	Add	AX,[DI+2]	;Return Front + Front.size
	Ret
ASkip:	Cmp	Word([DI]),0	;Exit When front.next = Null
	Jz	Get_from_top
	Mov	DI,[DI]		;front := front.next
	Jmp	ALoop

Get_from_top:	;<<Get_from_top>> -- Get block from top of heap, checking
		;for overflow
	Mov	BX,[Heap_Ptr]
	Add	AX,BX		;Allocate AX Bytes
	Mov	[Heap_Ptr],AX	;Save New Heap_Ptr
	Add	AX,64		;Need 64 bytes leaway
	Cmp	SP,AX
	JB	HeapOver
	Xchg	AX,BX		;Return the value in BX, so put it in AX
	Ret
HeapOver:	;Heap Overflow
	Mov	AX,Str11
	Call	WCstr	;'Heap Overflow'
	Jmp	Err_Exit
Str11:	db	16,'** Heap Overflow'
End Proc New_Ptr

	;-------------------------------------------
	;---- Return of large objects routines	----
	;---- These entries allocate and	----
	;---- release space on the return list, ----
	;---- used for returing objects larger	----
	;---- than 2 bytes.			----
	;-------------------------------------------

	;Allocate a block of param byes long for a return
	;Link it into the return list.
	;The result pointer is in AX
	;Kills AX, DI, and SI
	;The format of a return block is:
	; | Size (2 Bytes) | <- Address in RetList
	; |----------------|
	; | Next Blk (2 B) |
	; |----------------|
	; | Return Data    | <- Address returned to user
Proc Func_Ret 
	Pop	DI
	Seg	CS	;Get the parameter
	Mov	AX,[DI]
	Inc	DI!Inc DI
	Push	DI	;Save Return Address
Cat_Entry: ;Entry for concat (Get a Block with the size in AX)
	Push	BX	;Save BX, in Case it holds good information
	Add	AX,4	;Allocate 4 Extra Bytes (for system use)
	Push	AX	;Save the size
	Call	Fun_all	;A special entry in Allocate just for this purpose
	Mov	SI,[RetList]	;Get the old Return Chain Address
	Mov	[RetList],AX	;Set the Head of the return list to the new
				;pointer
	Xchg	AX,BX	;Get the pointer address into BX
	Pop	[BX]	;Store the size in the block
	Mov	[BX+2],SI ;Store the next chain address in the block
	Xchg	AX,BX
	Pop	BX	;Get the saved BX
	Add	AX,4	;Return a pointer 4 greater than the one I got
	Ret
End Proc Func_Ret

	;Free the blocks on the Return List.
	;Kills All
	;Is done only up to the pointer, Ret_End - This keeps
	;objects from being released when they are still needed.  Example:
	;PCall(Str & Str2);  -- In PCall The parameter Str & Str2 could
	;be released even though it is still needed.
Proc Func_Release
	;Loop
	;  If RetList = RetEnd Then
	;	Return;
	;  Else
	;	temp := RetList;
	;	RetList := RetList.ptr;
	;	Dispose(temp);
	;  End If;
	;End Loop;

	Mov	BX,[RetList]
	Cmp	BX,[RetEnd]	;Test for Return Chain End
	Jz	FDone
	;Release a block
	Mov	BX,[RetList]
	Mov	AX,[BX+2]	;RetList.ptr
	Mov	[RetList],AX	; =: RetList
	Mov	AX,[BX]		;Get temp.size for Dispose
	Call	Dispose		;Toss the block
	Jmp	Func_Release	;Go around again

FDone:	Ret
End Proc Func_Release

	;Memory Available
	;Returns the amount of memory available in AX
Proc EMemAvail
	Mov	AX,SP		;Get the top of unused memory address
	Sub	AX,[Heap_Ptr]	;Subtract the heap pointer, leaving the
				;memory left
	Ret			;Return the result in AX
End Proc EMemAvail

	;Maximum Memory Available (including disposed area)
	;Returns the amount of memory available in AX
Proc EMaxAvail
	Mov	AX,SP		;Get the top of unused memory address
	Sub	AX,[Heap_Ptr]	;Subtract the heap pointer, leaving the
				;memory left
	;Now add the memory on the free chain to it
	Mov	BX,[Free_Chain]	;Load the head of the free chain
	Mov	DX,BX		;Let the free chain be available in DX
				;(Only for testing of dispose)
CLoop:	Cmp	BX,0
	Je	EMaxDone	;Quit when the return chain is Null
	Add	AX,[BX+2]	;Add the block size to max_avail
	Mov	BX,[BX]		;Move down the chain
	Jmp	CLoop
EMaxDone: Ret
End Proc EMaxAvail

	;Dispose of a block of heap space.
	;The pointer to the pointer to the block is in AX.
	;The size of the block is in BX.
	;Kills All
	;The pointer to the block is set to Null by this procedure
Proc EDispose
	;addr := param.addr;
	;param.addr := Null;	-- Set the disposed pointer to Null
	;If addr = Null Then Return; End If;
	;If size + addr = Top_of_heap Then
	;    Top_of_heap := addr;
	;    -- Check to see if the last block may be merged
	;    If Free_Chain = Null Then
	;	Return;
	;    Else
	;	Back := Free_Chain'Address;
	;	Front := Free_chain;
	;	Loop
	;	    If Front.next := Null Then -- Reached end of chain
	;		If Front + Front.size = Top_of_heap Then
	;		    Top_of_Heap := Front;
	;		    Back.Next := Null;
	;		End If;
	;		Return;
	;	    Else
	;		-- On to next block
	;		Back := Front;
	;		Front := Back.Next;
	;	    End If;
	;	End Loop;
	;    End If;
	;Else
	;    Back := Free_Chain'Address;
	;    Front := Free_Chain;	-- Fudge to avoid duplicated code
	;    GoTo Entry;	-- The first if test cannot be performed
	;			-- For the first block
	;    Loop
	;	-- On to next block
	;	Back := Front;
	;	Front := Back.Next;
	;	If back.size + back = addr Then -- Can do a back merge
	;	    back.size := back.size + size;
	;	    If back.size + back = front Then -- Can do a front merge
	;		-- Front cannot be null
	;		back.size := back.size + front.size;
	;		back.next := front.next;
	;	    End If;
	;	    Return;
	;	End If;
	;    <<Entry>> If Front = Null Then  -- End of chain reached
	;	    Back.next := Addr;
	;	    Addr.Size := Size;
	;	    Addr.Next := Null;
	;	    Return;
	;	Elsif addr < Front Then -- Insert the block here
	;	    Addr.size := Size;
	;	    Addr.next := Front;
	;	    Back.next := Addr;
	;	    If addr + size = front Then -- Merge Front Blocks
	;		Addr.size := size + front.size;
	;		Addr.next := front.next;
	;	    End If;
	;	    Return;
	;	End If;
	;    End Loop;
	;End If;

	;Back = SI
	;Front = DI
	;Size = AX
	;Addr = BX

	Xchg	AX,BX	;Get AX and BX to conform to above
	Mov	CX,[BX]	;Get the actual pointer
	Mov	Word([BX]),0	;Set the actual pointer to Null
	Cmp	CX,0	;If the pointer is Null, then quit
	Jnz	DSkip
	Ret
DSkip:	Mov	BX,CX	;Put the pointer to the block into BX
	;Address in BX, Size in AX
	;Entry Point for Release Return Chain
Dispose:Mov	DX,AX	;Move Size to DX
	Add	DX,BX	;Find out if the block is at the end of the Heap
	Cmp	DX,[Heap_Ptr]
	Jne	DChain	;Not same, must add to Dispose chain
	Mov	[Heap_ptr],BX	;Mark the end of the heap the same as this
				;block
	;Run down the free chain to check if the last block can be merged
	Cmp	Word([Free_Chain]),0
	Jne	Check_Blk
	Ret			;No chain to check
Check_Blk: Mov	SI,Free_Chain	;Back := Free_Chain'Address
	Mov	DI,[Free_Chain]	;Front := Free_Chain
Check_Loop: Cmp	Word([DI]),0	;If Front.next = Null Then
	Jne	Chk2
	Mov	AX,[DI+2]	;If front.size
	Add	AX,DI		; + front
	Cmp	AX,[Heap_Ptr]	; = Top_of_heap
	Jne	CDone		;Then
	Mov	[Heap_Ptr],DI	;Top_of_heap := Front
	Mov	Word([SI]),0	;Back.next := Null
CDone:	Ret			;Return;
Chk2:	Mov	SI,DI		;Back := Front; -- On to next block
	Mov	DI,[SI]		;Front := Back.Next
	Jmp	Check_Loop

DChain: ;Add block to free chain (or merge it)
	Mov	SI,Free_Chain	;Back := Free_Chain'Address
	Mov	DI,[Free_Chain]	;Front := Free_Chain
	Jmp	CEntry		;Goto Entry
CLoop2:				;Loop
	Mov	SI,DI		;Back := Front; -- On to next block
	Mov	DI,[SI]		;Front := Back.next
	Mov	DX,[SI+2]	;If back.size
	Add	DX,SI		; + back
	Cmp	DX,BX		; = addr
	Jne	CEntry		;Then -- Can do back merge
	Add	[SI+2],AX	;back.size := size + back.size;
	Mov	AX,[SI+2]	;If back.size
	Add	AX,SI		; + back
	Cmp	AX,DI		; = front
	Jne	CDone		;Then (Else Done) -- Can do front merge
	Mov	AX,[DI+2]	;
	Add	[SI+2],AX	;back.size := back.size + front.size
	Mov	AX,[DI]		;front.next
	Mov	[SI],AX		; =: back.next
	Ret

CEntry: ;<<Entry>>
	Cmp	DI,0		;If front = Null
	Jne	CNext2		;Then -- End of chain reached
	Mov	[SI],BX		;back.next := addr
	Mov	Word([BX]),0	;addr.next := Null
	Mov	[BX+2],AX	;addr.size := size
	Ret

CNext2:				;Elsif
	Cmp	BX,DI		; addr < Front
	Ja	CLoop2		;Then (Else go around again)
				;-- Insert block here
	Mov	Word([BX]),DI	;addr.next := Front
	Mov	[BX+2],AX	;addr.size := size
	Mov	[SI],BX		;back.next := addr	
	Add	AX,BX		;If size + addr
	Cmp	AX,DI		; = front
	Jne	CDone		;Then (Else Done) -- Can merge front
	Mov	AX,[DI+2]
	Add	[BX+2],AX	;addr.size := addr.size + front.size
	Mov	AX,[DI]		;front.next
	Mov	[BX],AX		; =: addr.next
	Ret
End Proc EDispose

	;-------------------------------------------
	;---- Byte (binary) file I/O procedures ----
	;---- These are used by the text I/O    ----
	;---- procedures below them		----
	;-------------------------------------------

	;Get an object, CX bytes in length, from the file pointed at by BX,
	;and put it into the memory pointed at by AX
	;Kills All
	;Count in CX, address in AX, and file on the stack
Proc ERead  ;Compiler Entry Point
	Pop	SI	;Get the return address off the stack
	Pop	BX	;Get the File address
	Push	SI	;Restore the file address
Read:	;File - BX, Ptr - AX, Bytes - CX
	;Entry Point for internal routines (Get, etc.)
	Cmp	BX,0	;Test for Null file pointer
	Jne	RSkip3	;Need a skip jump
	Jmp	Not_Open
RSkip3:	Test	Byte([BX + FMode]),01H	;Test the file mode for read access
	Jnz	RSkip2	;Need a skip jump
	Jmp	Mode_Err ;No File Access
RSkip2:	Jcxz	Rend	;Quit if no characters to read
	Cmp	Byte([BX + Ftype]),0	;Is this a disk file?
	Jnz	RSkip4		;Need skip jump
	Jmp	RDisk
RSkip4:	Mov	SI,AX		;Put the object's address in SI
	Mov	AL,[BX + FType]	;Get the device type
	Cmp	AL,1		;Is this the console?
	Jz	RCon
	Cmp	AL,2		;Is this the RDR: device?
	Jz	RRdr
	Cmp	AL,5		;Is this the KBD: device?
	Jz	Rkbd
	Jmp	Mode_Err	;No access to other devices - Cannot read
				;from the printer

	;Read from the Reader (RDR:) device
Rrdr:	Cmp	Word([BX + Buf_ptr]),0
	Jnz	Raback	;Back up character exists
	Push	ES	;Must save all of these registers
	Push	CX
	Push	SI
	Mov	CL,3	;CP/M-86 opcode
	Int	224	;Call OS
	Pop	SI
	Pop	CX
	Pop	ES
Rago:	Mov	[SI],AL	;Store the character
	Inc	SI
	Loop	Rrdr	;Go around again until the count expires
Rend:	Ret
Raback:	Mov	AL,[BX + Buff]	;Get the backup character
	Mov	Word([BX + Buf_ptr]),0	;Set flag off
	Jmp	Rago

	;Read from the console with no echo
Rkbd:	Cmp	Word([BX + Buf_ptr]),0
	Jnz	Rkback	;Back up character exists
	Push	ES	;Must save all of these registers
	Push	CX
	Push	SI
Rloop5:	Mov	CL,6	;CP/M-86 direct I/O opcode
	Mov	DL,0FFh ;Specify input
	Int	224	;Call OS
	Cmp	AL,0	;Character Not Ready
	Jz	Rloop5	;Read it again until one is
	Pop	SI
	Pop	CX
	Pop	ES
Rkgo:	Mov	[SI],AL ;Store the character
	Inc	SI
	Loop	Rkbd	;Go around again until count expires
	Ret
Rkback:	Mov	AL,[BX + Buff]	;Get the backup character
	Mov	Word([BX + Buf_ptr]),0	;Set flag off
	Jmp	Rkgo

	;Read from console (CON:) device
Rcon:	Mov	DI,[BX + Buf_ptr]	;Get the buffer pointer into DI
	Mov	DL,[BX + Buff + 1]	;Get the string length
	Mov	DH,0
	Add	DX,3			;Figure the string end offset
RConLoop:
	Cmp	DI,0	;Is the buffer empty?
	Jnz	RCh
	;Refill the buffer
	Mov	Byte([BX + Buff]),127	;Size of buffer allowed
	Push	ES
	Push	SI
	Push	CX			;Save registers
	Push	BX
	Lea	DX,[BX + Buff]		;Load buffer address
	Mov	CL,10			;CP/M-86 opcode
	Int	224			;Call OS - Read Line from console
	Mov	CL,2			;Echo a LF
	Mov	DL,10
	Int	224			;Call CP/M-86 to write it
	Pop	BX
	Pop	CX
	Pop	SI
	Pop	ES

	Mov	DL,[BX + Buff + 1]	;Get the no. of characters read
	Mov	DH,0			;Make it into a word
	Add	DX,3			;Make into ending index (first two
					;locations are used for control info)
					;And count for <CR>
	Mov	DI,DX
	Mov	Byte([BX + DI + (Buff-1)]),13	;Add <CR>
	Mov	Byte([BX + DI + Buff]),10	;Add an <LF>
	Mov	DI,2			;Start with the second character
RCh:	Mov	AL,[BX + DI + Buff]	;Get the character
	Mov	[SI],AL			;Store it away
	Inc	SI			;Bump pointer
	Inc	DI			;Bump buff pointer
	;Check for end of buffer, and set DI to zero if it has been reached
	Cmp	DX,DI			;Buffer is empty if pointer is past
	Jae	RCSkip			;end of string (if DX > DI)
	Mov	DI,0			;Buffer is empty
RCSkip:	Loop	RConloop		;Go around if count hasn't expired
	Mov	[BX + Buf_ptr],DI	;Restore the buffer pointer
	Ret


	;Disk File Input
Rdisk:  ;File address - BX, Value Address - AX, Bytes to transfer - CX
	Mov	SI,AX	;Put the Value address in SI
	Cmp	Byte([BX + EOF_Flag]),0	;Test the EOF flag
	Jnz	RdEof	;Set IOresult, already at the end_of_file
	Mov	DI,[BX + Buf_Ptr] ;Get Buffer Pointer
Rloop9:	;Here DI=buf pointer; CX=Byte count; SI=Location; BX=File address
	;Buf ptr points at the last byte read in the file buffer
	Jcxz	RDone	;Done when count = 0
	Cmp	DI,BUFFER_SIZE-1
			;Have all of the bytes in the buffer been read?
	Jz	RSect
	Inc	DI	;Bump buffer index
GetByte: Mov	AL,[BX + DI + Buff] ;Read byte from buffer (BX=File address,
		    ;DI = Buffer Pointer, Buff = Offset of buffer from start
	Mov	[SI],AL	;Store the byte away
	Dec	CX
	Inc	SI	;Bump Pointers and count
	Jmp	Rloop9	;Do it all again

Rsect:	;Read a sector (same register values as upon entrance to Rloop9)
	;Read sector buffer address already set
	Push	ES
	Push	SI
	Push	CX	;Save regs since CP/M-86 will kill them
	Mov	CX,(BUFFER_SIZE/128)	;No. of sectors to read
	Lea	DX,[BX + Buff] ;Offset of file buffer
RLoop7: Push	CX
	Push	DX
	Push	BX
	Mov	CL,26	;Set Buffer Address
	Int	224	;Call OS
	Pop	BX
	Push	BX
	Lea	DX,[BX+FCB] ;Get file FCB address
	Mov	CL,20
	Int	224	;Call OS to Read a sector
	Cmp	AL,0
	Jnz	REOF	;Test for End of File error
	Pop	BX
	Pop	DX
	Pop	CX
	Add	DX,128	;Move pointer to next sector
	Loop	RLoop7	;Do it again until all sectors have been read
	Pop	CX
	Pop	SI
	Pop	ES
	Cmp	AL,0
	Jnz	REOF	;Test for End of File Error
RPart:	Mov	DI,0	;Clear Buffer Pointer (Start at Zero)
	Jmp	GetByte	;Read the byte and continue

REOF:	;End_of_File found (TOS contains the address of the sector which was
	;not read)
	Pop	BX
	Pop	DI	;Address of bad sector
	Pop	CX
	Mov	[DI],26	;Put control-Z at beginning of missing sector
	Cmp	CX,(BUFFER_SIZE/128)
	Je	Reend	;No sectors read
	Pop	CX
	Pop	SI
	Pop	ES
	Jmp	RPart	;Read part of the buffer

Reend:	;End_of_File found
	Mov	Byte([BX + Eof_Flag]),1	;Set EOF flag
	Pop	CX
	Pop	SI
	Pop	ES	;Clear the stack
	Ret

RdEOF:	;Already at EOF
	;Set IOresult in the future (or raise an exception)
	Ret

Rdone:	;Normal Disk Read Exit
	;Restore buffer pointer in FCB
	Mov	[BX + Buf_ptr],DI
	Ret

End Proc ERead		;Finally!!


	;Put the object pointed at by AX into the file pointed at by BX.
	;The number of bytes to transfer is in CX
	;The object is assumed in the Data segment (for Code segment, see
	;CWrite, below)
	;Note that the Extra Segement = The Data Segement
	;Kills All
Proc EWrite  ;Compiler Entry Point
	Pop	SI	;Get the return address off the stack
	Pop	BX	;Get the File address
	Push	SI	;Restore the file address
Write:	;File - BX, Ptr - AX, Bytes - CX
	;Internal Entry Point for routines like Put
	Cmp	BX,0	;Test for Null file pointer
	Jne	WSkip3	;Need a skip jump
	Jmp	Not_Open
WSkip3:	Test	Byte([BX + Fmode]),02H	;Test the second bit of the file mode
	Jnz	WSkip2	;Need a skip jump
	Jmp	Mode_Err ;No File Access
WSkip2:	Jcxz	WEnd	;Quit if no characters to write
	Cmp	Byte([BX + FType]),0	;Is this a disk file?
				; (Including Named Devices)
	Jz	Wdisk
	Mov	SI,AX		;Put the object's address in SI
	Mov	AL,[BX + FType]	;Get the Device code and double it
				; (word access)
	Cmp	AL,1
	Jz	WCon
	Cmp	AL,3
	Jz	WPun
	Cmp	AL,4
	Jz	WLst
	Jmp	Mode_Err	;Device cannot be used this way

	;Write Characters to console (CON:) device
Wcon:	Seg	ES	;Will be set to the correct segment
	Mov	DL,[SI]	;Get the byte to write into DL
			; (where CP/M-86 expects it)
	Inc	SI
	Push	CX	;Save regs since CP/M-86 will kill them
	Push	SI
	Push	ES
	Mov	CL,2
	Int	224	;Call OS
	Pop	ES
	Pop	SI
	Pop	CX
	Loop	WCon	;Go around again if count has not expired
Wend:	Ret

	;Write to punch (PUN:) device
Wpun:	Seg	ES	;Will be set to the correct segment
	Mov	DL,[SI]	;Get the byte to write into DL
			; (where CP/M-86 expects it)
	Inc	SI
	Push	CX	;Save regs since CP/M-86 will kill them
	Push	SI
	Push	ES
	Mov	CL,4
	Int	224	;Call OS
	Pop	ES
	Pop	SI
	Pop	CX
	Loop	Wpun	;Go around again
	Ret

	;Write to list (LST:) device
Wlst:	Seg	ES	;Will be set to the correct segment
	Mov	DL,[SI]	;Get the byte to write into DL
			; (where CP/M-86 expects it)
	Inc	SI
	Push	CX	;Save regs since CP/M-86 will kill them
	Push	SI
	Push	ES
	Mov	CL,5
	Int	224	;Call OS
	Pop	ES
	Pop	SI
	Pop	CX
	Loop	Wlst	;Go around again
	Ret

	;Disk File Output
Wdisk:  ;File address - BX, Value Address - AX, Bytes to transfer - CX
	Mov	SI,AX	;Put the Value address in SI
	Mov	DI,[BX + Buf_Ptr] ;Get Buffer Pointer
Wloop9:	;Here DI=buf pointer; CX=Byte count; SI=Location; BX=File address
	;Buf ptr points at the first empty byte in the file buffer
	Jcxz	WDone	;Done when count = 0
	Seg	ES	;Will be set to the correct segment
	Mov	AL,[SI]	;Get the byte to write
	Mov	[BX + DI + Buff],AL ;Write byte into buffer
			;(BX = File address, DI = Buffer Pointer,
			; Buff = Offset of buffer from start)
	Dec	CX
	Inc	SI	;Bump Pointers and count
	Inc	DI
	Cmp	DI,BUFFER_SIZE	;Is buffer full?
	Jnz	Wloop9	;Do it all again if sector not full
	;Falls thru to WSect
Wsect:	;Write a sector (same register values as upon entrance to Wloop9)
	;Write sector buffer address already set
	Push	CX	;Save these registers since CP/M-86 will kill them
	Push	SI
	Push	ES
	Lea	DX,[BX+Buff]
	Mov	CX,(BUFFER_SIZE/128)
WLoop7: Push	DX
	Push	CX
	Push	BX
	Mov	CL,26
	Int	224	;Set write buffer address
	Pop	BX
	Push	BX
	Lea	DX,[BX+FCB] ;Get file FCB address
	Mov	CL,21
	Int	224	;Call OS to write a sector
	Cmp	AL,0
	Jne	Werr	;Error Writing
	Pop	BX
	Pop	CX
	Pop	DX
	Add	DX,128	;Move pointer to next sector to write
	Loop	WLoop7	;Write another sector until the counter expires
	Pop	ES
	Pop	SI
	Pop	CX
	Mov	DI,0	;Clear Buffer Pointer (Start at Zero)
	Jmp	WLoop9	;Do it all again


Werr:	;Disk/Directory Full Error
	Pop	BX
	Pop	DX
	Pop	CX	;Clear stuff off of the stack
	Mov	Byte([BX + Eof_flag]),1
		;Set EOF flag (means Disk/Dir Full Error on write)
		;Should raise an exception instead
	Pop	ES
	Pop	SI
	Pop	CX	;Restore the stack
	Ret

Wdone:	;Normal Disk Write Exit
	;Restore buffer pointer in FCB
	Mov	[BX + Buf_ptr],DI
	Ret

End Proc EWrite		;Finally!!


	;Value write - write the value in AX or AL to the file on the stack
	;File in BX, Bytes to transfer in CX
	;Kills All except Data Value
Proc EVWrite  ;Compiler entry point (File on stack)
	Pop	SI	;Get return address
	Pop	BX	;Get file address
	Push	SI	;Restore return address
VWrite: ;Entry Point for internal routines
	Push	AX	;Put the value on the stack
	Mov	AX,SP	;Get the address of the value out of the SP
	call	Write	;Got its address in AX now
	Pop	AX	;Get it off of the stack (Value has been written now)
	Ret
End Proc EVWrite

	;Code Segement Write -
	;Put the object pointed at by AX into the file pointed at by BX.
	;The number of bytes to transfer is in CX
	;The object is in the Code segment
	;The actual write routine uses the extra segment for all data
	;references, so set that equal to the code segment
	;Kills All
Proc ECWrite   ;Compiler Entry Point
	Pop	SI	;Get the return address off the stack
	Pop	BX	;Get the File address
	Push	SI	;Restore the file address
CWrite:	;File - BX, Ptr - AX, Bytes - CX
	;Internal Routines Entry Point
	Push	ES
	Mov	SI,CS
	Mov	ES,SI	;Set the Extra Segment equal to the code segment
	Call	Write
	Pop	ES
	Ret
End Proc ECWrite

	;Illegal mode for file
	;File Pointer is in BX
Mode_Err: Push	BX
	Push	DS		;Set ES to = DS, as it is assumed to be so,
	Pop	ES		;but may not be (from Write)
	Mov	AX,MStr
	Call	WCstr
	Pop	AX
	Call	EFile_Name
	Mov	BX,[Output_File] ;Standard Output File
	Call	Put_Str		;Data segment string (not constant)
	Jmp	Err_Exit
Mstr:  DB	21,'File access denied - '

	;File Pointer is Null - File is not open
Not_Open: Push	DS		;Set ES to = DS, as it is assumed to be so,
	Pop	Es		;but it may not be (from Write)
	Mov	AX,Not_Str
	Call	WCstr
	Jmp	Err_Exit
Not_Str: DB	13,"File Not Open"

	;Make a string out of the file name
	;File address is in AX, return the string address in AX
Proc EFile_Name
	Mov	BX,AX
	Cmp	BX,0	;Test for Null file pointer
	Jne	FSkip3	;Need a skip jump
	Jmp	Not_Open
FSkip3:	Mov	AL,[BX + FType]	;Get file type
	Cmp	AL,0	;Compare each type separately, so no crashes
	Jz	FDisk
	Cmp	AL,1
	Jz	FCon
	Cmp	AL,2
	Jz	Frdr
	Cmp	AL,3
	Jz	Fpun
	Cmp	AL,4
	Jz	Flst
	Cmp	AL,5
	Jz	Fkbd
	Mov	BX,NNone
	Jmp	NMov
Fkbd:	Mov	BX,NKbd
	Jmp	NMov
Flst:	Mov	BX,NLst
	Jmp	NMov
Frdr:	Mov	BX,NRdr
	Jmp	NMov
Fpun:	Mov	BX,NPun
	Jmp	NMov
Fcon:	Mov	BX,NCon
NMov:	;Move the result string into the data segment (Cannot return the
	; address of a constant string)
	Mov	DI,NDisk
	Mov	CX,18
NMLoop: Seg	CS
	Mov	AL,[BX]	;Constant String
	Mov	[DI],AL
	Inc	BX
	Inc	DI
	Loop	NMLoop	;Dec's CX and Jumps on /= 0
	Mov	AX,NDisk
	Ret

	;Get the name of a disk file
Fdisk:	Mov	DI,NDisk ;Output Buffer Address
	Add	BX,FCB	 ;File FCB address
	Mov	AL,[BX]	 ;Get disk number
	Inc	BX
	Cmp	AL,0
	Jz	Nodisk
	Add	AL,'@'	;Change to ASCII
	Mov	[DI],14	;Length of string
	Inc	DI
	Mov	[DI],AL	;Disk Name
	Inc	DI
	Mov	[DI],':'
	Inc	DI
	Jmp	Dname
Nodisk: Mov	[DI],12	;Length of string
	Inc	DI
Dname:	Mov	CX,8	;Load counter
	;Move Next 8 characters into string
Dloop:  Mov	AL,[BX]
	Mov	[DI],AL
	Inc	BX
	Inc	DI
	Loop	DLoop	;Dec CX and Jump on /= 0
	Mov	[DI],'.'
	Inc	DI
	Mov	CX,3	;Load counter
Dloop2: Mov	AL,[BX]
	Mov	[DI],AL
	Inc	BX
	Inc	DI
	Loop	DLoop2
	Mov	AX,Ndisk
	Ret		;And thats all there is to it

Ncon:	DB	4,'CON:'
Nrdr:	DB	4,'RDR:'
Npun:	DB	4,'PUN:'
Nlst:	DB	4,'LST:'
Nkbd:	DB	4,'KBD:'
NNone:  DB	15,'*Bad File Name*'

	DSEG
Ndisk:	RB	20	;In data segment
	CSEG

End Proc EFile_Name

	;------------------------------------
	;---- Get and Put Text I/O Calls ----
	;------------------------------------

	;Put the string in AX to the file in BX
	;Kills All
	;Data Segment Version (Need a similar one for String Constants)
Proc EPut_Str	;Compiler Entry Point (File on stack, string in AX)
	Pop	DI	;Get Return address
	Pop	BX	;Get File Pointer
	Push	DI	;Restore Return Address
Put_Str: ;Internal Entry Point
	Mov	SI,AX
	Mov	CL,[SI]	;Byte string length byte as length to transfer
	Xor	CH,CH	;Clear Upper Byte
	Inc	AX	;Get the address of the string to output
	Jmp	Write	;Write the string (Write returns for Put_Str)
End Proc EPut_Str

	;Put the string in CS:BX to the file in AX
	;Kills All
	;Code Segment Version (for String Constants)
Proc Put_CStr
	Xchg	AX,BX	;Put address and file in normal registers
	Mov	SI,AX
	Seg	CS
	Mov	CL,[SI]	;Byte string length byte as length to transfer
	Xor	CH,CH	;Clear Upper Byte
	Inc	AX	;Get the address of the string to output
	Jmp	CWrite	;Write the string (Write returns for Put_CStr)
End Proc Put_Cstr

	;Write Constant (Code Seg) String to Console
	;The address of the string is in AX
	;Kills All
	;This procedure is maintained only for error message writing
WCstr:	Xchg	AX,BX
	Mov	AX,[Output_File]
	Jmp	Put_CStr	;String in CS:BX, File in AX

	;Write the integer in AX in decimal, with sign
	;File in BX; width in CX
	;Kills All
Proc EPutInt	;Entry from compiler - No field width
	Pop	DI	;Return address
	Pop	AX	;Value
	Pop	BX	;File Address
	Push	DI	;put return address back on the stack
	Jmp	PutInt
End Proc EPutInt

Proc EPutIntW	;Entry from compiler
	Pop	DI	;Return address
	Pop	CX	;Get width
	Pop	AX	;Get Value
	Pop	BX	;Get File address
	Push	DI	;put return address back on the stack
	Jmp	PutIntW
End Proc EPutIntW

	;Entrys for above are just below
Wint:	;(For console write operations in the library [errors])
	;Value in AX
	Mov	BX,[Output_File] ;Set the output file
PutInt: Mov	CX,0		;Field Width is zero (expanded as needed)
PutIntW:	;Integer output routine
	Cmp	CX,0	;Check if width is negative
	JG	PIskip
	Mov	CX,0	;Width is zero if it was negative
PIskip: Push	BX
	Push	CX
	Mov	Byte([Isign]),0	;Sign is positive
	Cmp	AX,0
	JG	WPos	;Is positive
	Mov	Byte([ISign]),255 ;Sign is negative, set flag
	Neg	AX
Wpos:	Jz	WZero	;Flags are still set, Special for Zero
	Mov	DI,Bufend ;Right End of output buffer
	Mov	CX,0	;Character Counter
	Mov	BX,10	;Divide by 10
Wiloop: 
	Xor	DX,DX	;Clear DX - Do NOT extend sign thru DX
	Div	BX	;Divide - Remainder in DX, Quotient in AX
			;Unsigned so that -32768 can be decoded
	Add	DL,'0'	;Make a character out of the remainder
	Mov	[DI],DL	;Put it in the buffer
	Inc	CX
	Dec	DI	;Bump pointers
	Cmp	AX,0
	Jnz	Wiloop	;Stop if quotient is zero
	Cmp	Byte([ISign]),0 ;Is the sign positive
	Jz	WrtInt	;Then do nothing
	Mov	Byte([DI]),'-'
	Inc	CX
	Dec	DI
WrtInt: ;Character Count in CX, Buffer Address in DI
	Pop	AX	;Get field width
	Pop	BX	;Get the file address
	Push	DI	;Save buffer address
	;File Address in BX(DE), Field Width in AX(HL), Char. Count in CX (A)
Wid_Loop:	;Generate the field width
	Cmp	AX,CX	;Is the field width less than the width of the
			; output value?
	JLe	Width_Done
	Push	CX	;Save char count
	Push	BX	;Save file address
	Push	AX	;Save current field width
	Mov	AL,' '	;Write a blank to the file in BX
	Mov	CX,1	;Write one byte
	Call	VWrite	;Value Write (kills all)
	Pop	AX
	Pop	BX
	Pop	CX	;Restore registers
	Dec	AX	;Decrease width count by one
	Jmp	Wid_Loop ;Go around again
Width_Done:
	Pop	DI	;Get buffer address
	Inc	DI	;Make it point at the first character to write
	Mov	AX,DI
	;File already in BX, and count already in CX
	Jmp	Write	;Write it, and let write return
WZero:	;Write a single 0 for zero
	Mov	DI,Bufend ;Get right end of buffer
	Mov	CX,1	;Load character count (1)
	Mov	[DI],'0';Put the character zero into the buffer
	Dec	DI
	Jmp	WrtInt	;Remember to set up the field width

	DSEG
	RB	10	;Character Buffer
Bufend: RB	1
Isign:  RB	1	;Integer Sign
	CSEG

	;Write the integer in AX in Hex, File in BX
	;Kills All
Proc PutHex
	Mov	DX,AX	;Copy the value
	Xchg	AL,AH
	And	AL,0F0h	;mask off the high nybble
	Shr	AL,1	;Shift it right 4 times
	Shr	AL,1
	Shr	AL,1
	Shr	AL,1
	Call	Putch
	Mov	AL,DH	;Get the Low nybble
	And	AL,0Fh	;Mask it
	Call	Putch
	Mov	AL,DL	;Get Low Byte
	And	AL,0F0h	;Mask off high nybble
	Shr	AL,1	;Shift it right 4 times
	Shr	AL,1
	Shr	AL,1
	Shr	AL,1
	Call	Putch
	Mov	AL,DL	;Get the Low Nybble
	And	AL,0Fh	;Mask it
	;Fall thru to Putch, then return from there
	;Write the Hex char for value in AL (0-15)
	;Trick code from 8080A assembly programming, pg. 7-3
	;Kills All Except BX and DX
Putch:	Add	AL,90h	;BCD add to hex digit
	Daa		;9x if <10; 0x if >9 w/ Carry
	Adc	AL,40h	;Add w/Carry BCD - Bumps lower bits if > 9
			;(Sets 10 = A)
	Daa		;3x if <10; 4x+1 if >9  Wow-it works!!
	Mov	CX,1	;Length to write
	Push DX!Push BX
	Call	VWrite	;Have value write write this value out
	Pop  BX!Pop  DX
	Ret
End Proc PutHex

	;Get a text integer from the file on the stack,
	;and put in into the var. pointed at by AX
	;Kills All
Proc GetInt

	DSEG
IntSign:RB	1	;Sign of the result
CharBuf:RB	1	;Character just read
	CSEG
	Pop	DI	;Return address
	Pop	BX	;File address
	Push	DI	;Put Return address on stack
	Push	AX	;Put var address on stack
	Push	BX	;Put file address on stack
	Mov	Byte([IntSign]),0 ;Set the sign to positive
SkipB:	Call	Igetch	;Read a character
	;Skip leading spaces, tabs, commas, LFs, and CRs
	Cmp	AL,' '
	Jz	SkipB ;Get another if it's a space
	Cmp	AL,09h
	Jz	SkipB ;Get another if it's a tab
	Cmp	AL,','
	Jz	SkipB ;Get another if it's a comma
	Cmp	AL,0Ah
	Jz	SkipB ;Get another if it's a LF
	Cmp	AL,0Dh
	Jz	SkipB ;Get another if it's a CR
	Cmp	AL,'+'
	Jz	NextCh	;Sign - Read the next character
	Cmp	AL,'-'
	Jnz	GetInit
	Mov	Byte([IntSign]),255	;Sign is negative
NextCh:	Call	Igetch	;Get the next character
	;Make up result in CX
GetInit: Mov	CX,0	;Result = 0
GetLoop: Cmp	AL,'0'
	JB	IntDone
	Cmp	AL,'9'
	JA	IntDone
	Push	AX	;Mul kills AX
	Mov	AX,10	;Multiply Result by 10
	IMul	CX
;	Jo	Error	;Value too large error
;	-- Goto Value Exception Raising Routine
	Into		;Arithmetic Overflow error
	Mov	CX,AX
	Pop	AX
	Sub	AL,'0'	;Make into a binary number
	Xor	AH,AH	;Clear AH
	Add	CX,AX	;Add to result
	Call	Igetch	;Get The next character
	Jmp	GetLoop
IntDone: Pop	BX	;Get file address
	;Character is in AL
	Call	RplcByte;Put byte back into file
	Cmp	Byte([IntSign]),0 ;Set the Integer's sign
	Jz	SkipN
	Neg	CX	;Value is Negative
SkipN:	Pop	BX	;Get Var. address
	Mov	[BX],CX ;Store value into var
	Ret

	;Get at character into CharBuf, and into AL (Kills AH)
Igetch:	Pop	DI	;Get return address
	Pop	BX	;Get file address
	Push	BX	;Shove these back onto the stack
	Push	DI
	Push	CX	;Save partial value
	Mov	CX,1	;Get one byte
	Mov	AX,CharBuf ;Var address
	Call	Read	;Get the byte
	Mov	AL,[CharBuf]	;Get the character into AL
	Pop	CX	;Restore partial value
	Ret
End Proc GetInt

	;Put the enumeration type
	;Kills All
	;Base of Table in CS:SI
	;Enum Value in AL
	;File in BX, Field Width in CX
Proc EPutEnumW	;Compiler entry Point
		;Table Lo in AX, rest on stack
	Mov	SI,AX	;Put Table value where it belongs
	Pop	DI	;Return Address
	Pop	CX	;Field Width
	Pop	AX	;Item to write
	Pop	BX	;File Pointer
	Push	DI	;Replace return address
	Jmp	PutEnum
End Proc EPutEnumW

Proc EPutEnum	;Compiler entry point
		;Table Loc in AX, rest on stack
	Mov	SI,AX	;Put Table value where it belongs
	Pop	DI	;Return Address
	Pop	AX	;Item to Write
	Pop	BX	;File Pointer
	Push	DI	;Replace return address
	Mov	CX,0	;Set field width to 0
	;Value in AL, Width in CX, File in BX, Table in CS:SI
PutEnum: ;Entry Point for above
	Xor	AH,AH	;Clear Upper Byte
	Add	AX,AX	;Double it
	Xchg	AX,BX	;Get this value into BX
	Seg	CS	;Get the String address out of the table
	Mov	BX,[BX + SI]
	Push	CX	;Save the field width
	Seg	CS
	Mov	DL,[BX]	;Get the string length
	;String Address in CS:BX, File in AX
	Push	DX	;Save string length
	Push	AX	;Save a copy of the file pointer
	Call	Put_CStr;And write the Constant string
	Pop	BX	;Restore file pointer
	Pop	DX	;Restore string length
	Pop	CX	;Restore field width
	Xor	DH,DH	;Clear Upper Byte
	;Have DL - chars already written; CX - Field width; BX - File
	;Trailing Blanks for enumerations with field width
PEnumLoop:
	Cmp	DX,CX
	JGe	PEDone	;Return when chars written >= field width
	Push	DX
	Push	BX
	Push	CX
	Mov	CX,1	;Write one character, the space
	Mov	AL,' '
	Call	VWrite
	Pop	CX
	Pop	BX
	Pop	DX
	Inc	DX	;One more character written
	Jmp	PEnumLoop
PEDone: Ret
End Proc EPutEnum
	
	;Put an <CR> <LF> into the file pointed at by AX
	;Kills All
Proc ENew_Line
	Mov	BX,AX	;Put the file in BX for write
	Mov	CX,2	;Object of length 2
	Mov	AX,CrLf	;Address of object
	Jmp	CWrite	;call write to write it (Write returns for New_Line)
CrLf:	DB	13,10
End Proc ENew_Line

	;Put a <CR> <LF> to the current output file
	;(used only by this library)
	;Kills All
Wcrlf:	Mov	AX,[Output_File]
	Jmp	ENew_Line

	;Read up to a <CR>, <LF>, <FF>, <VT>, or the pair <CR> <LF>
	;Stop at EOF, of course
	;File is pointed to by AX
	;Used a simple scheme to implement skip_line.
	;A more complicated scheme actually took longer to run.
Proc ESkip_Line
	Mov	BX,AX	;Put the file in BX to use it
Skip_Loop: ;Loop until an EOLN character is found
	;Read a character for skip
	Push	BX
	Mov	CX,1	;Load the count
	Mov	AX,Temp_char ;Load the address of the temporary character
	Call	Read	;Call Read - File in BX, Var in AX, Count in CX
	Pop	BX
	Mov	AL,[Temp_char]	;Load result of read into AL
	;Test for the end the line
	Cmp	AL,26	;End-of-File
	Jz	Test_Done ;Done if EOF
	Cmp	AL,10	;Line Feed
	Jl	Skip_Loop   ;Not End-of-Line if < 10 (Go around again)
	Cmp	AL,12	;Form Feed
	Jle	Test_Done ;Done if LF, VT, FF (< 12)
	Cmp	AL,13	;Carriage Return
	Jnz	Skip_Loop
		;Read a character to see if it is a LF
	Push	BX
	Mov	CX,1	;Load the count
	Mov	AX,Temp_char ;Load the address of the temporary character
	Call	Read	;Call Read - File in BX, Var in AX, Count in CX
	Pop	BX
	Cmp	Byte([Temp_char]),10
	Jz	Test_Done ;Done if LF (CR-LF)
	;Otherwise, put the character back
	Call	RplcByte
Test_Done: Ret		;Return - EOLN was found

	DSEG
Temp_Char: RB	1
	CSEG
End Proc ESkip_Line

	;Replace character into file (Backup)
	;Usually used to put back a look-ahead character
	;Used by GetInt and Skip_Line internally
	;Used by End_of_Line and End_of_File externally
	;File is in BX, Character is in AL; Kills None
Proc RplcByte
	Cmp	BX,0	;Test for Null file pointer
	Jne	PSkip3	;Need a skip jump
	Jmp	Not_Open
PSkip3: Cmp	Byte([BX + FType]),1	;Get file type
	Jz	RBCon		;Back up the Console
	Ja	RBDev		;Back up a device
	Dec	[BX + Buf_ptr]	;Back up the buffer pointer for disk files
				; and the console
	Ret
RBDev:	;Backup a device - AUX: and KBD:
	Mov	Word([BX + Buf_Ptr]),1	;Set the backup flag
	Mov	[BX + Buff],AL	;Save character
	Ret
RBCon:	;Backup the CON:
	Cmp	Word([BX + Buf_Ptr]),0	;Buffer is empty if Ptr = 0
	Jz	RBEnd
	Dec	[BX + Buf_Ptr]
	Ret
RBEnd:	;Set buffer to last character of previous string
	Mov	AL,[BX + Buff + 1]
	Mov	AH,0
	Add	AX,3
	Mov	[BX + Buf_Ptr],AX
	Ret
End Proc RplcByte

	;Close a file
	;A pointer to the file is in AX
	;Kills All
	;This routine is provided in the default library so the run-time
	;can close all open files at termination
Proc EClose
	Xchg	AX,BX	;File is assumed in BX by all file handlers
	Cmp	BX,0	;Test for Null file pointer
	Jne	ESkip3	;Need a skip jump
	Jmp	Not_Open
ESkip3:

	;-- Remove File from file chain
	;Back := File_Chain'Address - 170; (170 being .link's offset)
	;Front := File_Chain;
	;Loop
	;    If Front = File Then
	;	Back.link := Front.Link;
	;	Exit;
	;    Elsif Front = Null Then
	;	Exit; -- Not on chain (should not happen)
	;    End If;
	;    Back := Front;
	;    Front := Front.link;
	;End Loop;

	;Back =  SI
	;Front = DI
	;File =  BX
	Mov	SI,File_Chain - Link	;Back := File_Chain'Address-.Link
	Mov	DI,[File_Chain]	;Front := File_Chain
CCLoop:	Cmp	BX,DI		;Loop If Front = File
	Jnz	CCSkip		;Then
	Mov	AX,[DI + Link]	
	Mov	[SI + Link],AX	;Back.link := Front.link
	Jmp	Close
CCSkip:	Cmp	DI,0		;Elsif Front = Null Then
	Jz	Close		;Not on chain, some sort of error, but
				;continue anyway
	Mov	SI,DI		;Back := Front;
	Mov	DI,[DI + Link]	;Front := Front.link;
	Jmp	CCloop

	;Close the file!!
Close:	Test	Byte([BX + FMode]),3	;Test to see if the file is open
	Jnz	COpen		;File is open
	Mov	AX,CErr
	Call	WCStr		;File is not Open
	Call	Err_Exit
CErr:	Db	13,"File not Open"

COpen:	Push	ES		;Save register, since CP/M-86 will kill it
	Cmp	Byte([BX + FType]),0	;Test to see if this is a disk file
	Jne	FDispose	;No operation for devices
	Test	Byte([BX + FMode]),2
				;Empty buffer only for Write files
	Je	FClose
	Mov	DI,[BX + Buf_ptr]	;Load the buffer offset
	Mov	AX,DI		;Save number of good characters
ELoop:	Mov	Byte([BX+DI+Buff]),26	;Fill the space remaining in the
				;sector with <Crtl>-Z's
	Inc	DI
	Cmp	DI,BUFFER_SIZE	;Stop when sector is full
	Jne	Eloop
	Add	AX,127		;Round value up to next full sector
	Shl	AX,1		;Double AX, sector count now is in AH
	Mov	CL,AH
	Mov	CH,0		;Count of # of sectors to write is now in CX
	Cmp	CX,0
	Jz	FClose		;Don't write 0 sectors
	Mov	DX,BX
	Add	DX,Buff
CLoop7:	Push	DX
	Push	CX
	Push	BX
	Mov	CL,26		;Set the write buffer address
	Int	224		;Call CP/M-86
	;Write the sector (Sequential assumed)
	Pop	BX
	Push	BX		;Get and Re-save the file address
	Lea	DX,[BX+FCB]	;Get file FCB address
	Mov	CL,21
	Int	224		;Call OS to write a sector
	;Cmp	AL,0
	;Jne	FDiskFull	;Raise Disk Full Exception
				;Must get BX,CX,DX,and ES off of stack
	Pop	BX		;Get file off of stack
	Pop	CX
	Pop	DX
	Add	DX,128
	Loop	CLoop7		;Write next sector until count expires	

FClose:	;Close the file in BX
	Push	BX		;Save the file address
	Lea	DX,[BX+FCB]	;Load the file FCB
	Mov	CL,16		;File Close Opcode
	Int	224		;Call CP/M-86
	Pop	BX		;Restore the file address
	;Cmp	AL,255		;Test for Close Error
	;Jne	FDispose
	;Raise Exception if Close error (must restore ES)

FDispose: Pop	ES		;Restore ES
	Mov	AX,File_Mask	;Dispose of File Block
	Call	Dispose
	Ret
	
End Proc EClose

	;----------------------------------
	;----  Error Handling Routines ----
	;----------------------------------

	;Checks for Stack Overflow
	;Kills All
StkOver:Mov	AX,[Heap_Ptr]	;Get the heap pointer
	Add	AX,64		;Must have 64 byte leaway
	Cmp	SP,AX
	JB	StkError	;Error if SP < AX (Unsigned)
	Ret
StkError: Mov	AX,Str5
	Call	WCstr	;'Recursion Stack Overflow'
	Call	Wcrlf
	Mov	AX,Str6
	Call	WCstr	;'From Procedure/Function Call on Line Number'
	;Got an error, now fix up stack (We're in a proc entry)
	;to make it look like we're inside if a subprogram
	Pop	AX	;Junk the return address (An abort is coming up)
	Pop	AX	;Junk the RetEnd address
	Pop	AX	;Get the Call line number
	Call	Wint
			;Call Walk_Back with the chain pointer on the stack
	Jmp	Walk_Back ;Start in the walk_back loop of Err_Exit
Str5:	DB	27,'** Recursion Stack Overflow'
Str6:	DB	44,'From Procedure/Function Call on Line Number '

	;Error in source language exit
Proc Sour_Err
	Mov	AX,Str7
	Call	WCstr	;'Error in Source Language'
	Jmp	Err_Exit
Str7:	DB	27,'** Error in Source Language'
End Proc Sour_Err

	;Case Table Error (Case value in DX)
Proc CaseErr
	Push	DX
	Mov	AX,Str8
	Call	WCstr	;'No limb for case value, pos of error value = '
	Pop	AX
	Call	Wint	;Write Integer
	Jmp	Err_Exit
Str8:	db	48,'** No limb for case value, pos of error value = '
End Proc CaseErr

	;Null/Uninitialized Pointer Test
	;Makes sure that the pointer in AX points into the heap.
Proc Null_Ptr
;	Cmp	AX,0	;Pointer is not null if it does not equal 0
;	Jz	Null_Err
	Cmp	AX,[Heap_Bot]
	Jb	Null_Err ;Below the valid heap
	Cmp	AX,[Heap_Ptr]
	Ja	Null_Err ;Above the valid heap
	Ret
Null_Err: Mov	AX,Str10
	Call	WCstr	;'Attempt to reference thru Null pointer'
	Jmp	Err_Exit
Str10:	DB	55,'** Attempt to reference thru NULL/Uninitialized pointer'
End Proc Null_Ptr

	;Single Byte Range Test
	;Kills All except AL (Never returns if error)
	;Args follow call - dw Offset; db level
Proc Range1
	Pop	SI	;Get return address
	Seg	CS
	Mov	DI,[SI] ;Get Offset
	Inc	SI
	Inc	SI
	Seg	CS
	Mov	BL,[SI] ;Get Level
	Inc	SI
	Push	SI
	Xor	BH,BH
	Add	BX,BX
	Add	DI,[BX+DispStart]
			;Add display pointer to Offset to get address
	;Test Range
	Cmp	AL,[DI]
	JB	R1Err	;Not in range if Below low bound
	Cmp	AL,[DI+1]
	JA	R1Err	;Not in Range if Above high bound
	Ret		;Ok - Return
	;Range Error
r1err:	Push	AX	;Save value
	Mov	AX,str9
	Call	WCstr	;'Subscript or Subrange out of bounds'
	Pop	AX	;Get value back
	Xor	AH,AH	;Make an integer out of the byte
	Call	Wint
	Jmp	Err_Exit
Str9:	db	62,'** Subscript or Subrange Out of Bounds - Pos of Error',
		' Value = '
End Proc Range1

	;Single Byte Constant Range Test
	;Kills All except AL (Never returns if error)
	;Args follow call - dw Address (in Code Segment)
Proc SRange1
	Pop	SI	;Get return address
	Seg	CS
	Mov	DI,[SI] ;Get Address
	Inc	SI
	Inc	SI
	Push	SI
	;Test Range
	Seg	CS
	Cmp	AL,[DI]
	JB	R1Err	;Not in range if Below low bound
	Seg	CS
	Cmp	AL,[DI+2] ;Range is formatted as integers
	JA	R1Err	;Not in Range if Above high bound
	Ret		;Ok - return
End Proc SRange1

	;Word (Integer) Range Test
	;Kills All except AX (If no error - never returns if error)
	;Args follow call - dw Offset; db level
Proc Range2
	Pop	SI	;Get return address
	Seg	CS
	Mov	DI,[SI] ;Get Offset
	Inc	SI
	Inc	SI
	Seg	CS
	Mov	BL,[SI] ;Get Level
	Inc	SI
	Push	SI
	Xor	BH,BH
	Add	BX,BX
	Add	DI,[BX+DispStart]
			;Add display pointer to Offset to get address
	;Test Range
	Cmp	AX,[DI]
	JL	R2Err	;Not in range if Less than low bound
	Cmp	AX,[DI+2]
	JG	R2Err	;Not in Range if Greater than high bound
	Ret		;OK
	;Range Error
r2err:	Push	AX	;Save value
	Mov	AX,Str9	;Message is above, in Range1
	Call	WCstr	;'Subscript or Subrange Out of Bounds'
	Pop	AX	;Get value back
	Call	Wint	;Write out the error value
	Jmp	Err_Exit
End Proc Range2

	;Word (Integer) Constant Range Test
	;Kills All except AX (If no error - never returns if error)
	;Args follow call - dw Address (in Code Segment)
Proc SRange2
	Pop	SI	;Get return address
	Seg	CS
	Mov	DI,[SI] ;Get Address
	Inc	SI
	Inc	SI
	Push	SI
	;Test Range
	Seg	CS
	Cmp	AX,[DI]
	JL	R2Err	;Not in range if Less than low bound
	Seg	CS
	Cmp	AX,[DI+2]
	JG	R2Err	;Not in Range if Greater than high bound
	Ret		;OK
End Proc SRange2

	;Error Exit for crashes
	;Error message should be printed prior to entry
Proc EErr_Exit
Err_Exit: ;Address for Internal routines to come
	Call	Wcrlf
	Mov	AX,Str1
	Call	WCstr	;'On Line Number '
	Mov	AX,[LineNo]
	Call	Wint
	Push	[PchainPtr]	;Save chain pointer
Walk_Back: Mov	AX,Str2
	Call	WCstr	;' In '
	Pop	BX	;Get the Old chain address
	Push	[BX]	;Save the New Chain Address
	Push	[BX + (-2)]	;Get and Save the Line Number of Call
	Mov	AX,[BX + (-6)]	;Get the Name Location
	Inc	AX
	Inc	AX	;Skip the pointer at the exception handler
	Call	WCstr	;Write the Proc. name
	Call	Wcrlf
	Pop	AX	;Get the Line Number
	Cmp	AX,0
	Jnz	WSkip	;Done if the line number is zero
	Jmp	EHalt
WSkip:	Push	AX	;Save line number
	Mov	AX,Str3
	Call	WCstr	;'Called from line number'
	Pop	AX
	Call	Wint	;Write the line number
			;New chain address is still on the stack
	Jmp	Walk_Back
Str1:	DB	15,'On Line Number '
Str2:	DB	4,' In '
Str3:	DB	24,'Called from line number '
End Proc EErr_Exit

	;---- Unused Entry Points

Proc Notused4
	Ret
End Proc Notused4 
Proc Notused7 
	Ret
End Proc Notused7 
Proc Notused8 
	Ret
End Proc Notused8 
Proc Notused9 
	Ret
End Proc Notused9 
Proc Notused10
	Ret
End Proc Notused10
Proc Notused11
	Ret
End Proc Notused11
Proc Notused12
	Ret
End Proc Notused12
Proc Notused13
	Ret
End Proc Notused13
Proc Notused14
	Ret
End Proc Notused14
Proc Notused15
	Ret
End Proc Notused15
Proc Notused16
	Ret
End Proc Notused16
Proc Notused17
	Ret
End Proc Notused17
Proc Notused18
	Ret
End Proc Notused18
Proc Notused26
	Ret
End Proc Notused26
Proc Notused27
	Ret
End Proc Notused27
Proc Notused28
	Ret
End Proc Notused28
Proc Notused29
	Ret
End Proc Notused29
Proc Notused30
	Ret
End Proc Notused30
Proc Notused43
	Ret
End Proc Notused43
Proc Notused44
	Ret
End Proc Notused44
Proc Notused50
	Ret
End Proc Notused50
Proc Notused75
	Ret
End Proc Notused75



main_name: db	0,0	;{End of the walkback chain}
	;Each package resets the name on the stack to be equal to its
	;package name
pend:
End Package Jlib86
 Notused26
Proc Notused27
	Ret
End Proc Notused27
Proc Notused28
	Ret
End Proc Notused28
Proc Notused29
	Ret
End Proc nd Proc Notused10
Proc Notused11
	Ret
End Proc Notused11
Proc Notused12
	Ret
End Proc Notused12
Proc Notused13
	Ret
End