/*

	UNWS.C - Transforms a WordStar DOCUMENT file to
		 a file that is like a NON-DOCUMENT file.
		 Specifically, transforms the end-of-line sequences
	  	 into normal CRLF sequences or SPACES depending
		 on what the user wants. Lines beginning with a
		 DOT '.' may be filtered out in the copy if the
		 user requests.
		 In addition to this, each character has it's top bit 
		 cleared and control characters other than CR, LF, TAB 
		 are filtered out. 

	Copyright (c). 1983 Solution Systems. All Rights Reserved.

*/

#include <stdio.h>
#define CR 0x0d
#define LF 0x0a
#define ASCII 0x7f
#define CTRLZ 26
#define TAB 9


main(argc,argv)
int argc;
char *argv[];
{
FILE *input, *output;
int crlf, skip, ch; 

	fputs("\nUNWS. Copyright (c) 1983, Solution Systems\n",stderr); 

	if(argc<3) 
	   { 
	   fputs("\nUsage: UNWS infile outfile\n",stderr); 
	   return;
	   } 

	input = fopen(argv[1],"rb");
	if(!input)
	   {
	   fputs("\nInput file not opened for READ\n",stderr);
	   return;
	   }
	
	output = fopen(argv[2],"w");
	if(!output)
	  {
	  fputs("\nOutput file not opened for WRITE\n",stderr);
	  fclose(input);
	  return;
	  }

	fputs("\nPlease select one of the following options:\n",stdout);
	fputs("\nA - Replace end of line character with CRLF ",stdout);
	fputs("\nB - Replace end of line character with SPACE ",stdout);
	fputs("\nC - Replace end of line character with NOTHING ",stdout);
	ch = getchar(); if(ch!='\n') while(getchar()!='\n') ; 
	crlf = toupper(ch);

	fputs("\nDo you want to filter out lines starting with '.' (Y/N) ? ",
		stdout); 

	ch = getchar(); if(ch!='\n') while(getchar()!='\n') ; 
	skip = toupper(ch)=='Y';	 

	unws(input,output,crlf,skip);

	fclose(input);
	fclose(output);
	return;
}


/*
	unws: this function does the work once the files are
	      opened and the options selected.
*/
unws(input,output,crlf,skip)
FILE *input,
     *output;
int crlf, skip;
{
int ch, pos;

	pos = 0;

	for(;;)   /* return through switch */
	   switch(ch = fgetc(input))
	      {
regular:      default:
		if(inrange(ch&=ASCII)) fputc(ch,output);
		pos++; break;

	      case CTRLZ: case EOF: return; 

	      case '.': if(pos || skip==0) goto regular;
		while((ch = fgetc(input)) != CTRLZ && ch != EOF) 
		   if((ch &= ASCII) == CR || ch == LF) break; 
		pos=0; break; 

	      case 0x8d:		
		if((ch = fgetc(input)) == 0x0a) /* soft return */ 
		   switch(crlf) 
		      { 
		      default: break; 
		      case 'A': fputc('\n',output); break; 
		      case 'B': fputc(' ',output); break; 
		      } 
		else { fputc(0x0d,output);  goto regular; } 
		pos = 0; break; 
	 
	      case 0x0a: break; 
	      case 0x0d: fputc('\n',output); pos = 0; break; 
	      }


} 

/* 
	inrange: returns 1 if the character is a non-control character 
		 returns 0 if the character is a control character 
		 (except for CR, LF, TAB) 
*/ 
inrange(c)
int c;
{
	return((c > CTRLZ && c < ASCII) || c == CR || c == LF || c == TAB);
}
wit