/* input / output routines for pt */
#include "b:pt.h"
#include "b:ptdefs.h"

/* xfopen: */
xfopen(fn,mode) char *fn, *mode; {
char *fcb;
FILE *fptr;
      s_toupper(fn);  add_drive(fn,drive);
      fcb = (char *) makefcb(fn);
      if(SHIELD==FALSE || index(mode,'r')) goto  ok; /* read */
      if((bdos(0x11,fcb)&0xff)==0xff) goto ok;
      fprintf(stderr,
	"%s already exists. Would you like to write over it \007 ? ",fn); 
      if(toupper(bdos(1))!='Y') { free(fcb); return 0; } 
ok:
      free(fcb);
      fptr = fopen(fn,mode); if(fptr) return(fptr);
      message3(fn," was not opened for ",
		 index(mode,'r') ? "reading." : "writing.");
      return 0;
}

/* findout: */
findout(fn,msg) char *fn, *msg; {
	fprintf(progout,"Please enter the name of the file to %s to > ",msg);
	if(!xfgets(fn,BLOCK,progin)) return FALSE;
	chop(fn);
	return(strlen(fn));
}

/* findin: */
findin(fn,msg) char *fn, *msg;
{
	fprintf(progout,"Please enter the name of the file to %s > ",msg);
	if(!xfgets(fn,BLOCK,progin)) return(FALSE);
	chop(fn); return(strlen(fn));
}

/*
	newline:	put out a CRLF
*/
newline()
{
	fputc('\n',progout);
	return;
}

/*
	getnum:		get a decimal number from progin
*/
getnum(msg,fill)
char *msg; int *fill;
{
char *tmp;
unsigned char tries;
	tries = 0;
	getvec(&tmp);
ask:
	xfputs("\nPlease enter ",progout);
	xfputs(msg,progout); xfputs(" : ",progout);
	if(!xfgets(tmp,BLOCK,progin))
	  { *fill=0; free(tmp); return 0; }
	if(sscanf(tmp,"%d",fill)) { free(tmp); return 1; }
	if(tries++ > 5) { free(tmp); return 0; }
	goto ask;
}


/*
	prompt:	display a newline and a message to progout
*/
prompt(msg)
char *msg;
{
	newline();
	xfputs(msg,progout);
	fputc(' ',progout);
	return;
}

/*
	prompt2: display 2 messages
*/
prompt2(m1,m2)
char *m1, *m2;
{
	prompt(m1);
	xfputs(m2,progout);
	fputc(' ',progout);
	return;
}

/*
	prompt3: display 3 messages
*/
prompt3(m1,m2,m3)
char *m1, *m2, *m3;
{
	prompt2(m1,m2);
	xfputs(m3,progout);
	fputc(' ',progout);
	return;
}

/*
	prompt4: 4 messages
*/
prompt4(p1,p2,p3,p4)
char *p1, *p2, *p3, *p4;
{
	prompt3(p1,p2,p3);
	xfputs(p4,progout);
	fputc(' ',progout);
	return;
}

/*
	message:	put a message to progout
*/
message(s)
char *s;
{
	xfputs("\n\t\t",progout);
	xfputs(s,progout);
	fputc(' ',progout);
	return;
}

/*
	message2:	put 2 messages to progout
*/
message2(s1,s2)
char *s1, *s2;
{
	message(s1); xfputs(s2,progout);
	fputc(' ',progout);
	return;
}

/*
	message3:	put 3 msgs to progout
*/
message3(m1,m2,m3)
char *m1, *m2, *m3;
{
	message2(m1,m2);
	xfputs(m3,progout);
	fputc(' ',progout);
	return;
}

/*
	message4:	put 4 messages to progout
*/
message4(m1,m2,m3,m4)
char *m1, *m2, *m3, *m4;
{
	message3(m1,m2,m3);
	xfputs(m4,progout);
	fputc(' ',progout);
	return;
}


/*
	select_drive:	takes the letters 'a' thru 'p'
*/
select_drive(d)
char d;
{
	d = toupper(d);
        if(d>='A' && d<='P')
	bdos(0x0e,d-'A');
	return;
}

/*
	get_drive: return character of drive selected
*/
char get_drive()
{
	return(bdos(0x19)+'A');
}

/*
	reading:	report name of file being read
*/
reading(s)
char *s;
{
	s_toupper(s);
	message2("Reading file: ",s);
	return;
}

/*
	writing:	report name of file being written to
*/
writing(s)
char *s;
{
	s_toupper(s);
	message2("Writing file: ",s);
	return;
}

/*
	fnf:	report file not found
*/
fnf(s)
char *s;
{
	s_toupper(s);
	message3("File: ",s,"not found");
	newline();
	return;
}


/*
	s_tolower:
*/
s_tolower(s)
char *s;
{
int i;
	for(i=0; i<strlen(s); i++)
	 *(s+i) = tolower(*(s+i));
	return;
}

/*
	s_toupper:
*/
s_toupper(s)
char *s;
{
int i;
	for(i=0; i<strlen(s); i++)
	  *(s+i) = toupper(*(s+i));
	return;
}


/*
	s_toascii:
*/
s_toascii(s)
char *s;
{
int i;
	for(i=0; i<strlen(s); i++)
	  *(s+i) &= 0x7f;
	return;
}

/*
	chop:
*/
chop(s)
char *s;
{   
int len;
	len=strlen(s);
	if(len==0) return;
	if(*(s+len-1)=='\n') *(s+len-1)=EOS;
	return;
}



/*
	clearscreen:
*/
clearscreen()
{
int i;
	for(i=0; i<24; i++) bdos(6,10);
}

/*
	xfread:
*/
xfread(buffer,count,size,input)
char *buffer;
unsigned int count, size;
FILE *input;
{
int res;
	res = read(input-0x8000,buffer,size*count);
	if(res<=0) return 0;
	return(res/size);
}

/*
	xfwrite:
*/
xfwrite(buffer,count,size,output)
char *buffer;
unsigned int count, size;
FILE *output;
{
int res;
	res = write(output-0x8000,buffer,size*count);
	if(res<=0) return 0;
	return(res/size);
}


/*
	xfgets:
*/
xfgets(buffer,count,input)
char *buffer;
unsigned count;
FILE *input;
{
int res;
	res = read(input-0x8000,buffer,count);
	if(res<0) return 0;
	*(buffer+res)=EOS;
	return res;
}

/*
	xfputs:
*/
xfputs(buffer,output)
char *buffer;
FILE *output;
{
int res;
	res = write(output-0x8000,buffer,strlen(buffer));
	return(res<=0 ? 0 : res);
}
t, size;
FILE *output;
{
int res;
	res = write(output-0x8000,buffer,size*count);
	if(res<=0