/*
 *	        DIFF file comparison utility vers. 1.8
 *
 *	   USAGE: diff [-flags] file_in [ > file_out or prn:]
 *
 *	                 FOR CP/M AND AZTEC C
 *
 *
 *         Copyright (c) December 1983,84 by Solution Systems
 */

#include "local.h"

#define LAST_TOKE 32765 /* at least 1 less than max positive int */
#define MAXLEN 255
#define HUNKSIZE 8192	/* Size of each circular buffer */
#define HASHCHUNK 16	/* # lines of each file to search for initial match */
#define HSIZE 2048	/* total # of lines that the hash table can hold */
struct line *missm[2];	/* last line fetched for htbl */
struct line *htbl[HSIZE];
struct _buf *fin[2];
struct _buf *in0, *in1;

/* data in the circular buffers is stored in linked form */
struct line {
	unsigned hash;		/* hashed value of text special case EOF=0 */
	char f; 		/* 0 or 1 which file it came from */
	int num;		/* number of line or LAST_TOKE if EOF */
	struct line *next;	/* pointer to next line, or null if last in
				   buffer, or to itself if EOF */
	char text[];		/* asciz line of text */
}
*bottom[2],			/* bottom of each file's buffer */
*top[2],			/* top of each buffer */
*thislna, *thislnb,		/* line just fetched from buf */
cdq[2]; 			/* reader from each file */
struct line *getnext(); 	/* forward declarations */

int linno[2];
int getc1();
int getc2();
int (*getit[2])();		/* getchar function for each file */
int (*getthis)();		/* getchar function for current file */
char bfx[2][HUNKSIZE];		/* circular buffers */
char *p, *q, *qq, *qqq, count;
char *Fname, *Dlinenum, Different, Display;
char ineof[2];			/* EOF (cpmeof) seen on file input */
char *patha, *pathb;		/* names of each file */

getc1()
{
	return getc(in0);
}

getc2()
{
	return getc(in1);
}

main(argc, argv)
char **argv;
{
char i, *cp, **av;
int ac;
	Different=Display=Fname=FALSE;
	Dlinenum=TRUE;
	getit[0]=getc1;
	getit[1]=getc2;
	while (--argc && *(cp = *++argv)=='-') {
		while( *++cp) {
			switch(tolower(*cp)) {
			case 'd':
				Display++;
				break;
			case 'f':
				 Fname=TRUE;
				 break;
			case 'l':
				 Dlinenum=FALSE;
				 break;
			default:
				goto usage;
			}
		}
	}
	if(argc < 1 || argc > 2) {
usage:
		fprintf(stderr,
		"\nDIFF File Comparison Utility, Copyright (c) Dec. 1983,84 by Solution Systems\n\n");
		fprintf(stderr,
		"Usage: diff [-flag(s)] filea fileb [>outfile]\n");
		fprintf(stderr,"\t-l don't display 'diff' line numbers\n");
		fprintf(stderr,"\t-d display lines that match\n");
		fprintf(stderr,"\t-f display file names\n");
		exit(1);
	}
	patha=argv[0];
	if ((fin[0]=fopen(patha,"r")) == NULL) {
		fprintf(stderr,
		"\nDIFF File Comparison Utility, Copyright (c) Dec. 1983,84 by Solution Systems\n\n");
		fprintf(stderr, "Can't open %s", patha);
		exit(128);
	}
	else
		in0=fin[0];

	if(argc==2) {
		if((fin[1]=fopen((pathb=argv[1]), "r")) == NULL) {
			fprintf(stderr, "Can't open %s", argv[1]);
			exit(128);
		}
		else
			in1=fin[1];
	}
	else goto usage;

	fprintf(stderr,"\nDIFF File Comparison Utility, Copyright (c) Dec. 1983,84 by Solution Systems");
	fprintf(stderr,"\nComparing files %s and %s\n\n",patha,pathb);
	ineof[0]=ineof[1]=FALSE;
	cdq[0].next=p=bottom[0] = bfx[0];
	cdq[1].next=bottom[1]=top[0]= bfx[1];
	top[1]= bfx[2];

     /* initialize this line so it won't get in the way of filling buffer */
	thislna=thislnb=0;
			    /* get the first line from each and start chain */
	getline(0, &cdq[0]);
	thislna=bottom[0];
	getline(1, &cdq[1]);
	thislnb=bottom[1];
	while( thislna->num != LAST_TOKE | thislnb->num != LAST_TOKE) {
		if(strcmp(thislna->text, thislnb->text))
			dodiff();
		else {
			if(Display)
				printf("%3d %3d   %s", thislna->num, thislnb->num, thislna->text);
			thislna=getnext(thislna);
			thislnb=getnext(thislnb);
		}
	}
	if(Different)
		fprintf(stderr,"\nFiles are different\n");
	else {
		fprintf(stderr,"\nNo differences encountered\n");
	}
}

struct line *getnext(fp)
register struct line *fp;
{
	if(fp->next)
		return fp->next;		/* link to next line */
	getline(fp->f, fp);			/* end of buffer -get more */
	return fp->next;
}

getline(n, fp)
struct line *fp;
char n;
{
struct line *gp;
int *number, len;
	number= &linno[n];
	getthis=getit[n];
	q=top[n];
	q -= (MAXLEN + 4 + sizeof(*fp));
	qq=n?thislnb:thislna;
	qqq = qq - (MAXLEN + 4 + sizeof(*fp));
	p=fp->next;
	if(p==NULL) {
		p=fp;
		p += sizeof(*fp)+1+strlen(fp->text);
	}
	if(ineof[n]) {
		fprintf(stderr, "Getline called after E-O-F\n");
		fputs(fp->text, stderr);
		return;
	}
	for(;;) {
			      /* check if we need to wrap at end of buffer */
		if(p > q) {
			p=bottom[n];
			if(qq==0)
				goto label;    /* special case first time */
		}
		/* is the buffer filled up ? */
		if(p <= qq && p >= qqq) {	/* before thislin ? */
label:
			return;
		}
		gp=p;
		gp->f=n;
		for(p=gp->text, count=MAXLEN; --count; )
			switch(*p++ = (*getthis)() ) {
			case CPMEOF:
			case EOF:
			case 0377:
				ineof[n]=TRUE;
				gp->hash = ~0;
				gp->next = gp;		/* link to self */
				gp->num = LAST_TOKE;
				strcpy(gp->text, "**EOF**\n");
				fp->next=gp;
				return;
			case 012:
				++*number;
				goto gotline;
			case 015:
				--p;
			}
		fprintf(stderr,"Line %d is too long\n", *number);
gotline:
		*p=0;
		gp->hash = 0;
		gp->num = *number;
		fp->next=gp;
		fp=gp;		/* advance along new chain */
		fp->next=NULL;
		++p;		/* bump pointer past trailing null */
	}
}

comp(a,b)
struct line **a, **b;
{
	if( (*a)->hash > (*b)->hash)
		return 1;
	if( (*a)->hash < (*b)->hash)
		return -1;
	return (*a)->f - (*b)->f;
}

dodiff()
{
	register struct line **lp;
	int quantity, m, l;
	char keepatit, n, wanta, wantb;
	Different=TRUE;
	wanta=wantb=TRUE;
	lp=htbl;
	*lp++ =missm[0]=thislna;
	*lp++ =missm[1]=thislnb;

	for(quantity=2,l=HASHCHUNK, keepatit=TRUE;
	  keepatit && (wanta||wantb); l+=l) {
		    if(wanta)
			for(m=l; --m>=0; ) {
				if((*lp = getnext(missm[0]))==NULL) {
					wanta=FALSE;
					break;
				}
				missm[0]= *lp++;
				/* quit n-o-w if table filled */
				if(++quantity==HSIZE) {
					keepatit=FALSE;
					goto nowlook;
				}
				/* Don't fill up the table with eof's */
				if(missm[0]->num==LAST_TOKE) {
					wanta=FALSE;
					break;
				}
			}
		if(wantb)
			for(m=l; --m>=0; ) {
				if((*lp = getnext(missm[1]))==NULL) {
					wantb=FALSE;
					break;
				}
				missm[1]= *lp++;
				if(++quantity==HSIZE) {
					keepatit=FALSE;
					goto nowlook;
				}
				if(missm[1]->num==LAST_TOKE) {
					wantb=FALSE;
					break;
				}
			}
nowlook:
		qsort(htbl, quantity, sizeof(p), comp);
		if(lookferit(quantity)) {
			return;
		}
	}
	fprintf(stderr,"Can't find match at a:line %d b:line %d\n",
	thislna->num, thislnb->num);
	exit(1);
}

lookferit(quantity)
{
	struct line *loa, *lob, **pa, **pb, **pe, *fp;
	int m, lowa, lowb;
	lowa=lowb=LAST_TOKE+1;
	pe= &htbl[quantity];
	for(pa=htbl; pa < pe; ++pa) {
		if((*pa)->f)
			continue;
		for(pb=pa+1; pb < pe; ++pb) {
			if((*pb)->f == 0)
				continue;
			if((*pa)->hash != (*pb)->hash)
				continue;
			if((*pa)->num > lowa || (*pb)->num > lowb)
				continue;
			if((*pa)->next==NULL || (*pb)->next==NULL)
				continue;
			if((*pa)->next->hash != (*pb)->next->hash)
				continue;
			if(strcmp((*pa)->text, (*pb)->text))
				continue;
			if(strcmp((*pa)->next->text, (*pb)->next->text))
				continue;
			lowa=(*pa)->num;
			lowb=(*pb)->num;
			loa= *pa;
			lob= *pb;
		}
	}
	if(lowa > LAST_TOKE) {
		return FALSE;
	}

	for(fp=thislna; fp->num < lowa; fp=getnext(fp)) {
	     if (Dlinenum) {
		if (Fname) printf("%3d *** %s",fp->num, patha);
		else printf("%3d ***",fp->num);
	     }
	     else {
		if (Fname) printf("*** %s",patha);
		else printf("***");
	     }
	     printf("  %s", fp->text);
	}

	for(fp=thislnb; fp->num < lowb; fp=getnext(fp)) {
	     if (Dlinenum) {
		if (Fname) printf("--- %3d %s",fp->num, pathb);
		else printf("--- %3d",fp->num);
	     }
	     else {
		if (Fname) printf("--- %s", pathb);
		else printf("---");
	     }
	     printf("  %s", fp->text);
	}

	/* advance pointers to matched lines */
	thislna= loa;
	thislnb= lob;
	return TRUE;
}

/*	Hores quicksort algorithm
*/

#define DEPTH 20		/* should be adequate for most sorts */

static swapbyte(a,b,count)
char *a,*b;
unsigned count;
{
  int temp;

  while(count--){
    temp=*a;
    *a++=*b;
    *b++=temp;
  }
}

qsort(base,n,width,cmpf)
char *base;		        /* base of data */
unsigned int n;			/* number of items to sort */
unsigned width;			/* width of an element */
int (*cmpf)();			/* key comparison function */
{
  unsigned j,k,pivot,count,low[DEPTH],high[DEPTH];

  if(n<2)return;		/* already sorted */
  count=1;			/* do initialisation */
  low[0]=0;
  high[0]=n-1;
  while(count--){
    pivot=low[count];
    j=pivot+1;
    n=k=high[count];
    while(j<k){
      while(j<k && (*cmpf)(base+j*width,base+pivot*width)<1)++j;
      while(j<=k && (*cmpf)(base+pivot*width,base+k*width)<1)--k;
      if(j<k)swapbyte(base+(j++*width),base+(k--*width),width);
    }
    if((*cmpf)(base+pivot*width,base+k*width)>0)
	swapbyte(base+pivot*width,base+k*width,width);
    if(k>pivot)--k;
    if(k>pivot && n>j && (k-pivot < n-j)){
      swapbyte(&k,&n,2);
      swapbyte(&pivot,&j,2);
    }
    if(k>pivot){
      low[count]=pivot;
      high[count++]=k;
    }
    if(n>j){
      low[count]=j;
      high[count++]=n;
    }
    if(count>=DEPTH)abort("qsort failure");
  }
}

abort(string)
char *string;
{
  fprintf(stderr,"\nABORT:- ");
  fprintf(stderr, "%s", string);
  fprintf(stderr,"\n");
  exit(0);
}
unsigned j,k,pivot,count,low