PROGRAM powertable (input,output);
	(* note again the input,output optionals *)
	(* NOTE ALSO THAT THE ; FOLLOWING (input,output) is NOT 
	   optional -- but the compiler will think the error is
	   in LINE 31 rather than 1.  The compiler counts all lines
	   including comments and blanks. *)

	(* This program prints a table of powers and roots. 
	Note use of writeln function rather than write.*)

	(* This will compile under both MT+ and M.  However,
	PASCAL M writes out variables to a LOT of precision, so that
	the writeln statements have to have a precision specified to make
	them line up right.  Study Grogono to see how.*)

{ Alas, MT+ and M have different requirements for trying to format output.
MT+ will compile this program with base, square, cube, and quad declared as
integers, with formatted output.  PASCAL/M will NOT allow you to format integer
output, and does not do any implicit conversion from integer to real.  The 
resulting confusion isn't our fault.  If you want to turn this into an MT+
program looking a lot like Grogono's, you can go back and change the 
declarations.  }

	CONST
		{See page 38 Grogono (second edition) to see how to add
		fieldwidth and precision to the writeln statements.
		You declare :}
		
		precision = 5;
		fieldwidth = 8;   (*as examples anyway *)

		{and insert these in the writeln after EACH VARIABLE that you
		want to format properly.  Try that.  With MT+ the precision
		defaults to a lower value and it makes a table without all
		this nonsense.  }

	VAR
	   tablesize : integer;

	   base : integer;
	   square, cube, quad : real;

	BEGIN
	   write('Input tablesize: '); (*not in Grogono, but needed!!!*)
	   read(tablesize);
	   FOR base := 1 TO tablesize DO  (* note := is not same as = *)
		BEGIN
			square := sqr(base);
			cube := base * square;
			quad := sqr(square);
			writeln((base):9,(square):9,(cube):9,(quad):9,
				(1/base):9,(1/square):9,(1/cube):9,(1/quad):9);
(* The ; above is optional*)

	END {for};

{  A note on formatting output: the ':9' after each of the output fields should
   (according to J & W) result in nine space wide fields for each of them.  In
   P/MT+ this works correctly for all eight fields; in P/M it does not.  The 
   first four, which are integers, look fine; the last four, which become
   reals, are not formatted at all (they look the same whether or not the ':9' 
   follows).  }

	writeln;

{  The following will compile with MT+ but will NOT compile with M
	when base, square, cube and quad are declared as integers.


	FOR base := 1 TO tablesize DO
	BEGIN

			square := sqr(base);
			cube := base * square;
			quad := sqr(square);


	writeln(base:fieldwidth:precision,
		square : fieldwidth:(precision),
		cube : fieldwidth : precision,
		quad : fieldwidth : precision,
		(1/base): fieldwidth : precision,
		(1/square): fieldwidth : precision,
		(1/cube): fieldwidth : precision,
		(1/quad): fieldwidth : precision )

	END (* for *);
(* semicolon for above is optional *)  END LONG COMMENT }

	FOR base := 1 TO tablesize DO
	BEGIN

			square := sqr(base);
			cube := base * square;
			quad := sqr(square);

	writeln(base,     (*  in MT+ this could also have formatters.*)
		square : fieldwidth:(precision),
		cube : fieldwidth : precision,
		quad : fieldwidth : precision,
		(1/base): fieldwidth : precision,
		(1/square): fieldwidth : precision,
		(1/cube): fieldwidth : precision,
		(1/quad): fieldwidth : precision )

	END {for};
(* semicolon for above is optional *)   

   END. {powertable}  (* Note that curly brace is also comment separator*)
