REM	Program NORMAL
rem	Takes a text file and puts it into a "normal" format
rem	with carriage return and line feed and lines 80 chars
rem	or fewer long.

rem	******		DECLARATIONS		****

STRING COMMAND.NAME, FILENAME, INFILE, OUTFILE
STRING WORKLINE, OUTLINE
STRING CR$, FF$, LF$, Bell$, SPACE$, TILDE$, CTL.Z$
STRING BLANK$

INTEGER i,j,k
INTEGER TRUE, FALSE, MAXLEN
INTEGER SPACE,TILDE,DEL,CR,LF,FF,CTL.Z,TABIT,BELL
INTEGER EOL, EOF,LOUD.FLAG,DOUBLE.FLAG,BREAK.FLAG,SKIP.FLAG,FFFLAG

REM	****		DEFINITIONS		***

TRUE 		=	1
FALSE 		=	0

MAXLEN 		=	78
BREAK.FLAG	=	FALSE
LOUD.FLAG	=	FALSE
DOUBLE.FLAG	=	FALSE

Space 		= 32
Tilde 		= 126
CR    		= 13
LF    		= 10
CTL.Z		= 26
TABIT		= 9
Bell  		= 7
FF		= 12
DEL		= 127

BLANK$ = ""
SPACE$ = " "
CR$ 		=	CHR$(CR)
LF$ 		=	CHR$(LF)
BELL$ 		=	CHR$(BELL)
CTL.Z$		=	CHR$(CTL.Z)
FF$ 		=	CHR$(FF)


REM	***		FUNCTIONS		***


DEF FN.FILTER$(C)
	STRING STUFF, C$
	INTEGER I,C

	EOL = FALSE
	FFFLAG = FALSE
	IF C >= SPACE AND C < DEL THEN \
		FN.FILTER$ = CHR$(C) : RETURN

	IF C = LF THEN FN.FILTER$ = BLANK$ : RETURN

	IF C = FF THEN FN.FILTER$ = CHR$(C) : \
	   EOL = TRUE : FFFLAG = TRUE : RETURN

	IF C = TABIT THEN FN.FILTER$ = CHR$(C) : RETURN

	IF C = CR THEN EOL = TRUE : FN.FILTER$ = BLANK$ : RETURN

	IF C = CTL.Z THEN EOF = TRUE : \
		FN.FILTER$ = CHR$(C) : RETURN

	IF C < SPACE THEN FN.FILTER$ = BLANK$ : PRINT "FOO" : RETURN
RETURN
FEND

DEF FN.PUTOUT(I%)
	INTEGER I%
	IF DOUBLE.FLAG THEN OUTLINE = OUTLINE + CR$ + LF$
	IF LOUD.FLAG THEN PRINT OUTLINE
	PRINT USING "&"; #I%; OUTLINE
FEND

DEF FN.GETIT(ID)
	INTEGER ID, C

	SKIP.FLAG = FALSE
	EOL = FALSE
	WORKLINE = BLANK$

REM	****	FOLLOWING IS A TRAP FOR LINES THAT ARE A SINGLE CR
	C = GET(ID)
	IF C = CR THEN SKIP.FLAG = TRUE : GOTO ENDGET
REM	 **** THE ABOVE TAKES CARE OF LINES THAT ARE A SINGLE CR

	WORKLINE = FN.FILTER$(C)
	WHILE EOL = FALSE
		C = GET(ID)
		WORKLINE = WORKLINE + FN.FILTER$(C)
	WEND
ENDGET:	REM
FEND

DEF FN.YES%(S$)
	STRING JIVE$, S$
	PRINT S$;
	INPUT JIVE$
	IF UCASE$(LEFT$(JIVE$,1)) =  "Y" THEN \
		FN.YES% = TRUE  \
	   ELSE \
		FN.YES% = FALSE
	RETURN
FEND

DEF FN.GETOUT(S$)
	STRING S$, C$
	INTEGER LEN.COUNT, LEN.W, COUNTER

	LEN.W = LEN(S$)
	IF LEN.W <= MAXLEN THEN OUTLINE = S$ : WORKLINE = BLANK$ : RETURN
	S$ = LEFT$(S$,MAXLEN)
	COUNTER = 0
HERE:	C$ = MID$(S$, MAXLEN - COUNTER, 1)
	IF C$ <> SPACE$ AND C$ <> FF$  THEN \
		COUNTER = COUNTER + 1 : GOTO HERE

	OUTLINE = LEFT$(S$, MAXLEN - COUNTER)
	S$  = RIGHT$(S$,COUNTER)
	WORKLINE = RIGHT$(WORKLINE, LEN(WORKLINE)-MAXLEN)
	WORKLINE = S$ + WORKLINE
	RETURN
FEND


REM	****		PROGRAM		***

rem	INITIALIZE

EOF = FALSE : EOL = FALSE
LOUD.FLAG = FALSE : SKIP.FLAG = FALSE

PRINT	"This is NORMAL, a program to accept text and output it formatted"
print   "with CR-LF pair to mark paragraph ends.  The program can also break"
print	"the lines into 78 characters or fewer."
PRINT

print	"Do you want me to break the lines ";
	IF FN.YES%("") then BREAK.FLAG = TRUE

PRINT	"Should I double space between paragraphs (ie add an extra CR LF)";
IF FN.YES%("") THEN DOUBLE.FLAG = TRUE

100	INPUT "Input File Name : "; LINE INFILE
PRINT

IF END # 1 THEN 150

OPEN INFILE AS 1
rem IF END #1 THEN GO TO 200	REM GO TO ENDIT
IF END  #1 THEN ENDIT
REM	****  IF END #1 THEN GOTO ENDIT   REM  wouldn't compile this.

GOTO GETOUT   rem  jump over 150

150	Print "Cannot open ";INFILE : GO to 100

GETOUT:    rem   try getting output
180	rem	who knows?
PRINT
INPUT "Output File Name :"; LINE OUTFILE
PRINT

IF SIZE(OUTFILE) <> 0 THEN \
	PRINT "File ";OUTFILE;" eixsts, and has size ";SIZE(OUTFILE) : \
	Print "If you continue I will write over that file." : \
	IF FN.YES%("Continue") = FALSE then GO TO GETOUT

CREATE OUTFILE AS 2	rem	MUST CREATE

IF FN.YES%("Display output") then loud.flag = true
PRINT

WHILE	true 		rem DO IT UNTIL END #1
	CALL FN.GETIT(1)
	IF (SKIP.FLAG = TRUE) THEN  \
		OUTLINE = CR$ : \
		CALL FN.PUTOUT(2) : GOTO SKIPOVER

	IF BREAK.FLAG = FALSE THEN OUTLINE = WORKLINE : \
		CALL FN.PUTOUT(2) : GOTO SKIPOVER

	WHILE LEN(WORKLINE) > MAXLEN
		CALL FN.GETOUT(WORKLINE)
		CALL FN.PUTOUT(2)
	WEND
	IF LEN(WORKLINE) > 0 THEN OUTLINE = WORKLINE : CALL FN.PUTOUT(2)
SKIPOVER:	REM	COMES HERE if no break
WEND

ENDIT:		rem	We have hit the end of file.
200		REM	The label should be enough, but it isn't.
PRINT BELL$
WHILE NOT EOF
	CALL FN.GETIT(1)
	IF (SKIP.FLAG = TRUE) THEN \
		OUTLINE = CR$ : \
		CALL FN.PUTOUT(2) : GOTO SKIPTOO

	IF BREAK.FLAG = FALSE THEN OUTLINE = WORKLINE : \
		CALL FN.PUTOUT(2) : GOTO SKIPTOO

	WHILE LEN(WORKLINE) > MAXLEN
		CALL FN.GETOUT(WORKLINE)
		CALL FN.PUTOUT(2)
	WEND
	IF LEN(WORKLINE) > 0 THEN OUTLINE = WORKLINE : CALL FN.PUTOUT(2)
SKIPTOO:	REM	SKIPS TO HERE
WEND

WORKLINE = BLANK$
WORKLINE = WORKLINE + CR$ + LF$
WORKLINE = WORKLINE + CTL.Z$

PRINT USING "&"; #2; WORKLINE

CLOSE 1
CLOSE 2

PRINT "All done."
PRINT  INFILE;" normalized and copied to ";
print OUTFILE

END

