(* this is the file mfileio.pas, a file of more file I/O stuff for Pascal M. *)
(*
function open (var name : string; mode : integer) : filedesc; forward;
(*
function create (var name : string; mode : integer) : filedesc; forward;
*)
(* Tool_close and the forward declarations for putstr, message, and error
  now appear in the file TOOLCLSE.PAS *)

{ error -- (M) prints an error message, attempts to close all files }
{note: does not close input, output, nor stderr; if it did, it would affect
 nothing outside the program), and then quits the program. }
procedure error (*( panic_message : string )*);
var
    i : filedesc;
begin
  message(panic_message);
  message('Attempting to close all files');
  for i := (STDERR+1) to MAXOPEN do
    tool_close(i);
  message('Exiting to CP/M...');
  halt;			(* the M procedure to exit the main program is called
			  "halt" and is called by its name, however,
			  exit(program) seems to work, too.  The manual says
			  to exit the main program by its name (or halt), but
			  it seems you have three options. *)

end (* error *);

{ getcf -- (M) get one character from file }
function getcf (var c : character; fd : filedesc) : character;

(* Yes, this is a S*L*O*W way of doing these functions, but it works!  Feel
  free to suggest new and better ways of doing this stuff; I think K & P can
  be improved upon with little loss of generality. *)

function file_getc (var fyle : text) : character;
var
    ch : char;
begin
  if eof(fyle) then
    file_getc := ENDFILE
  else if eoln(fyle) then begin
    readln(fyle);
    file_getc := NEWLINE
  end
  else begin
    read(fyle, ch);
    file_getc := ord(ch);
  end;
end (* file_getc *);

begin (* getcf *)
    if (fd = STDIN) then
	getcf := getc(c)
    else begin
      case fd of
(*	STDOUT: closed := eof(STDOUTFILE);	-- output file only *)
(*	STDERR: closed := eof(STDERRFILE);	-- ditto *)
	4: c := file_getc(file1);
	5: c := file_getc(file2);
	6: c := file_getc(file3);
	7: c := file_getc(file4);
	8: c := file_getc(file5)
      otherwise
	c := ENDFILE;
      end (* case *);
      getcf := c;
    end (* if fd = STDIN *);
end (* getcf *);

{ getline -- (M/MT+) get a line from file.}
{ Substantially different from the book's implementation, this one should have 
  no problems with lines longer than 80 or 255 characters. }
function getline (var s : string; fd : filedesc;
	maxsize : integer) : boolean;
var
    i : integer;
    c : character;
    small_string : string[1];	(* added for use in concat *)

(* Note that anything in the string s is lost when using this procedure; this
  is actually no different from the book, though it's done differently. *)

begin
    i := 1;
    s := '';
    small_string := ' ';	(* sets length correctly *)
    repeat
        small_string[1] := chr(getcf(c, fd));   (* gets char into
						   small_string*)

(* The following replacement may work on some systems:

	s := concat(s, chr(getcf(c, fd));

  I won't guarantee it. *)

	s := concat(s, small_string);
	i := i + 1;
    until (c = ENDFILE) or (c = NEWLINE) or (i >= maxsize);
    if (c = ENDFILE) then    { gone too far }
	delete(s, length(s), 1);
    getline := (c <> ENDFILE)
end (* getline *);

{ putcf -- (M) put a single character on file fd }
procedure putcf (c : character; fd : filedesc);
const
    putcf_err_msg = 'attempted to output to nonexistent file (putcf)';
var
  ch : char;

procedure file_putc (c : character; var fyle : text);
begin
  if (c = NEWLINE) then writeln(Fyle)
  else write(fyle, chr(c));
end (* file_putc *);

begin (* putcf *)
    if (fd = STDOUT) then
	putc(c)
    else
	case fd of
	STDERR: file_putc(c, STDERRFILE);
	4: file_putc(c, file1);
	5: file_putc(c, file2);
	6: file_putc(c, file3);
	7: file_putc(c, file4);
	8: file_putc(c, file5);
	otherwise
	  error(putcf_err_msg);
	end(* case *)
end (* putcf *);

{ putstr -- (M/MT+) put out string on file }
procedure putstr (*(var s : string; f : filedesc)*);
var
    i : integer;
begin
    i := 1;
    while (i <= length(s)) do begin
	putcf(ord(s[i]), f);
	i := i + 1
    end
end;

{ message -- (M/MT+) string out to error, then <writeln> }
procedure message (* (billboard : string ); *);
begin
    putstr(billboard, STDERR);
    putcf(NEWLINE, STDERR);
end;

{ remove -- (M) remove files from CP/M.  It assumes the file is closed}
{If it isn't, unpredictable results will occur, though the Pascal/M manual
 maintains that nothing untoward happens. }
procedure remove (var s : string);

(* There's no IORESULT return under CP/M on purge operations, so we don't
  bother to check it afterwards. *)

begin
  purge(s);
end;

