
{GETFNS}
{ getfns -- get filenames into fname, look for duplicates }
procedure getfns;
var
    i, j : integer;
    junk : boolean;
begin
    errcount := 0;
    nfiles := nargs - 2;
    if (nfiles > MAXFILES) then
	error('archive: too many file names');

(* Note: though you might be tempted to check for no files, don't; the table
  and print functions of ARCHIVE take no other arguments than the archive file
  name:

a> archive -t store.txt

    else if (nfiles <= 0) then
	error('archive: no filenames');
*)

(* the following replacement for the 'for' loop that used to be here checks for
  empty names; if found it does not add them to the list. *)

    i := 1;
    j := 1;
    while (i<=nfiles) do
    begin
	junk := getarg(i+2, fname[j], MAXSTR);
        if (fname[i] = '') then
	    nfiles := nfiles - 1
	else
	    j := j + 1;
	i := i + 1;
    end;
    for i := 1 to nfiles do	(* set file statistic flags to <false>; all
				  tools procedures use this flag in tracking
				  what's been done. *)
	fstat[i] := false;
    for i := 1 to nfiles - 1 do
	for j := i + 1 to nfiles do
	if (equal(fname[i], fname[j])) then begin
	    putstr(fname[i], STDERR);
	    error(': duplicate file name')
	end
end {GETFNS};


