program echo;

(*$F toolsinc.pas*)
(*$Intoolinc.src*)
(*$F nfchario.pas*)
(*$Infchario.pas*)

(* A few notes to the unknowing CP/M user.  The CP/M console command processor
  (CCP for short) turns everything passed to it into uppercase.  Except for the
  odd exception (MBASIC is the most prominent), EVERYTHING that's passed
  through it arrives as uppercase.  This is somewhat less than good, for
  anything that requires lowercase input.  So what to do?

   Well, there are several possibilities: one, establish a lowercase
 _character_, that is one which when followed means, "the following is a
  lowercase character; ignore this character unless it is doubled."  This would
  look like so:

A>Zap ^a-^z A-Z

or, for situations where the carat (^) is wanted:

A>Zap ^^-* 3-9.

   The second possibility would be to forego the CCP inputs and have an
  internal prompt instead.  I'd recommend doing this anyway: ALL programs will
  have uninitiates using them often enough to warrant it.  So, the following:

A>Zap
  
  Zap program [ACP 9/7/82]

Options (or 'help' for help): a-z A-Z.

  One point: ALWAYS spend more time worrying about human interfaces than
  mechanics.  The innards are easy, for most programs; it's the outside world
  that gives so many pains.

*)
  
(* A note on this program: if you invoke ECHO as below:

A>prun echo

  and then type a great deal of characters, followed by a return, the maximum
  length of the first returned argument (no matter what the value of argsize)
  will be 127.  This seems to go for any program with a readln, though I
  haven't tested it too thoroughly.*)



(*$F getargs.pas*)
(*$Igetargs.src*)


{ echo -- echo command line arguments to output }
procedure echo;
(* Note the change in the arguments to getarg.  I think it's a little more
  reasonable to have the maximum size of returned arguments to be connected
  to the size of the argument string, rather than that of the maximum string
  length allowed.  I see no reason to have 255-character long arguments where
  25 will do. *)
var
    i, j : integer;
    argstr : argstring;
begin
    i := 1;
(* Used to be:
    while (getarg(i, argstr, MAXSTR)) do begin*)

    while (getarg(i, argstr, argsize)) do begin
	if (i > 1) then
	    putc(BLANK);
	for j := 1 to length(argstr) do
	begin
	    putc(ord(argstr[j]));
	end;
	i := i + 1
    end;
    if (i > 1) then
	putc(NEWLINE)
end;

begin (* main program *)
  grabtail(source);
  echo;
end (* main program *).

