(* Create creates files as needed; currently it's just a copy of Open. *)


{ create -- (M) open a file for reading or writing }
{   non-portable -- uses the standard M file opening commands }
{   status can be returned, fortunately }
function create (var name : string; mode : integer) : filedesc;
const
    create_err_msg = ': error in creating file (create)';
var
    iohold : integer;
    fd : filedesc;
    i : filesearch;	(* not filedesc because we can overflow if no file is
			  found *)
    erasefile,		(* Should we erase the file before opening it ? *)
    found : boolean;

(* there are currently no basic differences between OPEN and CREATE; only the
  names have been changed to cause less confusion.  Must_create still calls
  create, and Must_open calls open; though they have been substantially
  rewritten to keep duplicate file calls from bollixing the runtime package, 
  there's no provisions for complaining if a file is called in 'create' mode
  as a READ file -- but then, neither do K and P. *)

{ file_create -- (M) creates a file for create. }
{ Removes old file first if the flag prevopened is TRUE. }
procedure file_create ( var fd : filedesc; var fyle : text;
        var name : argstring; prevopened : boolean );
var
  iohold : integer;
begin
(*$I- turn io checking off for the testing *)
  if prevopened then begin
    close(fyle);
    iohold := ioresult;
    if (iohold <> 0) then begin
      putstr(name, STDERR);
      message(': error on closing for reopening');
      fd := IOERROR;
      exit(file_create);
    end;
(*  if (openlist[i].mode = IOWRITE) then remove(name); *)
(* for systems that require resetting a file a second time without an outside
  world name, put such stuff here. *)
  end (* if prevopened *);
  if (openlist[i].mode = IOREAD) then
    reset(fyle, name)
  else begin
    remove(name);	(* no "file exists" error -- change to query *)
    rewrite(fyle, name);
  end;
  iohold := ioresult;
{DIAG}
  writeln('In create_file, ioresult is :', iohold);
  if (iohold <> 0) then
    fd := IOERROR;	(* otherwise, we finished successfully *)
(*$I+ turn io checking back on again *)
end (* file_create *);

begin (* create *)

  { find a free slot in openlist }
  create := IOERROR;	(* if no slot found, error. This will be the default
			  value if we exit create abnormally. *)
  found := false;
  i := FIRSTAVAIL;	(* start there because first 3 files are taken
			  by standard files; don't bother looking at them *)
		{STDIN, STDOUT, STDERR are 1, 2, 3 }
{DIAGNOSTIC}
WRITELN('IN create, NAME = ',NAME);
  while (i <= LASTAVAIL) and (not found) do
  begin
    found := equal(name, openlist[i].name);
    i := i + 1;
  end;
  i := i - 1;	(* we increment once too often *)
  if found then begin
    if (openlist[i].mode = IOERROR) then begin
      putstr(name, STDERR);
      message(': attempt to create file with errors');
      exit(create);	(* CREATE will have value IOERROR *)
    end;
    erasefile := true;
  end
  else begin		(* searching for an empty slot *)
    i := FIRSTAVAIL;
    while (i <= LASTAVAIL) and (not found) do
    begin
      found := openlist[i].mode = IOAVAIL;
      i := i + 1;
    end;
    i:= i - 1;	(* once again to get number correct *)
    if (not found) then begin
      putstr(name, STDERR);
      message(': no open slot available');
      exit(create);	(* CREATE will have value IOERROR *)
    end
    else
      openlist[i].name := name;
    erasefile := false;
  end   (* if found *);
  openlist[i].mode := mode;	(* set mode to correct mode *)
  (* we have now found the slot and done all work preparatory to sending it off
    to be opened. *)
  fd := i;	(* "i" is of <type> filesearch, allowing it to search one
 beyond the end of the files; after an open file has been found, we use the
 file descriptor fd (of <type> filedesc) to index into the array of file
 records. *)

  case fd of
    4: file_create(fd, file1, name, erasefile);	(* the numbers should *)
    5: file_create(fd, file2, name, erasefile);	(* correspond to *)
    6: file_create(fd, file3, name, erasefile);	(* the files you *)
    7: file_create(fd, file4, name, erasefile);	(* declared in *)
    8: file_create(fd, file5, name, erasefile);	(* TOOLSINC.PAS or such. *)
  otherwise
    putstr(name, STDERR);
    error(create_err_msg);
  end (* case *);
  create := fd;
{DIAGNOSTIC}
      writeln('File name is ', name, 'File descriptor number is ', fd);
end(* create *);


{ mustcreate -- (M/MT+) create file or DIE }
function mustcreate (var name : string; mode : integer)
	: filedesc;
var
    fd : filedesc;
begin
    fd := create(name, mode);
    if (fd = IOERROR) then begin
	putstr(name, STDERR);
	error(': can''t create file')
    end;
    mustcreate := fd;
end;


