PROGRAM countchars (input, output);
	(* Accepts character input from console and counts the
	number of characters input. *)
    CONST
	blank = ' ';
	comma = ',';
        period = '.';
    VAR
        charcount, blankcount, commacount, periodcount
            : integer;
        character : char;
    BEGIN
       charcount := 0;
       blankcount := 0;
       commacount := 0;
       periodcount := 0;
       writeln('Type any characters, including carriage returns.');
       writeln('The program will stop when you type control-Z.');

(*  Successive character READs at the end of the line will pile up characters
    like a typewriter.  Type carriage returns and backspaces wherever you want 
    to; the program will merely count them as characters.*)

       WHILE NOT eof DO
          BEGIN
             read(character);
             charcount := charcount + 1;
             IF character = blank
                THEN blankcount := blankcount + 1
             ELSE IF character = comma
                THEN commacount := commacount + 1
             ELSE IF character = period
                THEN periodcount := periodcount + 1;  (* optional ; *)
          END; { while }
       writeln;
       writeln(charcount, ' characters');
       writeln(blankcount, ' blanks');
       writeln(commacount, ' commas');
       writeln(periodcount, ' periods');    (* another optional ; *)

(*  The above output (writeln) routines are nearly but not quite 
    identicial with those given by Grogorno.  We changed them to put
    a space between the label (e.g. 'blanks' or 'commas') and the number
    given in the output.  Thus ours is somewhat prettier.  Ours is
    "functionally identical" to Grogono but more readable.*)

{   IF, under P/M, you type:

    a>PRUN COUNTCHR
      Type any characters, including carriage returns.
      The program will stop when you type control-Z.
      ^Z  (* this is control-Z, CP/M end of file, ending program. *)

	  the result will not be what you expect: it will show one
	  character (a blank) having been typed when in fact none were.
	  Try it for yourself. }

	(* The same result will obtain under PASCAL MT+ *)

    END. { countchars }
