-h- COPY80.PAS 1667
(* This is the first program in the COPY series, COPY80.PAS *)

program Copy80(infile,outfile);
(*copy ASCII files from file to file.*)
(* Lines are truncated to 80 characters*)
(* This is a test for PASCAL/M  CP/M to look at IO.*)
(* This program does indeed truncate everything to 80 characters.*)

var
	IFILE, OFILE: Text;
	Line: String;

begin

	RESET (IFILE, 'IN.TXT'); (* should open IN.TXT *)
	(* initial Get implied by RESET *)
	(* If empty file, EOF if True *)
	REWRITE(OFILE, 'OT.TXT');

	WHILE NOT EOF(IFILE) DO
		BEGIN
			ReadLn(IFILE, Line);
			WriteLn(OFILE, Line)
		END;
END.

(* The reason this program truncates all the input lines to 80 
characters is that PASCAL assumes a string is 80 characters long
unless you tell it explicitly differently.  To make the string
known as line longer, it could be declared line[99] as an
example, and it would then truncate to 99 characters long.
	The maximum length of a PASCAL string is 255 characters.
This makes for some unfortunate problems in i/o.  You are supposed
to like the structured features enough to overlook this. *)

(* Note that using readln and writeln does produce output with 
carriage returns and line feeds in it.  Thus, if your text cannot
come in lines longer than 255, then this program would work for
all your cases.  You would simply do line[255] in the declarations
above, and you would get all your text--PROVIDED THAT YOU HAVE NO
INPUT TEXT IN STRINGS LONGER THAN 255 CHARACTERS BEFORE A CARRIAGE
RETURN.
	Unfortunately, many of the best text editors normally 
produce text that this program will clobber. There are ways around
this, involving more advanced methods; more later. *)

-h- COPY801.PAS 1378
program Copy801(infile,outfile);
(*copy ASCII files from file to file.*)
(* Lines are truncated to 80 characters*)
(* This is a test for PASCAL/M  CP/M to look at IO.*)
(* We have declared line = 255 and will now see the result. *)


var
	IFILE, OFILE: Text;
	Line: String[255];

begin

	RESET (IFILE, 'IN.TXT'); (* should open IN.TXT *)
	(* initial Get implied by RESET *)
	(* If empty file, EOF if True *)
	REWRITE(OFILE, 'OT.TXT');

	WHILE NOT EOF(IFILE) DO
		BEGIN
			ReadLn(IFILE, Line);
			WriteLn(OFILE, Line)
		END;
END.

(*Note what happens.  The program no longer truncates to 80 chars,
as did copy80; but it does truncate to 255.  It is faster than
copy82 which gets character at a time, but is relatively useless
when used on text created by Electric Pencil, WRITE, and other text
editors that do not put carriage returns at the ends of lines. *)

(*Note also that PASCAL has its infamous I/O problems.  The language
was not really as well thought out as its enthusiastic adherents
would like you to believe; it was intended never to be compiled on
machines, but rather to be read by an instructor as part of a teaching
environment, and thus the I/O was pretty well tacked on as an afterthought
when they decided to make it a real language.

  What dad's saying is that he's infuriated.  There are some basic probs, not
yet solved; I'm workin' on it, massa.... *)


-h- COPY81.PAS 691
program Copy81(infile,outfile);
(*copy ASCII files from file to file.*)
(*will use read rather than readln, and write rather then writeln.*)
(* As written it copies the first line of text and does nothing else.
   This is rather strange.  It does not terminate itself at all. It just
   hangs there.  This is because one must do a READLN on the file in order
   to fill the buffer. *)


var
	IFILE, OFILE: Text;
	Line: String;

begin

	RESET (IFILE, 'IN.TXT'); (* should open IN.TXT *)
	(* initial Get implied by RESET *)
	(* If empty file, EOF if True *)
	REWRITE(OFILE, 'OT.TXT');

	WHILE NOT EOF(IFILE) DO
		BEGIN
(* need READLN *)
			Read(IFILE, Line);
			Write(OFILE, Line)
		END;
END.
-h- COPY820.PAS 636
program Copy820(infile,outfile);
(*copy ASCII files from file to file.*)
(* We will try to read into a packed array of char.*)
(* THE trouble is that this doesn't WORK.  It will not 
   compile, and cannot readln into the array.  It's not
   allowed in Pascal to READLN into an array, it turns
   out. *)

var
	IFILE, OFILE: Text;
	Line: String;
	Aray : packed array [1..600] of CHAR;


begin

	RESET (IFILE, 'IN.TXT'); (* should open IN.TXT *)
	(* initial Get implied by RESET *)
	(* If empty file, EOF if True *)
	REWRITE(OFILE, 'OT.TXT');

	WHILE NOT EOF(IFILE) DO
		BEGIN
			ReadLn(IFILE, Aray);
			WriteLn(OFILE, Aray)
		END;
END.
-h- COPY82.PAS 2150
program Copy81(infile,outfile);
(*copy ASCII files from file to file.*)
(*will use read rather than readln, and write rather then writeln.*)
(* will use charac instead of line to read and write. *)
(* Using a char to read will not result in the ghastly failure of
   copy81.  On the other hand, we will also have to test for end of
   line, and do things when that happens.
	PASCAL and these programs particularly sort of expect text to 
  come in neat arrays of 80 line text followed by cr and lf, and preferably
  both cr AND lf.  Unfortunately, text doesn't always come that way. *)


const
        newline = 13;   (* carriage return ONLY *)


var
	IFILE, OFILE: Text;
	charac: Char;
	Line: String;
        

begin

	RESET (IFILE, 'IN.TXT'); (* should open IN.TXT *)
	(* initial Get implied by RESET *)
	(* If empty file, EOF if True *)
	REWRITE(OFILE, 'OT.TXT');

	WHILE NOT EOF(IFILE) DO
		BEGIN
			Read(IFILE, charac);
                        If eoln(IFILE) then    (* EOLN true if end of line.*)
                            write(OFILE,chr(newline))
						(*so if EOLN write cr *)
                        else
                            Write(OFILE, charac);
		END;
END.
(* This program works, in that it copies all the characters.  Unfortunately,
it does not copy carriage returns unless you use the IF EOLN business.
If you just go READ(IFILE, charac) and WRITE(OFILE, charac) you get
a copy but with no cr in it at all.  That isn't what you wanted. *)

(* Of course if what you wanted was a full newline, which is a cr and lf
together, this program will not give you what you wanted either.  This
program makes files readable by WRITE and ELECTRIC PENCIL.
	If you want cr and lf in your file, then define lf up in 
	the consts area as lf = 10, and in the conditional write
        you do   Write(OFILE, chr(newline), chr(lf)))

	and it'll do what you wanted it to.  Of course you might object
	to defining cr alone as newline, and want to change the name of
	the thing to cr, up in consts and down in the write statement.
	   It'd read then Write(OFILE, chr(cr), chr(lf)) and up 
	   above it wouldn't say newline = 13 it'd say cr = 13. *)-h- COPY825.PAS 1188
program Copy825(infile,outfile);
(*copy ASCII files from file to file.*)
(*will use read rather than readln, and write rather then writeln.*)
(* will use aray rather than charac to read into.  Similar to copy82 *)
(* Unfortunately this will not work either.  You cannot read into an
array with either readln or read.  You can assign the character read
to the array, element at a time, as see in later comments.  But this
program cannot be compiled.*)


const
        newline = 13;   (* carriage return ONLY *)


var
	IFILE, OFILE: Text;
	charac: Char;
	Line: String;
	Aray : Packed array [1..600] of CHAR;
        

begin

	RESET (IFILE, 'IN.TXT'); (* should open IN.TXT *)
	(* initial Get implied by RESET *)
	(* If empty file, EOF if True *)
	REWRITE(OFILE, 'OT.TXT');

	WHILE NOT EOF(IFILE) DO
		BEGIN
			Read(IFILE, Aray); (*program blows up here.*)
                        If eoln(IFILE) then    (* EOLN true if end of line.*)
                            write(OFILE,chr(newline))
						(*so if EOLN write cr *)
                        else
                            Write(OFILE, Aray); (* wouldn't work either.*)
		END;
END.

(* Illustrative example.  PROGRAM CANNOT COMPILE.  *)
-h- COPY83.PAS 1208
program Copy83(infile,outfile);
(*copy ASCII files from file to file.*)
(*will use read rather than readln, and write rather then writeln.*)
(* will use charac instead of line to read and write. *)
(* Note that is is like copy82 except it has cr and lf, as we told you
   about in copy82. *)

const
        cr = 13;  (* numerical value of ^M or CR *)
        lf = 10;  (* numerical value of ^J or LF *)

var
	IFILE, OFILE: Text;  (* We declare the inputfile and outputfile *)
	charac: Char;
        

begin

	RESET (IFILE, 'IN.TXT'); (* should open IN.TXT for reading only *)

	(* initial Get implied by RESET *)
	(* If empty file, EOF if True *)

	REWRITE(OFILE, 'OT.TXT');  (* opens OT.TXT for output; erases old. *)

	WHILE NOT EOF(IFILE) DO   (* as long as no end of file marker.*)
		BEGIN
			Read(IFILE, charac);
                        IF eoln(IFILE) THEN  (* take care of end of "line" *)

                            write(OFILE,chr(cr),chr(lf))   (* will write
                                                              out a <CR>
							      and a <LF>
							      when it sees
							      an eoln*)

                        ELSE
                            Write(OFILE, charac);
		END;
END.
-h- COPYIO.SRC 1839
  lock : integer;

{ all right, you ask, what is lock for?  Since close in P/MT+ takes two 
  arguments, one of which is an IORESULT return, we 'conform' the programs
  by creating a global variable 'lock'.  Then the value is returned to lock,
  MT+ is happy, and the close for the program is the same for either M or MT+.}

{ The $I- option, which is used in /M and UCSD to 'turn off' I/O checking, is 
  not supported in MT+.  Other methods I haven't had time to figure out are
  used instead.  Later, perhaps.}

{ On MT+ include files:  Their syntax is:

(*$Ifilename any comment you feel like*)  Note this text is not compiled

  Which is much less restrictive than P/M.  Other
  compiler directives can be followed by more text:

(*$R+*) this will indeed be compiled (and cause errors)

  Which is at least consistent.  In any case, it's probably a bad practice;
  put your directives on a separate line so they stand out in the program.}

procedure openfile;  (*strictly for MTPLUS*)
var
  okay : boolean;
  filename:string[14];  (* CP/M maximum filename length *)
begin
  repeat
    write('What file you wish to read from ? ');
    readln(filename);
    assign(infile,filename);  (* MT+ standard *)
    okay := (IORESULT=0);
    if okay then
    begin
      reset(infile);          (* also MT+ standard *)
      okay := (IORESULT=0);
    end;
    IF NOT okay THEN
      writeln('I can''t open that file.  Please try again.');
  until okay;
  repeat
    write('What file you wish to write to ? ');
    readln(filename);
    assign(outfile,filename);  (* MT+ standard *)
    okay := (IORESULT=0);
    if okay then
    begin
      rewrite(outfile);          (* also MT+ standard *)
      okay := (IORESULT=0);
    end;
    IF NOT okay THEN
      writeln('I can''t open that file.  Please try again.');
  until okay;
end(* openfile *);
-h- COPYJ.SRC 739
program copyprog (input,output);
const
	ENDFILE = -1;
	NEWLINE = 13; (* CARRIAGE RETURN *)
type
	character = -1..127;   (* ASCII plus ENDFILE*)

{getc -- get one character from standard input }
function getc (var c : character) : character;
var
	ch : char;
begin
	if (EOF) then
		c := ENDFILE
	else if (eoln) then begin
		readln;
		c := NEWLINE
	end
	else begin
		read(ch);
		c := ord(ch)
	end;
	getc := c
end;

{putc -- put one character on standard output }
procedure putc (c : character);
	begin
		if (c = NEWLINE) then
			writeln
		else
			write(chr(c))
	end;

{copy -- copy input to output }
procedure copy;
var
	c : character;
begin
	while (getc(c) <> ENDFILE) do
		putc(c)
end;

BEGIN	{main program}

	copy

END.  (* END PROGRAM *)
