PROGRAM Buses (input, output);


(*  THIS PROGRAM COMPILES UNDER BOTH PASCAL/M AND PASCAL MT+ *)

{TO LINK this program (MT+ only), you must use:
	LINKMT busses,fpreals/s,trancend,paslib/s}

	{It will work with the /s option for trancend,
	but that is not always wise in mt+; read the mt+ 
	document on library searches.}

	{This program is worth considerable study.  It illustrates an
	elegant way to accomplish a number of desirable goals.  Dr. Grogono
	could have been more clear in his explanations of how some of his
	features work; we'll try to rectify that.}


	CONST
	  stopmax = 100;
	  busmax = 100;
	  queuemax = 100;

	  fw1 = 8;	{field width for output}
	  pr1 = 3;	{precision for output}

	TYPE
	  stopnumber = 0 .. stopmax;
	  busnumber = 0 .. busmax;
	  queuelength = 0 .. queuemax;
	  eventkind = (person, arrival, boarder);
	  link = ^event; {thus link points to a variable of type event.}
	  event =
  	   RECORD
		fptr,bptr : link;  {thus these point to events.}
		kind : eventkind;
		time : real;
		stopnum : stopnumber;
		busnum: busnumber
	    END;
	
	VAR
	  queue : ARRAY[stopnumber] OF queuelength;
	  atstop : ARRAY[stopnumber] OF boolean;
	  evtime : ARRAY[eventkind] OF real;
	  gap, stop, stoptot : stopnumber;
	  bus, bustot : busnumber;
	  maxtime : real;
	  currentevent, base : link;
	  randomseed : real; {integer in original }
			{to use the random generator we have, it must have
			 a real rather than integer seed.}
	  evindex : eventkind;

	  m : real; {needed for random number generator}


	FUNCTION random (VAR seed : real ) : real;

(* this whole mess was a losing attempt to get this to work.

{  	Function modreal(top,bottom:real):integer;
		VAR
		Remainder,
                Quotient:real;
			Begin
			    Quotient := Top / Bottom;
			    Remainder := Quotient - trunc (Quotient);
			    Modreal := Trunc(Remainder*Top);
			End }{  Modreal  };


  { Note that this is not at all like the Grogono approach, due to
    limitations in both M and MT+ implementations.}

	   {As specified in Grogono's book, function Random produces
	    numbers between .0000153 and 11.090355.  This multiplied 
	    by evtime[evkind] for people (which is input in the main)
	    produces the time of the next person joining a queue.}

	   {Unfortunately, using Grogono's original numbers will result
	    in division by 0, since the largest integer in an 8-bit
	    machine is somewhat lower than 2^16.  Thus we must fudge.}

{First we tried converting from integers to reals; but there is no
implicit conversion in MT+ PASCAL, and it will not compile.}

{	   BEGIN
		random := - ln((seed + 1) / 65536.0); {65536 in Grogono}
		seed := Modreal((25173.0 * seed + 13849.0), 65536.0)
		   {in original 25173, 13849, 65536 which overflows}
		{we truncate seed because it is declared as an integer,
		and mt+ will not implicitly make the conversion.}

	   END;} {random}    {end of losing attempt }  *)

{ ****************************************************************  }

{  RANDOM NUMBER GENERATOR BEGINS HERE.}

	{This is a fairly good generator that outputs numbers
	 between 0 and 1.}

		BEGIN
			seed := seed*133.0 * m;
			seed:= seed-trunc(seed);
			random :=seed
		END; {random}


	PROCEDURE genevent (evkind : eventkind;
	  		    newtime : real;
			    stop : stopnumber;
 			    bus : busnumber);
	   VAR
		ev,newev : link;
		delay : real;
	   BEGIN
		IF evkind = person
		   THEN delay := evtime[evkind] * random(randomseed)
			{NOTE this is how long it takes for a new person to
			 join a queue; recall that 0 <= random =< 1 }
		   ELSE delay := evtime[evkind];
			{evtime[evkind] for time between stops, and how long
			 it takes to get off a bus, will be input in main.}

		new(newev);
			{ new is a Standard Procedure, whose argument is
			  a pointer.  In this case, new will create a
			  component of type EVENT whose name is newev^ }

		WITH newev^ DO
		   BEGIN
			kind := evkind;
			time := newtime + delay;
			stopnum := stop;
			busnum := bus
		    END; {with}
		ev := base;
		REPEAT
		   ev := ev^.bptr
		UNTIL newev^.time >= ev^.time;
		newev^.fptr := ev^.fptr;
		newev^.bptr := ev;
		ev^.fptr^.bptr := newev;
		ev^.fptr := newev
	  END; {genevent}

	PROCEDURE messages;
	 { Attempts to compile this with the messages in the main program
	   busses result in error 253, procedure or program body too long.
	   This is supposed to be a feature, not a bug; PASCAL deliberately
	   discourages putting things in the main program -- even though in
	   this case the darned thing is not to be called but once. }

	BEGIN {messages}
	writeln;
	writeln('TIME FACTORS.           First, a multiplier for the');
	writeln('time required for people to join a queue.  Recall that');
	writeln('this will be multiplied by 0 <= random <= 1, and thus');
	writeln('will be the maximum time for someone to join a queue.');
	writeln;
	writeln('The next two numbers will be how long it takes for a bus');
	writeln('to go between stops, and how long it takes to board a bus.');

	writeln('Now enter time factors: people join queue,');
	writeln('time of bus travel from stop to stop,');
	writeln('time required for passenger to board a bus.');
	writeln('     If the first number is small, the queues form so fast');
	writeln('     that the busses seldom move.  Numbers that work are: ');
	writeln('     12 stops, 5 busses, times 4, 5, 1, simulation time 99.');
	END; {messages}


{MAIN Program}
	BEGIN {busses}

		{read simulation parameters}

	m := 1173.0 / 65536.0 ;

	write('Enter a value for random seed: ');
	readln(randomseed);
	
	write('Enter total stops: ');
	readln(stoptot);
	write('Enter total busses: ');
	readln(bustot);


	messages;

	FOR evindex := person TO boarder DO
		BEGIN
			write(' Enter a time factor: ');
			readln(evtime[evindex])
		END; {for}

	writeln;
	write('Enter maximum time for simulation: ');
	readln(maxtime);

{create an empty ring}
	new(base);  {base is type link, so we create an event named base^ }
 WITH base^ DO
		BEGIN
		  fptr:= base;
		  bptr := base;
		  time := 0
		END; {with}

{distribute the busses evenly along the route }


	IF stoptot < bustot
	   THEN gap := 1
	   ELSE gap := stoptot DIV bustot;
	stop := 1;
	FOR bus := 1 TO bustot DO
	   BEGIN
		genevent(arrival,0,stop,bus);
		IF stop + gap <= stoptot
		   THEN stop := stop + gap
		   ELSE stop := 1
	   END; {for}

	{We now have a number of events of kind arrival distributed about
	the ring.  They will all happen at the same time, namely time 0.
	BASE.fptr points to the first one, so base^.fptr is the first event
	at time 0.  They will all be processed before any events with time > 0
	will receive attention.}

{create a queue at each bus stop}

	FOR stop := 1 TO stoptot DO
		BEGIN
		   queue[stop] := 0;
		   genevent(person,0,stop,0);
		   atstop[stop] := false
		END; {for}

	{We now have a number of events at random times > 0; they are the
	times at which some person will join queue[stop] which is to say a
	queue at stop number [stop].  These events have been put into the 
	ring at their proper times.  The fptr of the "last" time 0 event
	points to the first non-zero time event.}

{simulate}

	REPEAT
	   currentevent := base^.fptr; {pointer to the current
					event = base's forepointer.}
	   WITH currentevent^ DO
		{figure out what kind of event it is.  At first it's all
		those busses arriving at stops at time 0.}
	     CASE kind OF
		person :
		   BEGIN
			queue[stopnum] := queue[stopnum] + 1;
			genevent(person,time,stopnum,0)
		   END; {person}
		arrival :
		   IF atstop[stopnum] OR (queue[stopnum] = 0)
		     THEN genevent(arrival,time,
				   (stopnum MOD stoptot)+1,busnum)
		     ELSE
			BEGIN
			   atstop[stopnum] := true;
			   genevent(boarder,time,stopnum,busnum);
			   write(time : fw1 : pr1);
			   write(' ' : 3 * stopnum);
				{EXAMINE above with some care.  It is an 
				 interesting method of outputting results.
				 stopnum is a variable of type stopnumber,
				 existing as part of the RECORD event. }
			   writeln(busnum : 1)
			END; {arrival}
		boarder :
			BEGIN
			   queue[stopnum] := queue[stopnum] - 1;
			   IF queue[stopnum] > 0
			      THEN genevent(boarder,time,stopnum,busnum)
			      ELSE
				BEGIN atstop[stopnum] := false;
				genevent(arrival,time,
					 (stopnum MOD stoptot)+1,busnum)
				END  {else}
			END {boarder}
	   END; {with and CASE}

		{We have now processed the event, and generated another of
		the same kind.}

	base^.fptr := currentevent^.fptr;
	currentevent^.fptr^.bptr := base
		{This "unhooks" the event we just processed.  Base's fptr
		now points to whatever was pointed to by the event we just 
		processed.  The bptr of whatever was pointed to by the
		fptr of the event just processed now points to base.  Thus
		the just-processed event is sawed out of the ring, and can
		no longer be accessed.}

	   UNTIL base^.fptr^.time >= maxtime
		{Keep doing this until the next event takes place at a time
		beyond the limit set.  Note that there will be events in the
		ring that exceed this limit, since we don't test for time too
		great in genevent.}

    END. {busses}
