 /*
  *	FCHART, The C function Call Plotter
  *	Copyrite (c) Dec. 1983 by Solution Systems
  */

#include "local.h"

#define CTRL_D 004
#define ATOMLENGTH 30
#define MAXNAME 300
#define MAXINST 1000
#define MAXDEPTH 75
#define MAXSEEN 300
#define PAPERWIDTH 78

int bracket = 0,
    linect = 0,
    terse = 1,
    ntabs = (PAPERWIDTH - 20)/8,
    lastchar = 0;
char aseen[MAXSEEN][ATOMLENGTH] = {'\0'};

char *sysword[] = {
	"if",
	"while",
	"for",
	"else",
	"return",
	"switch",
	"do",
	"sizeof",
	0 };

struct rname {
	char namer[ATOMLENGTH];
	int rnamecalled;
	int rnameout;
	struct rinst *dlistp;
} namelist[MAXNAME], *actvlist[MAXDEPTH];

int activep = 0;

struct rinst {
	struct rname *namep;
	struct rinst *calls;
} dlist[MAXINST], *frp = dlist;

FILE *fp;

main(argc, argv)
int argc;
char *argv[];
{
	int atoi(), gf, i, ok;
	char atom[ATOMLENGTH];
	char *startfunc = "main", *lcstr();
	struct rname *startp, *lookfor();
	struct rinst *curproc = NULL, *initfree(), *newproc(), *add2call();

	(void) initfree();

	 if (argc==1) {
	     usage_msg();
	     exit();
	 }

	for (i = 1; i < argc && (argv[i][0] == '-' || argv[i][0] == '?'); i++) {
		if (match(argv[i], "-T") || match(argv[i], "-TERSE") || match(argv[i], "-terse") || match(argv[i], "-t"))
			terse = 1;
		else if (match(argv[i], "-V") || match(argv[i], "-VERBOSE") || match(argv[i], "-verbose") || match(argv[i], "-v"))
			terse = 0;
		else if (match(argv[i], "-?") || match(argv[i], "?") || match(argv[i], "-H") || match(argv[i], "-h") || match(argv[i], "-help") || match(argv[i], "-HELP")) {
			help_msg();
			exit(0);
		     }
		else if (match(argv[i], "-WIDTH") || match(argv[i], "-w") || match(argv[i], "-W"))
			ntabs = (atoi(argv[++i]) - 20)/8;
		else {
			(void) fprintf(stderr,"\nunknown flag %s\n", argv[i]);
			usage_msg();
		}

		(void) fprintf(stderr, "\n");
	}

	ok = 1;
	--argc;
	if ((fp=fopen(argv[argc], "r"))==NULL) {
	    fprintf(stderr,
	      "\nFCHART, Copyrite (c) Dec. 1983 by Solution Systems");
	    fprintf(stderr, "\ncan't open file: %s\n", argv[argc]);
	    exit(0);
	}

	fprintf(stderr, "\n\tFCHART, Copyrite (c) Dec. 1983 by Solution Systems");
	fprintf(stderr,"\n\tPlotting Function Calls, File: %s\n",argv[argc]);
	fprintf(stderr,  "\t    (enter the flag ? for help)\n\n");

	while ((gf = getfunc(atom)) != -1 && ok ) {
		_int();
		if (gf) ok = (int)(add2call(atom, curproc));
		else ok = (int)(curproc = newproc(atom));
	}

	if (i < argc) do {
			startfunc = lcstr(argv[i]);
			if (startp = lookfor(startfunc)) {
				_int();
				(void) output(startp, 0);
				(void) printf("\n\n");
			}

			else (void) printf("*** error *** function %s not found\n", startfunc);

			} while (++i < argc);

	 else for (startp = namelist; startp->namer[0]; startp++)
			if (!(startp->rnamecalled)) {
				_int();
				(void) output(startp, 0);
				(void) printf("\n\n");
			}
}

int getfunc(atom)
char atom[];
{
	register int c;
	int ss;
	for(;;) {
		_int();
		c = getch();
		if (isalpha(c) || (c=='_')) {
			lastchar = c;
			(void) scan(atom);
			continue;
		}
		else {
			_int();
			switch(c) {
			case '\t':
			case ' ':
				continue;

			case '\n':
				if ((c = getch()) == '#')
					while ((c = getch()) != '\n')
						;
				lastchar = c;
				continue;

			case '\'':
				while ((c = getch()) != '\'')
					if (c == '\\')
						(void) getch();
				atom[0] = '\0';
				continue;

			case '\"':
				while (( c = getch()) != '\"')
					if (c == '\\')
						(void) getch();
				continue;

			case '{':
				bracket++;
				atom[0] = '\0';
				continue;
			case '}':
				--bracket;
				if (bracket < 0)
					(void) printf("bracket underflow");
				atom[0] = '\0';
				continue;

			case '(':
				if(!atom[0])
					continue;
				if (!checksys(atom)) {
					if (!bracket)
						return(0);
					if ((ss = seen(atom)) == -1)
						(void) printf("aseen overflow");
					if (bracket && !ss)
						return(1);
				}
				atom[0] = '\0';
				continue;

			case CTRL_D:
			case EOF:
				return(-1);

			case '/':
				if ((c = getch()) == '*')
					for (;;) {
						while (getch() != '*')
							;
						if ((c = getch()) == '/')
							break;
						lastchar = c;
					}
				else
					lastchar = c;
				continue;

			case '\\':
				(void) getch();
				/* drop through */

			default:
				atom[0] = '\0';
				continue;
			}
		}
	}
}

scan(atom)
char atom[];
{
	int c;
	int i;

	c = lastchar;
	for(i = 0; isalnum(c) || c=='_'; i++) {
		atom[i] = (char)(c = getch());
		if (i > ATOMLENGTH)
			break;
	}
	atom[i-1] = '\0';
	lastchar = c;
}

int checksys(atom)
char atom[];
{
	int i;
	for (i = 0; sysword[i]; i++)
		if (match(atom, sysword[i]))
			return(1);
	return(0);
}

int seen(atom)
char *atom;
{
	int i,j;
	for (i = 0; aseen[i][0] && i < MAXSEEN; i++)
		if (match(atom, aseen[i]))
			return(1);
	if (i >= MAXSEEN)
		return(-1);
	for (j = 0; (aseen[i][j] = atom[j]) != '\0' && j < ATOMLENGTH; j++)
		;
	aseen[i+1][0] = '\0';
	return(0);
}

int match(atom, name)
register char *name;
register char *atom;
{
	for (; *atom == *name; ++atom, ++name)
		if (!*atom)
			return(1);
	return(0);
}

int getch()
{
	register int c;

	if(!lastchar)
		c = fgetc(fp);
	else {
		c = lastchar;
		lastchar = 0;
	}
	return(c);
}

struct rinst *newproc(name)
char name[];
{
	struct rinst *install();
	struct rname *place();

	aseen[0][0] = '\0';
	return(install(place(name), (struct rinst *)NULL));
}

struct rinst *add2call(name,curp)
char name[];
struct rinst *curp;
{
	struct rinst *install(),*ip;
	struct rname *place(),*p;

	ip = install(p = place(name), curp);
	if (p)
		++(p->rnamecalled);
	return(ip);
}

struct rname *place(name)
char name[];
{
	register int i;
	struct rname *npt;
	char *strcpy();

	for (i = 0 ; (npt = &namelist[i])->namer[0] && i < MAXNAME ; i++)
		if (match(name, npt->namer))
			return(npt);

	if (i >= MAXNAME) {
		(void) printf("namelist overflown");
		return((struct rname *)NULL);
	}

	/* name was not on list, so put it on */
	(void) strcpy(npt->namer, name);
	(npt+1)->namer[0] = '\0';
	npt->rnamecalled = 0;
	npt->rnameout = 0;
	return(npt);
}

struct rinst *install(np, rp)
struct rname *np;
struct rinst *rp;
{
	struct rinst *newp;
	struct rinst *op;
	struct rinst *getfree();
	if (!np)
		return((struct rinst *)NULL);
	if (!(newp = getfree()))
		return((struct rinst *)NULL);
	newp->namep = np;
	newp->calls = 0;
	if (rp) {
		op = rp;
		while (op->calls)
			op = op->calls;
		op->calls = newp;
	}
	else
		np->dlistp = newp;

	return(newp);
}

struct rinst *getfree()
{
	struct rinst *ret;
	ret = frp;
	if (!ret)
		(void) printf("out of instance blocks\n");
	frp = frp->calls;
	return(ret);
}

struct rinst *initfree()
{
	int i;
	for (i = 0 ; i < (MAXINST - 2); i++) {
		frp->namep = 0;
		frp->calls = frp+1;
		frp++;
	}
	frp->namep = 0;
	frp->calls = 0;
	frp= dlist;
	return(dlist);
}

output(func, tabc)
struct rname *func;
int tabc;
{
	struct rinst *nextp;
	int i, tabd, tabstar, tflag;

	++linect;
	(void) printf("\n%d  ", linect);
	if (!(makeactive(func)))
		(void) printf("*"); /* calls nested too deep */
	else {
		tabstar = 0;
		tabd = tabc;
		for (;tabd > ntabs; tabstar++)
			tabd = tabd-ntabs;
		for (i = 0 ; i < tabstar; i++ )
			(void) printf("<");
		(void) printf(" ");
		for (i = 0 ; i < tabd ; i++ )
			(void) printf("\t");
		if (active(func))
			(void) printf("^ %s ^", func->namer); /* recursive call */
		else {
			if (func->dlistp) {
				(void) printf("%s", func->namer);
				nextp = func->dlistp->calls;
				if (!terse || !func->rnameout) {
					++tabc;
					if (!func->rnameout)
						func->rnameout = linect;
					if (tabc > ntabs && (tabc % ntabs) == 1 && nextp) {
						(void) printf("\n- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
						tflag = 1;
					}
					else
						tflag = 0;
					for (; nextp; nextp = nextp->calls)
						output(nextp->namep, tabc);
					if (tflag) {
						(void) printf("\n- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
						tflag = 0;
					}
				}
				else if (nextp)
					(void) printf(" ... [see line %d]", func->rnameout);
			}
			else
				(void) printf("%s [ext]", func->namer); /* library or external call */
		}
		(void) backup();
	}
}

struct rname *lookfor(name)
char *name;
{
	struct rname *np;

	for (np = namelist; np->namer[0]; np++)
		if (match(name, np->namer))
			return(np);
	return((struct rname *)NULL);
}

char *lcstr(s)
char *s;
{
	register char *sp;

	for (sp = s; *sp = tolower(*sp); ++sp)
		;
	return(s);
}

int makeactive(func)
struct rname *func;
{
	if (activep < MAXDEPTH) {
		actvlist[activep] = func;
		activep++;
		return(1);
	}
	return(0);
}

int backup()
{
	if (activep) {
		actvlist[activep--] = 0;
		return(1);
	}
	return(-1);
}

int active(func)
struct rname *func;
{
	register int i;

	for (i = 0; i < (activep - 1); i++) {
		if (func == actvlist[i])
			return(1);
	}
	return(0);
}

_int()				  /* TEST FOR CONTROL-C */
{
	if(bdos(KEY_STAT) & 0xff) {
		if((bdos(KEY_IN)&0xff)==0x03) fprintf(stderr,"^C entered");
		exit(0);
	}
	return(TRUE);
}

help_msg()
{
      fprintf(stderr,
	"\n usage: fchart [-flag(s)] [func_name(s)] fname_in [>fname_out]\n");

	fprintf(stderr,"\n\tT         terse form  (default case)");
	fprintf(stderr,"\n\tterse     ditto");
	fprintf(stderr,"\n\tv         verbose form");
	fprintf(stderr,"\n\tverbose   ditto");
	fprintf(stderr,"\n\tw nn      display width  (default 78)");
	fprintf(stderr,"\n\twidth nn  ditto");
	fprintf(stderr,"\n\thelp      this message");
	fprintf(stderr,"\n\t?         ditto");
	fprintf(stderr,"\n\tname      function to start from\n\n");
}

usage_msg()
{
      fprintf(stderr,"\nFCHART Copyrite (c) Dec. 1983 by Solution Systems");
      fprintf(stderr,
	"\nusage: fchart [-flag(s)] [func_name(s)] fname_in [>fname_out]\n");
	fprintf(stderr,  "               enter the flag ? for help\n\n");
}


