
/*
 *     CUTIL -- REMOVES  TRAILING  WHITESPACES, FILTER CONTROL CHARACTERS
 *     AND REMOVES 8TH BITS, CHANGE CASE  (IN  JUST  COMMENTS,	OR  ALL).
 *     ALSO DISPLAYS LINE NUMBERS OR A SELECTED LINE, SHOW REPRESENTATION
 *     OF CONTENTS OF FILE (^ REPRESENTS CONTROL, ~ REPRESENTS	8TH  BIT
 *     SET) AND PRINTS C PROGRAMS A FUNCTION PER PAGE.	CUTIL REMOVES OR
 *     ADDS TABS INSTEAD OF SPACES, ALSO.
 *
 *
 *	   USAGE: CUTIL [-FLAGS] FILE_IN [ >FILE_OUT OR PRN:]
 *			   FOR HELP CUTIL ?
 *
 *
 *		      VERSION 1.12 DECEMBER 1983
 *
 *               FOR CP/M-86 AND COMPUTER INNOVATIONS C
 *
 *		   BY BOB GREEN FOR SOLUTION SYSTEMS
 *
 *		      COPYRIGHT (C) DECEMBER 1983
 *
 *                       ALL RIGHTS RESERVED
 */

#include "local.h"

#define IS_WHITE_SPACE(c) ((c) == ' ' || (c) == '\t' || (c) == '\r' || (c) == '\n')

FILE *fp;

char *File_name;
int E_flg=FALSE;
int Ln_flg=FALSE;

main(argc, argv)
int argc;
char *argv[];
{
    /*
     * INIT ALL
     */

    int select_ln, tab_flg, untab_flg, lpr_flg, j_show, s_show;
    int c, a_flg, c_flg, f_flg, l_flg, u_flg, x_flg;
    select_ln=tab_flg=untab_flg=lpr_flg=j_show=s_show=FALSE;
    a_flg=c_flg=f_flg=l_flg=u_flg=x_flg=FALSE;

    /*
     * TEST ARGUMENTS AND OPEN INPUT FILE
     */

    fprintf(stderr,
       "\nCUTIL Copyright (c) Dec. 1983 by Solution Systems, All Rights Reserved.");
    File_name=argv[--argc];
    if ((fp = fopen(File_name, "rb")) ==NULL) {
	    if (argc==0) {
		fprintf(stderr, "%c\nERROR: no arguments\n", BELL);
		use();
		exit(0);
	    } else if ((argv[argc][0]=='?') || ((argv[argc][1])=='?')) {
	            help();
	            exit(0);
	    } else {
		fprintf(stderr, "%c\ncan't open file: %s\n",
		BELL, argv[argc]);
		use();
		exit(0);
	    }
    }

    /*
     *
     * TEST FOR HELP OR FLAG VALIDITY AND EVALUATE FLAG IF VALID
     *
     */

    while (--argc) {
	if ((isdigit(argv[argc][0])) || (isdigit(argv[argc][1])))
	    select_ln=(ABS(atoi(argv[argc]))-3); /*  TEST SELECT  */

						 /* TEST FOR HELP */
	else if ((argv[argc][0]=='?') || (toupper(argv[argc][0])=='H')) {
	    help();
						 /* TEST FOR FLAG */
	} else if (argv[argc][0]=='-') {
	    switch(toupper(argv[argc][1])) {
	    case 'H':
	    case '?':
		help();
		break;
	    case 'D':
		a_flg=TRUE;
		break;
	    case 'C':
		c_flg=TRUE;
		break;
	    case 'E':
		E_flg=TRUE;
		break;
	    case 'F':
		f_flg=TRUE;
		break;
	    case 'J':
		j_show=TRUE;
		break;
	    case 'L':
		l_flg=TRUE;
		break;
	    case 'N':
		Ln_flg=2;
		break;
	    case 'P':
		lpr_flg=TRUE;
		break;
	    case 'R':
		untab_flg=TRUE;
		break;
	    case 'S':
		s_show=TRUE;
		break;
	    case 'T':
		tab_flg=TRUE;
		break;
	    case 'U':
		u_flg=TRUE;
		break;
	    case 'X':
		x_flg=TRUE;
		break;
	    default:
		fprintf(stderr,
		"%c\nError, -%c is an unknown flag\n",
		BELL, toupper(argv[argc][1]));
		help();
	    }

	} else {
	    fprintf(stderr,
	    "%c\nError, %c is an unknown flag\n",
	    BELL, toupper(argv[argc][0]));
	    help();
	    exit(0);
	}
    }
	fprintf(stderr,"\n\tprocessing file: %s\n\n", File_name);

/*
 * SELECT FUNCTION FROM FLAGS
 */

    if (select_ln) {
	lns(select_ln);
	exit(0);
    } else if (j_show) {
	show(FALSE);
	exit(0);
    } else if (s_show) {
	show(TRUE);
	exit(0);
    } else if (lpr_flg) {
	lpr();
	exit(0);
    } else if (tab_flg) {
	tabify();
	exit(0);
    } else if (untab_flg) {
	untab();
	exit(0);
    } else util(a_flg, c_flg, f_flg, l_flg, u_flg, x_flg);

}

/*
 * MAIN UTILITY PROGRAM
 */

util(a_flg, c_flg, f_flg, l_flg, u_flg, x_flg)
int a_flg, c_flg, f_flg, l_flg, u_flg, x_flg;
{
    int ln_num, in_comnt;
    register int i, x, c;
    register char line[MAXLINE];

    i=ln_num=0;
    in_comnt=FALSE;
    while (((c=getc(fp)) != CPMEOF) && (c != EOF)) {
	if (c > ASCIIMASK) line[i] = (c & ASCIIMASK);
	else line[i] = c;
	i++;
	if (c == '\n') {
	    while (--i) {
		if (!(IS_WHITE_SPACE(line[i]))) break;
	    }
	    line[++i] = '\n';
	    line[++i] = '\0';
	    ln_num++;
	    for (x=0; x<i; x++) {
		c = line[x];

		/*
		 * TEST FOR IN_COMMENT
		 */

		if (c=='/') {
		    if (line[x-1]=='*')
			in_comnt=FALSE;
		    else if (line[x+1]=='*')
			in_comnt=TRUE;
		}

		/*
		 *  PRINT LINE NUMBERS
		 */

		if (Ln_flg)
		    if (Ln_flg!=ln_num) {
			ln_out_put(ln_num);
			Ln_flg=ln_num;
		    }

	       /*
		*    PRINT OUTPUT, IF ITS A LEGAL CHARACTER
		*/

		if ((c > 0x1f) || (a_flg) ||
			  ((c=='\f') && (f_flg)) || (c=='\t') || (c=='\n'))
		    select_out(c, in_comnt, c_flg, l_flg, u_flg, x_flg);
	    }
	    i=0;
	}
    }
    fclose(fp);
    fprintf(stderr, "\n\nEOF found, file: %s\n", File_name);
    exit(0);
}

select_out(c, in_comnt, c_flg, l_flg, u_flg, x_flg)
int c, in_comnt, c_flg, l_flg, u_flg, x_flg;
{
    if (l_flg) {			/*  CHANGE CASE TO LOWER  */
	if (((!(c_flg)) && (!(x_flg))) ||	/*    FOR ALL	  */
	       ((c_flg) && (in_comnt)) ||	/* FOR IN COMMENT */
	       ((x_flg) && (!(in_comnt))))	/* NOT IN COMMENT */
	    out_put(tolower(c));
	else out_put(c);

    } else if (u_flg) { 		  /* CHANGE CASE TO UPPER */
	if (((!(c_flg)) && (!(x_flg))) ||
	       ((c_flg) && (in_comnt)) ||
	       ((x_flg) && (!(in_comnt))))
	    out_put(toupper(c));
	else out_put(c);

   } else out_put(c);			 /*  DO NOT CHANGE CASE	*/
}

out_put(c)
int c;
{
    putc(c, stdout);
    if (E_flg)
	putc(c, stderr);
}

ln_out_put(ln_num)
int ln_num;
{
    fprintf(stdout, "%3d: ",ln_num);
    if (E_flg) fprintf(stderr, "%3d: ",ln_num);
}

help()
{
    use();
    fprintf(stderr, "\n\tflags -number  display line entered +/- 3 lines");
    fprintf(stderr, "\n\t       number  same as above ");
    fprintf(stderr, "\n\t      -?       display this message");
    fprintf(stderr, "\n\t      -c       only change case if in comment");
    fprintf(stderr, "\n\t      -d       filter 8th bit, not control characters");
    fprintf(stderr, "\n\t      -e       display (echo) stdout with stderr");
    fprintf(stderr, "\n\t      -f       don't filter form-feeds");
    fprintf(stderr, "\n\t      -j       show special chars, including ^J (LF)");
    fprintf(stderr, "\n\t      -l       change upper to lower case");
    fprintf(stderr, "\n\t      -n       display line numbers");
    fprintf(stderr, "\n\t      -p       c print");
    fprintf(stderr, "\n\t      -r       replace tabs with spaces");
    fprintf(stderr, "\n\t      -s       show special chars, except ^J (LF)");
    fprintf(stderr, "\n\t      -t       replace spaces with tabs");
    fprintf(stderr, "\n\t      -u       change lower to upper case");
    fprintf(stderr, "\n\t      -x       only change case if not in comment\n");
}

use()
{
    fprintf(stderr,"\n\nUSAGE: cutil [-flags] file_in [ >file_out or prn:]");
    fprintf(stderr,"\nfor help cutil ? \n\n");
}

/*
 *   SHOW: SHOW'S REPRESENTATION OF FILE CONTENTS USING ^ TO
 *     REPRESENT CONTROL  CHARACTERS AND ~ TO  REPRESENT
 *     THE 8TH BIT SET (AS IN WORDSTAR'S DOCUMENT MODE).
 *     IF THERE IS A FLAG, ALL CHARACTERS  I.E.  ^J  ARE
 *     SHOWN ( ^J IF FLAG -J IS USED).
 *
 */

show(show_flg)
int show_flg;
{
    register int c, cc, ccc;
    int ln_num=1;

    while (((c = fgetc(fp)) != CPMEOF) && (c != EOF)) {
	cc = c | CTRLMASK;
	if ((Ln_flg) && (Ln_flg!=ln_num)) {
	    ln_out_put(ln_num);
	    Ln_flg=ln_num;
	}
	if ((c=='\n') || (cc=='\n')) ln_num++;
	if (show_flg) {
	    if ((c < 0x20) && (c != '\n')) {
		out_put('^');
		out_put(cc);
	    }
	} else {
	    if (c < 0x20) {
		out_put('^');
		out_put(cc);
	    }
	}
	ccc = c & ASCIIMASK;

	if (c > ASCIIMASK) {
	    out_put('~');
	    out_put(ccc);
	} else {
	    out_put(c);
	}
    }
    fclose(fp);
    fprintf(stderr, "\nEOF found\nFILE: %s\n", File_name);
    exit(0);
}

/*
 *
 *    LNS:  PRINTS THE SPECIFIED LINES OF AN ASCII
 *	FILE, ALONG WITH 3 LINES BEFORE AND AFTER
 *
 */

lns(select_ln)
int select_ln;
{
    int ln1, ln4, ln7, print_number;
    register int c, line;

    ln1 = select_ln;
    ln4=ln1+3;
    ln7=ln4+3;

    fprintf(stderr,"\nFILE: %s ", File_name);
    fprintf(stderr,"Display lines %d to %d:\n", ln1, ln7);

    line= 0;
    while (((c = getc(fp)) != CPMEOF) && (c != EOF)) {
	if (c == '\n') {
	    line++ ;
	    if (line > ln7) {
		out_put('\n');
		break;
	    }
	    print_number= YES;
	} else {
	    if	((ln1 <= line) && (line <= ln7)) {
		if (print_number) {
		    out_put('\n');
		    ln_out_put(line);
		    if (line==ln4) {
			out_put('=');
			out_put('>');
		    } else {
			out_put(' ');
			out_put(' ');
		    }
		}
		out_put(c);
	    }
	    print_number= NO;
	}
    }
    fclose(fp);
    fprintf(stderr, "\nEOF found, file %s\n",File_name);
    exit(0);

}

/*
 * TABIFY
 */

int spc_count;

tabify()
{
    register int column, i, c;
    int quote_flg;
    spc_count = column = 0;
    quote_flg=FALSE;

    do {
	if ((c = getc(fp))==ERROR) {
	    putc(CPMEOF,stdout);
	    break;
	} else switch(c) {
	case '\r':
	    spc_count = column = 0;
	    break;
	case '\n':
	    out_put(c);
	    column = spc_count = 0;
	    quote_flg=FALSE;
	    break;
	case ' ':
	    column++;
	    if (quote_flg) out_put(' ');
	    else {
		spc_count++;
		if (column%8==0) {
		    if (spc_count > 1)
			out_put('\t');
		    else
			out_put(' ');
		    spc_count = 0;
		}
	    }
	    break;
	case '\t':
	    spc_count = 0;
	    column += (8-column%8);
	    out_put('\t');
	    break;
	case '"':
	    outspc('"');
	    if (quote_flg) quote_flg=FALSE;
	    else quote_flg=TRUE;
	    break;
	case 0x1a:
	    putc(CPMEOF,stdout);
	    break;
	default:
	    outspc(c);
	    column++;
	}
    }
    while (c != CPMEOF);

    fclose(fp);
    fprintf(stderr, "\n\nEOF found, file: %s\n", File_name);
    exit(0);
}

void outspc(c)
char *c;
{
    int i;
    for (i=0; i<spc_count; i++)
	out_put(' ');
    spc_count = 0;
    out_put(c);
}

/*
 *  UNTAB
 */

void untab()
{
    register int column, i, c;
    int quote=FALSE;
    column = 0;

    while ((c=getc(fp)) != CPMEOF) {
	switch(c) {

	case '\r':
	    column = 0;
	    quote=FALSE;
	    break;
	case '\n':
	    out_put(0x0a);
	    break;
	case '\f':
	    out_put(c);
	    column = 0;
	    break;
	case '"' :
	    out_put(c);
	    column++;
	    if (quote) quote=FALSE;
	    else quote=TRUE;
	    break;
	case '\t':
	    if (quote) out_put('\t');
	    else for (i=(8-( column % 8)); i>0; i--) {
		out_put(' ');
		column++;
	    }
	    break;
	default:
	    out_put(c);
	    column++;
	}
    }

    fclose(fp);
    fprintf(stderr, "\n\nEOF found file: %s\n\n", File_name);
}

/*
 *
 *	C FUNCTION PRINTER
 *
 */

#define PGLEN 60	/* LINES PER LINEPRINTER PAGE */
#define ON 1
#define OFF 0

int page_flag;
int prpg, pg;
int count;
int column_num, linesleft;
int in_quote=FALSE;
int in_comment=FALSE;
int single_quote=FALSE;
int double_quote=FALSE;

lpr()
{
    int i, z, pgno, ln_has_char, *fd;
    char date[30], linebuf[135];
    char tempbuf[30], ntempbuf[30], fnbuf[30], *fname;
    char *pgstr;
    char pgnmbuf[10];

    pg = count = 0;
    page_flag= ON;
    pgno = column_num = 0;
    linesleft = PGLEN;
    fprintf(stderr,"What is today's date? ");
    fgets(date,30,stdin);

    while (1) {
	if (File_name) {
	    fname = File_name;
	} else {
label:
	    fprintf(stderr,"\nEnter file to print, or CR if done: ");
	    if (!(fgets(fnbuf,30,stdin))) break;
	    if (strlen(fnbuf)==1) exit();
	    strncpy(ntempbuf,fnbuf,(strlen(fnbuf)-1));
	    fname = ntempbuf;
	}
	fprintf(stderr,"\nEnter page to print, CR for all: ");
	if (fgets(pgnmbuf,10,stdin)) {
	    strncpy(tempbuf,pgnmbuf,(strlen(pgnmbuf)-1));
	    pgstr = tempbuf;
	    pg=atoi(pgstr);
	} else pg=0;

	if ((fd = fopen(fname,"r")) == NULL) {
	    fprintf(stderr,"Can't open %s\n",fname);
	    goto label;
	}
	else fprintf(stderr,"\n\nPrinting %-13s\n\n",fname);

	/*
	 *   SELECT A PAGE ?
	 */

	for (pgno = 1; ; pgno++) {	   /* PAGE NUMBER */
	    if (pg != 0) {
		if (pg==pgno) {
		    page_flag=ON;
		} else page_flag=OFF;
	    } else page_flag=ON;
	    prpg=TRUE;
	    ln_has_char=FALSE;
loop:
	    if ((fgets(linebuf,134,fd)) == 0)  {
		prpg=FALSE;
		end(pgno,fd);
		goto label;
	    }

	    /*
	     *	   TEST FOR KEYBOARD INTERRUPT
	     */

	    if (kbint()) {
		getchar();
		break;
	    }

	    /*
	     *	   TEST FOR TEXT TO START ANOTHER PAGE
	     */

	    if (!(ln_has_char)) {
		for (z=0; z<strlen(linebuf); z++) {
		    if (!(isspace(linebuf[z]))) ln_has_char=TRUE;
		}
	    }

	    /*
	     *	   PRINT A TITLE IF CALLED FOR
	     */

	    if ((prpg) && (ln_has_char)) {
		fprintf(stderr,"*");
		if (page_flag == ON)
		    fprintf(stdout,"%18s%-13s%5s%-3d%20s\n\n",
		    "file: ",fname,"page ",pgno,date);
		prpg=FALSE;
		ln_has_char=FALSE;
	    }

	    /*
	     *	   IS IT ANOTHER PAGE ?
	     */

	    if (linepr(linebuf)) continue;

	    if (linesleft > 2) goto loop;
	    formfeed();
	}
	end(pgno,fd);
    }
}

end(pgno,fd)
{
    formfeed();
    if (pgno % 2) formfeed();
    fclose(fd);
}

/*
    PRINT A LINE OF TEXT OUT ON THE LIST DEVICE, AND
    RETURN TRUE IF A FORMFEED WAS ENCOUNTERED IN THE
    TEXT.
*/

linepr(string)
char string[135];
{
    register int cc, c;
    char *ffflag;
    int i;
    ffflag = 0;
    for (i=0;i<strlen(string);i++) {
	c = string[i];
	switch (c) {
	case '{':
	    if ((!(in_comment))  && (!(in_quote))) count+=1;
	    putlpr(c);
	    column_num++;
	    break;
	case '}':
	    if ((!(in_comment))  && (!(in_quote))) {
		count-=1;
		if (count==0) ffflag=1;
	    }
	    if (count<0) count=0;
	    putlpr(c);
	    column_num++;
	    break;
	case '\'':
	    if ((!(in_comment)) && (string[i+1]!='\'')) {
		if (single_quote) single_quote=FALSE;
		else if (string[i+2]=='\'') single_quote=TRUE;
	    }
	    putlpr(c);
	    column_num++;
	    if ((single_quote) || (double_quote)) in_quote=TRUE;
	    else in_quote=FALSE;
	    break;
	case '"':
	    if ((!(in_comment)) && (string[i+1]!='\'')) {
		if (double_quote) double_quote=FALSE;
		else double_quote=TRUE;
	    }
	    putlpr(c);
	    column_num++;
	    if ((single_quote) || (double_quote)) in_quote=TRUE;
	    else in_quote=FALSE;
	    break;
	case '/':
	    if (string[i+1]=='*')
		in_comment=TRUE;
	    putlpr(c);
	    column_num++;
	    break;
	case '*':
	    if ((string[i+1]=='/') && (in_comment))
		in_comment=FALSE;
	    putlpr(c);
	    column_num++;
	    break;
	case '\f':
	    ffflag = 1;
	    column_num++;
	    break;
	case '\n':
/*	    PUTLPR('\R');  CR FOR DOUBLE SPACES */
	    putlpr('\n');
	    column_num = 0;
	    linesleft--;
	    break;
	case '\t':
	    do {
		putlpr(' ');
		column_num++;
	    }
	    while (column_num % 8);
	    break;
	default:
	    putlpr(c);
	    column_num++;
	}
    }
    if (ffflag) formfeed();
    return(ffflag);
}

putlpr(c)
char c;
{
    if (page_flag==ON)
	out_put(c);
}

formfeed()
{
    if (FF) putlpr(FF);
    else while (linesleft--) putlpr('\n');
    linesleft = PGLEN;
}

kbint()       /* BREAK FOR ^C */
{
    if(bdos(KEY_STAT) & 0xff) {
	if(((bdos(KEY_IN)&0xff)!=0x19) && ((bdos(KEY_IN)&0xff)!=0x20)) {
	    fprintf(stderr,
	    "%c\n\n\t***  KEYBOARD INTERRUPT ***\n\n",  BELL);
	    return(TRUE);
	}
    }
    return(FALSE);
}
