 
/*
 *
 *			     CCREF
 *
 *		C Program Cross Reference Utility
 *
 * 
 *		for MS-DOS and Computer Innovations C86 
 * 
 *		Copyright (c) 1983,84 Solution Systems
 *
 *			  May 1984 
 * 
 */

#include "stdio.h" 
#include "chelper.h"


#define PATHLEN	   64		/* maximum pathname length */ 
#define MAX_REF    5		/* maximum refs per ref-block */
#define MAX_LEN    20		/* maximum identifier length  */
#define MAX_WRD   799		/* maximum number of identifiers */
#define MAX_ALPHA  53		/* maximum alpha chain heads */
#define REFS_PER_LINE  8	/* maximum refs per line */
#define	LINES_PER_PAGE 60

struct	id_blk {
	char  id_name[MAX_LEN];
	struct id_blk *alpha_lnk;
	struct rf_blk *top_lnk;
	struct rf_blk *lst_lnk;
}
oneid;

struct	rf_blk {
	int  ref_item[MAX_REF];
	int  ref_cnt;
}
onerf;

struct id_blk *id_vector[MAX_WRD];

struct alpha_hdr {
	struct id_blk *alpha_top;
	struct id_blk *alpha_lst;
};

struct alpha_hdr alpha_vector[MAX_ALPHA];

int	linum;		/* line number */
int	edtnum;		/* edit line number */
int	fil_cnt;	/* active file index */
int	wrd_cnt;	/* token count */
int	page_num;		/* page number */
int	id_cnt;		/* number of unique identifiers */
int	rhsh_cnt;	/* number of conflict hits */
int	filevl;		/* file level  */
int	paglin;		/* page line counter */
int	prt_ref;
char	act_fil[MAX_LEN+PATHLEN];
char	gbl_fil[MAX_LEN+PATHLEN];
char	l_buffer[BUFSIZ];
int	i_flg,c_flg,r_flg,l_flg,f_flg;
int	column;		/* need the column count for correct
			   #include processing */

int 	last_pound;

/* start here */
main(argc,argv)
int	argc;
char	**argv;
{

	banner();       		/* print copyright */
	initialize();   		/* initialize globals */
	get_options(argc,argv); 	/* process command line args */
	ccref();        		/* generate cross reference */ 
	return; 
}


/* copyright */
banner()
{

	fprintf(errmsg, 
"CCREF: C Cross Reference %s, Copyright (c) 1983,84 Solution Systems\n",
	version);

}       /* end banner */


/* initialize globals */
initialize()
{

	prt_ref = FALSE;
	fil_cnt = wrd_cnt = linum = 0;
	filevl=paglin=page_num=edtnum=0;
	id_cnt=rhsh_cnt=0;
	i_flg=c_flg=r_flg=l_flg=f_flg=FALSE;
   
	for(linum=0;linum < MAX_WRD;linum++) {
		id_vector[linum] = NULL;
	}
	for(linum=0;linum < MAX_ALPHA;linum++) {
		alpha_vector[linum].alpha_top =
		    alpha_vector[linum].alpha_lst = NULL;
	}
	linum=column=last_pound=0;

}	/* end initialize */


/* get user options */
get_options(argc,argv)
int argc;
char *argv[];
{
char *arg;

/*
 * get command line arguments, test and process flags
 */
	if (argc < 2) use_err();
	arg=argv[--argc];
	strcpy(gbl_fil,arg);

	if(gbl_fil[0] == '-')
		use_err();

	while(--argc) {
		if(argv[argc][0] == '-') {
			switch(toupper(argv[argc][1])) {

			case 'F': 
				f_flg++;	 
				break; 
			case 'I':
				i_flg++;
				break;
			case 'T':
				c_flg++;
				break;
			case 'R':
				r_flg++;
				break;
			case 'L':
				l_flg++;
				break;
			default:
				use_err();
			}
		}
		else use_err();
	}

}       /* end  get_options */




/*
 * main program, do list and cross reff
 */
ccref()
{
	proc_file(gbl_fil);
	if(!l_flg) {
		prnt_tbl();
		fprintf(stdout, "\nAllowable Symbols: %d\n",MAX_WRD);
		fprintf(stdout, "Unique    Symbols: %d\n",id_cnt);
	}
	putchar(f_flg?FF:NL);

} 	/* end ccref */


/* give the user some help */
usage_msg()
{
	fprintf(errmsg,
	      "\nCCREF: usage: ccref [-flags] infile [>outfile]\n");

	fprintf(errmsg, "\nFlags: -i    =     Enable file inclusion\n");
	fprintf(errmsg, "       -f    =     Use form feeds in output\n");
	fprintf(errmsg, "       -l    =     Generate listing only\n");
	fprintf(errmsg, "       -t    =     Generate reference table only\n");
	fprintf(errmsg, "       -r    =     Cross-reference reserved words\n");

}       /* end usage_errmsg */

/* process the file */
proc_file(filnam)
char *filnam;
{
	char  *buffer;		/* allocated buffer pointer */
	char  *sav_buffer;	/* saved alloc buffer pointer */
	char  token[MAX_LEN+PATHLEN];	/* token buffer */
	int   eof_flg;		/* end-of-file indicator */
	int   tok_len;		/* token length */
	int   incnum;		/* included line number */

	strcpy(act_fil,filnam);
	if ((sav_buffer = buffer =  alloc(BUFSIZ)) == 0) {
		fprintf(errmsg,
			"CCREF: Unable to allocate file buffer for %s\n",
			filnam);
		exit(0);
	}
	if((buffer=fopen(filnam, "r")) == NULL) {
 	  fprintf(errmsg,"\nCCREF: File not found: %s\n",filnam); 
	  exit(0);
	}	 

	if(filevl++ == 0) prt_hdr();
	eof_flg = FALSE;
	do {
	     if(get_token(buffer,token,&tok_len,&eof_flg,0,0))
		if(chk_token(token)) {
		     if((!strcmp(token,"#include")) && (!last_pound))
			if(get_token(buffer,token,&tok_len,&eof_flg,1,1))
				if(!i_flg) continue;
			else {
				incnum=edtnum;
				edtnum=0;
				nl();
				strip_quotes(token);
				proc_file(token);
				edtnum=incnum;
				strcpy(act_fil,filnam);
				continue;
			}
			put_token(token,linum);
		}
	}
	while (!eof_flg);

	filevl -= 1;
	fclose(buffer);
	/*put "free(sav_buffer);" here */

} 	/* end proc_file  */


/* strip the quotes from the file name */ 
strip_quotes(filename)
char *filename;
{
int i;
char out[MAX_LEN+PATHLEN]; 
char *cpin,*cpout;

  for(cpin=filename,cpout=out;*cpin;cpin++){
	if(!index("<>\"",*cpin))    /* if it's not a < >  or " */ 
		*cpout++=*cpin;
  }
  *cpout=EOS; 
  strcpy(filename,out);      	/* copy it back */ 

}	/* end strip_quotes */ 


/* get a token */ 
get_token(g_buffer,g_token,g_toklen,g_eoflg,g_flg,fn_flg)
char	*g_buffer;
char	*g_token;
int	*g_toklen;
int	*g_eoflg;
int	g_flg;
int	fn_flg;		/* true if we are getting a file name */ 
{
	int	c;
	char	*h_token;
	char	tmpchr;
	char	spass[10];      /* characters that will pass */ 

	h_token = g_token;

gtk:
	*g_toklen = 0;
	g_token = h_token;
	if(fn_flg)strcpy(spass,"\"<"); 
	else strcpy(spass,"_0#"); 

	*g_token=rdchr(g_buffer,g_eoflg,fn_flg);
	while(!*g_eoflg){
	   if(pass(*g_token,fn_flg,0,spass)) break; 
	   *g_token=rdchr(g_buffer,g_eoflg,fn_flg); 
	}

	if(*g_eoflg) return(FALSE);
	*g_toklen += 1;

	strcpy(spass,g_flg ? "." : "_"); 
	if(fn_flg)strcat(spass,"\">"); 

	c=rdchr(g_buffer,g_eoflg,fn_flg); 
	while(!*g_eoflg) { 
        	if(!pass(c,fn_flg,1,spass)) break;
		if(*g_toklen < MAX_LEN+PATHLEN) { 
		    *++g_token = c; 
		    *g_toklen += 1; 
		} 
		c=rdchr(g_buffer,g_eoflg,fn_flg); 
	} 

	if (*h_token == '0') goto gtk;

	*++g_token = NULL;

	if (*h_token == '#' && strcmp(h_token,"#include")) goto gtk;

	return(TRUE);

}       /* end get_token */ 


/* pass: return 1 if character is okay, 0 otherwise  
*/ 
pass(c,fn_flg,digit,string)
int c;          /* the character to check */ 
int fn_flg;     /* is it a file name ? */ 
int digit;      /* will a digit pass ? */ 
char *string;   /* other characters that will pass */ 
{ 


  if(fn_flg) return !isspace(c); 
  if(isalpha(c)||index(string,c)) return 1; 
  return digit&&isdigit(c); 

}       /* end pass */ 
/*isalpha */
isalpha(c)	/*return FALSE if non-ascii alphabetic */
int c;
{

return((c >= 'a' && c <= 'z') ||( c >= 'A' && c <= 'Z') ? TRUE : FALSE);

}

/* fil_chr */ 
fil_chr(f_buffer,f_eof)
char *f_buffer;
int *f_eof;
{
	int fc;
	fc=getch(f_buffer);
	if (fc == EOF) {
		*f_eof = TRUE;
		fc = NULL;
	}
	else if(fc == ERROR) {
	  fprintf(errmsg, "\nERROR: Error while processing input file - %s\n",
		act_fil);
		exit(0);
	}
	if(fc=='#')
		last_pound=column;

	if(fc=='\n')
		column=0;
	else
		column++;
	return(fc);

}       /* end fil_chr */ 


/* rdchr */ 
rdchr(r_buffer,r_eoflg,rd_flg,fn_flg)
int	*r_eoflg;
char	*r_buffer;
int	rd_flg;
int	fn_flg; 
{
	int	c;
	int	q_flg;		/* double quoted string flag */
	int	q1_flg;		/* single quoted string flag */
	int	cs_flg;		/* comment start flag */
	int	ce_flg;		/* comment end flag */
	int	c_cnt;		/* comment nesting level */
	int	t_flg;		/* transparency flag */

	q_flg = FALSE;
	q1_flg = FALSE;
	cs_flg = FALSE;
	ce_flg = FALSE;
	t_flg = FALSE;
	c_cnt  = 0;

rch:
	c=fil_chr(r_buffer,r_eoflg); 
	if(*r_eoflg) return(c);   /* EOF encountered */
	 
	if (c == '\n')  nl();
	else if (!c_flg) putchar(c);
	if(rd_flg) return(c);

	if(t_flg) {
		t_flg = !t_flg;
		goto rch;
	}

	if (!fn_flg && c == '\\') {
		t_flg = TRUE;
		goto rch;
	}

	if (!fn_flg && !q_flg && !q1_flg) {
		if (c == '*' && c_cnt && !cs_flg) {
			ce_flg = TRUE;
			goto rch;
		}
		if (c == '/' && ce_flg) {
			c_cnt -= 1;
			ce_flg = FALSE;
			goto rch;
		}
		ce_flg = FALSE;
		if (c == '/') {
			cs_flg = TRUE;
			goto rch;
		}
		if (c == '*' && cs_flg) {
			c_cnt += 1;
			cs_flg = FALSE;
			goto rch;
		}
		cs_flg = FALSE;
		if (c_cnt) goto rch;
	}

	if (!fn_flg && c == '\"' && !q1_flg) {
		q_flg =  !q_flg; /* toggle quote flag */
		goto rch;
	}
	if (!fn_flg && q_flg) goto rch;

	if (!fn_flg && c == '\'') {
		q1_flg = !q1_flg; /* toggle quote flag */
		goto rch;
	}
	if (!fn_flg && q1_flg) goto rch;

	return(c);

}       /* end rdchr */ 


/*  check the token */ 
chk_token(c_token)
char	*c_token;
{
	char  u_token[MAX_LEN];
	int   i;

	{
		if(r_flg) return(TRUE);
		i = 0;
		do {
			u_token[i] = toupper(c_token[i]);
		}
		while (c_token[i++] != NULL);

		switch(u_token[0]) {
		case 'A':
			if (strcmp(u_token,"AUTO") == 0) return(FALSE);
			break;
		case 'B':
			if (strcmp(u_token,"BREAK") == 0) return(FALSE);
			break;
		case 'C':
			if (strcmp(u_token,"CHAR") == 0) return (FALSE);
			if (strcmp(u_token,"CONTINUE") == 0) return (FALSE);
			if (strcmp(u_token,"CASE") == 0) return (FALSE);
			break;
		case 'D':
			if(strcmp(u_token,"DOUBLE") == 0) return(FALSE);
			if(strcmp(u_token,"DO") == 0) return(FALSE);
			if(strcmp(u_token,"DEFAULT") == 0) return(FALSE);
			break;
		case 'E':
			if(strcmp(u_token,"EXTERN") == 0) return(FALSE);
			if(strcmp(u_token,"ELSE") == 0) return(FALSE);
			if(strcmp(u_token,"ENTRY") == 0) return(FALSE);
			break;
		case 'F':
			if(strcmp(u_token,"FLOAT") == 0) return(FALSE);
			if(strcmp(u_token,"FOR") == 0) return(FALSE);
			break;
		case 'G':
			if(strcmp(u_token,"GOTO") == 0) return(FALSE);
			break;
		case 'I':
			if(strcmp(u_token,"INT") == 0) return(FALSE);
			if(strcmp(u_token,"IF") == 0) return(FALSE);
			break;
		case 'L':
			if(strcmp(u_token,"LONG") == 0) return(FALSE);
			break;
		case 'R':
			if(strcmp(u_token,"RETURN") == 0) return(FALSE);
			if(strcmp(u_token,"REGISTER") == 0) return(FALSE);
			break;
		case 'S':
			if(strcmp(u_token,"STRUCT") == 0) return(FALSE);
			if(strcmp(u_token,"SHORT") == 0) return(FALSE);
			if(strcmp(u_token,"STATIC") == 0) return(FALSE);
			if(strcmp(u_token,"SIZEOF") == 0) return(FALSE);
			if(strcmp(u_token,"SWITCH") == 0) return(FALSE);
			break;
		case 'T':
			if(strcmp(u_token,"TYPEDEF") == 0) return(FALSE);
			break;
		case 'U':
			if(strcmp(u_token,"UNION") == 0) return(FALSE);
			if(strcmp(u_token,"UNSIGNED") == 0) return(FALSE);
			break;
		case 'W':
			if(strcmp(u_token,"WHILE") == 0) return(FALSE);
			break;
		}
	}
	return(TRUE);

}       /* end chk_token */ 

/* put the token */ 
put_token(p_token,p_ref)
char *p_token;
int  p_ref;
{
	int  hsh_index;
	int  i;
	int  j;
	int  d;
	int  found;
	struct id_blk *idptr;
	struct rf_blk *rfptr;
	struct id_blk *alloc_id();
	struct rf_blk *alloc_rf();
	struct rf_blk *add_rf();

	if(l_flg) return;
	j=0;
	for (i=0; p_token[i] != NULL; i++)  /* Hashing algorithm is far from */
	{			      /* optimal but is adequate for a */
		j = j * 10 + p_token[i];      /* memory-bound index vector!  */
	}
	hsh_index = ABS(j) % MAX_WRD;
	found = FALSE;
	d = 1;

	do {
	idptr = id_vector[hsh_index];
	if(idptr == NULL) {
		id_cnt++;
		idptr = id_vector[hsh_index] = alloc_id(p_token);
		chain_alpha(idptr,p_token);
		idptr->top_lnk = idptr->lst_lnk = alloc_rf(p_ref);
		found = TRUE;
	}
	else
	    if(strcmp(p_token,idptr->id_name) == 0) {
		idptr->lst_lnk = add_rf(idptr->lst_lnk,p_ref);
		found = TRUE;
	}
	else {
		hsh_index += d;
		d += 2;
		rhsh_cnt++;
		if (hsh_index >= MAX_WRD)
			hsh_index -= MAX_WRD;
		if (d == MAX_WRD) {
			fprintf(errmsg, "\nERROR: Symbol table overflow\n");
			exit(0);
		}
	}
	}
	while (!found);

}       /* end put_token */ 


/* chain_alpha */ 
chain_alpha(ca_ptr,ca_token)
struct id_blk *ca_ptr;
char  *ca_token;
{
	char  c;
	int   f;
	struct id_blk *cur_ptr;
	struct id_blk *lst_ptr;

	c = ca_token[0];
	if(c == '_') c = 0;
	else
		isupper(c) ? (c=1+((c-'A')*2)) : (c=2+((c-'a')*2));

	if(alpha_vector[c].alpha_top == NULL) {
		alpha_vector[c].alpha_top =
		    alpha_vector[c].alpha_lst = ca_ptr;
		ca_ptr->alpha_lnk = NULL;
		return;
	}

	if(strcmp(alpha_vector[c].alpha_top->id_name,ca_token) >0) {
		ca_ptr->alpha_lnk=alpha_vector[c].alpha_top;
		alpha_vector[c].alpha_top=ca_ptr;
		return;
	}

	if(strcmp(alpha_vector[c].alpha_lst->id_name,ca_token) < 0) {
		alpha_vector[c].alpha_lst->alpha_lnk = ca_ptr;
		ca_ptr->alpha_lnk = NULL;
		alpha_vector[c].alpha_lst=ca_ptr;
		return;
	}

	cur_ptr = alpha_vector[c].alpha_top;
	while(strcmp(cur_ptr->id_name,ca_token) < 0)
	{
		lst_ptr = cur_ptr;
		cur_ptr = lst_ptr->alpha_lnk;
	}

	lst_ptr->alpha_lnk = ca_ptr;
	ca_ptr->alpha_lnk = cur_ptr;
	return;

}       /* end chain_alpha */ 

/* alloc_id */ 
struct id_blk *alloc_id(aid_token)
char  *aid_token;
{
	int  ai;
	struct id_blk *aid_ptr;

	if((aid_ptr = alloc(sizeof(oneid))) == 0) {
		fprintf(errmsg, "CCREF: Unable to allocate identifier block\n");
		exit(0);
	}
	ai=0;
	do {
		aid_ptr->id_name[ai] = aid_token[ai];
	}
	while (aid_token[ai++] != NULL);
	return (aid_ptr);

}       /* end alloc_id */ 

/* alloc ref */ 
struct rf_blk *alloc_rf(arf_ref)
int  arf_ref;
{
	int ri;
	struct rf_blk *arf_ptr;

	if((arf_ptr = alloc(sizeof(onerf))) == 0) {
		fprintf(errmsg, "CCREF: Unable to allocate reference block\n");
		exit(0);
	}
	arf_ptr->ref_item[0] = arf_ref;
	arf_ptr->ref_cnt = 1;
	for(ri=1;ri<MAX_REF;ri++)
		arf_ptr->ref_item[ri] = NULL;
	return (arf_ptr);

}       /* end alloc_rf */ 


/* add_rf */ 
struct rf_blk *add_rf(adr_ptr,adr_ref)
struct rf_blk *adr_ptr;
int adr_ref;
{
	struct rf_blk *tmp_ptr;

	tmp_ptr = adr_ptr;
	if(adr_ptr->ref_cnt == MAX_REF) {
		tmp_ptr = adr_ptr->ref_cnt = alloc_rf(adr_ref);
	}
	else {
		adr_ptr->ref_item[adr_ptr->ref_cnt++] = adr_ref;
	}
	return (tmp_ptr);

}       /* end add_rf */ 


/* print table */ 
prnt_tbl()
{
	int prf_cnt;
	int pti;
	int pref;
	int lin_cnt;
	struct id_blk *pid_ptr;
	struct rf_blk *ptb_ptr;

	prt_ref = TRUE;
	c_flg=FALSE;
	prt_hdr();
	for (pti=0;pti<MAX_ALPHA;pti++) {
	    if ((pid_ptr = alpha_vector[pti].alpha_top) != NULL) {
		do {
			fprintf(stdout, "%-14.13s: ",pid_ptr->id_name);
			ptb_ptr=pid_ptr->top_lnk;
			lin_cnt=prf_cnt=0;
			do {
				if(prf_cnt == MAX_REF) {
					prf_cnt=0;
					ptb_ptr = ptb_ptr->ref_cnt;
				}
				if(ptb_ptr > MAX_REF) {
					if((pref=ptb_ptr->ref_item[prf_cnt++]) != 0)
					{
						fprintf(stdout, "%d\t",pref);
						if (++lin_cnt == REFS_PER_LINE)
						{
							nl();
							fprintf(stdout, "\t\t");
							lin_cnt=0;
						}
					}
				}
				else pref=0;
			}
			while (pref);
			if (lin_cnt = 0)
				nl();
			else {
				nl();
				nl();
			}
		}
		while ((pid_ptr=pid_ptr->alpha_lnk) != NULL);
	}	
     }

}       /* end prnt_tbl */ 


/*  print header */ 
prt_hdr()
{
	unless (c_flg)
		page_num++;
	if (page_num != 0) {
		unless ((page_num==1)) putchar(f_flg?FF:NL);
		fprintf(stdout,
    "CCREF ... 'C' Cross Reference Utility ... File: %s\t  Page %d",
		     gbl_fil,page_num);
		fprintf(stdout, "\n\n");
	}
	nl();
	paglin =5;
	return;
}

/* nl */ 
nl()
{
	unless (c_flg) fprintf(stdout,"\n");
	if ((++paglin == LINES_PER_PAGE) && (!(c_flg))) prt_hdr();
	else
		if (!prt_ref) {
		    ++linum;
		    ++edtnum;
		    unless (c_flg) {
			if (i_flg) fprintf(stdout, "%3d.%3d: ",linum,edtnum);
			else fprintf(stdout, "%3d: ", linum);
		    }
		}
	return;
}

/* usage error */ 
use_err()
{
	usage_msg();
	exit(0);
}

/*  modified fgetc(fp) */ 
getch(fp)
FILE *fp;
{
int c; 

  if(fread(&c,1,1,fp)) {
     if(c==EOF || c==CPMEOF) return EOF;
     return c&0xff;
  }
  return EOF;

}       /* end getch */ 

/*  file not found */ 
fnf(fn)
char *fn;
{

  fprintf(errmsg,
    "CCREF: File not found: %s\n",fn); 
  exit(0); 
}       /* end fnf */ 
_flg)
		page_num++;
	if (page_num != 0) {
		unless ((page_num==1)) putchar(f_flg?FF:NL);
		fprintf(stdout,