; wc.xm: Word Count Unicum
; /AJK 1.Sep.81, 1.Sep.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'WC V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

BufSiz	equ	8192		; input buffer size
LinSiz	equ	256		; line buffer size

DADDRM	macro	mem,r		; double add register to memory
	ld	hl,(mem+2)
	add	hl,r
	ld	(mem+2),hl
	ld	hl,(mem)
	ld	r,0
	adc	hl,r
	ld	(mem),hl
	endm

DADDIM	macro	mem,imm		; double add immediate to memory
	ld	hl,(mem+2)
	ld	bc,imm
	add	hl,bc
	ld	(mem+2),hl
	ld	hl,(mem)
	ld	bc,0
	adc	hl,bc
	ld	(mem),hl
	endm

DADDMM	macro	mem1,mem2	; double add memory to memory
	ld	hl,(mem1+2)
	ld	de,(mem2+2)
	add	hl,de
	ld	(mem1+2),hl
	ld	hl,(mem1)
	ld	de,(mem2)
	adc	hl,de
	ld	(mem1),hl
	endm

	entry wc
wc:
	HEAhea [hl=0100h]	; initialize stack and heap
	USKini []		; scan command
	USKflg [hl=flgtbl]	; process flags
	USKdef [stk="-",stk=0]	; supply default argument
	USKano []->[(args)=a]	; count arguments
	USKall [hl=LinSiz]->[(line)=hl]

; Open the next file.
wc1:
	USKtnf [stk=(nflg),stk=(vflg)]->[hl=stk,bc=stk,de=stk]+C-a
	jp	c,wc10		; done when files exhausted
	ld	(fname),hl
	BBIopn [stk=hl,stk=RO+Text+OldOnly,stk=BufSiz]->[(inch)=a]+C
	jr	nc,wc2
	ERRmsg [a=a,b=1,c=0,hl=hl]
	ld	(code),a
	jr	wc1
wc2:

; Clear the totals.
	ld	hl,0
	ld	(chars),hl
	ld	(chars+2),hl
	ld	(words),hl
	ld	(words+2),hl
	ld	(lines),hl
	ld	(lines+2),hl

; Loop for each line.
wc3:
	BBIgl [stk=(inch),stk=(line),stk=LinSiz]->[]+C-a
	jr	c,wc8		; branch on EOF

; If we're ignoring format commands and this is one, ignore it.
	ld	a,(iflg)	; see if -i was specified
	and	a
	jr	z,wc4		; branch if not
	ld	hl,(line)	; it was, check for char of line
	ld	a,(hl)
	cp	'.'
	jr	z,wc3		; skip it if it starts with period

; Begin counting.
wc4:
	DADDIM lines,1		; bump line count
	ld	bc,2		; count chars in BC (include CR and LF)
	ld	de,0		; count words in DE
	ld	hl,(line)	; HL -> characters in line

; We're not within a word.
wc5:
	ld	a,(hl)		; A = next character
	inc	hl
	and	a		; check for end-of-line
	jr	z,wc7
	inc	bc		; count chars
	call	IsLtr		; see if A is a word character
	jr	c,wc5		; it's not, go to next character

; We're within a word.
	inc	de		; count words
wc6:
	ld	a,(hl)		; A = next character
	inc	hl
	and	a		; check for end-of-line
	jr	z,wc7
	inc	bc		; count chars
	call	IsLtr		; see if A is a word character
	jr	nc,wc6		; it is, continue within word
	jr	wc5		; go back to not being in a word

; Here at end of line.
wc7:
	DADDRM chars,bc		; bump char count for line
	DADDRM words,de		; bump word count for line
	jp	wc3		; go do another line

; Here on file EOF.
wc8:
	BBIcls [stk=(inch)]	; close the file
	ld	a,(args)	; see if we should give the file name

; Add totals to grand totals.
	DADDMM tchars,chars
	DADDMM twords,words
	DADDMM tlines,lines

; If -z was specified, don't give individual file totals.
	ld	a,(zflg)
	and	a
	jp	nz,wc1

; Announce the filename if necessary.
	ld	a,(args)
	cp	2
	jr	nz,wc9
	OPUTF [stk="%t: ",stk=(fname)]

; Produce the totals.
wc9:
	OPUTF [stk="%lmu characters, %lmu words, ",stk=(chars),stk=(chars+2),stk=(words),stk=(words+2)]
	OPUTF [stk="%lmu lines^m^j",stk=(lines),stk=(lines+2)]
	jp	wc1

; Here on EOF.  Produce totals if desired.
wc10:
	ld	a,(tflg)
	ld	hl,zflg
	or	(hl)
	jr	z,wc11		; branch if totals not desired
	OPUTF [stk="Total: %lmu characters, %lmu words, ",stk=(tchars),stk=(tchars+2),stk=(twords),stk=(twords+2)]
	OPUTF [stk="%lmu lines^m^j",stk=(tlines),stk=(tlines+2)]

wc11:
	SHLexi [a=(code)]

; IsLtr:
;   call with char in A;
;   return carry set if not a letter, carry clear if a letter.
IsLtr:
	cp	'A'
	jr	c,il1		; branch if not a letter, might be a digit
	cp	'Z'+1
	jr	c,il3		; letter
	cp	'a'
	jr	c,il2		; not a letter
	cp	'z'+1
	jr	c,il3
	jr	il2
il1:				; here for possible digit
	cp	'0'
	jr	c,il2		; not a letter
	cp	'9'+1
	jr	nc,il2		; not a letter
	push	hl		; it's a digit, see if digits are allowed
	ld	hl,dflg
	bit	0,(hl)		; see if -d was specified
	pop	hl
	jr	nz,il3		; if so, digits allowed

; Here if not a letter.
il2:
	scf			; set carry
	ret

; Here if a letter.
il3:
	and	a		; clear carry
	ret

; Flag table
flgtbl:
	db 'd',0,0,0,0,0,0,0,0,0,0,0,0
dflg:	dw 0
	db 'i',0,0,0,0,0,0,0,0,0,0,0,0
iflg:	dw 0
	db 'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw 0
	db 't',0,0,0,0,0,0,0,0,0,0,0,0
tflg:	dw 0
	db 'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw 0
	db 'z',0,0,0,0,0,0,0,0,0,0,0,0
zflg:	dw 0
	db 0

code:	db 0			; return code
inch:	dw 0			; input channel

tchars:	dw 0,0			; total characters
twords:	dw 0,0			; total words
tlines:	dw 0,0			; total lines

chars:	ds	4		; characters
words:	ds	4		; words
lines:	ds	4		; lines

args:	ds	1		; number of arguments (loosely)
fname:	ds	2		; -> file name
line:	ds	2		; -> buffer

	end wc
