; sr.xm: pattern SeaRch unicum
; /AJK 15.Jun.81, 13.Sep.82

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\


; History:
; V1  1.Sep.81: initial distribution of Unica
; V2  1.Oct.82: incorporate new PAT2800k component, add -q flag


	uses LIB2800		; Z80 components
	uses LIB2801		; CP/M components

	db	13,'SR V2: COPYRIGHT (C) 1981, 1982 BY KNOWLOGY',13,10,26,0

; Alternate highlight begin/end sequences.  These cause reverse video
; on a TRS-80 model II running Pickles&Trout CP/M.  If you have XM-80,
; you might want to change these to something appropriate for your
; terminal.  If you don't have XM-80, you can use DDT to patch these
; locations; enough room has been left in the string for sequences
; of up to eight bytes.  Be sure that the sequence ends in a null.
altbeg:	db	'^N',0,0,0,0,0,0,0	; begins at location 0133h
altend:	db	':^O',0,0,0,0,0,0	; begins at location 013Dh

StdOut	equ	1		; standard output channel
LinLen	equ	256		; max input line length
BufSiz	equ	8192		; input buffer size

	entry sr
sr:
	HEAhea [hl=0100h]	; set up heap and stack
	USKini []		; initialize command scan
	USKflg [hl=flgtbl]	; interpret flags

; Determine which pattern compiler to use.
; If the pattern is quoted (-q), use PATacs, else use PATac.
; Keep the address of the pattern compiler in IY.
	ld	iy,PATac##	; assume non-quoted pattern
	ld	a,(qflg)	; see if -q was specified
	and	a
	jr	z,sr1		; branch if not
	ld	iy,PATacs##	; quoted pattern
sr1:

; Compile the pattern.
	USKgna []->[hl]+C-a	; get the pattern argument
	jr	nc,sr2		; branch if argument supplied
	EPUTF [stk="Usage: sr [-acflnoqrtvz] [-b begseq] [-e endseq] pattern [file ..]^m^j"]
	SHLexi [a=1]
sr2:
	(iy) [hl,a=0]->[(patrn)=hl,a]+C	; compile the pattern
	jr	nc,sr3		; branch on successful compilation
	EPUTF [stk="Pattern syntax error^m^j"]
	SHLexi [a=1]
sr3:

; If no files are specified, just read from standard input.
	USKdef [stk="-",stk=0]	; supply default arguments
	USKano []->[a]		; A = 2 if multiple files given
	ld	(mltflg),a	; save "multiple files" flag

; Clear the totals.
	ld	hl,0
	ld	(filtot),hl	; zero total file count
	ld	(mattot),hl	; zero total match count
	ld	(mattot+2),hl	; (mattot is a long)

; Allocate the line buffer.
	USKall [hl=LinLen]->[(line)=hl]

; If -a was specified, change the begin and end sequences.
	ld	a,(aflg)	; check for -a
	and	a
	jr	z,sr4		; branch if -a not specified
	ld	hl,altbeg	; change to alternate begin sequence
	ld	(begseq),hl
	ld	hl,altend	; and change to alternate end sequence
	ld	(endseq),hl

; Top of loop for each file.
sr4:
	USKtnf [stk=(nflg),stk=(vflg)]->[hl=stk,bc=stk,de=stk]+C-a
	jp	c,sr16		; branch when no more files
	BBIopn [stk=hl,stk=RO+Text+OldOnly,stk=BufSiz]->[a]+C
	jr	nc,sr5
	ERRMSG [a=a,b=1,c=0,hl=hl]
	jr	sr4		; skip this file
sr5:
	ld	(fname),hl	; store input file name
	ld	(inch),a	; save input channel
	xor	a		; mark that match hasn't occurred in this file
	ld	(matflg),a
	ld	h,a
	ld	l,a
	ld	(lineno),hl	; clear the current line number
	ld	(matcnt),hl	; clear the count of matches in this file

; Top of loop for each line.
sr6:
	BBIgl [stk=(inch),stk=(line),stk=LinLen]->[]+C-a
	jp	c,sr13		; branch when EOF
	ld	hl,(lineno)	; bump the current line number
	inc	hl
	ld	(lineno),hl
	PATm [hl=(line),de=(patrn)]->[hl,de]+C-a
	ld	a,(rflg)	; A = "-r" flag (reverse sense)
	jr	c,sr7		; branch if pattern not in line
	and	a		; pattern is in line, see if -r specified
	jr	nz,sr6		; branch if so, ignore this line
	jr	sr8		; otherwise branch to announce this line
sr7:
	and	a		; pattern is not in line, see if -r
	jr	z,sr6		; branch if not, ignore this line

; Here to announce the line.
sr8:
	ld	hl,(matcnt)	; bump count of matches in this file
	inc	hl
	ld	(matcnt),hl

	ld	a,(matflg)
	ld	c,a		; C is the copy of matflg
	ld	a,1		; mark that this file has been highlighted
	ld	(matflg),a

; If -z was given, just bump the counts.
	ld	a,(zflg)	; see if -z is in effect
	and	a
	jr	nz,sr6		; if so, we have nothing to say yet

; If -f was given, just give the file name and bump the counts.  If -t is
;   not in effect, then we're not giving line counts so there's no point
;   in reading any longer, finish this file.
	ld	a,(fflg)	; see if -f is in effect
	and	a
	jr	z,sr10		; branch if not
	ld	a,c		; it is, see if filename has been given yet
	and	a
	jr	nz,sr9		; branch if so
	OPUTF [stk="%t^m^j",stk=(fname)] ; filename for -f
sr9:
	ld	a,(tflg)	; are we doing totals?
	and	a
	jp	z,sr15		; if not, we're done with this file
	jr	sr6		; otherwise just done with this line
sr10:

; If -c was given, just bump the file line count.
	ld	a,(cflg)	; see if -c is in effect
	and	a
	jr	nz,sr6		; if so, we're done with this line

; Otherwise if the file name has not been announced and -o is not in effect,
; do so.  Then, if -l is in effect, give the line number; then give the line.
	ld	a,c		; see if filename has been given yet
	and	a
	jr	nz,sr11		; branch if so
	ld	a,(mltflg)	; see if we should announce the file
	cp	2		; only if USKano returned 2
	jr	nz,sr11
	ld	a,(oflg)	; and if -o wasn't specified
	and	a
	jr	nz,sr11
	OPUTF [stk=(begseq)]	; print begin sequence
	OPUTF [stk="%t",stk=(fname)]
	OPUTF [stk=(endseq)]	; print end sequence
	OPUTF [stk="^m^j"]	; carriage return
sr11:
	ld	a,(lflg)	; -l?
	and	a
	jr	z,sr12		; branch if not
	OPUTF [stk="%5u:  ",stk=(lineno)] ; put line number
				; note that line number MUST consume 8 spaces,
				; else any tabs in the line will be messed up!
sr12:
	OPUTF [stk="%s^m^j",stk=(line)] ; put the line
	jp	sr6		; go read the next line

; Here when end-of-file.  If -c, give the line count.
sr13:
	ld	a,(cflg)	; see if -c
	and	a
	jr	z,sr14
	ld	a,(matflg)	; see if this file had a match
	and	a
	jr	z,sr14
	OPUTF [stk="%t: %mu lines^m^j",stk=(fname),stk=(matcnt)]
sr14:

; Transfer totals to grand totals.
	ld	a,(matflg)	; see if there were any matches
	and	a
	jr	z,sr15		; branch if none
	ld	hl,(filtot)	; bump file total
	inc	hl
	ld	(filtot),hl
	ld	hl,(mattot+2)	; bump matched line total
	ld	de,(matcnt)
	add	hl,de
	ld	(mattot+2),hl
	ld	hl,(mattot)
	ld	de,0
	adc	hl,de
	ld	(mattot),hl
sr15:

; Done with this file.
	BBIcls [stk=(inch)]
	jp	sr4		; go do another file

; Here when all files done.  Summarize.
sr16:
	ld	a,(tflg)	; see if -t or -z was specified
	and	a
	jr	nz,sr17
	ld	a,(zflg)
	and	a
	jr	z,sr18		; if not, don't give totals
sr17:
	OPUTF [stk="%mu files, %mlu lines^m^j",stk=(filtot),stk=(mattot),stk=(mattot+2)]
sr18:
	SHLexi [a=0]

; Flag table
flgtbl:
	db 'a',0,0,0,0,0,0,0,0,0,0,0,0
aflg:	dw 0
	db 'b',3,0,0,0,0,0,0,0,0,0
begseq:	dw pribeg,0
	db 'c',0,0,0,0,0,0,0,0,0,0,0,0
cflg:	dw 0
	db 'e',3,0,0,0,0,0,0,0,0,0
endseq:	dw priend,0
	db 'f',0,0,0,0,0,0,0,0,0,0,0,0
fflg:	dw 0
	db 'l',0,0,0,0,0,0,0,0,0,0,0,0
lflg:	dw 0
	db 'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw 0
	db 'o',0,0,0,0,0,0,0,0,0,0,0,0
oflg:	dw 0
	db 'q',0,0,0,0,0,0,0,0,0,0,0,0
qflg:	dw 0
	db 'r',0,0,0,0,0,0,0,0,0,0,0,0
rflg:	dw 0
	db 't',0,0,0,0,0,0,0,0,0,0,0,0
tflg:	dw 0
	db 'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw 0
	db 'z',0,0,0,0,0,0,0,0,0,0,0,0
zflg:	dw 0
	db 0

; Primary highlight begin/end sequences
pribeg:	db	'----- ',0
priend:	db	': -----',0

; Data
patrn:	ds	2		; -> pattern with asterisks appended
line:	ds	2		; -> line input buffer
fname:	ds	2		; -> this file name
inch:	ds	1		; current input channel
mltflg:	ds	1		; multiple files flag
matflg:	ds	1		; true if current file has a match
lineno:	ds	2		; line number within file
matcnt:	ds	2		; matches within file
filtot:	ds	2		; total matching files
mattot:	ds	4		; (long) total matching lines

	end sr
