; sp2.xm: second part of SPelling error detector/corrector Unicum
; /AJK 13.Sep.82, 24.Oct.82

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1982 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\


; The sp Unicum is made up of three files:
;   sp.cif -- global definitions
;   sp1.xm -- main program
;   sp2.xm -- correction dialog
;   sp3.xm -- support routines and data
; To re-create the executable program image SP.COM, do the following:
;   xm80 =sp1
;   xm80 =sp2
;   xm80 =sp3
;   l80 sp1,sp2,sp3,lib/s,sp/n/e

	uses LIB2800
	uses LIB2801
	uses SP			; global procedures and data

; TALK routine from sp1
; Can't put it in sp.cif because of bug involving PROVIDing routines with
; stk* parameters
	proc TALK [FORMAT:stk,VALS:stk*]
	extrn TALK

; Internal routines
	proc TmpFil [OLDFILE:ix,NEWFILE:hl]
	proc UCtoLC [a]->[a]
	proc Update [CHANNEL:a,FLAGMASK:c,FILENAME:ix]
	proc WrdPut [FLAG:a,WORD:hl,REPL:de]


; Correction dialog.

correct::

; If -o was not specified and the input file is on disk,
; create and open a temporary file to receive corrected text.
	ld	a,(oflg)		; (again) see if -o was specified
	and	a
	jr	nz,co3			; branch if so, don't need temp file
	IO.sts [a=(inch)]->[a,b,hl]+C	; get status of input file
					; *ignore failure*
	bit	StDsk,a			; is file on disk?
	jr	z,co3			; branch if not

; Open a temporary file on the same disk as the input file.
	TmpFil [ix=(infnm),hl=tmpfnm]	; create temp file name
	IO.opn [stk=hl,stk=WO+Text+NewOnly]->[(outch)=a]+C ; open file
	jp	c,ioerr##		; branch if can't open temp file
	ld	a,1			; set "temp file open" flag
	ld	(tmpf),a
co3:					; here with output file open

; Rewind the input file.		
	IO.see [stk=(inch),stk=0,stk=0]->[a,hl]+C
	jp	c,ioerr##

; Announce correction mode.
	TPUTF [stk="Error correction dialog, type ? for help^m^j"]

; Top of loop to make the second pass through the input file.
; Read the next line from that file.
co4:
	xor	a			; clear "skip rest of line" flag
	ld	(skipl),a
	LIOgl [stk=(inch),stk=(linbuf),stk=(linlen)]->[]+C
	jp	c,co49			; branch at file EOF
	WRDnew [ix=(linbuf),iy=(wrkbuf),hl=(fmtpat),de=0,bc=trtbl]

; Top of loop for each word in the line.
; Look up the word and see if it's correctly spelled.
; Register use during loop:
;   IY -> position in linbuf up to which characters have been written to output
	ld	iy,(linbuf)		; IY -> current place in line buffer
co5:
	WRDget [hl=(wrdbuf)]->[(wrdst)=hl,(wrdlen)=de]+C-a
	jp	c,co48			; branch after last word in line

; We found a candidate word.
; Write out all characters before that word.
	push	iy			; IY is first unwritten character
	pop	de
	and	a
	sbc	hl,de			; HL is number of characters to write
	IO.wri [stk=(outch),stk=iy,stk=hl]->[a,hl]+C
	jp	c,ioerr##
	ld	iy,(wrdst)

; Check that word isn't too short.
	ld	hl,(ival)		; see if word is too short
	ld	de,(wrdlen)
	sbc	hl,de			; (carry is clear from IO.wri)
	jr	nc,co5			; branch if word is short, ignore it

; Look up the word.
	Lookup [hl=(wrdbuf)]->[(where)=de]+C-a ; look up the word in the list
	jr	nc,co6			; it *must* be there
	EPUTF [stk="? sp internal error - word '%t' disappeared^m^j",stk=hl]
	SHLexi [a=0FFh]
co6:					; here with DE -> word pointer
	ex	de,hl			; HL -> word pointer
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl			; HL -> word
co7:
	inc	hl			; look for terminator
	bit	7,(hl)
	jr	z,co7
	bit	STgood,(hl)		; is the word spelled correctly?
	jr	nz,co5			; if so, skip it
	ld	(term),hl		; store terminator position

; We've found an incorrectly spelled word.
; If it's to be automatically processed, dispatch to the automatic handler.
	ld	a,(hl)			; A = control bits
	and	AUTOms			; isolate auto bits
	cp	AUTOr			; automatically replace?
	jp	z,co32			; go do it
	cp	AUTOm			; automatically mark?
	jp	z,co39			; go do it

; No automatic processing, see if we're skipping.
; If so, go on to next word.
co8:
	ld	a,(skipl)		; A = "skip rest of this line" flag
	ld	hl,skipf		; HL -> "skip rest of this file" flag
	or	(hl)
	jr	nz,co5			; if we're skipping, go on

; Display the line in which this mispelled word occurs.
; If -h was specified, display using highlighting,
; otherwise show the line and underline the word.
	ld	a,(hflg)		; are we highlighting?
	and	a
	jr	z,co12			; if not, use underlining

; Display line with highlighting.
	ld	de,(wrdst)		; DE -> start of word
	ld	hl,(linbuf)		; HL -> start of line
co9:					; see if we've come to start of word
	push	hl
	and	a
	sbc	hl,de
	pop	hl
	jr	z,co10			; branch if we have
	ld	a,(hl)			; haven't, put this character
	TPUTF [stk="%pc",stk=af]
	inc	hl			; step to next
	jr	co9
co10:
	TPUTF [stk=(bval)]		; put the highlight begin sequence
	ld	bc,(wrdlen)		; put the word
co11:
	ld	a,(hl)			; put a character of the word
	TPUTF [stk="%pc",stk=af]
	inc	hl
	dec	bc
	ld	a,b			; loop for all of word
	or	c
	jr	nz,co11
	TPUTF [stk=(eval)]		; put the highlight end sequence
	TPUTF [stk="%s^m^j",stk=hl]	; write the rest of the line
	jr	co16			; done displaying line

; Display line with underlining.
co12:
	TPUTF [stk="%s^m^j",stk=(linbuf)] ; put the line
	ld	hl,(wrdst)
	ld	de,(linbuf)
	and	a
	sbc	hl,de			; HL = number of spaces to put
co13:
	ld	a,h
	or	l
	jr	z,co14			; branch when done with spaces
	TPUTF [stk=" "]			; else put one
	dec	hl
	jr	co13			; loop
co14:
	ld	hl,(wrdlen)		; now put underlines (hyphens)
co15:
	TPUTF [stk="-"]
	dec	hl
	ld	a,h
	or	l
	jr	nz,co15
	TPUTF [stk="^m^j"]		; finish off the line

; Done displaying line.
; If there's a replacement, suggest it.
co16:
	ld	hl,0			; assume no replacement pointer
	ld	(repler),hl
	ld	hl,(term)		; HL -> terminator
	bit	STrepl,(hl)		; is there a terminator to suggest?
	jr	z,co17			; branch if there isn't
	inc	hl			; HL -> replacement
	TPUTF [stk="(%s) ",stk=hl]	; suggest the word
	ld	(repler),hl		; store replacement pointer

; Prompt for and get a command.
co17:
	ld	hl,0			; clear "arg": no argument seen yet
	ld	(arg),hl
	TPUTF [stk=": "]		; well?
	TVGET [hl=(wrdbuf)]		; get an answer into the word buffer

; Assemble a command.
; First letter must be one of scrmx?
; Subsequent letter(s) can include gaj
; Get command letter, set option flags "gopt", "aopt", "jopt" as indicated
	xor	a			; clear option flags
	ld	(gopt),a
	ld	(aopt),a
	ld	(jopt),a
	ld	a,(hl)			; A = command letter
	and	a			; check for blank command
	jp	z,co8			; just repeat the line
	UCtoLC [a]->[a]			; convert to lower case
	cp	'?'			; asking for help?
	jr	nz,co18			; branch if not
	TPUTF [stk=help]		; supply help
	jp	co8			; allow for more input
co18:
	ld	c,a			; save command in C
co19:
	inc	hl			; process options
	ld	a,(hl)			; A = next option character
	and	a			; check for null (terminator)
	jr	z,co23
	cp	' '			; check for space (word/mark follows)
	jr	z,co22
	UCtoLC [a]->[a]			; convert option to lower case
	cp	'g'			; set appropriate ?opt flag
	jr	nz,co20
	ld	(gopt),a
	jr	co19
co20:
	cp	'a'
	jr	nz,co21
	ld	(aopt),a
	jr	co19
co21:
	cp	'j'
	jr	nz,co24			; error
	ld	(jopt),a
	ld	a,(jflg)		; make sure there is jargon dictionary
	and	a
	jr	nz,co19
	TPUTF [stk="No jargon dictionary^m^j"]
	jp	co16

; Here when a blank is seen after the command.
; An argument follows.
co22:
	inc	hl			; step past blank
	ld	(arg),hl		; stow argument

; Here when the command is all split up.
; Dispatch to the appropriate handler.
co23:
	ld	a,c			; get command character
	cp	's'			; skip (word)
	jp	z,co5
	cp	'l'			; skip line
	jp	z,co46
	cp	'r'			; replace
	jr	z,co25
	cp	'm'			; mark
	jp	z,co36
	cp	'x'			; exit
	jp	z,co47
	cp	'c'			; word is correct
	jp	z,co41

; Here when the command is bad.
; Publish an error and try again.
co24:
	TPUTF [stk="Type ? for help^m^j"]
	jp	co8

; Here on an 'r' (replace) command.
; Make sure there's something to replace it with.
co25:
	ld	hl,(arg)		; HL = command argument
	ld	a,h			; check for it
	or	l
	jr	nz,co26			; branch if argument seen
	ld	hl,(repler)		; look for suggested replacement
	ld	a,h
	or	l
	jr	nz,co28			; branch to use suggestion
	TPUTF [stk="Replace with what?^m^j"]
	jp	co16			; prompt for another command

; The user gave an explicit replacement (didn't take the default).
; Enter the word into the word list with the replacement.
co26:
	ld	(repler),hl		; save replacement string address
	ld	hl,(term)		; save word flags
	ld	c,(hl)			;   in C
	Repl [ix=(where),de=(repler)]	; make a replacement
	ld	l,(ix+0)		; find the new terminator byte
	ld	h,(ix+1)
co27:
	inc	hl
	bit	7,(hl)
	jr	z,co27
	ld	(term),hl		; (term) -> new terminator byte
	ld	a,c			; A = old word flags
	or	1 SHL STrepl		; mark "replacement present"
	ld	(hl),a			; record new flags

; Record options in word flags.
; If we're to make this replacement globally:
co28:
	ld	hl,(term)		; HL -> flags
	ld	a,(gopt)		; see if 'g' was specified
	and	a
	jr	z,co29			; branch if not
	ld	a,(hl)
	or	AUTOr			; set "auto replace"
	ld	(hl),a
co29:
; If we're to add word to auxiliary dictionary:
	ld	a,(aopt)		; see if 'a' was specified
	and	a
	jr	z,co30			; branch if not
	set	STaux,(hl)		; set "add to aux"
	ld	(aupd),a		; remember to update aux
co30:
; If we're to add word to jargon dictionary:
	ld	a,(jopt)		; see if 'j' was specified
	and	a
	jr	z,co31			; branch if not
	set	STjarg,(hl)		; set "add to jargon"
	ld	(jupd),a		; remember to update jargon
co31:
	jr	co33			; go to common replace code

; Here on word auto-replace
co32:
	inc	hl			; HL -> replacement word
	ld	(repler),hl		; record replacement location

; Common replace code, for both auto-replace and 'r' command.
; Start by copying the word into the "word" buffer, so we can
; modify it without damaging the in-memory word list.
co33:
	STRcpy [de=(repler),hl=(wrdbuf),bc=WrdSiz]

; Now to match capitalization.  There are three cases:
; 1) The first letter of the word to be replaced is lower case.
;    (Note that it must be a letter because of the word-match pattern.)
;    The replacement is used unchanged.
; 2) The first letter of the word to be replaced is upper case,
;    but the second letter is not.  (This includes the case where the
;    word has but one letter or the second letter is an apostrophe.)
;    Only the first letter of the replacement is forced to upper case.
; 3) Both the first and second letters of the word to be replaced are
;    upper case.  The entire replacement is forced to upper case.
	ld	hl,(wrdst)		; HL -> word being replaced
	ld	a,(hl)			; A = first character
	cp	'a'			; is it lower case?
	jr	nc,co35			; if so, case (1)
	inc	hl			; step to second letter (if any)
	ld	a,(hl)			; A = second letter
	cp	'A'			; check for upper case letter
	jr	c,co34			; (branch if not, case (2))
	cp	'Z'+1
	jr	nc,co34			; (branch if not)
	STRuc [hl=(wrdbuf)]		; case (3), upper case whole word
	jr	co35
co34:					; here for case (2)
	ld	hl,(wrdbuf)		; upper case first letter
	ld	a,(hl)
	sub	'a'-'A'
	ld	(hl),a
co35:

; Got the replacement word.
; Write it to the output file.
	STRlng [hl=(wrdbuf)]->[hl]	; HL = length of new word
	IO.wri [stk=(outch),stk=(wrdbuf),stk=hl]->[a,hl]+C
	jp	c,ioerr##

; Advance IY so that the original word is not written out.
	ld	de,(wrdlen)		; DE = length of new word
	add	iy,de			; advance IY

	jp	co5			; go do next word

; Here on an 'm' (mark) command.
; Disallow 'a' and 'j' options.
co36:
	ld	a,(aopt)
	ld	hl,jopt
	or	(hl)
	jp	nz,co24

; If the user specified a mark string, use it, otherwise use the default.
; Cannot both specify 'g' (global) and explicit mark string, as we
; have no provision to store a distinct mark string for each auto-mark word.
	ld	hl,(arg)		; HL -> argument
	ld	a,h
	or	l
	jr	z,co37			; branch if there is none
	ld	a,(gopt)		; there is, disallow 'g'
	and	a
	jp	nz,co24
	ld	(marker),hl		; use specified string
	jr	co40			; join common mark code
co37:					; here if no explicit argument
	ld	a,(gopt)		; see if 'g' was specified
	and	a
	jr	z,co38			; branch if not
	ld	hl,(term)		; it was, set auto-mark for this word
	ld	a,(hl)
	or	AUTOm
	ld	(hl),a
co38:					; fall into auto-mark code

; Here to do auto-mark.
co39:
	ld	hl,(mval)		; use default mark string
	ld	(marker),hl

; Common mark code.
; Send the mark to the output file.
co40:
	STRlng [hl=(marker)]->[hl]	; HL = length of mark
	IO.wri [stk=(outch),stk=(marker),stk=hl]->[a,hl]+C
	jp	c,ioerr##

; This word will be written out when we get to the next word.
	jp	co5			; go on to next word

; Here on an 'c' (word is correct) command.
; 'g' option may be specified and is ignored.
co41:
	ld	hl,(term)		; HL -> flags
	bit	STbad,(hl)		; do we KNOW that this word is bad?
	jr	z,co42			; if not, allow it to be corrected
	TPUTF [stk="This word is known to be mispelled.^m^j"]
	jp	co16
co42:					; here if word may be corrected

	set	STgood,(hl)		; mark word "good"
	ld	a,(aopt)		; put word in aux dictionary?
	and	a
	jr	z,co43
	set	STaux,(hl)		; yes
	ld	(aupd),a		; remember to update aux
co43:
	ld	a,(jopt)		; put word in jargon dictionary?
	and	a
	jr	z,co44
	set	STjarg,(hl)		; yes
	ld	(jupd),a		; remember to update jargon
co44:
	jp	co5			; go on to next word

; Here on an 'l' (skip line) command.
; Set the "skip rest of line" flag and go on to next word.
co46:
	ld	a,1
	ld	(skipl),a
	jp	co5

; Here on an 'x' (exit) command.
; Set the "skip rest of file" flag and go on to next word.
co47:
	ld	a,1
	ld	(skipf),a
	jp	co5

; Here after last word in line.
; Finish writing the line to the output channel, then go on to the next line.
co48:
	LIOpl [stk=(outch),stk=iy]	; finish writing line
	jp	co4			; go on to next line

; Here after entire file has been copied.
; Close the input and output files.
co49:
	IO.cls [stk=(inch)]->[a,hl]+C
	jp	c,ioerr##
	IO.cls [stk=(outch)]->[a,hl]+C
	jp	c,ioerr##

; If we're updating the file in place, delete the original and
; rename the temporary.
	ld	a,(tmpf)		; working on a temp file?
	and	a
	jr	z,co50			; branch if not
	ld	hl,(infnm)		; HL -> input file name
	DUTdel [stk=hl]->[a]+C		; delete it
	jp	c,ioerr##
	ex	de,hl			; DE -> input file name
	ld	hl,tmpfnm		; HL -> temp file name
	DUTren [stk=hl,stk=de,stk=0]->[a]+C ; rename temp file
	jp	c,ioerr##
co50:

; Update dictionaries.
	ld	a,(aupd)
	and	a
	jr	z,co51
	TALK [stk="[Updating auxiliary dictionary]^m^j"]
	ld	c,1 SHL STaux
	Update [a=(ach),c,ix=(aval)]
co51:
	ld	a,(jupd)
	and	a
	jr	z,co52
	TALK [stk="[Updating jargon dictionary]^m^j"]
	ld	c,1 SHL STjarg
	Update [a=(jch),c,ix=(jval)]
co52:

; All done.
	ret


; TmpFil procedure
; Create a temporary file which will eventually replace an existing file.
; OLDFILE is the name of a file which will eventually be replaced.
; Coin a unique filename for the same disk as OLDFILE, return it in NEWFILE.
	proc TmpFil [OLDFILE:ix,NEWFILE:hl]
	begin
	push	af			; save registers
	push	bc
	push	de
	push	hl

; Determine the unique prefix for UNIQFN.
; If OLDFILE does not include a disk, then it's "sp",
; otherwise it's "x:sp" where x is OLDFILE's disk.
	STRcpy [de="@:sp",hl=(linbuf),bc=5]
	ld	a,(ix+1)		; look for explicit disk
	cp	':'
	jr	z,tf1			; branch if explicit disk seen
	inc	hl			; step hl past "@:"
	inc	hl
	jr	tf2
tf1:					; here if explicit disk seen
	ld	a,(ix+0)		; A = input disk
	ld	(hl),a			; change "@:sp" to "x:sp", x is disk
tf2:

; Now make a unique filename.
	ex	de,hl			; DE -> file prefix
	pop	hl			; restore NEWFILE pointer
	UNIQFN [stk=de,stk=".tmp",stk=hl]

	pop	de			; restore other registers
	pop	bc
	pop	af

	end TmpFil


; Upper Case to Lower Case conversion.
	proc UCtoLC [a]->[a]
	begin
	cp	'A'
	ret	c
	cp	'Z'+1
	ret	nc
	add	a,'a'-'A'
	end UCtoLC


; Update a dictionary.
; The dictionary is open on CHANNEL.  Its name is FILENAME.
; FLAGMASK is (1 SHL STaux) for auxiliary, or (1 SHL STjarg) for jargon.
; The words marked to be added to that dictionary are added.
	proc Update [CHANNEL:a,FLAGMASK:c,FILENAME:ix]
	begin
	push	af			; save registers
	push	bc
	push	de
	push	hl
	push	iy
	push	ix			; (SP) = dictionary file name

	ld	(inch),a		; save input channel
	ld	hl,flag
	ld	(hl),c			; save flags

; Rewind the dictionary.
	IO.see [stk=(inch),stk=0,stk=0]->[a,hl]+C
	jp	c,ioerr##

; Open a temp file to hold the updated dictionary.
	TmpFil [ix,hl=tmpfnm]		; make a temp file name
	IO.opn [stk=hl,stk=Text+WO+NewOnly]->[(outch)=a]+C
	jp	c,ioerr##

; Seed the initial "word from dictionary" to a null string.
	ld	hl,(wrdbuf)		; HL -> word buffer
	ld	(hl),0			; set it to a null string

; Loop over the words in the word list with the indicated flag.
; Register usage during loop:
;   IY -> next pointer in pointer list
	ld	iy,(ptrbot)
up1:
	inc	iy			; step to next word in pointer list
	inc	iy
	ld	l,(iy+0)
	ld	h,(iy+1)		; HL -> next word
	ld	a,(hl)			; see if it's the terminator
	cp	07Fh
	jr	z,up7			; branch when last word done
	ld	d,h			; save word address in DE
	ld	e,l
up2:					; find the word delimiter byte
	inc	hl
	bit	7,(hl)
	jr	z,up2			; HL -> terminator byte on loop exit
	ld	a,(flag)		; see if this word goes out
	and	(hl)
	jr	z,up1			; branch if it does not

; DE -> a word to be added to the dictionary
; HL -> word's flag bytes
; any replacement is at (HL+1)
; Synchronize: cycle through the dictionary to find the line before
;   which this word is to be placed.
	ld	(wrdst),de		; save word start position
	ld	(term),hl		; save word terminator position

; See if the current dictionary word has caught up to the word being added.
up3:
	WrdCmp [hl=(wrdbuf),de=(wrdst)]->[]+C+Z-a
	jr	nc,up5			; branch if dictionary has caught up

; Must write out the current dictionary word and get a new one.
; Only write it out if it's a not a dummy
	ld	a,(hl)			; A = first character of word
	and	a			; check for 0
	jr	z,up4
	WrdPut [a=(bufflg),hl,de=(linbuf)] ; write word to dictionary
up4:					; here to get a new word
	AuxWord [a=(inch),hl,de=(linbuf)]->[(bufflg)=a]+C
	jr	nc,up3			; branch on successful read
	ld	(hl),07Fh		; out of words, add a dummy
	jr	up3
up5:

; The current dictionary word is either equal to or greater than the word
; that we want to add to the dictionary.  If it's equal, discard the
; old one.
	jr	nz,up6			; branch if words aren't equal
	ld	(hl),0			; force dict word to dummy null
up6:

; Add our word.
	ld	hl,(term)		; HL -> flag byte for our word
	ld	a,(hl)			; A = flag byte
	inc	hl
	ex	de,hl			; DE -> replacement (if any)
	WrdPut [a,hl=(wrdst),de]	; add word to dictionary
	jr	up1			; go do next word

; Here when all of our words have been added to the dictionary.
; Continue cycling until the complete dictionary has been copied.
up7:
	ld	hl,(wrdbuf)		; see if dictionary is done
	ld	a,(hl)
	cp	07Fh
	jr	z,up10			; branch if it is
	ld	de,(linbuf)		; prepare to cycle
	and	a			; make sure current word isn't dummy
	jr	z,up9
up8:
	WrdPut [a=(bufflg),hl,de]	; put a word
up9:
	AuxWord [a=(inch),hl,de]->[(bufflg)=a]+C ; get next word
	jr	nc,up8			; loop till EOF
up10:

; Close the files, delete the old dictionary,
; and rename the new file to the dictionary.
	IO.cls [stk=(inch)]->[a,hl]+C	; close input file
	jp	c,ioerr##
	IO.cls [stk=(outch)]->[a,hl]+C	; close output file
	jp	c,ioerr##
	pop	hl			; HL -> input file name
	push	hl
	DUTdel [stk=hl]->[a]+C		; delete it
	jp	c,ioerr##
	ex	de,hl			; DE -> input file name
	ld	hl,tmpfnm		; HL -> temp file name
	DUTren [stk=hl,stk=de,stk=0]->[a]+C ; rename temp file
	jp	c,ioerr##

	pop	ix			; restore registers
	pop	iy
	pop	hl
	pop	de
	pop	bc
	pop	af

	end Update


; WrdPut procedure: put a word to the dictionary.
	proc WrdPut [FLAG:a,WORD:hl,REPL:de]
	begin
	push	af			; save registers
	push	bc
	push	de
	push	hl
	ld	c,a			; save FLAG in C

; Determine the length of the word (which may be terminated by a null
; or by a byte with parity set).
	ld	de,0			; count word length in DE
wp1:
	inc	hl			; step to next character
	inc	de			; count it
	bit	7,(hl)			; check for terminator
	jr	nz,wp2
	ld	a,(hl)			; could be null
	and	a
	jr	nz,wp1
wp2:					; here with word length in BC

; Write the word.
	pop	hl			; set HL -> word again
	push	hl
	IO.wri [stk=(outch),stk=hl,stk=de]->[a,hl]+C
	jp	c,ioerr##

; We have one of four cases:
;   word is good -- line is "word"
;   word is mispelled but there's no replacement -- line is "word!"
;   word is mispelled with a replacement -- line is "word!repl"
;   as above but auto-replace -- line is "word!!repl"
	bit	STrepl,c		; is there a replacement?
	jr	nz,wp3			; branch if so
	bit	STbad,c			; is word known to be bad?
	jr	z,wp5			; no, it's a good word
	LIOpc [stk=(outch),a='!']	; just finish with exclamation point
	jr	wp5			; done with this word
wp3:

; Word has a replacement.
	LIOpc [stk=(outch),a='!']	; indicate replacement coming
	ld	a,c			; see if it's auto-replace
	and	AUTOms
	cp	AUTOr
	jr	nz,wp4			; branch if not
	LIOpc [stk=(outch),a='!']	; add another exclamation point
wp4:
	pop	hl
	pop	de			; DE -> replacement
	push	de
	push	hl
	STRlng [hl=de]->[hl]		; get length of replacement
	IO.wri [stk=(outch),stk=de,stk=hl]->[a,hl]+C
	jp	c,ioerr##

; Here when done with word.
; Conclude with carriage return, line feed.
wp5:
	IO.wri [stk=(outch),stk=CRLF,stk=2]->[a,hl]+C
	jp	c,ioerr##

	pop	hl
	pop	de
	pop	bc
	pop	af

	end WrdPut


help:
    db 's	skip word',13,10
    db 'l	skip line',13,10
    db 'c	word is correct (ca, cj) [*]',13,10
    db 'r	use suggested replacement (ra, rj) [*]',13,10
    db 'r word	replace with "word"',13,10
    db 'rg word	replace with "word" from now on (rga, rgj) [*]',13,10
    db 'm	mark the word',13,10
    db 'm xxx	mark the word with "xxx"',13,10
    db 'mg	mark the word from now on',13,10
    db 'x	stop correcting words and exit',13,10
    db 13,10
    db '    [*]	"a" or "j" mean add to auxiliary or jargon dictionary',13,10
    db 13,10,0

wrdst:	dw	0		; -> start of word
wrdlen:	dw	0		; length of word
where:	dw	0		; -> word descriptor in pointer list
term:	dw	0		; -> word terminator (control bits)
arg:	dw	0		; explicit argument
repler:	dw	0		; replacement word ('r' or auto-replace)
marker:	dw	0		; mark string ('m' or auto-mark)
tmpf:	db	0		; temp file opened
aupd:	db	0		; nonzero means update aux dictionary
jupd:	db	0		; nonzero means update jargon dictionary
gopt:	db	0		; 'g' option
aopt:	db	0		; 'a' option
jopt:	db	0		; 'j' option
skipl:	db	0		; nonzero means skip rest of this line
skipf:	db	0		; nonzero means skip rest of this file
flag:	db	0		; FLAGMASK during Update
bufflg:	db	0		; flags from AuxWord
tmpfnm:	ds	FNPmfn+1	; temporary file name
