; rm.xm: file ReMoval unicum
; /AJK 15.Jul.81, 18.Jul.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'RM V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

	entry rm
rm:
	HEAhea [hl=0100h]	; initialize stack and heap
	USKini []		; scan command
	USKflg [hl=flgtbl]	; allow flags

; Loop for each file.
; Get a filename.
rm1:
	USKmnf [stk=(nflg),stk=(vflg)]->[hl=stk,bc=stk,de=stk]+C-a
				; HL -> file name
				; BC = attributes
				; DE = size
	jr	c,rm4		; branch when out of filenames to remove
	bit	0,c		; see if file is read/only
	jr	z,rm2		; branch if not, clear to delete

; Here for read/only file.
; If -f was specified, change it to read/write and delete it,
; otherwise give an error message.
	ld	a,(fflg)	; A is nonzero if -f specified
	and	a		; clear Z if -f was given
	ld	a,IoFRO		; load error code
	jr	z,rm3		; branch if no -f, give error message
	DUTslk [stk=hl,stk=0]->[a]+C ; try to make file read/write
	jr	c,rm3		; branch if it didn't work, give error message

; Delete the file.
rm2:
	DUTdel [stk=hl]->[a]+C	; once again: try to delete the file
	jr	nc,rm1		; branch if it worked

; Here if something blew, issue error message and skip file.
rm3:
	ld	(code),a	; save error code
	ERRMSG [a=a,b=1,c=0,hl=hl]
	jr	rm1		; skip to next file

; Here when done.
rm4:
	ld	a,(code)
	SHLexi [a=a]

; Flags
flgtbl:
	db 'f',0,0,0,0,0,0,0,0,0,0,0,0
fflg:	dw 0
	db 'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw 0
	db 'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw 0
	db 0

code:	db 0

	end rm
