; fid.xm: File IDentifcation unicum
; /AJK 18.Jun.81, 18.Jul.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'FID V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

BufLen	equ	8192		; input buffer size (must be even!)

	entry fid
fid:
	HEAhea [hl=0100h]	; initialize heap and stack
	USKall [hl=BufLen]->[(buffer)=hl]
	USKini []		; scan command line
	USKflg [hl=flgtbl]	; interpret flags
	USKdef [stk="-",stk=0]	; default is the usual filter act
	USKano []->[(ano)=a]	; guess at number of arguments

; Get the next filename and open it for binary input.
fid1:
	USKtnf [stk=(nflg),stk=(vflg)]->[(fname)=stk,de=stk,bc=stk]+C-a
	jp	c,fid9		; exit when files exhausted
	STRcmp [hl=(fname),de="-"]->[]+C+Z
	jr	nz,fid2		; branch if not standard input
	xor	a		; "-" causes read from standard input
	ld	(chno),a
	jr	fid3
fid2:
	IO.opn [stk=(fname),stk=Binary+RO+OldOnly]->[(chno)=a]+C
	jr	nc,fid3		; branch if successful open
	ld	(code),a	; remember error code
	ERRMSG [a=a,b=1,c=0,hl=(fname)]
	jr	fid1		; skip this file, go do another
fid3:				; here on successful open
	ld	hl,0		; initialize crc
	ld	(crcval),hl
fid4:				; loop for each bufferfull
	IO.rea [stk=(chno),stk=(buffer),stk=BufLen]->[a,hl]+C
	jr	nc,fid5		; branch if no I/O error
	ld	(code),a	; remember error code
	ERRMSG [a=a,b=1,c=0,hl=hl]
	jr	fid6		; finish with this file
fid5:				; here after successful read
	ld	a,h		; check EOF condition
	or	l
	jr	z,fid6		; branch when encountered
	ld	b,h		; copy buffer length into BC
	ld	c,l
	CRC [hl=(crcval),ix=(buffer),bc=bc]->[(crcval)=hl]
	jr	fid4
fid6:				; here on EOF or read error
	ld	a,(chno)	; don't close standard input
	and	a
	jr	z,fid7
	IO.cls [stk=(chno)]->[a,hl]+C
	jr	nc,fid7
	ld	(code),a	; remember error code
	ERRMSG [a=a,b=1,c=0,hl=hl]
fid7:
	ld	a,(ano)		; should we mention the file name?
	cp	2
	jr	c,fid8		; branch if not
	OPUTF [stk="%t: ",stk=(fname)]
fid8:
	OPUTF [stk="%a^m^j",stk=(crcval)]
	jp	fid1		; proceed to the next file
fid9:				; here when files all done
	ld	a,(code)
	SHLexi [a=a]

flgtbl:
	db 'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw 0
	db 'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw 0
	db 0

code:	db 0			; return code

ano:	ds	1		; argument number: 2 if multiple arguments
chno:	ds	1		; input channel
fname:	ds	2		; current filename string (pointer)
buffer:	ds	2		; -> input buffer
crcval:	ds	2		; file CRC

	end fid
