;********************************;
;     FILE PRINT UTILITY         ;
;********************************;

;********************************;
;VERSION 1.1
;ORIGINAL CODED BY JEFF KRAVITZ
;MODIFIED BY A. GOLD
;CONDITIONAL ASSEMBLY FOR <FF> HARDWARE AND
;OUTPUT TO CONSOLE OR CP/M LIST DEVICE
;10/15/77
;********************************;

;********************************;
;      MISCELLANEOUS EQUATES     ;
;********************************;


MAXLN	EQU	56	;LINES/PAGE
NULLS	EQU	12	;NULLS AFTER A FORM FEED

BOOT	EQU	0000H	;REBOOT ENTRY POINT
CPM	EQU	0005H	;CPM ENTRY POINT

TBUF	EQU	0080H	;TRANSIENT PROGRAM BUFFER 
TFCB	EQU	005CH	;TRANSIENT PROGRAM FCB

OPEN	EQU	15	;OPEN FUNCTION CODE
READ	EQU	20	;READ FUNCTION CODE

LINES	EQU	7	;LINES TO PAGE TOP
LF	EQU	0AH	;<LF>

FF	EQU	0CH	;<FF>
CR	EQU	0DH	;<CR>

TAB	EQU	09H	;<TAB>
SPACE	EQU	20H	;<SPACE>
RUBOUT	EQU	7FH	;USED AS FF NULL. MAY CAUSE PROBLEM
			;TO SOME PRINTERS

ODEV	EQU	5	;CON:=2  LST:=5
FORM	EQU	0H	;SET 0FFFFH FOR 0CH <FF>
			;SET 0 FOR <LF>'S TO PAGE TOP
;TO DEVICE THAT NEEDS LINE-FEEDS
;
;********************************;

;********************************;
;          MAIN LOOP             ;
;********************************;

	ORG	100H
	JMP	PRINT

;PUT A CLUE IN OBJECT
	DB	'/ PRINT UTILITY VERS. 1.1 /'
	IF FORM
	DB	' HARDWARE FF /'
	ENDIF
	IF	NOT FORM
	DB	' LF TO PAGE TOP /'
	ENDIF
	IF	NOT ODEV-5
	DB	' OUT TO LST: /'
	ENDIF
	IF	NOT ODEV-2
	DB	' OUT TO CON: /'
	ENDIF

PRINT:	LXI	SP,STACK
	LXI	D,TFCB	;POINT TO FCB
	CALL	FOPEN	;OPEN FILE
	JC	ERR	;IF ERROR, EXIT
;
	IF	FORM	;DO <FF> IF HARDWARE
	CALL	TOF	;PRINT HEADING
	ENDIF
;
	IF 	NOT FORM;IF NO HARDWARE, ASSUME THERE
	CALL TOF3
	ENDIF
;

LOOP:	CALL	GETBT	;GET A BYTE
	JC	ERR	;ERROR
	CPI	1AH	;EOF?
	JZ	DONE	;YES
	CPI	CR	;CR?
	JZ	CRET	;YES
	CPI	LF	;LF?
	JZ	LFEED	;YES
	CPI	TAB	;TAB?
	JZ	TABMOV	;YES
	CPI	SPACE	;ODD CONTROL CHR?
	JNC	LOOPX	;NO, PRINT CHR.
	JMP	LOOP	;YES, DROP IT

TABMOV:	LXI	H,COL	;POINT TO COLUMN
TBLP:	MVI	A,SPACE	;PRINT ONE SPACE
	CALL	PBYT
	MOV	A,M	;GET COLUMN
	ANI	07H	;MODULO 8
	JNZ	TBLP	;IF NOT AT TAB STOP, KEEP TYPEIN
	JMP	LOOP
LOOPX:	CALL	PBYT	;PRINT BYTE
	JMP	LOOP

CRET:	XRA	A
	STA	COL
	MVI	A,CR
	JMP	LOOPX

LFEED:	LDA	LINE	;GET LINE COUNT
	CPI	MAXLN	;PAGE OVERFLOW?
	JZ	NEWPG	;YES
	INR	A	;BUMP LINE COUNT
	STA	LINE
	MVI	A,LF
	JMP	LOOPX	;CONTINUE

NEWPG:	MVI	A,CR
	CALL	PBYT	;PRINT CR
	CALL	TOF
	JMP	LOOP
;
;
	IF	FORM	;ROUTINE TO FORM FEED WITH 0CH
TOF:	MVI	A,FF	;FORM FEED
	CALL	PBYT
	MVI	B,NULLS	;NUMBER OF RUBOUTS
TOF2:	MVI	A,RUBOUT
	CALL	PBYT
	DCR	B	;DCREMENT COUNT
	JNZ	TOF2	;PRINT 'N' RUBOUTS
	ENDIF
;
;
	IF	NOT FORM;ROUTINE TO PAGE TOP WITH <LF>'S
TOF:	MVI	B,LINES	;NUMBER OF LINES
TOF2:	MVI	A,LF	;<LF>
	CALL	PBYT
	DCR	B	;DCREMENT COUNT
	JNZ	TOF2	;PRINT 'N' <LF>'S
	ENDIF
;
;
TOF3:	LXI	H,FMSG	;POINT TO MESSAGE
	CALL	PSTRNG	;PRINT STRING
	LXI	H,TFCB+1;POINT TO NAME
	MVI	B,8	;SIZE OF NAME
	CALL	PCNT	;PRINT COUNT
	MVI	A,SPACE	;PRINT A SPACE
	CALL	PBYT
	LXI	H,TFCB+9;POINT TO TYPE
	MVI	B,03	;SIZE OF TYPE
	CALL	PCNT	;PRINT COUNT
	LXI	H,PMSG	;POINT TO MESSAGE
	CALL	PSTRNG	;PRINT STRING
	LDA	PAGE	;GET PAGE NUMBER
	INR	A	;BUMP IT
	STA	PAGE	;SAVE IT
	CALL	DEC	;CONVERT TO DECIMAL
	LXI	H,DECWRK;POINT TO DEC STRING
	MVI	B,3
	CALL	PCNT	;PRINT PAGE NUMBER
	MVI	A,CR	;PRINT CR
	CALL	PBYT
	MVI	A,LF
	CALL	PBYT	;PRINT LF
	MVI	A,LF
	CALL	PBYT	;AND SECOND
	MVI	A,LF
	CALL	PBYT	;AND A THIRD
	XRA	A
	STA	LINE	;RESET LINE COUNT
	STA	COL	;RESET COLUMN
	RET

PBYT:	PUSH	H
	PUSH	B
	PUSH	PSW
	MOV	E,A
	MVI	C,ODEV
	CALL	CPM	;PRINT
	POP	PSW
	CPI	SPACE	;NON-PRINTING?
	JC	PBY2	;YES, DONT BUMP COL
	LXI	H,COL	;INCREMENT COLUMN
	INR	M
PBY2:	MVI	C,11	;GET CONSOLE STATUS
	CALL	CPM
	CPI	00	;BREAK?
	JNZ	BOOT	;YES, DONE
	POP	B
	POP	H
	RET
PSTRNG:	MOV	A,M	;GET BYTE
	CPI	'$'	;STRING END?
	RZ		;YES, DONE
	CALL	PBYT	;PRINT BYTE
	INX	H	;BUMP POINTER
	JMP	PSTRNG	;LOOP

PCNT:	MOV	A,M	;GET BYTE
	CALL	PBYT	;PRINT IT
	INX	H	;BUMP POINTER
	DCR	B	;DECREMENT COUNT
	JNZ	PCNT
	RET

DEC:	LXI	H,DECWRK
	MVI	C,100
	CALL	DIGIT
	MVI	C,10
	CALL	DIGIT
	MVI	C,1
	CALL	DIGIT
	RET

DIGIT:	MVI	M,'0'
DI0:	SUB	C
	JM	DI1
	INR	M
	JMP	DI0
DI1:	ADD	C
	INX	H
	RET


	IF	FORM
DONE:	MVI	A,FF	;FORM FEED
	CALL	PBYT
	MVI	B,NULLS	;RUBOUT COUNT
DLP2:	MVI	A,RUBOUT
	CALL	PBYT
	DCR	B
	JNZ	DLP2
	ENDIF
;
	IF	NOT FORM
DONE:	LXI	H,LINE	;POINT TO CURRENT LINE
	MVI	A,MAXLN
	SUB	M	;LINES LEFT TO PRINT
	ADI	LINES	;PLUS LINE TO PAGE TOP
	MOV	B,A
DLP2:	MVI	A,LF	;<LF>
	CALL	PBYT
	DCR	B	;DCREMENT COUNT
	JNZ	DLP2	;PRINT 'N' LINES TO PAGE TOP
	ENDIF
;
	JMP	BOOT	;EXIT

ERR:	LXI	D,ERMSG
	MVI	C,09H	;WRITE MSG
	CALL	CPM
	JMP	BOOT

 
;********************************;
;           F O P E N            ;
;  ROUTINE TO OPEN A DISK FILE   ;
;                                ;
;  INPUT:     DE=A(FCB)          ;
; OUTPUT:     CARRY=ERROR        ;
;********************************;

FOPEN:	MVI	C,OPEN	;OPEN CODE
	CALL	CPM	;ISSUE OPEN
	CPI	0FFH	;ERROR?
	JZ	FOERR	;YES
	XRA	A	;CLEAR CARRY
	RET
FOERR:	STC
	RET


;********************************;
;            G E T B T           ;
;   ROUTINE TO READ A BYTE       ;
;                                ;
;  OUTPUTS:     A=BYTE           ;
;               CARRY=ERROR      ;
;********************************;

GETBT:	LXI	H,TBUF+128
	XCHG		;BUFFER END ADDR. IN DE
	LHLD	INPTR	;CURRENT POINTER IN HL
	CALL	CPHL	;TEST FOR END OF BUFFER
	JZ	GETB2	;YES, READ
GETB1:	MOV	A,M	;GET BYTE
	INX	H	;BUMP POINTER
	SHLD	INPTR	;SAVE POINTER
	ORA	A	;RESET CARRY
	RET
GETB2:	MVI	C,READ	;READ CODE
	LXI	D,TFCB	;FCB ADDRESS
	CALL	CPM	;ISSUE READ
	CPI	00	;ERROR?
	JNZ	IERR	;YES
	LXI	H,TBUF	;RESET BUFFER POINTER
	SHLD	INPTR
	JMP	GETB1	;CONTINUE
IERR:	STC
	RET

;********************************;
;   MISCELLANEOUS SUBROUTINES    ;
;********************************;

;********************************;
;             C P H L            ;
;  ROUTINE TO COMPARE HL VS DE   ;
;********************************;

CPHL:	MOV	A,H
	CMP	D
	RNZ
	MOV	A,L
	CMP	E
	RET

;********************************;
;             D A T A            ;
;********************************;

COL:	DB	0	;COLUMN COUNTER
LINE:	DB	0	;LINE COUNTER
PAGE:	DB	0	;PAGE COUNTER

FMSG:	DB	CR,'FILE: $'
PMSG:	DB	'                 PAGE $'
ERMSG:	DB	'ERROR',0DH,0AH,'$'
	DS	32
STACK	EQU	$
INPTR:	DW	TBUF+128;INPUT POINTER
DECWRK:	DB	'000'
	END	PRINT
