	TITLE	'CCS DISK COPY PROGRAM V1.0'
	PAGE	56
WBOOTV:	EQU	0
BDOSV:	EQU	5
;
TRUE:	EQU	0FFFFH
FALSE:	EQU	NOT TRUE
;
MINI:	EQU	TRUE
MAXI:	EQU	TRUE	;CONDITIONAL FLAG FOR 8" DRIVE SUPPORT
BOTH:	EQU	MINI AND MAXI
;
;
DSTAT	EQU	30H	;DISK STATUS PORT
DCMMD	EQU	DSTAT	;DISK COMMAND PORT
DTRCK	EQU	DSTAT+1	;DISK TRACK PORT
DSCTR	EQU	DSTAT+2	;DISK SECTOR PORT
DDATA	EQU	DSTAT+3	;DISK DATA PORT
DFLAG	EQU	DSTAT+4	;DISK FLAF PORT
DCTRL	EQU	DSTAT+4	;DISK CONTROL PORT
BCTRL:	EQU	4	;DISK STATUS 2 PORT
;
RSTR:	EQU	8	;BASIS OF RESTORE COMMAND
SEEKV:	EQU	1CH	;BASIS OF SEEK COMMAND
STEPI:	EQU	58H	;BASIS OF STEP IN COMMAND
RDSEC:	EQU	88H	;BASIS OF READ SECTOR COMMAND
WRSEC:	EQU	0A8H	;WRITE SECTOR COMMAND
RDADD:	EQU	0C4H	;READ ADDRESS COMMAND
WRTRK:	EQU	0F4H	;WRITE TRACK COMMAND
FICMD:	EQU	0D0H	;FORCE INTERRUPT COMMAND
;
; STEP RATES MAY BE TAILORED TO MEET INDIVIDUAL DRIVE REQUIREMENTS.
;   TO DO SO, DETERMINE THE PROPER TRACK-TO-TRACK STEP RATES FROM
;   YOUR DISK DRIVE'S TECHNICAL MANUAL, AND SET THE STEP5 (FOR MINI
;   DRIVES) AND/OR STEP8 (FOR 8" DRIVES) TO THE VALUE SHOWN IN
;   THE FOLLOWING TABLE:
;
;	VALUE		MINI DISKS	8" DISKS
;	  0		  6 MS		  3 MS
;	  1		 12 MS		  6 MS
;	  2		 20 MS		 10 MS
;	  3		 30 MS		 15 MS
;
STEP5:	EQU	3	;MINI DISK STEP RATE
STEP8:	EQU	1	;8" DISK STEP RATE
;
	IF	MINI
HLWAIT:	EQU	3000H	;HEAD LOAD WAIT FOR MINI DRIVES
	ENDIF
	IF	NOT MINI
HLWAIT:	EQU	1600H	;HEAD LOAD WAIT FOR 8" DRIVES
	ENDIF
;
TRIES:	EQU	10	;NUMBER OF ATTEMPTS
;
;
CTRLC:	EQU	3	;ASCII ETX
BELL:	EQU	7	;ASCII BELL CHARACTER
CR:	EQU	0DH	;ASCII CARRIAGE RETURN
LF:	EQU	0AH	;ASCII LINE FEED
UCMSK:	EQU	0DFH
;
DISKNO:	EQU	40H	;ACTIVE DISK NUMBER
TRACK:	EQU	DISKNO+1
SECTOR:	EQU	TRACK+1
SIDE:	EQU	SECTOR+1  ;SIDE SELECT HOLD AREA
SPT:	EQU	SIDE+1	;SECTORS PER TRACK HOLD
TWOSID:	EQU	SPT+1	;SINGLE/DOUBLE SIDED SWITCH HOLD
STPRAT:	EQU	46H	;STEP RATE SAVE AREA
STATUS:	EQU	47H
CMND:	EQU	STATUS+1
LUNIT:	EQU	49H	;LAST USED DRIVE
CUNIT:	EQU	LUNIT+1	;CURRENT DRIVE
RWFLG:	EQU	4BH
DMAAD:	EQU	4CH	;HOST BUFFER ADDRESS
IDSV:	EQU	4EH	;SECTOR ID SAVE AREA
TBUF:	EQU	80H
TPA:	EQU	100H
;
	ORG	TPA	;ORIGIN OF THIS PROGRAM
;
COPY:	LXI	SP,STACK	;SET STACK TO KNOWN VALUE
	LXI	D,LOGMSG	;LOG ON TO THE SYSTEM
COPY0:	CALL	PMSG1
COPY1:	LXI	D,CRMSG
	CALL	PMSG
	LXI	D,SMSG	;ASK FOR SOURCE DRIVE
	CALL	DSKS0
	MOV	A,B	;SAVE THE SOURCE SELECT BITS
	STA	SSELBIT
	MOV	A,C	;SAVE THE STEP RATE
	STA	STPRAT
	MOV	A,D
	STA	ASDRV	;SAVE THE ASCII SOURCE SELECTION
	XRA	A
	STA	TRACK	;SET THE INITIAL TRACK NUMBER
	MVI	A,'0'
	STA	ATRKNO
	STA	ATRKNO+1
	LXI	D,DMSG	;ASK FOR DESTINATION
	CALL	DSKS0
	MOV	A,D	;SAVE THE ASCII SELECTION
	STA	ADDRV
	MOV	A,B	;SAVE THE DESTINATION SELECT BITS
	STA	DSELBIT
	ANI	10H	;SEE IF DRIVE TYPES MATCH
	MOV	B,A
	LDA	SSELBIT
	ANI	10H
	XRA	B
	JZ	COPY2	;JUMP IF OK
	LXI	D,INVMSG
	CALL	PMSG1
	LXI	D,COMBMSG
	CALL	PMSG
	JMP	COPY1
;
COPY2:	CALL	IDRD	;DETERMINE FORMAT OF SOURCE
	LXI	D,BSCMSG
	JC	COPY0	;JUMP IF UNABLE TO READ
	LDA	TRACK	;SEE IF ON TRACK 0
	ORA	A
	JNZ	COPY4	;JUMP IF NOT
	MVI	A,77	;ELSE, SET UP NUMBER OF TRACKS, ETC
	STA	NTRKS	;SAVE IT
	IN	BCTRL	;SEE IF DOUBLE SIDED DRIVE
	ANI	40H	;ISOLATE THE DS BIT
	XRI	40H	;FLIP IT
	STA	TWOSID
	LDA	SSELBIT
	ANI	10H	;SEE IF MINI
	JNZ	COPY3	;JUMP IF NOT
	LXI	D,SD2MSG	;ASK IF DOUBLE SIDED
	CALL	PMSG1
	CALL	GCHAR	;GET ANSWER
	ANI	UCMSK
	CPI	'Y'
	MVI	A,0
	JNZ	COPY2D
	MVI	A,40H	;SET DOUBLE SIDED FLAG
COPY2D:	STA	TWOSID
	MVI	A,35	;SET MINI DEFAULT
	STA	NTRKS
	LXI	D,MTKMSG	;ASK FOR # OF MINI TRACKS
COPY2C:	CALL	PMSG1
	MVI	B,0
COPY2B:	PUSH	B
	CALL	GCHAR	;GET FIRST DIGIT
	POP	B
	CPI	CR
	JZ	COPY3	;SELECT THE DEFAULT
	SUI	'0'	;UNBIAS THE VALUE
	JC	COPY2A	;JUMP IF BAD NUMBER
	CPI	10
	JNC	COPY2A	;JUMP IF BAD NUMBER
	ADD	B	;ACCUMULATE THE VALUE
	MOV	B,A
	STA	NTRKS
	ADD	A
	ADD	A
	ADD	B
	ADD	A
	MOV	B,A
	JMP	COPY2B	;GO FINISH CURRENT DIGIT
;
COPY2A:	LXI	D,BADMSG
	JMP	COPY2C
;
COPY3:	LXI	D,CAUTION
	CALL	PMSG1
	CALL	GCHAR
	PUSH	PSW
	LXI	D,CRMSG
	CALL	PMSG
	POP	PSW
	ANI	UCMSK
	CPI	'Y'
	JNZ	COPY1
COPY4:	LXI	D,SPT8
	LXI	B,T8S	;SET FOR MAXI DRIVES
	LDA	SSELBIT
	ANI	10H	;SEE IF MINI SELECTED
	JNZ	COPY4A
	LXI	B,T5S	;SET FOR MINI DRIVES
	LXI	D,SPT5	;ELSE SET MINI TABLE
COPY4A:	LDA	SSELBIT
	CPI	40H	;SEE IF DOUBLE DENSITY
	LXI	H,0
	JC	COPY5	;JUMP IF SINGLE DENSITY
	LXI	H,T8D-T8S
	DCX	D
COPY5:	DAD	B	;SET TRACK TABLE
	LXI	B,9
	DAD	B	;OFFSET TO SECTOR ENTRIES
	SHLD	TBLADD
	LDA	IDSV+3	;GET THE SECTOR SIZE
	LXI	H,10H	;BASE VALUE FOR BYTES/SECTOR
	INR	A
COPY6:	DAD	H	;BUILD SECTOR BYTE COUNT
	INX	D	;AND POINT TO SECTORS PER TRACK
	DCR	A
	JNZ	COPY6
	SHLD	BYTCNT	;SAVE VALUES
	LDAX	D
	STA	SPT
COPY8:	XRA	A	;SET UP FOR SIDE 0
	STA	SIDE
	LXI	D,CPYMSG
	CALL	PMSG
	MVI	A,0D0H
COPY9:	OUT	BCTRL	;SELECT THE SIDE
	MVI	A,1
	STA	SECTOR
	LXI	H,BUFIN
	SHLD	DMAAD
COPY10:	CALL	DREAD	;READ A SECTOR
	PUSH	H
	CNZ	RDERR	;JUMP IF ERROR
	POP	H
	SHLD	DMAAD
	LXI	H,SECTOR
	INR	M
	LDA	SPT
	CMP	M
	JP	COPY10
	LDA	DSELBIT
	OUT	DCTRL	;GIVE HEADS TIME TO SETTLE
	LHLD	TBLADD	;GET TABLE ADDRESS
	LXI	D,OFFSET+1  ;AND OFFSET TO START OF TABLE
	DAD	D
	MOV	E,M	;GET BUFFER LENGTH
	INX	H
	MOV	D,M
	XCHG
	SHLD	BUFLEN
	XCHG
	MVI	B,4
	LXI	D,TRKBUF  ;POINT TO START OF BUFFER
	CALL	XPND	;EXPAND THE TRACK LEADER
	LDA	SPT	;PREPARE FOR SECTOR LOOP
	MOV	C,A
	MVI	A,1	;RESET SECTOR POINTER
	STA	SECTOR
COPY11:	PUSH	B	;SAVE SECTOR LOOP CONTROL
	LHLD	TBLADD	;POINT TO SECTOR GAP TABLE
	MVI	B,4	;EXPAND FIRST 4 ENTRIES
	CALL	XPND
	LDA	TRACK	;SET THE TRACK
	STAX	D
	INX	D
	LDA	SIDE	;SET THE SIDE INDICATOR
	STAX	D
	INX	D
	LDA	SECTOR	;SET THE SECTOR
	STAX	D
	INX	D
	LDA	IDSV+3	;SET THE SECTOR SIZE
	STAX	D
	INX	D
	MVI	B,5	;EXPAND THE NEXT 5 ENTRIES
	CALL	XPND
	LDA	BYTCNT	;GET THE NUMBER OF SECTOR BYTES
	MOV	B,A
	MVI	A,0E5H	;DATA FILL
COPY12:	MVI	C,4
COPY13:	STAX	D
	INX	D
	DCR	C
	JNZ	COPY13
	DCR	B
	JNZ	COPY12
	MVI	B,2	;EXPAND LAST 2 ENTRIES
	CALL	XPND
	POP	B
	LDA	SECTOR
	INR	A
	STA	SECTOR
	DCR	C
	JNZ	COPY11	;DO REST OF SECTORS
	PUSH	D	;SAVE BUFFER POINTER
	MOV	A,D	;INVERT IT
	CMA
	MOV	B,A
	MOV	A,E
	CMA
	MOV	C,A
	INX	B	;MAKE TWO'S COMPLIMENT
	LXI	D,TRKBUF  ;GET START ADDRESS OF BUFFER
	LHLD	BUFLEN	;GET LENGTH OF BUFFER
	DAD	D	;FIND END OF BUFFER
	DAD	B	;FIND BYTES REMAINING TO FILL
	POP	D	;REGET BUFFER POINTER
	DCX	D
	LDAX	D	;GET THE FILL CHARACTER
	INX	D
	INR	H
COPY14:	STAX	D	;PUT DOWN THE FILL
	INX	D
	DCR	L
	JNZ	COPY14
	DCR	H
	JNZ	COPY14
	CALL	WTRAK	;WRITE THE TRACK
	CNZ	WRERR
	MVI	A,1
	STA	SECTOR
	LXI	H,BUFIN
	SHLD	DMAAD
COPY14A:  CALL	DWRITE
	PUSH	H
	CNZ	WRERR
	POP	H
	SHLD	DMAAD
	LXI	H,SECTOR
	INR	M
	LDA	SPT
	CMP	M
	JP	COPY14A
	LDA	TWOSID	;SEE IF DOUBLE SIDED DRIVE
	ORA	A
	JZ	COPY15	;JUMP IF NOT
	LDA	SIDE	;ELSE, CHECK SIDE
	ORA	A
	JNZ	COPY15	;JUMP IF READY FOR NEXT TRACK
	INR	A	;SET SIDE 1 INDICATOR
	STA	SIDE
	MVI	A,90H	;AND SIDE SELECT BITS
	JMP	COPY9
;
WRERR:	LXI	D,WERMSG
	ANI	40H
	JZ	WRERR1
	LXI	D,WPMSG
WRERR1:	CALL	PMSG1
	CALL	GCHAR
	PUSH	PSW
	LXI	D,CRMSG
	CALL	PMSG
	POP	PSW
	ANI	UCMSK
	CPI	'Y'
	RZ
	POP	H
	POP	H
	JMP	COPY1
;
COPY15:	LDA	NTRKS	;SEE IF DONE
	MOV	B,A
	LXI	H,ATRKNO+1
	INR	M
	MVI	A,'9'+1
	CMP	M
	JNZ	COPY16
	MVI	M,'0'
	DCX	H
	INR	M
COPY16:	LDA	TRACK
	INR	A
	MOV	C,A
	STA	TRACK
	CMP	B
	JZ	COPY1	;JUMP IF DONE WITH THIS COPY
	MVI	B,STEPI	;GET STEP IN COMMAND
	CALL	EOJA
	LDA	SSELBIT
	OUT	DCTRL
	LXI	H,1000H	;INJECT A LITTLE TIME DELAY
COPY17:	DCX	H
	MOV	A,H
	ORA	L
	JNZ	COPY17
	CALL	EOJA	;STEP IN THE SOURCE DRIVE
	MOV	A,C	;SEE IF ON SYSTEM TRACKS
	CPI	4
	JNC	COPY8
	JMP	COPY2	;REREAD ID FOR SYSTEM TRACKS
;
RDERR:	LXI	D,BSMSG
	JMP	WRERR1
;
XPND:	INX	H	;POINT TO NEXT ENTRY
	MOV	C,M	;GET IT
	INX	H	;POINT TO NEXT ENTRY
	MOV	A,M	;GET IT ALSO
XPND1:	STAX	D	;PUT INTO BUFFER
	INX	D
	DCR	C
	JNZ	XPND1
	DCR	B	;SEE IF MORE ENTRIES TO PROCESS
	JNZ	XPND	;JUMP IF SO
	RET
;
DSKS0:	CALL	PMSG1	;OUTPUT THE MESSAGE
DSKSEL:	LXI	D,DRVMSG
	CALL	PMSG	;OUTPUT THE COMMON MESSAGE
	CALL	GCHAR	;GET THE SELECTED DRIVE
	CPI	CTRLC
	JZ	WBOOTV	;ABORT IF CONTROL C
	ANI	UCMSK
	STA	DNRMSGA
	SUI	'A'
	JC	DSKS1
	CPI	4
	JC	DSKS2
DSKS1:	LXI	D,INVMSG
	CALL	PMSG1
	JMP	DSKSEL
;
DSKS2:	MOV	B,A
	XRA	A	;CLEAR THE A REGISGER
	STC
DSKS3:	RAL
	DCR	B
	JP	DSKS3
	ORI	20H
	MOV	B,A
	OUT	DCTRL
	MVI	A,0BH
	CALL	EOJC
	LDA	DNRMSGA	;GET ASCII DRIVE SELECT
	MOV	D,A	;RETURN IN A REGISTER
	IN	BCTRL
	RAR
	MVI	C,STEP5
	RNC
	MVI	C,STEP8
	MVI	A,10H
	ORA	B
	MOV	B,A
	RET
;
; BDOS INTERFACE ROUTINES
;
PCHAR:	MOV	E,A
	MVI	C,2
	JMP	BDOSV
;
GCHAR:	MVI	C,1
	JMP	BDOSV
;
PMSG1:	PUSH	D
	LXI	D,CRMSG
	CALL	PMSG
	POP	D
PMSG:	MVI	C,9
	JMP	BDOSV
;
;INDIVIDUAL SUBROUTINES TO PERFORM EACH FUNCTION
;
DREAD:	MVI	D,TRIES
	LDA	ASDRV	;GET ASCII DRIVE INDICATOR
	STA	DISKNO
	LDA	TRACK
	OUT	DTRCK
DREAD1:	LDA	BYTCNT
	MOV	B,A
	LDA	SECTOR
	OUT	DSCTR
	LDA	SSELBIT	;GET THE SELECT BITS
	ORI	80H	;SET THE AUTO-WAIT BIT
	OUT	DCTRL
	LHLD	DMAAD	;GET THE TRANSFER ADDRESS
	MVI	A,RDSEC	;GET THE READ SECTORS COMMAND
	STA	CMND
	DI
	OUT	DCMMD	;DISK COMMAND PORT
READ1:	IN	DDATA	;READ THE DATA
	MOV	M,A	;PUT INTO BUFFER
	INX	H	;INCREMENT MEMORY POINTER
	IN	DDATA	;READ THE DATA
	MOV	M,A	;PUT INTO BUFFER
	INX	H	;INCREMENT MEMORY POINTER
	IN	DDATA	;READ THE DATA
	MOV	M,A	;PUT INTO BUFFER
	INX	H	;INCREMENT MEMORY POINTER
	IN	DDATA	;READ THE DATA
	MOV	M,A	;PUT INTO BUFFER
	INX	H	;INCREMENT MEMORY POINTER
	DCR	B
	JNZ	READ1
	CALL	EOJ
	ANI	9CH	;ISOLATE READ ERROR BITS
	RZ
	DCR	D
	JNZ	DREAD1
	ORA	A
	RET
;
DWRITE:	MVI	D,TRIES
	LDA	ADDRV	;GET ASCII DRIVE INDICATOR
	STA	DISKNO
	LDA	TRACK
	OUT	DTRCK
DWRITE1:  LDA	BYTCNT
	MOV	B,A
	LDA	SECTOR
	OUT	DSCTR
	LDA	DSELBIT	;GET THE SELECT BITS
	ORI	80H	;SET THE AUTO-WAIT BIT
	OUT	DCTRL
	LHLD	DMAAD	;GET THE TRANSFER ADDRESS
	MVI	A,WRSEC	;GET THE WRITE SECTOR COMMAND
	STA	CMND
	DI
	OUT	DCMMD	;DISK COMMAND PORT
WRITE1:	MOV	A,M	;GET DATA FROM BUFFER
	OUT	DDATA	;OUTPUT IT
	INX	H	;ADVANCE MEMORY POINTER
	MOV	A,M	;GET DATA FROM BUFFER
	OUT	DDATA	;OUTPUT IT
	INX	H	;ADVANCE MEMORY POINTER
	MOV	A,M	;GET DATA FROM BUFFER
	OUT	DDATA	;OUTPUT IT
	INX	H	;ADVANCE MEMORY POINTER
	MOV	A,M	;GET DATA FROM BUFFER
	OUT	DDATA	;OUTPUT IT
	INX	H	;ADVANCE MEMORY POINTER
	DCR	B
	JNZ	WRITE1
	CALL	EOJ
	RZ
	DCR	D
	JNZ	DWRITE1
	ORA	A
	RET
;
WTRAK:	LHLD	BUFLEN
	MOV	B,H
	MOV	C,L
	MVI	D,TRIES
	LDA	ADDRV	;GET ASCII DRIVE SELECT
	STA	DISKNO
WTRAK1:	LDA	DSELBIT
	ORI	80H
	OUT	DCTRL
	LXI	H,TRKBUF
	MVI	A,WRTRK
	STA	CMND
	DI
	OUT	DCMMD	;DISK COMMAND PORT
WRT1:	MOV	A,M	;GET DATA FROM BUFFER
	OUT	DDATA	;OUTPUT IT
	INX	H	;ADVANCE MEMORY POINTER
	MOV	A,M	;GET DATA FROM BUFFER
	OUT	DDATA	;OUTPUT IT
	INX	H	;ADVANCE MEMORY POINTER
	MOV	A,M	;GET DATA FROM BUFFER
	OUT	DDATA	;OUTPUT IT
	INX	H	;ADVANCE MEMORY POINTER
	MOV	A,M	;GET DATA FROM BUFFER
	OUT	DDATA	;OUTPUT IT
	INX	H	;ADVANCE MEMORY POINTER
	DCR	C	;INNER LOOP CONTROL
	JNZ	WRT1
	DCR	B
	JNZ	WRT1
	CALL	EOJ
	RZ
	DCR	D	;SEE IF TRIES LEFT
	JNZ	WTRAK1
	ORA	A	;REGET THE FLAGS
	RET
;
EOJB:	MVI	B,RSTR	;BASIS OF RESTORE COMMAND
EOJA:	LDA	STPRAT
	ORA	B	;ADD ON THE COMMAND
EOJC:	STA	CMND
	OUT	DCMMD	;DO THE COMMAND
EOJ:	EI
	IN	DFLAG	;DISK FLAG PORT
	RAR
	JNC	EOJ
EOJ1:	IN	DSTAT	;GET THE DISK STATUS
	STA	STATUS
	ANI	0FCH
	IF	MAXI
	RP		;DONE IF DRIVE IS READY
	LDA	DISKNO	;GET DRIVE NUMBER
	STA	DNRMSGA	;PUT IT INTO MESSAGE
	PUSH	H	;SAVE (H,L)
	PUSH	D
	PUSH	B
	LXI	D,DNRMSG
	CALL	PMSG1	;PRINT THE MESSAGE
	CALL	GCHAR
	CPI	CTRLC
	JZ	WBOOTV
	POP	B
	POP	D
	POP	H	;RESTORE (H,L)
	JMP	EOJ1	;  AND TRY AGAIN
	ENDIF
	IF	NOT MAXI
	RET
	ENDIF
;
;
IDRD:	MVI	C,2	;TWO TRIES IS ENOUGH
IDRD1:	LDA	SSELBIT
	ORI	80H	;SET THE AUTO-WAIT BIT
	OUT	DCTRL
	LDA	ASDRV
	STA	DISKNO
	MVI	A,0D0H	;SELECT SIDE 0
	OUT	BCTRL
	PUSH	H	;SAVE POINTER
	LXI	H,IDSV	;SET UP TO READ ADDRESS
	MVI	B,2	;SET UP TO READ 6 BYTES OF DATA
	MVI	A,RDADD	;READ ADDRESS COMMAND
	DI
	STA	CMND
	OUT	DCMMD	;START THE READ ADDRESS
IDRD4:	IN	DDATA	;GET A BYTE
	MOV	M,A	;STORE IT
	INX	H
	IN	DDATA	;GET A BYTE
	MOV	M,A	;STORE IT
	INX	H
	IN	DDATA	;GET A BYTE
	MOV	M,A	;STORE IT
	INX	H
	DCR	B	;LOOP CONTROL
	JNZ	IDRD4
	CALL	EOJ
	ANI	9CH
	POP	H	;RESTORE POINTER
	RZ		;RETURN IF GOOD READ
	DCR	C
	JZ	IDRD3	;TAKE THE ERROR
	LDA	SSELBIT
	XRI	40H	;ELSE, TRY OTHER DEN
	STA	SSELBIT
	LDA	DSELBIT
	XRI	40H
	STA	DSELBIT
	JMP	IDRD1
;
IDRD3:	ORA	A
	RET		;ERROR EXIT
;
T8S:	DW	5450
	DB	20,0FFH
	DB	20,0FFH
	DB	6,0
	DB	1,0FCH
OFFSET:	EQU	T8S-$
	DB	26,0FFH
	DB	3,0
	DB	3,0
	DB	1,0FEH
	DB	1,0F7H
	DB	11,0FFH
	DB	3,0
	DB	3,0
	DB	1,0FBH
	DB	1,0F7H
	DB	1,0FFH
T8D:	DW	10800
	DB	80,04EH
	DB	12,0
	DB	3,0F6H
	DB	1,0FCH
	DB	50,4EH
	DB	12,0
	DB	3,0F5H
	DB	1,0FEH
	DB	1,0F7H
	DB	22,4EH
	DB	12,0
	DB	3,0F5H
	DB	1,0FBH
	DB	1,0F7H
	DB	4,4EH
T5S:	DW	3400
	DB	2,0FFH
	DB	2,0FFH
	DB	1,0FFH
	DB	1,0FFH
	DB	10,0FFH
	DB	3,0
	DB	3,0
	DB	1,0FEH
	DB	1,0F7H
	DB	11,0FFH
	DB	3,0
	DB	3,0
	DB	1,0FBH
	DB	1,0F7H
	DB	1,0FFH
T5D:	DW	6600
	DB	3,4EH
	DB	3,4EH
	DB	3,4EH
	DB	3,4EH
	DB	20,4EH
	DB	12,0
	DB	3,0F5H
	DB	1,0FEH
	DB	1,0F7H
	DB	22,4EH
	DB	12,0
	DB	3,0F5H
	DB	1,0FBH
	DB	1,0F7H
	DB	2,4EH
;
SPT8:	DB	48
	DB	26
	DB	15
	DB	8
	DB	4
;
SPT5:	DB	30
	DB	18
	DB	10
	DB	5
	DB	2
;
LOGMSG:	DB	'CCS DISK COPY PROGRAM VERS 1.0$'
SMSG:	DB	'SOURCE$'
DMSG:	DB	'DESTINATION$'
DRVMSG:	DB	' DRIVE (OR CONTROL C TO ABORT)  $'
INVMSG:	DB	'INVALID DRIVE$'
MTKMSG:	DB	'MINI DRIVES WILL DEFAULT TO 35 TRACKS.',CR,LF
	DB	'IF THIS IS O.K., TYPE A CARRIAGE RETURN.  OTHERWISE,',CR,LF
	DB	'ENTER THE NUMBER OF TRACKS:  $'
WERMSG:	DB	'WRITE ERROR- IGNORE?  $'
WPMSG:	DB	'DRIVE IS WRITE PROTECTED- TYPE CR TO CONTINUE$'
COMBMSG: DB	' COMBINATION$'
CPYMSG:	DB	CR,'COPYING TRACK '
ATRKNO:	DB	'00$'
CAUTION: DB	'WARNING - CONTENTS OF DESTINATION DISKETTE WILL BE LOST.',CR,LF,'  DO YOU WISH TO CONTINUE?  $'
DNRMSG:	DB	BELL,'DRIVE '
DNRMSGA:  DB	0,' NOT READY$'
CRMSG:	DB	CR,LF,0,0,'$'
SD2MSG:	DB	'IS IT DOUBLE-SIDED?  $'
BADMSG:	DB	'BAD NUMBER- TRY AGAIN:  $'
BSCMSG:	DB	'CANNOT READ SOURCE$'
BSMSG:	DB	'BAD SOURCE SECTOR- IGNORE?  $'
;
SSELBIT: DS	1
DSELBIT: DS	1
ASDRV:	DS	1
ADDRV:	DS	1
NTRKS:	DS	1
BYTCNT:	DS	2
TBLADD:	DS	2
BUFLEN:	DS	2
	DS	32
STACK:	EQU	$
BUFIN:	DS	8192
TRKBUF:	DS	10800
	END
