
			;;;;;;;;;;;;;;;;;;;;;;;
			;;;;		   ;;;;
			;;;;	MEMTEST	   ;;;;
			;;;;		   ;;;;
			;;;;;;;;;;;;;;;;;;;;;;;


	;ALLOWS TESTING OF MULTIPLE 1K MEMORY SEGMENTS WITH A CHOICE
	;OF 5 DIFFERENT MEMORY TESTS.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


				ORG	100H


	CR	EQU	0DH
	LF	EQU	0AH
	TAB	EQU	09H


		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;CHECKSUMMABLE STORAGE (NOT ALTERED IN EXECUTION);;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


	CHKVALUE	EQU	1B84H	;2C(CHECKSUM OF MEMTEST AT 1ST LOAD)
					;(FIX LATER)
	TWOC		EQU	0D6BFH	;1C(OFFSET TO CHKSUM ADDED EACH RELOC)
					;(FIX LATER)


		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;STORAGE ALTERED BY PROGRAM IN EXECUTION;;	(FIX ADDRESSES
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	& #'S LATER)

	
	CHECKSTORE	EQU	0B00H	;WORD HOLDS CURRENT CHECKSUM OF MEMTEST
	PROGBEGIN	EQU	0B02H	; "     "   LOAD ADDRESS   OF MEMTEST
	TESTADR		EQU	0B04H	; "	"   START ADDRESS OF TEST BLOCK
	NUMBYTS		EQU	0B06H	; "	"   LENGTH(BYTES) "   "	   "
	SWTCHS		EQU	0B08H	;BYTE	"   SET BITS FOR TESTS CHOSEN
	SCALER		EQU	0B09H	;120A HOLDS .5s DELAY MULTIPLIER
	VALUE		EQU	0B0BH	;HOLDS WRITE VALUE, DECAY TEST
	ENTRYBUFF	EQU	0B0CH	;HOLDS TEST, BLOCK INFO INPUT(24 BYTES)
	STACK		EQU	0B36H	;ALLOWS 8 LEVELS OF CALLS OR PUSHES.
	PLUS		EQU	0B36H	;HOLDS CURRENT OFFSET TO BASIC CHECKSUM


MACLIB	Z80
MACLIB	CPM


			;;;;;;;;;;;;;;;;;;;
			;;EXECUTABLE CODE;;
			;;;;;;;;;;;;;;;;;;;

				;;;;;
				;I/O;
				;;;;;

PROGRAM:

				;<INPUT>;

LXI	H,CHKVALUE		;SET UP 2C(PROGRAM CHECKSUM) IN 'PLUS'
SHLD	PLUS

JMP	CHOICES

TSTMSG:	DB LF,LF,'ENTER STARTING ADDRESS OF TEST BLOCK (ON 1K BOUNDARY);',CR,LF
	DB '# BYTES (1K MULTIPLE) TO BE TESTED;',' THE .5s MULTIPLIER FOR TEST'
	DB ' A (<=00FFH);',CR,LF,'AND THE TESTS CHOSEN:',CR,LF,TAB
	DB 'A',TAB,'Bit Decay Test',TAB,TAB,'(WRITE-WAIT-READ)',CR,LF,TAB
	DB 'B',TAB,'Bad Bit Test',TAB,TAB,'(INCREMENT TEST)',CR,LF,TAB
	DB 'C',TAB,'Bad Addressing Test',TAB,'(MARCH 00/FF UP/DN)',CR,LF,TAB
	DB 'D',TAB,'Memory Fast Access Test',TAB,'(READ&EXECUTE FAST OPCODES)'
	DB CR,LF,TAB,TAB,TAB,TAB,TAB,'(AN ERROR CAUSES CRASH OR FF OUTPUT)'
	DB CR,LF,TAB,'E&F',TAB,'''Repeated Read'' Sensitivity Tests; Genera'
	DB 'l Burn-in',CR,LF,TAB,TAB,'(WALK A 1 OR A 0, RESPECTIVELY, '
	DB ' THROUGH OPPOSITE BACKGROUND)',CR,LF,LF,'FOR EXAMPLE,'
	DB CR,LF,LF,'ADDRESS BYTES   DELAY   TESTS?',CR,LF,'0400(TAB)'
	DB '0C00(TAB)0010(TAB)AC',CR,LF,LF,'(STARTING AT 0400H,TEST 0C00H'
	DB ' BYTES {=3K} WITH TESTS A AND C,',CR,LF,'USE AN 8s {=10H*.5s}'
	DB ' DELAY, TEST A).',CR,LF,LF
	DB 'PLEASE USE UPPER CASE '
	DB 'LETTERS AND 4 DIGIT HEX #s.',' TEST <=40K BYTES AT A TIME.',CR,LF
	DB LF,LF,'ADDRESS BYTES   DELAY   TESTS?',CR,LF,'$'
	


CHOICES: W$  TSTMSG		;PRINTS EXPLANATION, AND ASKS FOR TEST PARAMS.
	 R$  ENTRYBUFF,22	;INIT.S ENTRYBUFF & PUTS TEST PARAMETERS IN IT.
				;PARAM. CHAR.S ACTUALLY START AT ENTRYBUFF+2.

	LXI	D,ENTRYBUFF+2	;PUT STARTING ADDRESS,IN
	CALL	CHARPACK	;PACKED FORM, INTO 'TESTADR'
	SHLD	TESTADR

	LXI	D,ENTRYBUFF+7	;PUT # BYTES TO TEST,IN
	CALL	CHARPACK	;PACKED FORM, INTO 'NUMBYTS'
	SHLD	NUMBYTS

	LXI	D,ENTRYBUFF+12
	CALL	CHARPACK
	SHLD	SCALER

	AS	SWTCHS,ENTRYBUFF+17	;THIS MACRO INPUTS ASCII BYTES A-F (FOR
					;TESTS A-F) AND SETS BITS 0-5 OF SWTCHS

	LXI	H,SWTCHS
	SETB	6,M

	LXI	SP,STACK		;SET UP NEW STACK



	LXI	H,0100H 	;PLACE INITIAL LOAD ADDRESS IN PROGBEGIN
	SHLD	PROGBEGIN

	MVI	A,0		;SET UP 'VALUE'(A PARAMETER FOR THE DELAY TEST)
	STA	VALUE


				;<OUTPUT>;

SCREENCONTROL:
	JMP	WHICHCALL

		CRLF:       DB CR,LF
		BITS:	    DB ' OOOO00'
		CONSTANTS:  DB '00'
   		BLANKS:	    DB '   '
		ONEKAY:	    DB '048C'
		FSTCHAR:    DB '0123456789ABCDEF'
		NORM:	    DB 1BH,'q'
		PLACE:	    DB 1BH,'x1',1BH,'Y8 ',1BH,'x5'
		PARAMS1:    DB 'STATUS:RUNNING   ADDRESS,BYTES,'
			    DB 'DELAY,TESTS: '
		CURSORSET:  DB 1BH,'x1',1BH,'Y8'''
		INV:	    DB 1BH,'p'
		PARAMS2:    DB 'DONE   ',0,0,0,0,0,0,0

		BADMSG:	    DB 1BH,'pBAD PROGRAM LOAD'

WHICHCALL:	LXIX	SWTCHS
		BITX	6,0		;BIT 6 IS SET ONLY FIRST TIME THROUGH,
		RESX	6,0		;SO IF BIT 6 IS SET, WRITE OUT THE
		JNZ	WRSCREEN	;FULL SCREEN.
		CPI	0		;OTHERWISE;
		JZ	STATUS		;'A'=0 INDICATES 'FLASH 'RUNNING''.
		JMP	UPDATE		;'A'<>0, THERE'S AN ERROR.

     WRSCREEN:	LXI	H,CHECKSUM   ;IT'S 1ST TIME THRU; SET UP 'RETURN' TO
		PUSH	H	;NEXT SECTION OF CODE (I.E. TO 'CHECKSUM').

		MVI	B,2
		LXI	H,INV		;SET UP INVERSE VIDEO MODE
		CALL	TERMOUT		

		LXI	B,0208H		;'B'=HALF PAGE CNT,'C'=TRPL LINE CNT
		PUSH	B

		LXI	H,FSTCHAR	;'HL' WILL INDEX INTO 1ST CHAR LIST
		PUSH	H

		LXI	D,ONEKAY	;'DE' WILL INDEX INTO 2ND CHAR LIST

   TRIAD:	MVI	C,4		;LOOP COUNTER

     GROUP:	MVI	B,3
		LXI	H,BLANKS
		CALL	TERMOUT		;WRITE BLANKS
		POP	H
		PUSH	H

		MVI	B,1		;WRITE 1ST CHAR
		CALL	TERMOUT
		POP	H
		XCHG			;GET 2ND CHAR LIST ADDRESS INTO 'HL'
		PUSH	H

		MVI	B,1
		CALL	TERMOUT		;WRITE 2ND CHAR
		POP	H
		INX	H
		XCHG
		PUSH	H

		MVI	B,5
		LXI	H,CONSTANTS
		CALL	TERMOUT

		DCR	C
		JNZ	GROUP


		MVI	B,4		;HALF PAGE FINISHED, FIX INDEX INTO
	FIX1ST:	DCX	D		;2ND CHAR LIST
		DJNZ	FIX1ST

		POP	H		;FIX 1ST CHAR INDEX
		INX	H

		POP	B		;THIS TESTS FOR END OF LINE
		DCR	B
		PUSH	B
		PUSH	H
		JNZ	TRIAD

		MVI	C,8		;BITLINE COUNTER

		MVI	B,2
		LXI	H,CRLF
		CALL	TERMOUT

	BITLN:	MVI	B,10		;WRITE OUT BITLINE
		LXI	H,BITS
		CALL	TERMOUT

		DCR	C
		JNZ	BITLN

		POP	H
		POP	B
		DCR	C		;FIX LOGICAL LINE COUNTER
		MVI	B,2		;SETUP HALF PAGE COUNTER
		PUSH	B
		PUSH	H
		JZ	STATUSLINE

			MVI	B,2
			LXI	H,CRLF
			CALL	TERMOUT

			MVI	C,40
		LINE:	MVI	B,2
			LXI	H,BLANKS
			CALL	TERMOUT
			DCR	C
			JNZ	LINE

			MVI	B,2
			LXI	H,CRLF
			CALL	TERMOUT

		JMP	TRIAD


	STATUSLINE:
		MVI	B,2
		LXI	H,CRLF
		CALL	TERMOUT

		MVI	B,56
		LXI	H,NORM
		CALL	TERMOUT

		W$	ENTRYBUFF+2

		MVI	B,7
		LXI	H,CURSORSET
		CALL	TERMOUT

		LXI	H,SWTCHS
		SETB	7,M
		POP	H		;CLEAR OFF STACK
		POP	H
		RET


    UPDATE:	;;THIS CODE WILL PLACE CURSOR ON CORRECT BIT POSITION FOR
		;;AN ERROR WRITE, AND PUT A '1' THERE.PRESERVE 'D' REGISTER.
		;;(PASS CORRECT VALUE IN 'A',ERROR ADDRESS IN 'HL'?)
		;;FALLS INTO 'STATUS', WHICH FLASHES RUNNING.
		;;PUTING BLOCK FROM ADDRESS IN HL. BAD BITS ARE MADE INVERSE.

		XRA	M	;'A' NOW HAS BAD BIT POSITION(S) SET.
		MOV	C,A	;'C' STORES BAD BIT MAP
		MOV	A,H
		RRC
		RRC
		BIT	2,A	;IS ADDRESS ON LEFT OR RIGHT SIDE OF DISPLAY?
		JZ	LEFT
			ANI	03H
			ADI	4
		LEFT:	ANI	07H	;'A' NOW HOLDS LOGICAL COLUMN #
			
	  Cx10:	RLC
		RLC
		RLC		;MULTIPLY COL. # BY 8
		MOV	B,A	;STORE LOGICAL COLUMN # * 8 IN 'B'

		RRC		;2 RRC'S GET US BACK TO LOGICAL COL # * 2.
		RRC
		ADD	B	
		MOV	B,A	;'B' NOW HOLDS (LOGICAL COL # * 10)
		PUSH	B


	  LNUM:	MOV	A,H	;DETERMINE LINE # OF ERROR BIT
		RRC		;DIVIDE ADDRESS BY 2000H (DROP LAST 2 DIGITS
		RRC		;OF ADDRESS, & DIVIDE TOP 2 BY 20H),MULT BY 3
		RRC		;AND ADD 2 TO GET ACTUAL LINE #
		RRC
		ANI	0EH	;STRIP OFF EXTRANEOUS ROTATED BITS
		MOV	B,A	;STORE x2 VALUE IN 'B'
		RRC		;GET x1 VALUE.
		ADD	B	;ADD x2. WE NOW HAVE (ADDRESS/2000H)x3 IN 'A'
		INR	A
		INR	A	;ADD 2, TO START LOGICAL LINE #'S AT '2'
		ADI	31	;CONVERT TO TERMINAL CODE #
		STA	BITMARK+2 ;PLACE LINE # CODE IN CURSOR PLACEMENT STRING

	  BBIT:	MOV	A,C	;MOVE THE BAD BIT MAP INTO 'A'
		POP	B	;RESTORE LOGICAL COLUMN ADDRESS
		MVI	C,8
		LOOK:	INR	B
			RLC
			CC	BITFLAG
			DCR	C
			JNZ	LOOK
		JMP	STATUS

		BITFLAG: PUSH	B
			 MOV	C,A		;MOVE BAD BIT MAP INTO 'C'
			 MOV	A,B
			 ADI	32		;CONVERT TO TERMINAL CODE #
			 STA	BITMARK+3


			 RECOV: PUSH	H
			 
				LXI	H,BITMARK
				MVI	B,7
				CALL	TERMOUT

				MOV	A,C	
			 	POP	H
				POP	B

			 RET


    STATUS:		
			MVI	B,7
			LXI	H,CURSORSET
			CALL	TERMOUT		;ENABLE LINE 25, & POSITION
						;CURSOR

			LXI	H,SWTCHS	;IT WILL FLASH 'RUNNING'
			BIT	7,M
			PUSH	H
			JNZ	INVERS
				LXI	H,NORM
				MVI	B,02
				CALL	TERMOUT
				POP	H
				SETB	7,M
				JMP	ALLDONE
			INVERS:
				POP	H
				RES	7,M
				LXI	H,INV
				MVI	B,02
				CALL	TERMOUT
			ALLDONE:
			LXI	H,PARAMS1+7
			MVI	B,07
			CALL	TERMOUT
			RET




			;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
			;PROGRAM DIAGNOSTICS & CURES;
			;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


CHECKSUM:	;;ROUTINE TO CHECKSUM THE PROGRAM; IF OK, FALLS INTO 'RELOC'.
		;;IF NOT, IT GIVES A BAD CHECKSUM MESSAGE AND EXITS TO SYSTEM.

		;LXI	D,PROGRAM+3
		JMP	RELOC
		LXI	H,BITMARK-PROGRAM-3
		DAD	D	
		XCHG		;'DE'=LAST ADDRESS OF PROG,'HL'=BEGIN ADDRESS
				;FOR CHECKSUMMING PURPOSES

		LXI	B,0		;'BC' STORES CHECKSUM
	CHKLOOP:	MOV	A,M
			ADD	C
			JNC	STORE
				INR	B
			STORE:	MOV	C,A
			INX	H

			CALL	CHECKBOUNDS
			JNZ	CHKLOOP

		MOV	E,C		;FINAL CHECKSUM NOW IN 'BC', MOVE TO
		MOV	D,B		;'DE' FOR DAD
		LHLD	PLUS	;ADD EXPECTED 2C(PROG CHECKSUM)
		DAD	D
		MVI	A,0	;IF RESULT <> 0, WE HAVE A LOAD ERROR
		CMP	L
		JNZ	BADCHK
		CMP	H
		JNZ	BADCHK
		JMP	RELOC				

		BADCHK:	MVI	B,18
			LXI	H,BADMSG
			CALL	TERMOUT

		HLT

RELOC:		;;CODE TO SEE IF NEXT TEST BLOCK OVERLAPS PROGRAM. IF SO,
		;;RELOC THE PROGRAM BY ADDING 40H TO SELECTED BYTES FROM BITMAP
		;;AND DO A BLOCK MOVE.THEN GO TO 'CHECKSUM' AND CONTINUE.
		;;******GET 2C(CHKSUM OFFSET) AND ADD IT TO 'PLUS'*************

	OVRLAP:		;;1} IF (TESTADR) > LAST PROGRAM ADDRESS, OR
			;;2} IF (PROGBEGIN) > (TESTADR)+(NUMBYTS)
			;;THEN  THE PROGRAM AND TEST AREAS DO NOT OVERLAP.

		TSTONE:	LXI	D,PLUS+2	;DE=LAST PROGRAM ADDRESS
			LHLD	TESTADR		;HL=(TESTADR)

			MOV	A,D
			CMP	H		;IF TOP BYTE(TESTADR)IS GREATER
			JC	TESTBIT		;THERE'S NO OVERLAP.
			JNZ	TSTTWO		
			MOV	A,E		;TOP BYTES ARE =,SO WE'RE
			CMP	L		;TESTING LOWER BYTES.
			JC	TESTBIT


		TSTTWO:	LHLD	TESTADR
			XCHG
			LHLD	NUMBYTS
			DAD	D
			XCHG			;DE=(TESTADR)+(NUMBYTS)
			LHLD	PROGBEGIN	;HL=(PROGBEGIN)

			MOV	A,D	;THIS SECTION ANALOGOUS TO SAME SECTION
			CMP	H	;IN 'TSTONE'.
			JC	TESTBIT
			JNZ	MUSTMOV
			MOV	A,E
			CMP	L
			JC	TESTBIT

	MUSTMOV:
		;FIX 'PLUS' FOR POSSIBLE NEXT RELOCATION
			LHLD	PLUS
			LXI	D,TWOC
			DAD	D
			SHLD	PLUS

			LHLD	PROGBEGIN
			XCHG
			LXI	H,4000H	;NEW PROGBEGIN IS 16K HIGHER
			DAD	D
			SHLD	PROGBEGIN
			XCHG		;HL' HAS OLD PROGBEGIN, DE' HAS NEW
			LXI	B,1000H ;PROGBEGIN, BC' HAS # BYTES TO MOVE.
			LDIR		;MOVE THE PROGRAM.


		LXIX	0		;FIX ADDRSES IN COPY OF PROGRAM AT NEW
		LHLD	PROGBEGIN	;LOCATION, USING THE BITMAP OF IT
		XCHG
		DADX	D	;IX HAS ADDRESS OF BEGINNING OF MOVED PROGRAM
		LXI	H,BITMAP	;IX WILL POINT TO PROGRAM BYTE.
		LXI	D,8	;WE ADD 8 TO IX EACH BYTE (IN BITMAP)=0


      BYTEVAL:		MOV	A,M	;LOAD NEXT BYTE IN BITMAP & EXAMINE IT
			CPI	3FH	;LAST BYTE IN BITMAP=3F
			JNZ	MORFIX
				LXI	H,4000H	;FIX SP FOR RELOC
				DAD	SP
				SPHL
				JMP	CHECKSUM+4000H
		MORFIX:	CPI	0H	;ANY BIT SET REQUIRES CORRESPONDING
			JNZ	BITLOOK ;PROGRAM BYTE(TOP BYTE OF ADR)MADE +40H
			DADX	D	;IF NO BIT SET,POINTER IX MADE+8(BYTES)
			INX	H	;LOOK AT NEXT BYTE IN BITMAP
			JMP	BYTEVAL

	      BITLOOK:	MVI	B,8	;LOOK AT THE BITS, ALTER CORRESPONDING
			SHIFT:	RAL				;PROGRAM BYTES
				JNC	NXTBIT
				MOV	C,A
				LDX	A,0  ;LOAD 'A' W/INDICATED PROGRAM BYTE
				ADI	40H  ;ADD 40H;THAT ADDRESS WORD NOW+16K
				STX	A,0  ;PUT BACK ALTERED VALUE
				MOV	A,C

			NXTBIT:	INXIX		;BYTE POINTER IS INCREMENTED
				DJNZ	SHIFT
				INX	H
				JMP	BYTEVAL



				;;;;;;;;;;;;;;;
				;TEST SELECTOR;
				;;;;;;;;;;;;;;;


TESTBIT:		;THIS ROUTINE IS THE 'CENTRAL STATION' FOR THE TESTS.
			;IT TESTS 'SWTCHS' (TESTS) AND SELECTS THE NEXT TEST
			;TO BE PERFORMED. WHEN A TEST IS DONE, CONTROL RETURNS
			;HERE FOR THE NEXT TEST TO BE CHOSEN. WHEN ALL TESTS
			;ARE DONE, IT CLOSES OUT THE MEMORY TEST PROGRAM.

		CALL	SETBOUNDS	;HAVE START PARAMS IN 'DE' & END
					;PARAMS IN 'HL'
		LDA	SWTCHS
		BIT	0,A
		JNZ	TEST0
		BIT	1,A
		RES	1,A
		STA	SWTCHS
		JNZ	TEST1
		BIT	2,A
		RES	2,A
		STA	SWTCHS
		JNZ	TEST2
		BIT	3,A
		RES	3,A
		STA	SWTCHS
		JNZ	TEST3
		BIT	4,A
		RES	4,A
		STA	SWTCHS
		JNZ	TEST4
		BIT	5,A
		RES	5,A
		STA	SWTCHS
		JNZ	TEST5

		MVI	B,17
		LXI	H,CURSORSET	;WRITES OUT 'DONE' MESSAGE
		CALL	TERMOUT

		HLT			;ALL TESTS ARE COMPLETE.



				;;;;;;;
				;TESTS;
				;;;;;;;

TEST0:				;DECAY TEST EXECUTES AND FALLS THRU TO INR TEST
    WRVAL:	LDA	VALUE
		MOV	C,A
	LOAD:	MOV	M,C
		INX	H
		CALL	CHECKBOUNDS
		JNZ	LOAD
		LHLD	SCALER
		XCHG		;GET .5s MULTIPLIER INTO 'E'
		INR	E	;MAKE '0' MULTIPLIER GIVE NO DELAY
    DELAY:	MVI	A,0
		CALL	SCREENCONTROL	;FLASH	'RUNNING'
    		LXI	H,0FFFFH
	CLOCK:	DCX	H
		MOV	A,L
		ORA	A
		JRNZ	CLOCK
		MOV	A,H
		ORA	A
		JRNZ	CLOCK
		DCR	E
		JNZ	DELAY
    CHECKOUT:	LDA	VALUE
		CALL	SETBOUNDS	;RELOAD START AND END PARAMS
		MOV	C,A
	UNLOAD:	MOV	A,M
		XRA	C
		MVI	M,0
		PUSH	B
		PUSH	H
		CNZ	SCREENCONTROL
		POP	H
		INX	H
		CALL	CHECKBOUNDS
		POP	B
		JNZ	UNLOAD
		MVI	A,0FFH	;2ND PASS?
		CMP	C
		JZ	FIN
		STA	VALUE	;'FF' IS WRITTEN OUT 2ND PASS
		JMP	TESTBIT
	FIN:	LDA	SWTCHS
		RES	0,A
		STA	SWTCHS
		JMP	TESTBIT



TEST1:				;'INCREMENT TEST'
	MVI	C,0	;'C' WILL KEEP NEXT VALUE TO WRITE INTO MEMORY.
	LIMITS:	CALL	SETBOUNDS
	MEMLOD:	INR	C
		MOV	M,C	;'HL' KEEPS CURRENT MEMORY ADDRESS
		INX	H
		CALL	CHECKBOUNDS
		JNZ	MEMLOD

		MVI	A,0
		PUSH	B
		CALL	SCREENCONTROL	;FLASH 'RUNNING'
		POP	B

	CHECK:	MOV	A,C	;GET LAST WRITTEN OUT NUMBER INTO 'A'.
		LHLD	NUMBYTS	;GET BLOCK LENGTH (NUMBYTS) IN 'HL'.
		MOV	C,L	;MOVE (NUMBYTS) TO 'BC' FOR THE CPD.
		MOV	B,H	;
		MOV	L,E	;'DE' CONTAINS (TESTADR)+(NUMBYTS)
		MOV	H,D
		DCX	H	;SET UP LAST TEST ADDRESS IN 'DE' FOR CPD.
		INR	A	;SET UP 'A' FOR 1ST DCR IN LOOP
		COMPARE: DCR	A
			 CCD
			 CNZ	BADBYTE	;'Z' RESET IF COMP FAILS.
			 JPE	COMPARE	;'PO' IF 'BC'=0.
		CPI	0	;IF 1ST BYTE IN BLOCK=0,WE'RE DONE (SINCE 1ST
		MOV	C,A	;PASS STARTED BY WRITING A '1',255 PASSES LATER
		INX	H	;FIX INDEX INTO TEST AREA
		NOP		;'NOP'S EASE LATE CORRECTION TO BITMAP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		JNZ	LIMITS	;IT WROTE A '0',FINISHING ALL POSSIBLE PASSES).
		JMP	TESTBIT

       BADBYTE:	PUSH	B
		MOV	D,A	;;MUST SAVE NEXT COMPARISON VALUE
		INX	H	;REPAIRS DCX H INHERENT IN CPD INSTRUCTION
				;AND GETS BACK TO ERROR ADDRESS.
		PUSH	H
		CALL	SCREENCONTROL
		MOV	A,D
		POP	H
		POP	B
		INX	B	;SETS UP FOR FOLLOWING DCX OF 'B'
	;	CCD		;DCX'S 'H'&'B' BACK TO CORRECT VALUE TO RETURN,
				;AND SETS PARITY FLAG FOR FOLLOWING JPE IN TEST
		DB	0EDH,0A9H	;ACTUAL CCD CODE,TO TEST WHERE PROBLEM
		RET

TEST2:	MVI	B,0		;'MARCH'
	MVI	C,0FFH

	FILL:	MOV	M,B
		INX	H
		MOV	M,C
		INX	H
		CALL	CHECKBOUNDS
		JNZ	FILL

		CALL	SETBOUNDS

	CHEC:	MOV	A,M
		CMP	B
		MOV	A,B
		PUSH	B
		PUSH	H
		CNZ	SCREENCONTROL
		POP	H
		POP	B
		INX	H
		MOV	A,M
		CMP	C
		MOV	A,C
		PUSH	B
		PUSH	H
		CNZ	SCREENCONTROL
		POP	H
		POP	B
		INX	H
		CALL	CHECKBOUNDS
		JNZ	CHEC

		PUSH	B		;FLASH 'RUNNING'
		MVI	A,0
		CALL	SCREENCONTROL
		POP	B

		CALL	SETBOUNDS	;PREPARE FOR NEXT PASS
		INR	B
		DCR	C
		JNZ	FILL		;WHEN 'C'=0, WE'VE FINISHED

		JMP	TESTBIT

TEST3:	
	LOADOPS:
			 MVI	A,80H
		ADDLOOP: MOV	M,A	;THIS LOADS REGISTER ADD OPS INTO MEM
			 INX	H	;'ADD	A,B'->'ADD   A,H'...
			 INR	A
		 	 CPI	85H
		 	 JNZ	ADDLOOP

			 MVI	A,0A8H
		XORLOOP: MOV	M,A	;THIS LOADS REG XOR OPS INTO MEM
			 INX	H	;'XRA  B'->'XRA  H'...
		 	 INR	A
		 	 CPI	0ADH
		 	 JNZ	XORLOOP

		RESTORA: MVI	A,0	;'NOP'...THESE INSTRUCTIONS RESTORE
			 MOV	M,A	;THE ORIGINIAL 'A'(LOGIC ABOVE SETS IT
			 INX	H	;UP,LOADED REGISTER VALUES CHOSEN FOR)
			 MVI	A,2FH	;'CMA'...
			 MOV	M,A	
			 INX	H
			 MVI	A,3CH	;'INR A'...
			 MOV	M,A
			 INX	H

		CHECKA:	 MVI	A,0CDH	;'CALL'...
			 MOV	M,A
			 LXI	B,ERRORCHECK	;'ERRORCHECK'...
			 INX	H
			 MOV	M,C
			 INX	H
			 MOV	M,B
			 INX	H

		CALL	CHECKBOUNDS
		JNZ	LOADOPS

		DCX	H		;LAST LOAD OF GROUP, SUBSTITUTE 'JMP
		DCX	H		;TESTBIT' FOR 'CALL ERRORCHECK'
		DCX	H
		MVI	A,0C3H
		MOV	M,A		;'JMP'
		INX	H
		LXI	B,TESTBIT	;'TESTBIT'
		MOV	M,C
		INX	H
		MOV	M,B

	MVI	A,1		;INITIALIZE THE  REGISTERS TO CORRECT STARTING
	LXI	B,0708H		;VALUES; A=1,B=111,C=1000,D=1 0000,E=10 0000,
	LXI	D,1020H		;H=1100 0000(BINARY).SUM A->H=0.XRA B->H=FFH.
	MVI	H,0C0H		;'CMA' & 'INR A' RESTORE 'A'=1
	
	LIXD	TESTADR		;START EXECUTING THE CODES PLACED IN MEMORY
	PCIX

	ERRORCHECK:	PUSH	B
			PUSH	H
			CPI	1	;IS CORRECT VALUE IN A?
			JZ	NORMAL
			MVI	A,7FH	;IF NOT, SET ALL BITS BAD
			LHLD	TESTADR  ;(HL)=80H, 'XRA M' IN S.C. GIVES FFH
			CALL	SCREENCONTROL
		NORMAL:	MVI	A,0H		;A=0 BLINKS 'RUNNING'
			CALL	SCREENCONTROL
			POP	H
			POP	B
			MVI	A,1	;SET UP FOR NEXT GROUP INSTRUCTIONS
			RET


TEST4:	MVI	B,0

	BCKGND0: MOV	M,B
		 INX	H
		 CALL	CHECKBOUNDS
		 JNZ	BCKGND0

	CALL	SETBOUNDS
	STC
	MVI	A,0
	ROTATE:	RAL		;WALK A BIT THROUGH THIS BYTE.
		CPI	0
		JZ	MOVEON	;MOVE ON TO THE NEXT BYTE
		MOV	M,A

	CHEQUE:	MOV	C,L	;BYTE ADDRESS OF SET BIT
		MOV	B,H	;NOW IN BC
		PUSH	PSW	;SAVE VALUE IN 'A'
		PUSH	B
		MVI	A,0
		CALL	SCREENCONTROL	;FLASH 'RUNNING'
		CALL	SETBOUNDS
		POP	B
		MVI	A,0

		BITHUNT:	CMP	M
				JNZ	CHKBYT
			   OK:	INX	H
				CALL	CHECKBOUNDS
				MVI	A,0
				JNZ	BITHUNT
				POP	PSW
				MOV	H,B	;RESTORE ADDRESS OF WALKING BIT
				MOV	L,C
				JMP	ROTATE

				CHKBYT:	MOV	A,L
					CMP	C
					JNZ	BADB
					MOV	A,H
					CMP	B
					JNZ	BADB
					;CHECK THE CORRECT BYTE TO SEE IF
					;CORRECT BITS ARE SET.
					POP	PSW
					PUSH	PSW
					XRA	M
					MOV	M,A
					JNZ	BADB
					MVI	A,0
					JMP	OK

					BADB:	MOV	A,M	;'XRA M'
						MVI	M,0	;WILL NOW WORK
						PUSH	H
						PUSH	B
						CALL	SCREENCONTROL
						POP	B
						POP	H
						JMP	OK


	MOVEON:	INX	H	;START ON NEXT BYTE.
		CALL	CHECKBOUNDS
		JZ	TESTBIT
		STC		;'ROTATE' CPI RESET CARRY,
				;THIS SETS IT AGAIN.
		MVI	A,0
		JMP	ROTATE


TEST5:	MVI	B,0FFH

	BCKGNDF: MOV	M,B
		 INX	H
		 CALL	CHECKBOUNDS
		 JNZ	BCKGNDF

	CALL	SETBOUNDS
	MVI	A,0FFH
	FIXCAR:	STC
		CMC		;RESET THE CARRY FLAG TO 0
		REVOLV:	RAL		;WALK A 0 BIT THROUGH THIS BYTE.
			CPI	0FFH
			JZ	GO$ON	;MOVE ON TO THE NEXT BYTE
			MOV	M,A

		CZECH:	MOV	C,L	;BYTE ADDRESS OF SET BIT
			MOV	B,H	;NOW IN BC
			PUSH	PSW	;SAVE VALUE IN 'A'
			PUSH	B
			MVI	A,0
			CALL	SCREENCONTROL	;FLASH 'RUNNING'
			CALL	SETBOUNDS
			POP	B
			MVI	A,0FFH

		HUNTBIT:	CMP	M
				JNZ	SEEBYT
			   AOK:	INX	H
				CALL	CHECKBOUNDS
				MVI	A,0FFH
				JNZ	HUNTBIT
				POP	PSW
				MOV	H,B	;RESTORE ADDRESS OF WALKING BIT
				MOV	L,C
				JMP	REVOLV

				SEEBYT:	MOV	A,L
					CMP	C
					JNZ	BBAD
					MOV	A,H
					CMP	B
					JNZ	BBAD
					;CHECK THE CORRECT BYTE TO SEE IF
					;CORRECT BITS ARE SET.
					POP	PSW
					PUSH	PSW
					XRA	M
					MOV	M,A
					JNZ	BBAD
					MVI	A,0FFH
					JMP	AOK

					BBAD:	MOV	A,M	;'XRA M'
						MVI	M,0FFH	;WILL NOW WORK
						PUSH	H
						PUSH	B
						CALL	SCREENCONTROL
						POP	B
						POP	H
						JMP	AOK


	GO$ON:	INX	H	;START ON NEXT BYTE.
		CALL	CHECKBOUNDS
		JZ	TESTBIT
		MVI	A,0FFH
		JMP	FIXCAR


			;;;;;;;;;;;;;;;
			;;SUBROUTINES;;
			;;;;;;;;;;;;;;;

		CHARPACK: LXI	H,0		;CONVERTS ASCII CHAR.
			  MVI	B,4		;TO PACKED BINARY #.
			CONVRT:	LDAX	D
				CPI	40H
				JC	REST
				SUI	7H	;SUBTRACT 37H IF A-F(ASCII>40H)
				REST:	SUI 30H ;AND 30H IF 0-9(ASCII 30-39)
				DAD	H	
				DAD	H
				DAD	H
				DAD	H
				ORA	L
				MOV	L,A
				INX	D
				DJNZ	CONVRT	
				RET

	CHECKBOUNDS:	MOV	A,L	;RETURNS W/ ZERO FLAG SET IF E.O.BLOCK
			CMP	E
			RNZ
			MOV	A,H
			CMP	D
			RET

	 SETBOUNDS:	LHLD	TESTADR
			XCHG
			LHLD	NUMBYTS
			DAD	D		;(ADD TESTADR).
			XCHG		;'DE' NOW CONTAINS (TESTADR)+(NUMBYTS);
			RET		;'HL' CONTAINS (TESTADR).

	   TERMOUT:	IN	2AH
			BIT	2,A
			JZ	TERMOUT
			MOV	A,M
			INX	H
			OUT	28H
			DJNZ	TERMOUT
			RET

BITMAP:		DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DB 4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,1,9,0,0
		DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80H,0
		DB 0,0,80H,44H,80H,88H,40H,24H
		DB 82H,42H,8,21H,21H,12H,0,82H
		DB 42H,4,48H,48H,90H,90H,91H,8
		DB 48H,49H,12H,2,0,10H,40H,20H,21H
		DB 4,10H,0,4,90H,81H,20H,48H
		DB 12H,4,81H,21H,22H,9,20H,40H
		DB 0,49H,0,42H,20H,92H,42H,42H
		DB 9,4,20H,2,40H,1,20H,40H,0
		DB 12H,40H,40H,8,24H,11H,9,0
		DB 40H,10H,0,4,4,80H,20H,0
		DB 10H,8,48H,40H,4,90H,8,2
		DB 40H,88H,41H,8,40H,84H,4,22H
		DB 41H,2,48H,2,0,90H,22H,10H
		DB 42H,10H,21H,1,8,90H,80H,10H
		DB 0,0,22H,0,80H,3FH			;'3F' MEANS WE'RE DONE


		BITMARK:    	DB 1BH,'Y',0,0,1BH,'q-'

		FINDCHK:	DB 0,0,0,0,0DH,0AH
