	title	'ISIS II monitor and disk emulator,  13 apr 82'
;==============================================================
;
;	  Ram based SBC202/201, and ISIS monitor emulator
;
;		Digital Microsystems DSC-2 version.
;
;==============================================================
;
	page	58
;
;	This module contains the input/output routines used by ISIS II
;
true		equ	-1		;define value of true
false		equ	not true	;define value of false
debug		equ	false		;set true if setup assembly for 
					;ram based debug at 32 memory size
;
;	define disk controller base addresses for operations
;
comand1		equ	80h		;first disk command port
stat		equ	80h		;disk status port
haddr		equ	81h		;high dma address port
laddr		equ	82h		;low dma address port
comand2		equ	83h		;second command port
;
;	define console and printer interface parameter equates
;
data		equ	40h		;console port
status		equ	data+1
data1		equ	48h		;punch and reader port
status1		equ	data1+1
data2		equ	50h		;list port
status2		equ	data2+1
;
rxrdy		equ	0000$0010b	;8251 receiver ready bit
txrdy		equ	0000$0001b	;8251 transmitter buffer empty bit
dtr		equ	1000$0000b	;8251 dtr bit (htif handshake bit)
;
;	define ASCII character codes that are referenced
;
cr		equ	0dh		;ASCII cariage return
lf		equ	0ah		;ASCII linefeed
;
;	define ISIS storage locations and constants
;
iobyte		equ	0003h		;INTEL iobyte
initio		equ	0006h		;initial I/O config
memtop		equ	0004h		;location ISIS stores the top of ram
;
	if debug
monitor		equ	08800h		;monitor start
memsiz		equ	32		;ram memory size in decimal kilo bytes
	endif				;debug
;
	if not debug
monitor		equ	0f800h		;monitor start
memsiz		equ	62		;ram memory size in decimal kilo bytes
	endif				;not debug
;
memmax		equ	((memsiz*1024)/256)-1	;memory map area
date		equ	0715h		;date
verh		equ	10h		;version 1.0
;
;
		org	0ffffh
;
		db	0		;set version number of monitor
;
;	start of ISIS boot load point routine
;
		org	monitor		;origin of this program
;
		jmp	start0		;reset entry point
		jmp	conin		;console input
		jmp	reader		;reader input
		jmp	conout		;console output
		jmp	punch		;punch output
		jmp	list		;list output
		jmp	const		;console input status
		jmp	iochk		;I/O system status
		jmp	ioset		;set I/O configuration
		jmp	memchk		;compute size of memory
		jmp	dmycmd		;define user I/O entry points
		jmp	dmycmd
;
		dw	date		;date stamp for monitor rom
		jmp	dmycmd		;upp input
		jmp	dmycmd		;upp output
		jmp	dmycmd		;upp status
;
		db	verh		;version stamp for monitor rom
		db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;dummy copyright
		jmp	dmycmd		;ioccom entry point
		jmp	dmycmd		;ioc output
		jmp	stat78		;disk controller 1 status
		jmp	stat88		;disk controller 2 status
		jmp	cmmd78		;disk controller 1
		jmp	cmmd88		;disk controller 2
		jmp	rtyp78		;disk controller 1 result type
		jmp	rtyp88		;disk controller 2 result type
		jmp	rbyt78		;disk controller 1 result byte
		jmp	rbyt88		;disk controller 2 result byte
;
;	disk command to controller that should be at 88h
;	hl points to address of I/O parameter block
;
cmmd88:		xra	a		;mark this is for controller 2
		jmp	cmmdent		;go do common I/O command
;
;
;	disk command to controller that should be at 78h
;	hl points to address of I/O parameter block
;
cmmd78:		ori	0ffh		;mark this is for controller 1
;
cmmdent:	sta	density		;select controller
		shld	iopb		;save pointer to iopb
		lxi	h,0		;make hl 0 for dad
		dad	sp
		shld	ostack		;save old stack pointer
		lxi	sp,newstk	;set up new stack
		push	d		;save d and e
		push	b		;save b and c
		mov	c,a		;drive select bit 1
		lxi	h,iodone	;make return address
		push	h		;put it on stack
;
;	copy iopb into scratch area
;
		lxi	d,ioblk		;point to ioblk destination
		lhld	iopb		;point to source
		mvi	b,7		;number of bytes to move
;
ibkmov:		mov	a,m		;get a byte
		stax	d		;store a byte
		inx	h		;bump pointers
		inx	d
		dcr	b		;decrement count
		jnz	ibkmov		;loop if not done
;
;	select disk drive specified in iopb
;
		lda	dskins		;get disk instruction
		rrc
		rrc
		rrc
		rrc			;drive select bits to 1 and 2
		ani	1		;select bit 0
		mov	c,a
		call	seldsk		;select drive
		call	settrk		;seek to proper track
		call	setsec		;setup sectors(s)
;
;	execute disk instruction from iopb
;
		lda	dskins		;get disk instruction
		ani	7		;look at opcode only
		cpi	4
		jz	iread		;goto INTEL read
		cpi	6
		jz	iwrite		;goto INTEL write
		cpi	7
		jz	iwrite		;do deleted write like normal write
		cpi	5
		jz	iverf		;goto INTEL verify
		cpi	1
		jz	settrk		;goto INTEL seek
		cpi	2
		jz	iverf		;INTEL format
		cpi	3
		jz	home		;do INTEL home
		xra	a		;nop, ret result byte=0
		ret
;
;	disk I/O complete restore regs and restore sp and return
;	disk controller simulator exit point
;
iodone:		sta	resbyt		;save disk status
		pop	b		;restore regs
		pop	d
		lhld	ostack
		sphl			;restore stack
		lhld	iopb
		ret			;return to ISIS
;
;	user entry point to check the status of the I/O byte
;
iochk:		lda	iobyte		;get status byte
		ret
;
;	user entry point to change the I/O byte to a new value
;
ioset:		mov	a,c		;put new value into the memory
		sta	iobyte
		ret
;
;	user entry point to get the value of the top of available memory
;
memchk:		lda	memtop+1	;msbyt of top address of memory
		dcr	a		;change one page less to permit
					;monitor to use 256 bytes of ram
		mov	b,a		;msbyt in b reg
		mvi	a,0c0h		;ab points to base of user stack
		ret			;in 2'nd from top page of ram
;
;	dummy I/O routine
;
dmycmd:		xra	a
		ret			;dummy routine
;
;	routine to simulate getting ready status of the single density
;	INTEL disk controller hardware
;
stat78:		mvi	a,1bh		;show always ready & dd controller
		ret
;
stat88:		mvi	a,0bh		;show always ready
		ret
;
;	routine to imitate return of result type byte from the disk 
;	controller hardware
;
rtyp78		equ	$
;
rtyp88:		xra	a
		ret
;
;	routine to imitate reading of the result byte from the disk
;	controller hardware code was made by the disk operation
;	command routines and stored at resbyt in the top page of ram
;
rbyt78		equ	$
;
rbyt88:		lda	resbyt		;get result byte
		ret
;
;	here to setup start of command inquiry loop to boot an ISIS 40
;	system disk that has been patched for disk I/O through this 
;	ram based i/c-bios software
;
start0:		lxi	sp,stack	;set stack pointer
;
;	put jump to monitor at zero
;
		mvi	a,0c3h		;put jump to monitor at 0
		sta	0000h
		lxi	h,monitor
		shld	0001h
		mvi	a,01h		;console is crt
		sta	iobyte
		sta	initio
;
;	calculate top of memory and store at "memtop" for the ISIS 
;	system operation
;
		lxi	h,03f00h	;start point for test
;
pag:		inr	h		;set to next page
		jz	fnd		;stop if at end
		mov	a,m		;get memory byte
		cma			;complement it
		mov	m,a		;put comp in memory
		cmp	m		;did it go in ok
		cma			;invert back
		mov	m,a		;restore original
		jz	pag		;loop to next 256 bytes if it changed
;
fnd:		dcx	h		;back up a page
		mov	a,h
		cpi	memmax		;less than f700h
		jc	x11		;if yes then use this value
;
fnd1:		mvi	h,memmax	;otherwise set memtop to 0f7ffh
;
x11:		shld	memtop		;set ISIS memory top address
;
;	print ISIS prompt message and then load disk on input of a "cr"
;
iboot:		lxi	h,isisms	;print ISIS load message
		call	pmsg
		call	conin		;get ready status
		cpi	cr		;see if a cr
		jnz	iboot		;start all over if not ISIS boot
		lxi	h,crlf		;print carriage return linefeed
		call	pmsg
;
;	setup scratch area
;
		lxi	h,0ffffh
		shld	trtab		;preset track table
		shld	trtab+2
		mvi	a,4		;set up initial out of range disk
		sta	diskno
		xra	a
		call	seldsk		;select drive 0
;
;	boot in ISIS.t0 to location 3000h and execute
;
		lxi	h,bootpb	;point to boot parameter block
		call	cmmd78		;read in disk
		ora	a
		jz	3000h		;if no errors goto ISIS
		lxi	h,bmsg
		call 	pmsg		;print boot error message
		jmp	iboot		;if error then go try for another command
;
;	iopb for booting ISIS.t0 in to 3000h
;
bootpb		db	80h		;iocw, no update bit set
		db	04h		;I/O instruction, read disk 0
		db	26		;read 26 sectors
		db	0		;track 0
		db	1		;sector 1
		dw	3000h		;load address
;
;	hardware interface I/O routines for ISIS bios software
;
;	check console input status
;
const:		in	status		;read console status
		ani	rxrdy
		rz			;set a=0
		ori	0ffh		;return if not ready with a=0
		ret
;
;	read a character from console
;
conin:		in	status		;read console status
		ani	rxrdy		;if not ready
		jz	conin		;keep waiting
		in	data		;read a character
		ani	7fh		;make most sig bit=0
		ret
;
;	write a character to the console device
;
conout:		in	status		;read console status
		ani	txrdy		;if not ready,
		jz	conout		;keep waiting
		mov	a,c		;get character
		out	data		;print it
		ret
;
;	write a character to the list device
;
prstat:		;check printer status, return 0ff if ready, 00 if not
		in	status2
		ani	dtr or txrdy	;check dtr and txrdy
		xri	dtr or txrdy
		mvi	a,0ffh
		rz
		cma
		ret
;
list:		;output character in <c> to printer device
		call	prstat
		ora	a
		jz	list
		mov	a,c
		out	data2
		ret
;
;
punch:		;punch character from register <c>
		in	status1
		rar
		jnc	punch
		mov	a,c		;character to register <a>
		out	data1
		ret
;
;
reader:		;read character into register <a> from reader device
		in	status1
		ani	rxrdy
		jz	reader
		in	data1
		ret
;
;
;	verify sector or sectors specified in iopb
;
iverf:		xra	a		;dummy routine
		ret
;
;	disk I/O error sorting tree that converts 1771 error codes into
;	those required to emulate an INTEL disk controller
;
dskerr:		cpi	10000000b	;test for not ready
		jz	rdyerr
		cpi	01000000b	;test for write protect
		jz	wprot
		cpi	00000100b	;test for lost data
		jz	losdat
		cpi	00011000b	;test for id crc error
		jz	idcrc
		cpi	00010000b	;test for record not found
		jz	idcrc
					;lets say all else is crc
;
crcerr:		mvi	a,00000010b	;make code for crc error
		ret
;
wprot:		mvi	a,00100000b	;make code for write protect
		ret
;
rdyerr:		mvi	a,10000000b	;make code for not ready
		ret
;
losdat:		mvi	a,00010000b	;make code for lost data
		ret
;
idcrc:		mvi	a,00001010b	;make code for id crc
		ret
;
adrerr:		mvi	a,00001000b	;make code for adress error
		ret
;
;	print data pointed to by h and l until a zero is found
;
pmsg:		mov	a,m		;get character
		ora	a		;set flags
		rz			;ret if char is a zero
		mov	c,a		;put char in "c"
		call	conout		;print character
		inx	h		;bump message pointer
		jmp	pmsg		;do another character
;
;
;	i/o drivers for the disk follow
;
;
;
home:		;move to the track 00 position of current drive
		call	headload
;
;	 <hl> points to word with track for selected disk
;
homel:		mvi	m,00		;set current track ptr back to 0
		in	stat		;read fdc status
		ani	4		;test track 0 bit
		rz			;return if at 0
		stc			;direction=out
		call	step		;step one track
		jmp	homel		;loop
;
;
seldsk:		;select disk given by register <c>
		;make sure dummy is 0 (for use in double add to <hl>)
		;set up the second command port
		mov	a,c		;get disk number
		sta	diskno		;update
		xra	a
		sta	dummy
		lda	density
		mov	b,c
;
ckdens:		dcr	b
		rrc
		jp	ckdens		;get density in [cy],(1=dd,0=sd)
		jnc	setsgl
		mov	a,c
		ori	08h		;set double density
		mov	c,a
;
setsgl:		lda	port
		ani	0f0h		;clear out old disk select bits
		ora	c		;new disk select bits
		sta	port
		ret
;
;
settrk:		;set track given by register <c>
		call	headload
		mov	a,m
		ora	a
		cm	homel
;
;	<hl> reference correct track indicator according to
;	selected disk
;
		mov	a,c		;desired track
		cmp	m
		rz			;we are already on the track
;
settkx:		call	step		;step track-carry has direction
					;step will update track indicator
		mov	a,c
		cmp	m		;are we where we want to be
		jnz	settkx		;not yet
;
;	have stepped enough
;	delay 10 msec for final step time and head settle time
;
		mvi	a,10d
;
;
delay:		;routine to delay <c(a)> milliseconds
		push	b
;
delay2:		mvi	c,88		;adjust for 1 msec loop delay
;
ldxa:		xthl
		xthl
		dcr	c
		jnz	ldxa		;loop 1 msec
		dcr	a
		jnz	delay2
		pop	b
		ret			;end of delay routine
;
;
setsec:		;set sector given by register <c>
		mov	a,c
		sta	sector
		ret
;
;
setdma:		;set dma address given by register <bc>
		mov	l,c		;low order address
		mov	h,b		;high order address
		shld	dmaad		;save the address
		ret
;
;
;
;	read sector or sectors specified in iopb
;
iread:		ori	0ffh		;check params and seek track
		sta	rdwrflg
;
;	this is similar to write, so set up read command and use
;	common code in write
;
		mvi	b,040h		;set read flag
		jmp	waitio		;to perform the actual i/o
;
;
;
;	write sector or sectors specified in iopb
;
iwrite:		xra	a		;check params and seek track
		sta	rdwrflg	
		mvi	b,080h		;set write command
;
waitio:		;enter here from read and write to perform the actual i/o 
		;operation.  return a 00h in register a if the operation completes
		;properly, and 01h if an error occurs during the read or write
		;
		;in this case, we have saved the disk number in 'diskno' 
		;			the track number in 'track' 
		;			the sector number in 'sector' 
		;			the dma address in 'dmaad' 
		;			<b> still has r/w flag
		;
		mvi	a,10		;set error count
		sta	errors		;retry some failures 10 times
					;before giving up
		push	b
		call	headload
;
;	<hl> point to track byte for selected disk
;
		pop	b
;
tryagn:		mov	c,m
;
;	decide whether to allow disk write precompenstation
;
allowit:	lhld	dmaad		;get buffer address
		push	b		;<b> has r/w code, <c> has track
		dcx	h		;save and replace 3 bytes below
					;buf with track,sector,address mark
		mov	e,m
;
;	figure correct address mark
;

		lda	port
		ani	08h
		mvi	a,0fbh
		jz	sin
		ani	0fh		;was double 
					;0bh is double density 
					;0fbh is single density
;
sin:		mov	m,a
;
;	fill in sector
;
		dcx	h
		mov	d,m
		lda	sector		;note that invalid sector number
					;will result in head unloaded
					;error, so dont check
		mov	m,a
;
;	fill in track
;
		dcx	h
		pop	b
		mov	a,c
		mov	c,m
		mov	m,a
		mov	a,h		;set up fdc dma address
		out	haddr		;high byte
		mov	a,l
		out	laddr		;low byte
		mov	a,b		;get r/w flag
		out	comand1		;start disk read/write
;
rwwait:		in	stat		;read fdc status
		ani	088h		;test for head unload or iof
		jz	rwwait
		mov	m,c		;restore 3 bytes below buf
		inx	h
		mov	m,d
		inx	h
		mov	m,e
		in	stat		;test for errors
		ani	0f0h
		rz			;<a> will be 0 if no errors
;
errtn:		;come here on error from disk
		;check for 10 errors
		lxi	h,errors
		dcr	m
		jnz	redo		;not ten yet, do a retry
;
;	set error return for operating system
;
		mvi	a,1
		ret
;
redo:		;<b> still has read/write flag
		ani	0e0h		;retry if not track error
		jnz	tryagn
;
;	was a track error so need to reseek
;
		push	b		;save	read/write indicator
;
;	figure out the desired track
;
		lxi	d,track
		lhld	diskno		;selected disk
		dad	d		;point to correct track indicator
		mov	a,m		;desired track
		push	psw		;save it
		call	home
		pop	psw
		mov	c,a
		call	settrk
		pop	b		;get read/write indicator
		jmp	tryagn
;
;
step:		;step head out towards zero
		;if [cy] is set, else step in
;
;	 <hl> point to correct track indicator word
;
		jc	outx
		inr	m		;increment current track byte
		mvi	a,04h		;set direction = in
;
dostep:		out	comand1		;set direction bit in fdc
		ori	2
		out	comand1		;pulse step bit
		ani	0fdh
		out	comand1		;turn off pulse
;
;	the fdc-2 had a step ready line. the fdc-3 relies on
;	software time out
;
		mvi	a,6		;wait for step ready
		jmp	delay
;
outx:		dcr	m		;update track byte
		xra	a
		jmp	dostep
;
;
headload:	;select and load the head on the correct drive
		lxi	h,portout	;old slect info
		mov	b,m
		dcx	h		;new select info
		mov	a,m
		inx	h
		mov	m,a
		out	comand2		;select the drive
;
;	set up <hl> to point to track byte for selected disk
;
		lxi	d,track
		lhld	diskno
		dad	d
;
;	now check for needing a 35 ms delay
;	if we have changed drives or if the head is unloaded
;	we need to wait 35 ms for head settle
;
		cmp	b		;are we on the same drive as before
		jnz	needdly
;
;	we are on the same drive
;	is the head loaded?
;
		in	stat
		ani	80h
		rz			;already loaded
;
needdly:	xra	a
		out	comand1		;load the head
		mvi	a,35
		jmp	delay
;
;
;	bios messages
;
isisms		db	cr,lf,cr,lf,'ISIS disk in drive A:, type return ',0
;
crlf		db	cr,lf,0
;
bmsg		db	cr,lf,'+++Disk Boot Error+++',0
;
;	bios scratch area placed at top of ram in system uses max of 256
;	bytes in top ram page
;
trtab		ds	5		;track table
diskno		ds	1		;current disk number
dummy		ds	1
port		ds	1
portout		ds	1
density		ds	1		;0ffh=double, 00h=single density
rdwrflg		ds	1		;read/write flag
errors		ds	1		;error count
resbyt		ds	1		;result byte
ostack		ds	2		;old stack storage
iopb		ds	2		;pointer to iopb
;
;	copy of i/o parameter block
;
ioblk		equ	$
chword		ds	1		;channel byte
dskins		ds	1		;disk instruction
numrec		ds	1		;number of records to do
itrack		ds	1		;track address
sect		ds	1		;current sector address
dmaadd		ds	2		;current r/w address
		ds	20		;stack space
newstk		ds	1	
stack		equ	newstk
;
;
		END
