;
; TITLE		DISK HARDWARE READ SPEED TESTER
; FILENAME	RSPEED.ASM
; AUTHOR	Robert A. Van Valzah   4/27/79
;
;
MAXSECT	EQU	100
$-MACRO
;
PRINT	MACRO	STRING
	LOCAL	MSG,AROUND
	MVI	C,9
	LXI	D,MSG
	CALL	5
	JMP	AROUND
MSG	DB	13,10,STRING,'$'
AROUND:
	ENDM
;
;
	ORG	100H
ENTRY:
	LXI	SP,STACK ;LOCAL STACK
	CALL	GETVEC	;LINK TO CBIOS
	PRINT	'RSPEED.COM  5/21/79'
	PRINT	'ENTER NUMBER OF SECTORS PER TRACK? '
	CALL	GETNUM
	STA	NSECTS
SETSKEW:
	PRINT	'ENTER SKEW FACTOR? '
	CALL	GETNUM
	STA	SKEW
	ORA	A
	JNZ	FILLTABL
	PRINT	'ENTER SECTOR NUMBERS, ZERO WHEN DONE'
	LXI	H,STABL
TABSEC:
	CALL	GETNUM
	MOV	M,A
	ORA	A
	JZ	GOTTABL
	INX	H
	JMP	TABSEC
FILLTABL:
	LXI	H,SUT
	MVI	C,MAXSECT
ZAPTABL:
	MVI	M,0
	INX	H
	DCR	C
	JNZ	ZAPTABL
	LXI	D,STABL+1
	LDA	NSECTS
	MOV	C,A
	MVI	B,1
STORSEC:
	MOV	A,B
	STAX	D
	MVI	A,LOW(STABL)
	ADD	C
	CMP	E
	INX	D
	MVI	A,0
	STAX	D
	JZ	GOTTABL
	CALL	SECAD
	MVI	M,0FFH	;SET SECTOR USED FLAG
	LDA	SKEW
	ADD	B
	MOV	B,A
MTYSEC:
	CALL	BMODC
	CALL	SECAD
	MOV	A,M
	ORA	A
	JZ	STORSEC
	INR	B
	JMP	MTYSEC
;
SECAD:
	LXI	H,SUT
	MOV	A,B
	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET
;
BMODC:
	MOV	A,B
	SUB	C
	RZ
	RC
	MOV	B,A
	RET
;
GOTTABL:
	PRINT	'PRESS ANY KEY TO READ, S TO RESET SKEW . .'
RDKEY:
	CALL	CONIN
	CPI	'S'
	JZ	SETSKEW
	CPI	3
	JZ	0
	LXI	H,STABL+1
RDSEC:
	MOV	A,M
	ORA	A
	JZ	GOTTABL
	MOV	C,A
	PUSH	H
	CALL	SETSEC
	CALL	READ
	POP	H
	INX	H
	JMP	RDSEC
;
GETNUM:
	MVI	C,0
GN1:
	PUSH	B
	CALL	CONIN
	MOV	C,A
	PUSH	PSW
	CALL	CONOUT
	POP	PSW
	POP	B
	CPI	13
	MOV	B,A
	MOV	A,C
	RZ
	ADD	A
	ADD	A
	ADD	C
	ADD	A
	MOV	C,A
	MOV	A,B
	SUI	'0'
	JC	GN1
	CPI	'9'+1
	JNC	GN1
	ADD	C
	MOV	C,A
	JMP	GN1
;
GETVEC:
	LHLD	1
	LXI	D,VECTORS
	MVI	C,14*3
GV1:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	GV1
	RET
;
; RAM AREAS
;
VECTORS:
WBOOT	DS	3
CSTS	DS	3
CONIN	DS	3
CONOUT	DS	3
LIST	DS	3
PUNCH	DS	3
READER	DS	3
HOME	DS	3
SELDSK	DS	3
SETTRK	DS	3
SETSEC	DS	3
SETDMA	DS	3
READ	DS	3
WRITE	DS	3
;
SKEW	DB	0
NSECTS	DB	0
;
	DS	30
STACK:
;
STABL:
	DS	MAXSECT
SUT:
	DS	MAXSECT
;
	END	ENTRY
