;
; TITLE		TARBELL DISK CONTROLLER COLD BOOT LOADER
; FILENAME	BVBOOT.ASM
; AUTHOR	ROBERT A. VAN VALZAH   2/22/79
; LAST REVISED	R. A. V.   4/07/79
; REASON	ADDED IF PASCAL ASSEMBLY SWITCH
;
;
; THIS PROGRAM IS LOADED AT LOCATION ZERO
; BY THE BOOTSTRAP PROM, AND RUN.  IT'S PURPOSE
; IS TO LOAD AND RUN THE CCP, BDOS AND CBIOS (CP/M) OR
; PINIT AND CBIOS (PASCAL) AT THE TOP OF THE MEMORY IN USE.
;
; THE FIRST SECTOR LOADED IS TRACK 0, SECTOR 2 (SECTOR
; 1 IS USED FOR THIS PROGRAM).  THIS SECTOR IS LOADED
; AT THE ADDRESS EQUATED AS LOADPNT.  SEQUENTIALLY FOLLOWING
; SECTORS ARE LOADED AT INCREASING ADDRESSES WITH AS
; MANY INWARD TRACK STEPS AS ARE NECESSARY TO READ
; A TOTAL OF DOSSECT SECTORS.  UPON COMPLETION OF THE
; LOAD, CONTROL IS TRANSFERED TO THE EQUATE DOSNTRY.
;
;
;	CONDITIONAL ASSEMBLY EQUATES
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
REL	EQU	FALSE	;TRUE TO GENERATE RELOCATABLE CODE
PASCAL	EQU	FALSE	;TRUE TO GENERATE PASCAL 'PBOOT'
MSIZE	EQU	47	;MEMORY AND CP/M SYSTEM SIZE
;
;	BASE OF CCP COMPUTATION
;
	IF	REL
BIAS	  EQU	0100H	;FOR RELOCATION, ASSUME CCP STARTS AT 0
	ENDIF
;
	IF	NOT REL	;OTHERWISE USE REAL CCP STARTING ADDR.
BIAS	  EQU	(MSIZE-16)*1024+2900H
	ENDIF
;
;	OTHER ENTRY CP/M ENTRY POINTS
;
CPMB	EQU	BIAS		;CCP START
CBIOS	EQU	CPMB+1500H	;CBIOS START
DOSEND	EQU	CPMB+1980H	;END OF DOS LOAD +1
;
;	COMPUTE NUMBER OF SECTORS TO LOAD
;
	IF	PASCAL
DOSSECT	  EQU	12	;LOAD JUST 12 SECTORS FOR PASCAL BOOT
	ELSE
DOSSECT	  EQU	(DOSEND-CPMB)/128
	ENDIF
;
;	EQUATE DOS LOAD AND ENTRY POINTS
;
	IF	PASCAL
LOADPNT	  EQU	(MSIZE-48)*1024+0BA00H
DOSNTRY	  EQU	LOADPNT	;JUMP TO LOAD POINT FOR PASCAL
	ELSE
LOADPNT	  EQU	CPMB	;START LOADING AT CCP BASE IN CP/M
DOSNTRY	  EQU	CBIOS	;ENTER AT BASE OF CBIOS (COLD BOOT)
	ENDIF
;
;	DISK I/O PORT NUMBERS
;
DBASE	EQU	0F8H	;BASE ADDRESS OF CONTROLLER CARD
COMMAND	EQU	DBASE	;FD1771 COMMAND OUTPUT
STATUS	EQU	DBASE	;FD1771 STATUS INPUT
SECT	EQU	DBASE+2	;SECTOR OUTPUT
DATA	EQU	DBASE+3	;DATA INPUT & OUTPUT
WAIT	EQU	DBASE+4	;DATA SYNCRONIZATION & INTRQ INPUT
;
;	FD1771 COMMANDS
;
STEPICMD EQU	48H	;STEP IN WITH HEAD LOAD
READCMD	 EQU	88H	;READ IBM FORMAT
;
;	OPTION BITS WITHIN COMMANDS
;
UPDTTRK	EQU	10H	;UPDATE TRACK REGISTER FLAG
LOADHEAD EQU	04H	;LOAD HEAD & DELAY BEFORE READ/WRITE
VERIFY	EQU	04H	;VERIFY AFTER SEEK/STEP
RATE	EQU	10B	;STEP RATE OF 10MS.
;
;	FD1771 STATUS BITS
;
; TYPE II STATUS BITS
;
NOTREADY EQU	80H	;DRIVE NOT READY
NOTFOUND EQU	10H	;SECTOR NOT FOUND
CRCERR	 EQU	08H	;READ CRC ERROR
LOSTDATA EQU	04H	;DATA LOAD, CPU TOO SLOW, DISK TOO FAST
BUSY	 EQU	01H	;CURRENTLY EXECUTING A COMMAND
;
; TYPE 1 STATUS BITS
;
SEEKERR	EQU	10H	;DESIRED TRACK WAS NOT VERIFIED
;
;
;	BEGIN CODE GENERATION
;
	ORG	0
ENTRY:
	LXI	H,LOADPNT ;MEMORY ADDRESS BEING LOADED IN REG HL
			;REG B WILL HOLD THE NEXT SECTOR NUMBER
			;TO READ, AND
			;REG C WILL HOLD THE NUMBER OF SECTORS
			;LEFT TO LOAD.
			;LOAD BOTH WITH ONE LXI
	LXI	B,(2 SHL 8) + DOSSECT
			;REG E WILL HOLD THE COMMNAD TO BE
			;SENT TO THE FD1771.  INITIALLY, USE
			;READ WITH HEAD LOAD, BUT THEREAFTER
			;USE READ WITHOUT HEAD LOAD
	MVI	E,READCMD + LOADHEAD
READSEC:
	MOV	A,B	;GET SECTOR NUBMER
	OUT	SECT	;SEND TO CONTROLLER
	MOV	A,E	;GET COMMAND
	MVI	E,READCMD ;NEXT TIME, USE READ WO/ HEAD LOAD
	OUT	COMMAND ;SEND COMMAND
READBYTE:
	IN	WAIT	;WAIT FOR A BYTE OR INTRQ
	ORA	A	;INTRQ (INDICATING END OF SECTOR OR ERROR) ?
	JP	SECDONE	;YES - EXIT READ LOOP
	IN	DATA	;NO - MUST BE DATA - GO GET IT
	MOV	M,A	;LOAD IT
	INX	H	;ON TO NEXT ADDRESS TO LOAD
	JMP	READBYTE
SECDONE:
	IN	STATUS	;CHECK FOR ERRORS LOADING THIS SECTOR
			;LOOK AT THE FOLLOWING ERROR BITS
			;NOT READY
			;NOT FOUND
			;CRC ERROR
			;LOST DATA
			;BUSY
	ANI	NOTREADY+NOTFOUND+CRCERR+LOSTDATA+BUSY
	JNZ	ERROR	;TAKE ERROR EXIT IF ANY ARE HIGH
	DCR	C	;HAVE ALL SECTORS BEEN LOADED?
	JZ	LODDONE	;YES - ENTER DOS TO BRING UP SYSTEM
	INR	B	;NO - INCREMENT SECTOR NUMBER
	MOV	A,B	;AT THE END OF A TRACK?
	CPI	26 + 1
	JC	READSEC	;NO - JUST READ THE NEXT SECTOR
	MVI	B,1	;YES - SET SECTOR BACK TO 1, AND
			;STEP IN TO THE NEXT TRACK
	MVI	A,STEPICMD+UPDTTRK+VERIFY+RATE
	OUT	COMMAND
	IN	WAIT	;WAIT FOR STEP COMMAND COMPLETION
	IN	STATUS	;SEE IF STEP WENT OK
			;LOOK AT THE FOLLOWING ERROR BITS
			;NOT READY
			;SEEK ERROR
			;CRC ERROR
			;BUSY
	ANI	NOTREADY+SEEKERR+CRCERR+BUSY
	JZ	READSEC	;STEP WENT OK - READ NEXT SECTOR
ERROR:
	STA	0CC00H	;STORE ERROR BITS ON VDM SCREEN
	HLT
;
;	COME HERE AFTER ALL SECTORS HAVE BEEN LOADED.
;	NOW INITIALIZE HARDWARE I/O PORTS AND SUCH.
;
LODDONE:
	;
	; YOUR I/O INIT CODE GOES HERE
	;
	JMP	DOSNTRY	;DONE BOOTING - ENTER DOS
;
;
;	AFTER LOADING THIS CODE AT ZERO, THE BOOTSTRAP PROM
;	JUMPS TO ADDRESS 7DH WHICH DISABLES IT.  THE NET
;	EFFECT IS THAT THE REAL ENTRY PINT IS 7DH.
;
	ORG	7DH
	JMP	ENTRY	;VECTOR TO START OF LOAD
;
	END	ENTRY
