;
;   PROM BURNER (FOR BYTESAVER 2708/1K PROMS)
;
BRNLPS   EQU  128       ; 128*.8MS>=100MS PGMING TIME
;
         ORG  100H
         JMP  PBURN
         NOP
RAM:     DW   200H        ; FROM (IN RAM)
ROM:     DW   0FC00H       ;  TO (IN ROM) ON LAST PROM
SIZE:    DB   1            ;  'K' TO BURN
BCNT:    DB   0  
;
SETADR:
         LHLD ROM
         XCHG              ; DE:=ROM ADDRESS
         LHLD RAM          ; HL:=RAM ADDRESS
         LDA  SIZE
         ADD  A
         ADD  A            ;  *4 TO CONVERT TO 'K'
         MOV  B,A
         MVI  C,0           ; BC:=SIZE TO  BURN
          RET
;
PBURN:    XRA  A
          LXI  SP,STAK
;
PBLP:     STA  BCNT
          CALL SETADR
;
PBLPP:   MOV  A,M
         STAX D
         INX  D
         INX  H
;
         DCX  B
         MOV  A,B
         ORA  C
         JNZ  PBLPP
;                         TEST FOR ENOUGH PASSES
         LDA  BCNT
         INR  A
         OUT  255        ; SHOW WHAT PASS I'M ON TO THE WORLD
         CPI  BRNLPS
         JNZ  PBLP
;
; 
;              VERIFY PASS
;
         CALL SETADR
VLP:     LDAX D
         CMP  M
         JZ   VOK
         RST  7            ;    BAD DATA
         ;
VOK:     INX  D
         INX  H
         DCX  B
         MOV  A,B
         ORA  C
         JNZ  VLP
;
         RST  7          ; BREAK TO DDT
         DS   5
STAK:    DS   0
