	TITLE	MACADPT
;
; VERSION 1.2   11 APR 77
; VERSION 1.3   20 SEP 77
; VERSION 1.4   17 OCT 77
;
; BY JEFFREY W. SHOOK
; PO BOX 185
; ROCKY POINT, NY 11778
;
; THIS PROGRAM ADAPTS THE TDL MACROASSEMBLER
; TO WORK UNDER CP/M.
;
;***********************************;
;         CP/M STANDARD EQUATES     ;
;***********************************;

BOOT	EQU	0000H	;WARM START ADDRESS
TFCB	EQU	005CH	;DEFAULT FCB ADDRESS
TBUF	EQU	0080H	;DEFAULT BUFFER ADDRESS
TBASE	EQU	0100H	;TRANSIENT PROGRAM BASE
CBASE	EQU	2900H	;CCP BASE ADDRESS
BDOS	EQU	0005H	;BDOS ENTRY POINT
CONIN	EQU	03E09H	;CONSOLE INPUT SUBROUTINE
CONOUT	EQU	03E0CH	;CONSOLE OUTPUT ROUTINE

;***********************************;
;       CP/M FUNCTION CODES         ;
;***********************************;
 
SRSET	EQU	00	;SYSTEM RESET
RCON	EQU	01	;READ CONSOLE
WCON	EQU	02	;WRITE CONSOLE
RRDR	EQU	03	;READ READER
WPUN	EQU	04	;WRITE PUNCH
WLST	EQU	05	;WRITE LIST
ISTAT	EQU	07	;GET IOSTATUS
SSTAT	EQU	08	;SET IOSTATUS
WCONB	EQU	09	;WRITE CONSOLE BUFFER
RCONB	EQU	10	;READ CONSOLE BUFFER
CSTAT	EQU	11	;CHECK CONSOLE STATUS
LHEAD	EQU	12	;LIFT DISK HEAD
RSDSK	EQU	13	;RESET DISK SYSTEM
SDISK	EQU	14	;SELECT DISK
OPEN	EQU	15	;OPEN FILE
CLOSE	EQU	16	;CLOSE FILE
SFRST	EQU	17	;SEARCH FIRST
SNEXT	EQU	18	;SEARCH NEXT
FDELT	EQU	19	;DELETE FILE
READ	EQU	20	;READ RECORD
WRITE	EQU	21	;WRITE RECORD
CREATE	EQU	22	;CREATE FILE
RENAM	EQU	23	;RENAME FILE
LOGIN	EQU	24	;GET LOGIN
IDISK	EQU	25	;GET DISK NUMBER
SDMA	EQU	26	;SET DMA VECTOR
IALLOC	EQU	27	;GET ALLOCATION VECTOR
;
;
EOF:	EQU	1AH	; CP/M END OF FILE CHAR
;
;
	ORG	100H	; LET CP/M FIND US
	JMP	MACAD
;
;
; TRANSIENT PROGRAM STORAGE
; DEFINITIONS
;
;
;
CSTSF:	DS	1	; CONSOLE STATUS FLAG
PASSP:	DS	2	; PASS TABLE POINTER
SRCPTR:	DS	2	; SOURCE BUFFER POINTER
LSTPTR:	DS	2	; LISTING BUFFER POINTER
HEXPTR:	DS	2	; HEX OBJECT FILE POINTER
SRCFCB:	DS	36	; SOURCE FILE CONTROL BLOCK
SRCBUF:	DS	128	; SOURCE FILE BUFFER
LSTFCB:	DS	36	; LISTING FILE CONTROL BLOCK
LSTBUF:	DS	128	; LISTING FILE BUFFER
HEXFCB:	DS	36	; OBJECT FILE CONTROL BLOCK
HEXBUF:	DS	128	; OBJECT FILE BUFFER
;
;
;
;
MACAD:	LXI	SP,MACRX+16EH	; SET TEMP STACK
	LXI	H,AZM	; INSERT FILETYPE
	LXI	D,TFCB+9
	LXI	B,3	; IN TRANSIENT FCB
	CALL	LDIR	; MOVE FILETYPE
	LXI	D,TFCB; CHECK DIRECTORY
	MVI	C,SFRST	; TO SEE IF FILE EXISTS
	CALL	BDOS
	CPI	0FFH
	CZ	ERROR
	LXI	H,TFCB	; MOVE FILE NAME TO SRCFCB
	LXI	D,SRCFCB
	LXI	B,12
	CALL	LDIR	; MOVE BLOCK
	MVI	C,OPEN	; OPEN SOURCE FILE
	LXI	D,SRCFCB
	CALL	BDOS
	CPI	0FFH
	CZ	ERROR
	LXI	D,LSTFCB; CREATE LISTING FILE
	LXI	B,PRN
	CALL	MAKEF
	LXI	D,HEXFCB; CREATE OBJECT FILE
	LXI	B,HXR
	CALL	MAKEF
	LXI	H,PASST	; INITIALZE PASS COUNT
	SHLD	PASSP
	LXI	H,LSTBUF; INITALIZE LISTING POINTER
	SHLD	LSTPTR
	LXI	H,HEXBUF; INITIALIZE HEX POINTER
	SHLD 	HEXPTR
	MVI	A,0	; INITIALIZE CONSOLE STATUS FLAG
	STA	CSTSF
	JMP	MACRX	; GO ASSEMBLE
;
; TABLE OF FILETYPES
;
AZM:	DB 'AZM'
PRN:	DB 'PRN'
HXR:	DB 'HXR'
;
;
; END OF ASSEMBLY
;
TRPSIM:	MVI	C,EOF	; EMPTY LIST BUFFER
	CALL	LOSIM
	JNC	TRPSIM
TRPS1:	CALL	POSIM	; EMPTY HEX BUFFER
	JNC	TRPS1
CLOSAL: MVI	C,CLOSE	; CLOSE ALL FILES
 	LXI	D,LSTFCB
	CALL	BDOS
	MVI	C,CLOSE
	LXI	D,HEXFCB
	CALL	BDOS
	JMP	BOOT
;
;
;
; SIMULATE CONSOLE INPUT FOR PASS
; CONTROL OF ASSEMBLER.
; PASS 1 = SYMBOL TABLE
; PASS 2 = LISTING
; PASS 3 = HEX OBJECT FILE
;
CISIM:	PUSH	H	; SAVE ASSEMBLER REGISTERS
	PUSH	D
	PUSH	B
	MVI	A,0	; SET NEXT RECORD POINTER TO ZERO
	STA	SRCFCB+32
	STA	CSTSF	; CLEAR CONSOLE STATUS FLAG
	LXI	H,SRCBUF+128
	SHLD	SRCPTR	; SET SRC PTR TO END OF BUFFER
	POP	B	; RESTORE ASM REGISTERS
	POP	D
	LHLD	PASSP	; LOAD POINTER TO PASS #
	MOV	A,M	; GET PASS
	INX	H
	SHLD	PASSP
	POP	H
	RET
;
;
; TABLE OF PASS NUMBERS
;
PASST:	DB '1230'
;
; CHARACTER INPUT SUBROUTINE
;
; CREATE A SOURCE BUFFER AND LOAD
; IT FROM THE DISK. AT EACH CALL
; SUPPLY ONE CHARCTER IN A REG.
; IF BUFFER EMPTY, CALL BDOS TO
; FILL IT. SET CARRY IF EOF IS
; FOUND IN FILE.
;
RISIM:	PUSH	H	; SAVE ASSM HL,DE
	PUSH	D
	LXI	D,SRCFCB; GET FCB ADDRESS
	LHLD	SRCPTR	; GET BUFFER POINTER
	CALL	BUFIN	; READ A BYTE
	SHLD	SRCPTR	; SAVE BUFFER POINTER
	POP	D	; RESTORE HL,DE
	POP	H
	CPI	EOF	; CHECK FOR EOF CHAR
	STC		; SET EOF FLAG IN CARRY
	RZ
	CMC		; NOT EOF, ERASE MARK
	RET
;
; LIST CHARACTER OUTPUT
;
; CREATE AN OUTPUT BUFFER AND
; PUT EACH CHAR IN UNTIL FULL.
; THEN WRITE CONTENTS TO DISK
; FILE AND RESET POINTER.
;
LOSIM:	PUSH	D
	PUSH	H
	LHLD	LSTPTR
	LXI	D,LSTFCB
	CALL	BUFOUT
	SHLD	LSTPTR
	POP	H
	POP	D
	MOV	A,C
	RET
;
;
; PUNCH CHARACTER OUTPUT
;
; SIMILAR TO LIST OUTPUT
;
POSIM:	PUSH	D
	PUSH	H
	LHLD	HEXPTR
	LXI	D,HEXFCB
	CALL	BUFOUT
	SHLD	HEXPTR
	POP	H
	POP	D
	MOV	A,C
	RET
;
;
; SOURCE BUFFER CONTROL
;
; REFILL BUFFER IF EMPTY, PUT NEXT CHARACTER IN A
;
; ENTER WITH FCB ADDRESS IN DE, BUFFER POINTER IN HL
; 
; SAVES BC, RETURNS WITH CHAR IN A, BUFFER POINTER IN HL
;
BUFIN:	MOV	A,E	; COMPUTE END OF BUFFER
	ADI	SRCBUF+128-SRCFCB
	CMP	L
	JNZ	SRCB1
	PUSH	B
	MVI	C,READ
	CALL	REFILL
	ANI	0FEH	; CHECK FOR GOOD READ
	CPI	0
	POP	B
	CNZ	ERROR
SRCB1:	MOV	A,M
	INX	H
	RET
;
;
; OUTPUT BUFFER CONTROL
;
; IF BUFFER FULL, WRITE CONTENTS TO DISK,
; PUT CHAR FROM C IN BUFFER.
;
; ENTER WITH FCB ADDR IN DE, BUFFER PTR IN HL,
; AND CHAR IN C.
; RETURN WITH BUFFER PTR IN HL,SAVE BC,SET CARRY AFTER
; BUFFER REFILL.
;
BUFOUT:	MOV	A,E	; COMPUTE END OF BUFFER
	ADI	164
	CMP	L	; FULL?
	STC		; CLEAR CARRY
	CMC
	JNZ	BUFOU1	; NOT FULL, STORE CHAR
	PUSH	B	; FULL, SAVE CHAR
	MVI	C,WRITE
	CALL	REFILL
	CPI	0	; GOOD WRITE?
	POP	B
	CNZ	ERROR
	STC		; MARK REFILL
BUFOU1:	MOV	M,C	; STORE CHAR IN BUFFER
	INX	H	; MOVE PTR TO NEXT CHAR
	RET
;
;
; BUFFER I/O ROUTINE
;
; ENTER WITH CP/M READ OR WRITE CODE
; IN BC AND FCB ADDRESS IN DE.
; RETURN WITH INITIALIZED BUFFER
; POINTER IN HL.
;
REFILL:	LXI	H,36	; CALC START OF BUFFER
	DAD	D
	PUSH	H	; SAVE START OF BUFFER
	PUSH	D	; SAVE FCB ADDRESS
	XCHG
	PUSH	B	; SAVE CP/M CODE
	MVI	C,SDMA
	CALL	BDOS	; SET DMA ADDRESS
	POP	B	; GET CP/M CODE
	POP	D	; GET FCB ADDRESS
	CALL	BDOS	; READ OR WRITE BUFFER
	POP	H	; SET PTR TO START OF BUFFER
	RET
;
;
; CREATE AND OPEN A FILE WITH SAME NAME AS DEFAULT FCB
;
; ENTER WITH ADDRESS OF FCB IN DE, AND
; ADDRESS OF FILETYPE STRING IN BC.
;
MAKEF:	LXI	H,TFCB
	PUSH	D
	PUSH	B
	LXI	B,9
	CALL	LDIR	; MOVE FILENAME
	POP	H
	LXI	B,3
	CALL	LDIR	; MOVE FILETYPE
	MVI	C,FDELT
	POP	D
	PUSH	D
	CALL	BDOS	; DELETE FILE
	MVI	C,CREATE
	POP	D
	PUSH	D
	CALL	BDOS	; CREATE FILE
	CPI	0FFH
	CZ	ERROR
	MVI	C,OPEN
	POP	D
	PUSH	D
	CALL	BDOS	; OPEN FILE
	CPI	0FFH
	CZ	ERROR
	POP	D	; SET NEXT RECORD PTR IN FCB TO ZERO
	LXI	H,33
	DAD	D
	MVI	M,0
	RET
;
;
; BLOCK MOVE (Z-80 LDIR INST)
;
LDIR:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	XRA	A
	CMP	C
	JNZ	LDIR
	CMP	B
	JNZ	LDIR
	RET
;
; MEMORY SIZE TEST
;
MEMSIM:	PUSH	H
	LHLD	BDOS+1
	MOV	A,L
	MOV	B,H
	POP	H
	RET
;
;
; CONSOLE STATUS CHECK

CSTSIM:	LDA	CSTSF	; CHECK CONSOLE STATUS
	RET

; IOCHECK
;
IOSIM:	MVI	A,0A8H
	RET
;
;
; ERROR HANDLER
;
ERROR:	PUSH	PSW
	LXI	D,ERRMES
	MVI	C,WCONB
	CALL	BDOS	; WRITE ERROR MESS
	POP	PSW
	POP	H	; GET ADDRESS OF CALLER
	PUSH	PSW
	CALL	OUTHHL	; GOTO CP/M AND PRINT IT
	MVI	C,'.'
	CALL	CO
	POP	PSW
	CALL	OUT2H	; PRINT ERROR TYPE
	JMP	CLOSAL	; CLEAN UP THE MESS
;
ERRMES:	DB 'MACROASSEMBLER ERROR $'
;
;++++++++++++++++++++++++++++++++++++++++++++++
;
; HEXIDECIMAL REGISTER OUTPUT
;
; HEXOUT.LIB  -  VERSION 0.2  -  12 SEP 77
;
;++++++++++++++++++++++++++++++++++++++++++++++

; FUNCTIONS AVAILABLE:
;
;	OUT2H	PRINT 2 HEX DIGITS FROM A
;	OUTHHL	PRINT HL

OUTHHL:	MOV	A,H	; PRINT HL
	CALL	OUT2H
	MOV	A,L

OUT2H:	PUSH	PSW
	CALL	OUTHL
	POP	PSW
	JMP	OUTHR

OUTHL:	RRC
	RRC
	RRC
	RRC
OUTHR:	ANI	0FH
	ADI	'0'
	CPI	'9'+1
	JC	OUTHR1
	ADI	'@'-'9'
OUTHR1:	JMP	OUTCH

CO:	MOV	A,C	; CHECK FOR PASS REQUEST
	CPI	'='
	JNZ	CO1
	MVI	A,0FFH	; SET CONSOLE STATUS
	STA	CSTSF
CO1:	MOV	A,C	; SIMULATE TDL CO
OUTCH:	PUSH	PSW	; CONSOLE OUTPUT
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,WCON
	MOV	E,A
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET


; NEW MACROASSEMBLER I/O VECTOR TABLE
; TO OVERWRITE PRESENT ASSEMBLER VECTOR TABLE

	ORG	0800H

MACRX:	DS	6
	JMP	CISIM
	JMP	RISIM
	JMP	CO
	JMP	POSIM
	JMP	LOSIM
	JMP	CSTSIM
	JMP	IOSIM
	JMP	MEMSIM
	JMP	TRPSIM

	END
