;CONTRIBUTED TO CP/M USERS' GROUP BY:
;
;               MEMORY MERCHANTS
;               1350 BUFFALO ROAD
;               ROCHESTER NY 14624
;

;	GO COMMAND ----- JUMPS TO A HEX ADDRESS

.I8080
.PABS
.PHEX
.XLINK

BDOS	=	05H
CPM	=	0
STACK	=	TEMP+10
TBUFF	=	080H

;	SYNTAX:	GO HHHH<CR> , WHERE 'H' IS A HEX CHARACTER
;OF LENGTH 0 TO 4 AND <CR> IS A CARRIAGE RETURN.
;	IE., GO 9CD<CR>  OR  GO F000<CR>

	.LOC	100H

	LXI	SP,STACK	;SET STACK
	LXI	H,0
	SHLD	GO.AD		;CLEAR GO.AD
	LXI	H,TBUFF		;POINT TO BUFFER
	LDA	TBUFF		;GET BUFFER COUNTER
	ADD	L		;GO TO END OF HEX STRING
	MOV	L,A
	INX	H
	PUSH	H
	LXI	H,GO.AD		;WORK ON LOWER ORDER BYTE OF GO.AD
	SHLD	TEMP
	POP	H
	CALL	ADDR		;DECODE HEX DIGITS
	PUSH	H
	LXI	H,GO.AD+1	;WORK ON HIGH ORDER BYTE OF GO.AD
	SHLD	TEMP
	POP	H
	CALL	ADDR
	LHLD	GO.AD
	PCHL

ADDR:	CALL	CHECK		;CHECK FOR END OF HEX DIGITS
	CALL	HEXDIG
	PUSH	H
	LHLD	TEMP
	MOV	M,A
	POP	H
	CALL	CHECK
	CALL	HEXDIG
	RLC
	RLC
	RLC
	RLC
	PUSH	H
	LHLD	TEMP
	ADD	M
	MOV	M,A
	POP	H
	RET

CHECK:	DCX	H		;LOOK AT NEXT HEX DIGIT
	MOV	A,M
	CPI	" "
	RNZ			;IF SPACE JUMP & GO
	LHLD	GO.AD
	PCHL

HEXDIG:	SUI	30H
	JC	HEXERR		;NOT A HEX DIGIT
	CPI	0AH
	JNC	..ALPHA
	RET

..ALPHA:
	SUI	07H
	CPI	10H
	JNC	HEXERR		;NOT A HEX DIGIT
	RET

HEXERR:	MVI	C,9
	LXI	D,..MSG
	CALL	BDOS
	JMP	CPM		;DO A WARM BOOT
..MSG:	.ASCII	"ERROR IN HEX ADDRESS  $"

GO.AD:	.BLKW	1
TEMP:	.BLKW	1
	.END
