;-----------------------------------------------
;
; DISK TEST PROGRAM - VERSION 0.2
;
; 10 JUL 77
;
; DONATED BY ANONYMOUS
;
; MODIFIED FOR CP/M BY J. W. SHOOK
;
;-----------------------------------------------
; MODIFICATION HISTORY ***
;
; (1) 28 JUN 77 : ADDED CP/M CONSOLE INPUT CALL
;     FOR SYSTEM SIZE INDEPENDENCE.
; (2) 03 JUL 77 : ADDED BREAK CHECK TO ALLOW HALT
;     OF TEST IN REPEAT MODE.
; (3) 10 JUL 77 : CHANGED DISK I/O TO USE DIRECT
;     CALLS TO CBIOS IN USER SYSTEM.
;
;-----------------------------------------------
; STANDARD EQUATES
;
LASTSEC	EQU	26
BDOS	EQU	5
CR	EQU	0DH
LF	EQU	0AH

	ORG	100H
GO:
	LXI	SP,STKTOP
	LXI	D,MESGA
	CALL	CRPRT
	CALL	CONIN
	ANI	1	;GET LSB FOR DISK SELECT
	XRI	1	;ASCII A MEANS SELECT 0
	MOV	C,A
	CALL	SELDSK
	LXI	D,MESGB
	CALL	CRPRT
	CALL	CONIN
	CALL	HOME
	LXI	D,MESGF
	CALL	CRPRT
	CALL	CONIN
	STA	REPEAT
GOTEST:
	CALL	TEST
	CALL	CONST
	ORA	A
	JNZ	STOPT
	LDA	REPEAT
	ANI	0DFH	;CONVERT TO UPPER CASE
	CPI	'R'	;LOOP IF REPEAT FLAG ON
	JZ	GOTEST
STOPT:	LXI	D,MESGH
	CALL	CRPRT
STOPT1:	CALL	CONIN
	ANI	0DFH	;CONVERT TO UPPER CASE
	CPI	'Y'
	JZ	GO
	CPI	'N'
	JNZ	STOPT1
	LXI	D,MESGG
	CALL	CRPRT
	CALL	CONIN
	JMP	0	;REBOOT

;CPM CONSOLE INPUT

CONIN:
	PUSH B ! PUSH D ! PUSH H
	MVI	C,1
	CALL	BDOS
	POP H ! POP D ! POP B
	RET

;CP/M CONSOLE OUTPUT

CONOUT:
	PUSH PSW ! PUSH B ! PUSH D ! PUSH H
	MOV	E,C
	MVI	C,2
	CALL	BDOS
	POP H ! POP D ! POP B ! POP PSW
	RET

; CP/M CONSOLE STATUS CHECK

CONST:	PUSH B ! PUSH D ! PUSH H
	MVI	C,11
	CALL	BDOS
	POP H ! POP D ! POP B
	RET

;
MESGA:	DB	'DISKTEST - VERSION 0.2',CR,LF
	DB	'03 JUL 77',CR,LF,LF
	DB	'SELECT DRIVE TO TEST, A OR B? $'
MESGB:	DB	'INSERT SCRATCH DISKETTE, THEN RETURN $'
MESGC:	DB	'COMPARE ERROR ON TRACK $'
MESGD:	DB	'(HEX) SECTOR $'
MESGE:	DB	'PERMANENT $'
MESGF:	DB	'REPEAT TEST (TYPE H TO HALT) OR STOP? (R OR S) $'
MESGG:	DB	'INSERT SYSTEM DISK, THEN RETURN $'
MESGH:	DB	'DO YOU WANT TO RESTART THIS TEST? (Y OR N) $'
MESGI:	DB	'COMPLETED TEST LOOP $'
MESGJ:	DB	'NOW FILLING DISK WITH 00$'
MESGK:	DB	'NOW PERFORMING SEEK TEST$'
MESGL:	DB	'NOW FILLING DISK WITH FF$'
MESGM:	DB	'NOW FILLING DISK WITH 55$'
MESGN:	DB	'NOW FILLING DISK WITH AA$'
MESGO:	DB	'NOW FILLING DISK WITH E5$'

;
TEST:
	LXI	D,MESGJ
	CALL	CRPRT
	MVI	A,0	;TEST PATTERN
	CALL	FILDSK
	LXI	D,MESGK
	CALL	CRPRT
	CALL	SKTST		;SEEK TEST
	LXI	D,MESGL
	CALL	CRPRT
	MVI	A,0FFH
	CALL	FILDSK
	LXI	D,MESGM
	CALL	CRPRT
	MVI	A,55H
	CALL	FILDSK
	LXI	D,MESGN
	CALL	CRPRT
	MVI	A,0AAH
	CALL	FILDSK
	LXI	D,MESGO
	CALL	CRPRT
	MVI	A,0E5H
	CALL	FILDSK
	LXI	D,MESGK
	CALL	CRPRT
	CALL	SKTST
	LXI	D,MESGI
	CALL	CRPRT
	LDA	TSTCNT
	INR	A
	STA	TSTCNT
	CALL	PRTHEX
	RET
;
;SEEK TEST
;
SKTST:
	XRA	A
	PUSH	PSW
SKLP:	XRA	A
	MOV	C,A
	CALL	READT	;READ TRACK ZERO
	POP	PSW
	INR	A
	CPI	77
	JZ	SKDONE
	PUSH	PSW
	MOV	C,A
	CALL	READT	;READ INCREASING TRACK NO
	JMP	SKLP
SKDONE:
	RET
;
;
CRPRT:	CALL	CRLF
PRTMSG:	LDAX	D	;GET CHAR
	INX	D
	CPI	'$'
	RZ
	PUSH	D
	MOV	C,A
	CALL	CONOUT
	POP	D
	JMP	PRTMSG	;LOOP TILL $
;
CRLF:	MVI	C,0DH
	CALL	CONOUT
	MVI	C,0AH
	CALL	CONOUT
	RET
;
PRTHEX:	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	PRTNBL
	POP	PSW
PRTNBL:	ANI	0FH
	ADI	30H
	CPI	3AH
	JC	SML
	ADI	7
SML:
	MOV	C,A
	CALL	CONOUT
	RET
;
FILDSK:	CALL	FILBUF0
	XRA	A
FDLP:	PUSH	PSW
	MOV	C,A
	STA	TRK
	CALL	WRITET	;WRITE ONE TRACK
	POP	PSW
	PUSH	PSW
	MOV	C,A
	CALL	COMPT
	POP	PSW
	INR	A
	CPI	77
	JNZ	FDLP	;DO ALL 77 TRACKS
	RET
;
FILBUF0:
	LXI	H,BUF0	;FILL BUF0 WITH (A)
	LXI	B,128*LASTSEC
FLP:	MOV	M,A
	INX	H
	DCR	C
	JNZ	FLP
	DCR	B
	JNZ	FLP
	RET
;
;
;
;
COMPT:	LXI	H,BUF1
	CALL	RT2	;REREAD INTO BUF1
	LXI	H,BUF0
	LXI	D,BUF1
	LXI	B,128*LASTSEC
CMPLP:	LDAX	D
	CMP	M
	JNZ	CERR
	INX	H
	INX	D
	DCR	C
	JNZ	CMPLP
	DCR	B	;ARE WE AT END OF BUFFER?
	JNZ	CMPLP
	RET
CERR:	PUSH	B
	LXI	D,MESGC
	CALL	CRPRT
	LDA	TRK
	CALL	PRTHEX
	LXI	D,MESGD
	CALL	PRTMSG
	POP	H	;PUSHED FROM B
	DAD	H	;COMPUTE SECTOR IN ERROR
	LXI	D,0FF00H
	DAD	D
	MVI	A,27
	SUB	H
	CALL	PRTHEX	;PRINT SECTOR
	RET
;
;
READT:	LXI	H,BUF0	;TRACK # IN C
RT2:	SHLD	DMAAD
	CALL	SETTRK
	MVI	C,1
RT3:	PUSH	B
	LHLD	DMAAD
	PUSH	H
	POP	B
	CALL	SETDMA
	POP	B
	PUSH	B
	CALL	SETSEC
	CALL	READ
	LHLD	DMAAD
	LXI	D,128
	DAD	D
	SHLD	DMAAD
	POP	B
	MVI	A,LASTSEC
	CMP	C
	RZ
	INR	C
	JMP	RT3
;
;
WRITET:	LXI	H,BUF0	;TRACK # IN C
WT2:	SHLD	DMAAD
	CALL	SETTRK
	MVI	C,1
WT3:	PUSH	B
	LHLD	DMAAD
	PUSH	H
	POP	B
	CALL	SETDMA
	POP	B
	PUSH	B
	CALL	SETSEC
	CALL	WRITE
	LHLD	DMAAD
	LXI	D,128
	DAD	D
	SHLD	DMAAD
	POP	B
	MVI	A,LASTSEC
	CMP	C
	RZ
	INR	C
	JMP	WT3

DMAAD:	DW	80
REPEAT:	DB	0
CMPERR:	DB	0	;NUMBER OF COMPARE ERRORS
TRK:	DB	0
TSTCNT:	DB	0
STK:	DS	40H
STKTOP:	DB	0

;--------------------------------------------------------
;
; DISK I/O CALLING PROCEDURES
;
;--------------------------------------------------------

HOME:	; MOVE HEAD TO TRACK 0

	MVI	A,21
	PUSH B ! PUSH D ! PUSH H
	CALL	FBIOS
	POP H ! POP D ! POP B
	RET

SELDSK:	; SELECT DISK DRIVE

	MVI	A,24
	PUSH B ! PUSH D ! PUSH H
	CALL FBIOS
	POP H ! POP D ! POP H
	RET

SETTRK:	; SELECT TRACK

	MVI	A,27
	PUSH B ! PUSH D ! PUSH H
	CALL FBIOS
	POP H ! POP D ! POP B
	RET

SETSEC:	; SELECT SECTOR

	MVI	A,30
	PUSH B ! PUSH D ! PUSH H
	CALL FBIOS
	POP H ! POP D ! POP B
	RET

SETDMA:	; SELECT DMA ADDRESS

	MVI	A,33
	PUSH B ! PUSH D ! PUSH H
	CALL	FBIOS
	POP H ! POP D ! POP B
	RET

READ:	; READ SECTOR

	MVI	A,36
	PUSH B ! PUSH D ! PUSH H
	CALL FBIOS
	POP H ! POP D ! POP B
	RET

WRITE:	; WRITE SECTOR

	MVI	A,39
	PUSH B ! PUSH D ! PUSH H
	CALL	FBIOS
	POP H ! POP D ! POP B
	RET

;******************************************
;* BIOS FUNCTION CALLING PROCEDURE        *
;******************************************
;
; THIS PROCEDURE ALLOWS CALLING BIOS
; FUNCTIONS WITHOUT PRIOR KNOWLEDGE OF THE
; SIZE OF THE CP/M SYSTEM.
;
; CALL FBIOS WITH THE FUNCTION IN A
; AND THE PARAMETER IN BC.
;
FBIOS:	MOV	E,A	; GET ENTRY OFFSET
	MVI	D,0	; IN DE
	LHLD	1	; GET BIOS ENTRY + 3
	DAD	D	; ADD ENTRY TO OFFSET
	PCHL		; JUMP TO BIOS
;
;
;
	DS	3
BUF0:	DS	128*LASTSEC
BUF1:	DS	128*LASTSEC
	END
